package Admin::SQLclient;

use strict;

use DBI;

#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Nurlan Mukhanov <webmaster@tourist.kz> (Infection)
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN = Admin::SKIN->new();
my $std = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO = Boardinfo->new();

sub new {
    my ($pkg, $args) = @_;
    my $obj = {};

    $obj->{'PREFIX'} = $INFO->{'DB_PREFIX'};

    bless $obj, $pkg;
    return $obj;
}

#+---------------------------------------------------------------------------------------------------------

sub splash {
    my ($obj, $db) = @_;

    my $tables = $db->tables();

    my $html = qq~

<table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
<tr>
    <td><font class='large'>>> List of actions</font><br>
    <font class='t'>  Please choose action.<br>  <font color='red'>Don't use 'Command line action'</font> if you
    are not familiar with SQL'</font>.<table cellspacing='1' cellpadding='0' width='100%'
    align='center' border='0' bgcolor='#333366'>
     <tr>
        <td><table border='0' width='100%' cellspacing='1' cellpadding='4'>
         <tr>
            <td width='30%' bgcolor='#FFFFFF'><font class='t'><a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=viewpolls&offset=0' target='BODY'>SQL poll fixer</a></font></td>
            <td width='70%' bgcolor='#FFFFFF'><font class='t'>This feature allows you to view and delete polls - useful if importing created some "random" polls</font></td>
         </tr>
         <tr>
            <td width='30%' bgcolor='#FFFFFF'><font class='t'><a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=forum_info' target='BODY'>Forum info fixer</a></font></td>
            <td width='70%' bgcolor='#FFFFFF'><font class='t'>This feature allows you you to update forum info after importing</font></td>
         </tr>
         <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=showtable' method='post'>
         <input type='hidden' name='AD' value='1'>
         <input type='hidden' name='act' value='sqlclient'>
         <input type='hidden' name='s' value='$iB::SESSION'>
         <input type='hidden' name='CODE' value='showtable'>
         <tr>
            <td width='30%' bgcolor='#FFFFFF'><font class='t'><b>SQL Table Properties Viewer</b><br>This is useful to make sure your schematic is up to date</font></td>
            <td width='70%' bgcolor='#FFFFFF' align='center'><select name='table' size='1' class='forminput'>
    ~;

    foreach my $i (@{$tables}) {
    
        ## SKIP NON iB TABLES
        
        next unless $i =~ /^$iB::INFO->{DB_PREFIX}/;
    
        $html .= "            <option value='$i'>$i</option>\n";
    };

    $html .= qq~
            </select></br>
            <input type='submit' value='View table properties' class='SUBMIT'></td>
         </tr>
         </form>
        </table>
        </td>
     </tr>
    </table>
    </td>
</tr>
</table>
    ~;

    $ADMIN->Output( WHERE => 'SQLCLIENT', NAV_ONE => 'SQL client backend toolbox', PRINT => $html);


}


sub viewpolls {
    my ($obj, $db) = @_;

    my %IN = ( CODE    => "",
             @_,
             );
    my $range;
  
    my $q = $obj->{'PREFIX'}."forum_polls";
    my $w = $obj->{'PREFIX'}."forum_topics";
    my $e = $obj->{'PREFIX'}."forum_info";

    if ($iB::INFO->{'DB_DRIVER'} eq "mySQL") {
        $range = " limit ".$iB::IN{'offset'}.",50";
    } else {
        $range = " limit 50 offset ".$iB::IN{'offset'}."";
    }

    my $query = "select $q.ID, $q.POLL_TITLE, $w.TOPIC_TITLE, $e.FORUM_NAME from $q, $w, $e where $q.POLL_ID=$w.TOPIC_ID and $q.FORUM_ID=$e.FORUM_ID";

    my $polls = $db->client_do( QUERY => $query."$range" );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    my $num = $db->client_do( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    my $rv=scalar(@$num);
    my $rw = $rv/50;

    my $html = qq~

<table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
<tr>
    <td><font class='large'>>> Deleting Wrong Polls</font><br>
    <font class='t'>  Please choose which polls to delete by checking the box<br>
      Wrongly created polls will have a different topic title to the natural topic it belongs in. It is safe to delete them if this is the case.</font>
     <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
     <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=dellpolls' method='post'>
     <input type='hidden' name='AD' value='1'>
     <input type='hidden' name='act' value='sqlclient'>
     <input type='hidden' name='s' value='$iB::SESSION'>
     <input type='hidden' name='CODE' value='dellpolls'>
     <input type='hidden' name='offset' value='$iB::IN{'offset'}'>
        <tr>
         <td><table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
             <td bgcolor='#8888AA' align='center' width='32'></td>
             <td bgcolor='#8888AA'><font class='t' style='color:white'><b>Poll title</b></font></td>
             <td bgcolor='#8888AA'><font class='t' style='color:white'><b>Topic title</b></font></td>
             <td bgcolor='#8888AA'><font class='t' style='color:white'><b>Forum name</b></font></td>
            </tr>
        ~;
    for my $poll (@{$polls}) {

        $html .= qq~
            <tr>
             <td bgcolor='#FFFFFF' align='center'><input type='checkbox' name='ID' value='$poll->{'ID'}' style='border:none'></td>
             <td bgcolor='#FFFFFF'><font class='t'>$poll->{'POLL_TITLE'}</font></td>
             <td bgcolor='#FFFFFF'><font class='t'>$poll->{'TOPIC_TITLE'}</font></td>
             <td bgcolor='#FFFFFF'><font class='t'>$poll->{'FORUM_NAME'}</font></td>
            </tr>
        ~;

    }
    $html .= qq~
            <tr>
              <td colspan='4' align='center' bgcolor='#FFFFFF' class='t'>Pages: 
        ~;
    my $num;
    my $page;
    for (my $i=0;$i<$rw;$i++) {
        $num=$i*50;
        $page = $i+1;
        if ($num==$iB::IN{'offset'}) {
            $html .= qq~               [ <b>$page</b> ] ~;
        } else {
            $html .= qq~                [<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=viewpolls&offset=$num'> $page </a>] ~;
        };
    };
    $html .= qq~
              </td>
            </tr>
            <tr>
             <td colspan='4' align='center' bgcolor='#FFFFFF'><br>
             <input type='submit' value='Delete Wrong Polls'></td>
            </tr>
         </table>
         </td>
        </tr>
     </table>
    </form>
    </td>
</tr>
</table>
        ~;

    $ADMIN->Output( WHERE => 'SQLCLIENT', NAV_ONE => 'SQL client backend', PRINT => $html);
}

sub showtable {
    my ($obj, $db) = @_;

    my $attr = $db->table_attr( TABLE => $iB::IN{'table'} );
    
    my $query = $db->show_query;

    my $html = qq~
<table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
<tr>
    <td><font class='large'>>>Table "$iB::IN{'table'}"</font><br>
    <font class='t'>  A field marked red is <font color=red>PRIMARY KEY</font>.<br>
    </font><table cellspacing='1' cellpadding='0' width='100%' align='center' border='0'
    bgcolor='#333366'>
     <tr>
        <td class='t' align='center'>
        <table border='0' width='100%' cellspacing='1' cellpadding='4'>
         <tr>
            <td width='33%' bgcolor='#FFFFFF' class='t' align='center'><strong>Attribute</strong></td>
            <td width='33%' bgcolor='#FFFFFF' class='t' align='center'><strong>Type </strong></td>
            <td width='33%' bgcolor='#FFFFFF' class='t' align='center'><strong>Modifier</strong></td>
         </tr>
    ~;
    foreach my $i (@$attr) {

        if ($$i{'PRIMARY_KEY'}) {
            $$i{'NAME'} = "<font color=red><b>$$i{'NAME'}</b></font>";
        }
        unless ($$i{'TYPE'} =~ /^int.*/i) {
            $$i{'TYPE'} = "$$i{'TYPE'} ".$$i{'SIZE'}."";
        }

        if (($$i{'NOTNULL'} ne "") and ($$i{'NOTNULL'})) {
            $$i{'NOTNULL'} = "not null "
        } else {
            $$i{'NOTNULL'} = "";
        }

        if (defined $$i{'DEFAULT'}) {
            $$i{'DEFAULT'} = " default ' $$i{'DEFAULT'} '";
        }
        
        $html .= qq~
         <tr>
             <td bgcolor='#FFFFFF' class='t'>$$i{'NAME'}</td>
             <td bgcolor='#FFFFFF' class='t'>$$i{'TYPE'} </td>
             <td bgcolor='#FFFFFF' class='t'>$$i{'NOTNULL'}$$i{'DEFAULT'}</td>
         </tr>
        ~;
    }
    $html .= qq~
        </table>
        </td>
     </tr>
    </table>
    <div align='center'>
    <form class='t' action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=action' method='post'>
    <table border='0' cellpadding='3' cellspacing='3' width='100%'>
	  <tr>
		<td colspan='3' class='t' width='100%' align='center'><b><u>The following commands are supported:</u></b></td>
	  </tr>
	  <tr>
		<td class='t' width='33%'>select from table<br>update table set<br>describe</td>
		<td class='t' width='33%'>delete from table<br>create table<br>alter table</td>
		<td class='t' width='33%'>drop table<br>drop index<br>drop sequence (pgSQL)</td>
	  </tr>
    </table>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='sqlclient'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='action'>
    Command: <textarea cols='50' rows='5' name='command' class='forminput'>$query</textarea><br><input type='submit' value='Execute' class='SUBMIT'>
    </form></div>
    </td>
</tr>
</table>
    ~;

    $ADMIN->Output( WHERE => 'SQLCLIENT', NAV_ONE => 'SQL client backend', PRINT => $html);

}

sub do_select {
my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};

    my $sel = $db->client_do( QUERY => $query );
    die "SQL error: $DBI::errstr </font><br><br>Query: <b>$query</b>" if $DBI::errstr;
    
    my $html = qq~
    
<table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
<tr>
    <td><font class='large'>>>Result of selecting</font><br>
    </font><table cellspacing='1' cellpadding='0' width='100%' align='center' border='0'
    bgcolor='#333366'>
     <tr>
        <td class='t' align='center'>
        <table border='0' width='100%' cellspacing='1' cellpadding='4'>
         <tr>
    ~;
    my $i = @$sel[0];
    if ($i) {
       foreach (keys %$i) {
           $html .= qq~
            <td bgcolor='#8888AA' class='t' align='center'><strong><font color='white'><b>$_</b></font></strong></td>
           ~;
       }
       $html .= qq~
         </tr>
       ~;
       foreach my $j (@$sel) {
           $html .= qq~
         <tr>
           ~;
          foreach (keys %$j) {
              $html .= qq~
                 <td bgcolor='#FFFFFF' class='t' align='center'>$$j{$_}</td>
              ~;
          }
       $html .= qq~
         </tr>
       ~;
       }
    } else {
       $html .= qq~
           <td bgcolor='#FFFFFF' class='t' align='center'><br><br>The requested information could not be found.<br><br></td>
         </tr>
       ~;
    };
    $html .= qq~
        </table>
        </td>
     </tr>
    </table><div align='center'>
    <form class='t' action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=action' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='sqlclient'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='action'>
    Command: <textarea cols='50' rows='5' name='command' class='forminput'>$query</textarea><br><input type='submit' value='Execute' class='SUBMIT'>
    </form></div>
    </td>
</tr>
</table>
    ~;

    $ADMIN->Output( WHERE => 'SQLCLIENT', NAV_ONE => 'SQL client backend', PRINT => $html);    

}

sub do_update {
    my ($obj, $db) = @_;
    my $query = $iB::IN{'command'};
    my $text;
    my $sth = $db->client_do_do( QUERY => $query );
    die "SQL error: $DBI::errstr </font><br><br>Query: <b>$query</b>" if $DBI::errstr;

    if ($sth < 1) {
        $text = "NO rows has been updated!"
    }
    elsif ($sth == 1) {
        $text = "1 row has been updated!"
    } else {
        $text = "$sth rows have been updated!"
    }
    $ADMIN->static_screen( URL => "act=sqlclient",
                           TITLE => "Updated",
                           TEXT => "$text"
                         );
};

sub pre_delete {
    my ($obj, $db) = @_;

    my $str = $iB::IN{'command'};
    $str =~ /^delete\s*(.*)$/i;
    my $query = "select * $1";
    my $sth = $db->client_exec( QUERY => $query );
    my $i = $sth->rows;
    my $html = qq~

<table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
<tr>
    <td><font class='large'> >> Deleting information</font><br>
    </font><table cellspacing='1' cellpadding='0' width='100%' align='center' border='0'
    bgcolor='#333366'>
     <tr>
        <td class='t' align='center'>
        <table border='0' width='100%' cellspacing='1' cellpadding='10'>
          <tr>
            <td bgcolor='#FFFFFF' class='t'>
    ~;
    if (!$i) {
        $html .= qq~
            <br>Nothing to delete!
            <br>Try another query<br><br>
        ~;
    }
    elsif ($i == 1) {
        $html .= qq~
            <br><font color='red'>This query will delete <b>1</b> row in table!</font>
            <br>Do you wish to proceed?<br><br>
        ~;
    }
    else {
        $html .= qq~
            <br><font color='red'>This query will delete <b>$i</b> rows in table!</font>
            <br>Do you wish to proceed?<br><br>
        ~;
    }
    $html .= qq~
            </td>
          </tr>
        </table>
        </td>
     </tr>
    </table>
    <div align='center'>
    ~;
    if ($i) {
        $html .= qq~
    <form class='t' action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=action' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='sqlclient'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='do_delete'>
    <input type='hidden' name='command' value='$iB::IN{'command'}'>
    <input type='submit' value='Yes, delete it' class='SUBMIT'>
    </form>
        ~;
    } else {
        $html .= qq~
    <input type='button' value='  Back  ' onclick='history.back();'>
        ~;
    }
    $html .= qq~
    </div>
    </td>
</tr>
</table>
    ~;

    $ADMIN->Output( WHERE => 'SQLCLIENT', NAV_ONE => 'SQL client backend', PRINT => $html); 
}

sub do_delete {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};
    my $del=$db->client_exec( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    $ADMIN->static_screen( URL => "act=sqlclient",
                           TITLE => "Deleted",
                           TEXT => "Information has been successfully deleted!"
                         );
};

sub pre_drop_t {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};

    $query =~ /^drop\s*.+?\s*(\S+)$/i;
    my $table = $1;

    my $attrs = $db->table_attr( TABLE => $table );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    my %attr;
    my $i;
    foreach $i (@$attrs) {
        foreach (keys %$i) {
            $attr{$_}=$$i{$_} if $$i{'PRIMARY_KEY'} == 1;
         }
    }

    unless (defined $attr{NAME}) {
        $attr{NAME} = $$attrs[0]{NAME};
    };

    my $QUERY = "select count($attr{NAME}) from $table";
    die "SQL error: $DBI::errstr" if $DBI::errstr;
    
    my $count = $db->client_exec( QUERY => $QUERY );
    my $numbers = $count->fetchrow;
    my $html = qq~

<table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
<tr>
    <td><font class='large'> >> Droping table $table</font><br>
    </font><table cellspacing='1' cellpadding='0' width='100%' align='center' border='0'
    bgcolor='#333366'>
     <tr>
        <td class='t' align='center'>
        <table border='0' width='100%' cellspacing='1' cellpadding='10'>
        <form class='t' action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=sqlclient&s=$iB::SESSION&CODE=do_prop' method='post'>
        <input type='hidden' name='AD' value='1'>
        <input type='hidden' name='act' value='sqlclient'>
        <input type='hidden' name='s' value='$iB::SESSION'>
        <input type='hidden' name='CODE' value='do_drop_t'>
        <input type='hidden' name='command' value='$iB::IN{'command'}'>
          <tr>
            <td bgcolor='#FFFFFF' class='t'><br>
Table <font color='red'><b>$table</b></font> contains <b>$numbers</b> rows!<br>
Are you sure you want to delete that table?<br><br>
<div align='center'><input type='submit' value='Drop table $table'><br><br>
<font color='red'>Remember that once you delete you won't be able to retrieve the data.</font></div>
            </td>
          </tr>
          </form>
        </table>
        </td>
     </tr>
    </table>

    </div>
    </td>
</tr>
</table>
    ~;

    $ADMIN->Output( WHERE => 'SQLCLIENT', NAV_ONE => 'SQL client backend', PRINT => $html); 
}

sub do_drop_t {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};
    my $drop = $db->client_exec( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    $ADMIN->static_screen( URL => "act=sqlclient",
                         TITLE => "Table dropped",
                         TEXT => "Table has been successfully dropped!<br><br>&nbsp;&nbsp;&nbsp;<font color='red'>Remember, if that table is being used by Ikonboard<br>&nbsp;&nbsp;&nbsp;you must create that table again to prevent errors!</font>"
                         );
}

sub create {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};

    $query =~ s/\n//g; 
    $query =~ /create\s*table\s*(\S+).*/i;
    my $table = $1;

    my $create = $db->client_do_do( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    $ADMIN->static_screen( URL => "act=sqlclient",
                           TITLE => "Table $table created!",
                           TEXT => "Now you can use the table in any manner you see fit."
                         );
}

sub alter {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};
    $query =~ s/\n//g; 
    $query =~ /alter\s*table\s*(\S+).*/i;
    my $table = $1;

    my $create = $db->client_do_do( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    $ADMIN->static_screen( URL => "act=sqlclient",
                           TITLE => "Altered!",
                           TEXT => "Table $table altered!"
                         );
}

sub drop_i {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};
    $query =~ s/\n//g; 
    $query =~ /drop\s*index\s*(\S+).*/i;
    my $index = $1;

    my $drop = $db->client_do_do( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    $ADMIN->static_screen( URL => "act=sqlclient",
                           TITLE => "Dropped!",
                           TEXT => "Index $index dropped!"
                         );
}

sub drop_s {
    my ($obj, $db) = @_;

    my $query = $iB::IN{'command'};
    $query =~ s/\n//g; 
    $query =~ /drop\s*sequence\s*(\S+).*/i;
    my $seq = $1;

    my $drop = $db->client_do_do( QUERY => $query );
    die "SQL error: $DBI::errstr" if $DBI::errstr;

    $ADMIN->static_screen( URL => "act=sqlclient",
                           TITLE => "Dropped!",
                           TEXT => "Sequence $seq dropped!"
                         );
}

sub not_yet {
    my ($obj, $db) = @_;

    $ADMIN->static_screen( URL => "act=sqlclient",
                         TITLE => "Not supported",
                         TEXT => "Sorry, but SQL client does not support this query!"
                         );
}

sub action {
my ($obj, $db) = @_;
my $query = $iB::IN{'command'};

    if ($query =~ /^select\s*.*/i) { 
        $obj->do_select($db);
    } 
    elsif ($query =~ /^describe\s*(\S+)$/i) {
        $iB::IN{table} = $1;
        $obj->showtable($db);
    }
    elsif ($query =~ /^update\s*.*/i) {
        $obj->do_update($db);
    }
    elsif ($query =~ /^delete\s*.*/i) {
        $obj->pre_delete($db);     
    }
    elsif ($query =~ /^drop\s*table\s*.*/i) {
        $obj->pre_drop_t($db);
    }
    elsif ($query =~ /^create\s*table\s*.*/i) {
        $obj->create($db);
    }
    elsif ($query =~ /^alter\s*table.*/i) {
        $obj->alter($db);
    }
    elsif ($query =~ /^drop\s*sequence\s*.*/i) {
       $obj->drop_s($db);
    }
    elsif ($query =~ /^drop\s*index\s*.*/i) {
       $obj->drop_i($db);
    }
# if ($query =~ /^insert.*/i)                { insert($db);    };

else { not_yet($obj,$db); };
}


sub dellpolls {
    my ($obj, $db) = @_;
    my $done = 0;

    my @to_delete = $iB::CGI->param('ID');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must choose a valid Poll ID to delete") unless scalar (@to_delete) > 0;

    $db->delete( TABLE => 'forum_polls',
                 KEY => \@to_delete,
             );

    $done = scalar (@to_delete);

    $ADMIN->static_screen( URL => "act=sqlclient",
                         TITLE => "Incorrectly created polls deleted",
                         TEXT => "The changes were successful<br><br>Polls removed: $done"
                         );

}

sub forum_info {
    my ($obj, $db) = @_;
    my $done;
    my $forum;
    my $topic;

    my $forums = $db->query(TABLE      => 'forum_info',
                            COLUMNS    => ['FORUM_ID',],
                           );
    foreach my $i (@{$forums}) {
        $topic = $db->query(TABLE      => 'forum_topics',
                            COLUMNS    => ['TOPIC_ID','TOPIC_TITLE'],
                            WHERE      => qq|FORUM_ID == $i->{FORUM_ID}|,
                            SORT_KEY   => 'TOPIC_LAST_DATE',
                            SORT_BY    => 'Z-A',
                            RANGE      => "0 to 0"
                           );

        next unless $topic->[0]->{'TOPIC_ID'};

        $forum = $db->update( TABLE    => 'forum_info',
                              KEY      => $i->{FORUM_ID},
                              VALUES   => { L_TOPIC_TITLE  => $topic->[0]->{'TOPIC_TITLE'},
                                            L_TOPIC_ID     => $topic->[0]->{'TOPIC_ID'},
                                          }
                            );
    $done++;
    }


    $ADMIN->static_screen( URL => "act=sqlclient",
                         TITLE => "Forum info updated",
                         TEXT => "The changes were successful<br><br>&nbsp;&nbsp;&nbsp;Forums updated: $done"
                         );
}

##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 
                 'viewpolls'        => \&viewpolls,
                 'dellpolls'        => \&dellpolls,
                 'showtable'        => \&showtable,
                 'action'           => \&action,
                 'do_delete'        => \&do_delete,
                 'do_drop_t'        => \&do_drop_t,
                 'drop_i'           => \&drop_i,
                 'drop_s'           => \&drop_s,
                 'forum_info'       => \&forum_info
             );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
}





1;
__END__
