package Admin::SKIN;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# Admin Skin: Administration HTML.
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
    require 'iTextparser.pm';
}

my $INFO   = Boardinfo->new();
my $img    = $INFO->{'IMAGES_URL'}.'/sys-img';
my $txt    = iTextparser->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub log_in {
    my ($obj, $error) = @_;

    $error = "<font class='text' style='color:#CC0000;font-weight:bold;font-size:14px'>$error</font><br><br>" if $error;

return qq~
    <html>
    <head>
    <title>Ikonboard Administration -&gt; Please Log In</title>
    <SCRIPT LANGUAGE="JavaScript">
    <!--
    if (top.location != self.location) { top.location = self.location }
    //-->
    </SCRIPT>
    <style type="text/css">
    font.text     { font-family: Verdana, Arial; font-size: 9px; color: #000000 }
    font.large    { font-family: Verdana, Arial; font-size: 11px; font-weight: bold; color: #000000 }
    INPUT, SUBMIT 	{
                      font-family: Verdana, Arial;
	                  font-size: 10pt;
	                  border-top:#333366 solid thin;
                      border-bottom:#333366 solid thin;
                      border-left:#333366 solid thin;
                      border-right:#333366 solid thin;
	                  font-family: verdana, helvetica, sans-serif;
                      vertical-align:middle
	}
    </style>
    </head>
    <body background="$img/whiteslice.gif" marginheight='0' marginwidth='0' leftmargin='0' topmargin='0'>
    <table width='100%' height='100%' cellspacing='0' cellpadding='0' align='center' border='0'>
    <tr>
        <td align='center' valign='middle'>
            <table cellspacing='0' cellpadding='0' align='center' border='0'>
            <tr>
                <!-- TOP ROW -->
                <td background="$img/log-in_r1_c1.gif" width='10'><img src="$img/blank.gif" border='0' width='10'  height='44' border='0'></td>
                <td background="$img/log-in_r1_c2.gif" style='width:112px'><img src="$img/blank.gif" border='0' width='112' height='44' border='0'></td>
                <td background="$img/log-in_r1_c3.gif" style='width:400px'><img src="$img/blank.gif" border='0' width='251' height='44' border='0'></td>
                <td background="$img/log-in_r1_c4.gif" width='11'><img src="$img/blank.gif" border='0' width='11'  height='44' border='0'></td>
                <!-- END TOP ROW -->
            </tr>
            <tr>
                <!-- MIDDLE ROW -->
                <td background="$img/log-in_r2_c1.gif" bgcolor='#333366'><img src="$img/blank.gif" border='0' width='10'  height='1'></td>
                <td colspan='2' background="$img/log-in_r2_c2.gif">
                    <form action='$INFO->{'BOARD_URL'}/ikonboard.$INFO->{'CGI_EXT'}?AD=1&act=dologin' method='post'>
                    <input type='hidden' name='AD' value='1'>
                    <input type='hidden' name='act' value='dologin'>
                    <input type='hidden' name='s'  value='$iB::SESSION'>
                    <input type='hidden' name='CookieDate'  value='1'>
                    <font class='large'>&gt;&gt; Welcome to the Ikonboard Control Panel</font>
                    <br><br>$error
                    <font class='text'>Please enter your log in details. You must be an administrator to access the control panel</font>
                    <br><br>
                    <table cellspacing='5' cellpadding='0' align='center' border='0' width='100%'>
                    <tr>
                    <td><font class='text'><b>Your Username</b></td>
                    <td>&nbsp;&nbsp;&nbsp;<img src='$img/keylock.gif' border='0' width='16' height='16'></td>
                    <td>&nbsp;<input type='text' maxlength='32' size='32' name='UserName'></td>
                    </tr>
                    <tr>
                    <td><font class='text'><b>Your Password</b></td>
                    <td>&nbsp;&nbsp;&nbsp;<img src='$img/keylock.gif' border='0' width='16' height='16'></td>
                    <td>&nbsp;<input type='password' maxlength='32' size='32' name='PassWord'></td>
                    </tr>
                    <tr>
                    <td colspan='3'><font class='text'><b><u>Please note:</b></u><br> If you do not log in after <b>5</b> attempts, you will be banned from the Control Panel for 15 minutes.<br>Also note, that if you are not an administrator, you will have your posting rights removed upon log in.</font></td>
                    </tr>
                    <tr>
                    <td colspan='3' align='center'><input type='submit' value='Log In'></td>
                    </tr>                               
                    </table>                      
                    </form>
                    <!-- END CONTENT -->
                </td>
                <td background="$img/log-in_r2_c4.gif" bgcolor='#333366'><img src="$img/blank.gif" border='0' width='11'  height='1'></td>
                <!-- END MIDDLE ROW -->
            </tr>
            <tr>
                <!-- BOTTOM ROW -->
                <td background="$img/log-in_r3_c1.gif"><img src="$img/blank.gif" border='0' width='10'  height='17'></td>
                <td colspan='2' background="$img/log-in_r3_c2.gif"><img src="$img/blank.gif" border='0' width='363'  height='17'></td>
                <td background="$img/log-in_r3_c4.gif"><img src="$img/blank.gif" border='0' width='10'  height='17'></td>
                <!-- END BOTTOM ROW -->
            </tr>
            </table>
        </td>
    </tr>
    </table>
    </body>
    </html>
~;
}
    


sub Error {
    my ($obj, $msg) = @_;

return qq~
    <html>
    <head>
    <title>Ikonboard Administration -&gt; ERROR</title>
    <style type="text/css">
    font.text     { font-family: Verdana, Arial; font-size: 12px; color: #000000 }
    font.large    { font-family: Verdana, Arial; font-size: 14px; font-weight: bold; color: #CC0000 }
    </style>
    </head>
    <body background="$img/whiteslice.gif" marginheight='0' marginwidth='0' leftmargin='0' topmargin='0'>
    <table width='100%' height='100%' cellspacing='0' cellpadding='0' align='center' border='0'>
    <tr>
        <td align='center' valign='middle'>
            <table cellspacing='0' cellpadding='0' align='center' border='0'>
            <tr>
                <!-- TOP ROW -->
                <td background="$img/log-in_r1_c1.gif" width='10'><img src="$img/blank.gif" border='0' width='10'  height='44' border='0'></td>
                <td background="$img/error.gif" style='width:112px'><img src="$img/blank.gif" border='0' width='112' height='44' border='0'></td>
                <td background="$img/log-in_r1_c3.gif" style='width:400px'><img src="$img/blank.gif" border='0' width='251' height='44' border='0'></td>
                <td background="$img/log-in_r1_c4.gif" width='11'><img src="$img/blank.gif" border='0' width='11'  height='44' border='0'></td>
                <!-- END TOP ROW -->
            </tr>
            <tr>
                <!-- MIDDLE ROW -->
                <td background="$img/log-in_r2_c1.gif" bgcolor='#333366'><img src="$img/blank.gif" border='0' width='10'  height='1'></td>
                <td colspan='2' background="$img/log-in_r2_c2.gif">
                    <font class='large'>&gt;&gt; Ikonboard Error</font>
                    <br><br>
                    <font class='text'><b>The error returned was:<br><br>$msg<br><br><center><b>&gt;&gt;<a href='#' onClick='javascript:history.go(-1)'>Back</a> :: <a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1;s=$iB::SESSION'>Log in</a></b></center></font>
                    <!-- END CONTENT -->
                </td>
                <td background="$img/log-in_r2_c4.gif" bgcolor='#333366'><img src="$img/blank.gif" border='0' width='11'  height='1'></td>
                <!-- END MIDDLE ROW -->
            </tr>
            <tr>
                <!-- BOTTOM ROW -->
                <td background="$img/log-in_r3_c1.gif"><img src="$img/blank.gif" border='0' width='10'  height='17'></td>
                <td colspan='2' background="$img/log-in_r3_c2.gif"><img src="$img/blank.gif" border='0' width='363'  height='17'></td>
                <td background="$img/log-in_r3_c4.gif"><img src="$img/blank.gif" border='0' width='10'  height='17'></td>
                <!-- END BOTTOM ROW -->
            </tr>
            </table>
        </td>
    </tr>
    </table>
    </body>
    </html>
~;
}

sub std_print {
    my $obj = shift;

    return qq~
    <html>
    <head>
    <title>Ikonboard Body Frame</title>
    <style type="text/css">
    font.h        { font-family: Arial; font-size: 12px; color: #FF0000 }
    font.t        { font-family: Arial; font-size: 11px; color: #000000 }
        .t        { font-family: Arial; font-size: 11px; color: #000003 }
    font.large    { font-family: Arial; font-size: 12px; font-weight: bold; color: #000000 }
    INPUT, SUBMIT 	{
                      font-family: Verdana, Arial;
	                   font-size: 10pt;
	                   font-family: verdana, helvetica, sans-serif;
                      vertical-align:middle;
                      background-color: #CCCCCC;
	}
    .forminput    {
	font-size: 8pt;
    background-color: #CCCCCC;
	font-family: verdana, helvetica, sans-serif;
    vertical-align:middle;
    width:90%
	}

    </style>
    </head>
    <body marginheight='0' marginwidth='0' leftmargin='0' topmargin='10' bgcolor='#EEEEEE'>
    <table cellspacing='0' cellpadding='0' width='95%' align='center' border='0' background='$img/t-bg.gif'>
    <tr>
    <td align='left' width='14'><img src='$img/wh-l.gif' border='0' width='14' height='23' alt=''></td>
    <td align='left' width='18'><a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION' target='_top' title='Close AdminCP'><img src='$img/t-red.gif' border='0' width='18' height='23' alt='X'></a></td>
    <td align='left' width='23'><a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION' target='_blank' title='Hide AdminCP'><img src='$img/t_amber.gif' border='0' width='23' height='23' alt='-'></a></td>
    <td align='left' width='24'><a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&AD=1' target='_top' title='AdminCP Home'><img src='$img/t-green.gif' border='0' width='24' height='23' alt='+'></a></td>
    <td align='center' width='100%'><img src='$img/<#TITLE#>' border='0' alt=''><img src='$img/blank.gif' border='0' height='23' width='68' alt=''></td>
    <td align='left' width='14'><img src='$img/wh-r.gif' border='0' width='14' height='23' alt=''></td>
    </tr>
    </table>
    <table cellspacing='0' cellpadding='0' width='95%' align='center' border='0' bgcolor='#EEEEEE'>
    <tr>
      <td background='$img/sh-mid-l.gif' align='right' valign='top' width='5'><img src='$img/sh-top-l.gif' border='0' width='5' height='12' alt=''></td>
        <!-- Middle -->
        <td colspan='3'><table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#000000'>
             <tr>
                 <td>
                 <table cellspacing='0' cellpadding='0' width='100%' align='center' border='0' background="$img/whiteslice.gif">
                 <tr>
                     <td align='left'>
                         <table cellspacing='8' cellpadding='0' width='100%' align='center' border='0'>
                         <tr><td align='left'><font class='large'><#NAV#><hr noshade size='1' color='#000000'></font></td></tr>
                         </table>
                         
                         <#OUTPUT#>
     
                     </td>
                 </tr>
                 </table>
                 </td>
               </tr>
           </table></td>
         <!-- Middle-->
     <td background='$img/sh-mid-r.gif' align='left' valign='top' width='5'><img src='$img/sh-top-r.gif' border='0' width='5' height='12' alt=''></td>
     </tr>
     <tr>
     <td align='left' valign='top' width='5'><img src='$img/sh-bot-l.gif' border='0' width='5' height='7' alt=''></td>
           <td align='left' background='$img/sh-bots.gif' valign='top'><img src='$img/sh-bots-l.gif' border='0' width='5' height='7' alt=''></td>
           <td background='$img/sh-bots.gif' align='left' valign='top' width='100%'><img src='$img/blank.gif' border='0' width='5' height='7' alt=''></td>
           <td align='right' background='$img/sh-bots.gif' valign='top'><img src='$img/sh-bots-r.gif' border='0' width='5' height='7' alt=''></td>
     <td align='left' valign='top' width='5'><img src='$img/sh-bot-r.gif' border='0' width='5' height='7' alt=''></td>
    </tr>
    </table>
    <br><br>
    <table cellspacing='0' cellpadding='0' width='95%' align='center' border='0' bgcolor='#EEEEEE'>
    <tr><td class='t' align='center'>Ikonboard $iB::VERSION &copy <a href='http://www.jarvisgroup.net' target='_blank' class='t'>Jarvis Entertainment Group, Inc.</a><br>Lead Programmer: Matthew Mecham</td></tr>
    </table>
    </body>
    </html>
    ~;

}


sub static {
    my $obj = shift;
    my $IN = {  
                "TEXT"          => "",
                "URL"           => "",
                "TITLE"         => "",
                "LINK"          => "Back to the last action",
                @_,
              };

    return qq~
    <html>
    <head>
    <title>Ikonboard Body Frame</title>
    <style type="text/css">
    font.h        { font-family: Verdana, Arial; font-size: 12px; color: #FF0000 }
    font.t        { font-family: Verdana, Arial; font-size: 10px; color: #000000 }
    font.large    { font-family: Verdana, Arial; font-size: 12px; font-weight: bold; color: #000000 }
    </style>
    </head>
    <body bgcolor="#EEEEEE" marginheight='0' marginwidth='0' leftmargin='0' topmargin='10'>
    <table cellspacing='1' cellpadding='0' width='90%' align='center' height='100%' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='0' cellpadding='8' width='100%' align='center' height='100%' border='0' background="$img/whiteslice.gif">
            <tr>
                <td align='left' valign='top'>
                 <font class='h'>&gt;</font>&nbsp;<font class='large'>$IN->{'TITLE'}</font>
                    <br><br>
                    <font class='t'>&nbsp;&nbsp;&nbsp;$IN->{'TEXT'}<br><br>&nbsp;&nbsp;&nbsp;<a href='$IN->{'URL'}' target='BODY'>$IN->{'LINK'}</a></font>
                </td>
            </tr>
            </table>
            </td>
        </tr>
    </table>
    </body>
    </html>
    ~;

}



sub do_frames {
    my $obj = shift;

    return qq~

            <html>
            <head>
                <title>Ikonboard Control Panel</title>
            </head>

            <frameset rows="50,*" cols="*" frameborder="NO" border="0" framespacing="0"> 
                <frame name="TOP" scrolling="NO" noresize src="$INFO->{'BOARD_URL'}/ikonboard.$INFO->{'CGI_EXT'}?AD=1&act=top&s=$iB::SESSION" >
                <frameset cols="185,1*" frameborder="NO" border="0" framespacing="0"> 
                    <frame name="MENU" noresize scrolling="auto" src="$INFO->{'BOARD_URL'}/ikonboard.$INFO->{'CGI_EXT'}?AD=1&act=menu&s=$iB::SESSION">
                    <frame name="BODY" noresize scrolling="auto" src="$INFO->{'BOARD_URL'}/ikonboard.$INFO->{'CGI_EXT'}?AD=1&act=body&s=$iB::SESSION">
                </frameset>
            </frameset>
            <noframes><body bgcolor="#FFFFFF">
             <b>You need a frame capable browser to use the Administration Center
            </body></noframes>
            </html>
    ~;
}

sub Redirect {
    my ($obj, $Text, $Url) = @_;
    $Url =~ s!;!&!g;

    return qq~
    <html>
    <head>
    <title>iB::Please Stand by...</title>
    <meta http-equiv="refresh" content="2; url=$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}$Url" window-location="_top">
    <link type="text/css" href="$iB::INFO->{'IMAGES_URL'}/ikonboard.css" rel="stylesheet">
    </head>
    <body bgcolor='$iB::SKIN->{'HTML_BACK_COL'}'>

    <table cellpadding='0' cellspacing='0' border='0' width="$iB::SKIN->{'TABLE_WIDTH'}" align='center' height='85%'>
    <tr align='center' valign='middle'>
        <td>
        <table cellpadding='10' cellspacing='0' border='0' width="80%" align='center'>
        <tr>
            <td valign='middle' align='center' bgcolor='$iB::SKIN->{'MISCBACK_ONE'}'>
            <font class='redirect'>
            Thanks, $Text
            <br><br>
            Please wait while we transfer you...
            <br><br>
            (<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}$Url' class='misc'>or click here if you do not wish to wait</a>)
            </font>
            </td>
        </tr>
        </table>
        </td>
    </tr>
    </table>
    </body>
    </html>
    ~;

}

sub top {

return qq~
    <html>
    <head>
    <title>Ikonboard Top Frame</title>
    <style type="text/css">
    .large    { font-family: Verdana, Arial; font-size: 10px; font-weight: bold; color: #FFFFFF }
    </style>
    </head>
    <body bgcolor='#666699' marginheight='0' marginwidth='0' leftmargin='0' topmargin='0'>
    <table border='0' cellspacing='0' cellpadding='0' width='100%'>
    <tr>
    <td align='left' width='29'><img src='$img/cp-left.gif' border='0' width='29' height='50' alt=''></td>
    <td align='left' width='100%'><img src='$img/cp-middle.gif' border='0' width='315' height='50' alt=''></td>
    <td align='right'><img src='$img/cp-right.gif' border='0' width='29' height='50' alt=''></td>  
    </tr>
    </table>
    </body>
    </html>
    ~;

}

sub body {

return qq~
    <html>
    <head>
    <title>Ikonboard Body Frame</title>
    <style type="text/css">
    font.text     { font-family: Verdana, Arial; font-size: 9px; color: #000000 }
    font.large    { font-family: Verdana, Arial; font-size: 11px; font-weight: bold; color: #CC0000 }
    </style>
    </head>
    <body background="$img/whiteslice.gif" marginheight='0' marginwidth='0' leftmargin='0' topmargin='0'>
    <br>BODY
    </body>
    </html>
    ~;

}


sub menu {
    my $obj = shift;
    my $url = "$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}";

    my $board_st = $INFO->{'B_ONLINE'} ? 'Offline' : 'Online';

return qq~
    <html>
    <head>
    <title>Ikonboard Menu Frame</title>
    <style type="text/css">
    font          { font-family: Verdana, Arial; font-size: 12px; color: #000000 }
    font.large    { font-family: Verdana, Arial; font-size: 11px; font-weight: bold; color: #CC0000 }
    #tble         { width: 100%; background-color: #EEEEEE }
    font.title    { background-color: #666699; font-weight: 800; font-family: Verdana, Arial; font-size:11px; color: #FFFFFF; width: 100%; padding: 2px }
    font.item     { font-family: Verdana, Arial; font-size:10px; color: #333366; }
    a:link,a:active, a:visited { text-decoration:none; color:#000000; }
    a:hover       { text-decoration:none; color:#000033; background-color:#DEDEDE }
    </style>
    <script language="javascript">
      <!--
      function PopUp(url, name, width,height,center,resize,scroll,posleft,postop) {
         if (posleft != 0) { x = posleft }
         if (postop  != 0) { y = postop  }

         if (!scroll) { scroll = 1 }
         if (!resize) { resize = 1 }

         if ((parseInt (navigator.appVersion) >= 4 ) && (center)) {
             X = (screen.width  - width ) / 2;
             Y = (screen.height - height) / 2;
         }
         if (scroll != 0) { scroll = 1 }
         var Win = window.open( url, name, 'width='+width+',height='+height+',top='+Y+',left='+X+',resizable='+resize+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no');
       }
     //-->
     </script>
    </head>
    <body marginheight='0' marginwidth='0' leftmargin='0' topmargin='0'>
        <table width='100%' cellspacing='0' cellpadding='0' border='0' align='center' bgcolor='#666699'>
        <tr>
            <td align='center'><img src='$img/cp-side-logo.jpg' border='0' width='170' height='77' alt=''></td>
        </tr>
        <tr>
            <td align='center' bgcolor='#EEEEEE'><a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION' target='_top'><font class='item'>Go to your board</font></a></td>
        </tr>
        </table>
        <table width='100%' cellspacing='0' cellpadding='0' border='0' align='center' background="$img/whiteslice.gif">
        <tr>
          <td>

            <font class='title'>Help Files</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='http://help.ikonboard.com/admincp/index.php' target='BODY'>Ikonboard.com help files</a>
            </font>

            <br><br>

            <font class='title'>Moderate</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=auth&s=$iB::SESSION' target='BODY'>Manage Reg. Requests</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=auth&s=$iB::SESSION&CODE=list_lost' target='BODY'>Manage lostP/W requests</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=auth&s=$iB::SESSION&CODE=preview' target='BODY'>Preview Registrations</a
            </font>

            <br><br>


            <font class='title'>Maintain</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=file&s=$iB::SESSION' target='BODY'>Launch File Manager</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=temps&s=$iB::SESSION' target='BODY'>Clean Temp Files</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=sess&s=$iB::SESSION' target='BODY'>Reset Sessions</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=stats&s=$iB::SESSION' target='BODY'>Rebuild Board Stats</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=logs&s=$iB::SESSION' target='BODY'>View Moderator Logs</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=logs&s=$iB::SESSION&CODE=del' target='BODY'>Remove Moderator Logs</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=online&s=$iB::SESSION' target='BODY'>Switch board on/off</a>
            </font>

            <br><br>

            <font class='title'>Options/Settings</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=defaults' target='BODY'>Skin/Language Defaults</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=showPaths' target='BODY'>Board Paths</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=showOps' target='BODY'>Board Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=forum' target='BODY'>Forum Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=topic' target='BODY'>Topic Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=email' target='BODY'>Email Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=search' target='BODY'>Search Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=register' target='BODY'>Register Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=post' target='BODY'>Post Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=member' target='BODY'>Member Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=pm' target='BODY'>PM Options</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=active' target='BODY'>Active Users Hi-lighting</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=ops&s=$iB::SESSION&CODE=report' target='BODY'>"Report Post" set up</a>
            </font>

            <br><br>

            <font class='title'>Category Control</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=cat&s=$iB::SESSION&CODE=02' target='BODY'>Add New</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=cat&s=$iB::SESSION&CODE=delete' target='BODY'>Remove Category</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=cat&s=$iB::SESSION' target='BODY'>Edit Category</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=cat&s=$iB::SESSION&CODE=reorder' target='BODY'>Re-Order Categories</a>
            </font>

            <br><br>

            <font class='title'>Forum Control</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=forum&s=$iB::SESSION&CODE=add' target='BODY'>Add New</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=forum&s=$iB::SESSION&CODE=del' target='BODY'>Remove Forums</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=forum&s=$iB::SESSION' target='BODY'>Edit Forum</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=forum&s=$iB::SESSION&CODE=reorder' target='BODY'>Re-Order Forums</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=forum&s=$iB::SESSION&CODE=count' target='BODY'>Recount Forum</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=forum&s=$iB::SESSION&CODE=list_rules' target='BODY'>Edit/Add Forum Rules</a>
            </font>

            <br><br>

            <font class='title'>Forum Moderators</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=mods&s=$iB::SESSION' target='BODY'>Add Moderator</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=mods&s=$iB::SESSION&CODE=del' target='BODY'>Remove Moderator(s)</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=mods&s=$iB::SESSION&CODE=edit' target='BODY'>Edit Moderators</a>
            </font>

            <br><br>


            <font class='title'>Member Control</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=member&s=$iB::SESSION&CODE=reg' target='BODY'>Pre-Register</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=member&s=$iB::SESSION' target='BODY'>Edit Member</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=member&s=$iB::SESSION&CODE=del' target='BODY'>DELETE Member(s)</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=member&s=$iB::SESSION&CODE=ban' target='BODY'>Ban Control</a>
            <!--<br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=member&s=$iB::SESSION&CODE=email' target='BODY'>Send Email</a>-->
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=member&s=$iB::SESSION&CODE=titles' target='BODY'>Add/Edit/Remove Titles</a>
            </font>

           <br><br>

            <font class='title'>Member Groups</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=group&s=$iB::SESSION&CODE=add' target='BODY'>Add Group</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=group&s=$iB::SESSION' target='BODY'>Edit Groups</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=group&s=$iB::SESSION&CODE=del' target='BODY'>Delete Groups</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=group&s=$iB::SESSION&CODE=default' target='BODY'>Default User Groups</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=group&s=$iB::SESSION&CODE=forummask' target='BODY'>Edit a groups forum mask</a>
            </font>

           <br><br>

            <font class='title'>Help Manager</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=help&s=$iB::SESSION&CODE=add'  target='BODY'>Add Help Topic</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=help&s=$iB::SESSION&CODE=edit' target='BODY'>Edit Topics</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=help&s=$iB::SESSION&CODE=del'  target='BODY'>Delete Topics</a>
            </font>

           <br><br>

            <font class='title'>News Manager</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=template&s=$iB::SESSION&CODE=news'    target='BODY'>Set Up/Edit Settings</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=template&s=$iB::SESSION&CODE=update'  target='BODY'>Force News Update</a>
            </font>

            <br><br>

            <font class='title'>Global Settings</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=emoticon&s=$iB::SESSION' target='BODY'>Edit Emoticons</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=emoticon&s=$iB::SESSION&CODE=add' target='BODY'>Add Emoticons</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=mime&s=$iB::SESSION' target='BODY'>Edit MIME Types</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=mime&s=$iB::SESSION&CODE=add' target='BODY'>Add MIME Types</a>

            <br><br>

            <font class='title'>Templates</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=template&s=$iB::SESSION' target='BODY'>Edit SSI/Email Templates</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=board&s=$iB::SESSION' target='BODY'>New Board Template</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=board&s=$iB::SESSION&CODE=edit' target='BODY'>Edit Board Template</a>

            <br><br>

            <font class='title'>Skins</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=styles&s=$iB::SESSION' target='BODY'>Edit Skin Properties</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=skin&s=$iB::SESSION' target='BODY'>Create New Skin</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=skin&s=$iB::SESSION&CODE=export' target='BODY'>Export Skin Pack</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=skin&s=$iB::SESSION&CODE=import' target='BODY'>Import Skin Pack</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=skin&s=$iB::SESSION&CODE=remove' target='BODY'>Remove Skin</a>


            <br><br>

            <font class='title'>Languages</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=lang&s=$iB::SESSION' target='BODY'>Edit Language files</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=lang&s=$iB::SESSION&CODE=new'    target='BODY'>Create Language Pack</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=lang&s=$iB::SESSION&CODE=export' target='BODY'>Export Language Packs</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=lang&s=$iB::SESSION&CODE=import' target='BODY'>Import Language Packs</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=lang&s=$iB::SESSION&CODE=remove' target='BODY'>Remove Language Pack</a>
            </font>

            <br><br>

            <font class='title'>Database</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=bak&s=$iB::SESSION'    target='BODY'>Export Database</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=import&s=$iB::SESSION' target='BODY'>Import Database</a>
            <br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=dbHandler&s=$iB::SESSION' target='BODY'>Drop Database</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=dbHandler&s=$iB::SESSION&CODE=setup' target='BODY'>Set-up Database</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=dbHandler&s=$iB::SESSION&CODE=switch' target='BODY'>Switch DB Driver</a>
            <br><br>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=convert&s=$iB::SESSION' target='BODY'>iB 2 Import into DBM</a>
            </font>
            <br><br>
            
            <font class='title'>DBM Tools</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=dbmclient&s=$iB::SESSION' target='BODY'>ReIndex Members</a>
            </font>
            <br><br>
 
             <font class='title'>SQL Tools</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=sqlclient&s=$iB::SESSION' target='BODY'>SQL client</a>
            </font>
            <br><br>
                       
            
            <font class='title'>General Tool Box</font>
            <font class='item'>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=tools&s=$iB::SESSION&CODE=groups' target='BODY'>Remove duplicate member<br>&nbsp;&nbsp;&nbsp;groups</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=tools&s=$iB::SESSION&CODE=titles' target='BODY'>Remove custom member<br>&nbsp;&nbsp;&nbsp;titles</a>
            <br><span style='color:red'>&gt;</span> <a href='$url?AD=1&act=tools&s=$iB::SESSION&CODE=skin'   target='BODY'>Rebuild skin .cfg files</a>
            <br><br>
            The following links open in new window
            <br>
            <br><span style='color:red'>&gt;</span> <a href="javascript:PopUp('$img/colours.html','Colours','500','300','0','1','1','1')">Colour Chart</a>
            <br><span style='color:red'>&gt;</span> <a href="javascript:PopUp('$img/css.html','CSS','500','300','0','1','1','1')">CSS Maker</a>
            </font>
            </td>
        </tr>
    </table>
    </body>
    </html>
    ~;

}


#######################################################################################################################

sub title {
    my $obj = shift;

    my %IN = ( TITLE => "",
               TEXT  => "",
               @_,
             );

    $IN{'TEXT'} = qq!<br><br><font class='t'>$IN{'TEXT'}</font>! if $IN{'TEXT'};

    return qq~
    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td><font class='large'>&gt;&gt;$IN{'TITLE'}
        <font class='t'>$IN{'TEXT'}
        <br>Please fill out all required (<font class='h'>*</font>) fields.</font>
    </td>
    </tr>
    </table>
    <br>
    ~;
}

#########################

sub formalize {
    my ($obj, $TXT) = @_;
    return unless defined $TXT;
    return $TXT if $obj->{'_allow_html'};
    return $txt->Convert_for_textfield($TXT);
}

sub htmlalize {
    my ($obj, $TXT) = @_;
    return unless defined $TXT;
    return $TXT if $obj->{'_allow_html'};
    return $txt->Convert_for_db( TEXT => $TXT, SMILIES => 1, IB_CODE => 1, HTML => 1 );
}

    

sub td_input {
    my $obj = shift;

    my %IN = ( TEXT  => "",
               NAME  => "",
               VALUE => "",
               REQ   => "",
               JS    => "",
               NO_PARSE => "",
               TYPE     => "text",
               @_,
             );

    my $req = $IN{'REQ'} ? " <font class='h'>*</font>" : '';

    $IN{'VALUE'} = $obj->formalize($IN{'VALUE'}) unless $IN{'NO_PARSE'};

    return qq~
    <tr>
    <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'>&nbsp;&nbsp;&nbsp;&nbsp;$IN{'TEXT'}$req</font></td>
    <td bgcolor='#FFFFFF' width='60%' align='left'><input type='$IN{TYPE}' name='$IN{'NAME'}' value='$IN{'VALUE'}' class='forminput'></td>
    </tr>
    ~;
}

#########################

sub td_checkbox {
    my $obj = shift;

    my %IN = ( TEXT     => "",
               NAME     => "",
               VALUE    => "",
               SELECTED => "",
               REQ      => "",
               JS       => "",
               @_,
             );

    my $req = $IN{'REQ'} ? " <font class='h'>*</font>" : '';

    $IN{'SELECTED'} = ' checked' if $IN{'SELECTED'};

    return qq~
    <tr>
    <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'>&nbsp;&nbsp;&nbsp;&nbsp;$IN{'TEXT'}$req</font></td>
    <td bgcolor='#FFFFFF' width='60%' align='left'><input type='checkbox' name='$IN{'NAME'}' value='$IN{'VALUE'}' style='border:#FFFFFF' $IN{'SELECTED'} $IN{'JS'}></td>
    </tr>
    ~;
}

#########################

sub td_select {
    my $obj = shift;

    my %IN = ( TEXT     => "",
               NAME     => "",
               SIZE     => "",
               MULTIPLE => "",
               DATA     => [],
               VALUES   => undef,
               REQ      => "",
               JS       => "",
               @_,
             );

    my $req = $IN{'REQ'} ? " <font class='h'>*</font>" : '';

    my $text = $IN{'MULTIPLE'} ? qq!<br><font class='t'><b>Windows Users:</b>Hold down [CTRL] to select multiple choices<br><b>Macintosh Users:</b>Hold down [APPLE] to select multiple choices</font>! : '';

    $IN{'SIZE'}     = "size='$IN{'SIZE'}'" if $IN{'SIZE'};
    $IN{'MULTIPLE'} = 'multiple' if $IN{'MULTIPLE'};

    my $return = qq!<select name='$IN{'NAME'}' $IN{'SIZE'} $IN{'MULTIPLE'} class='forminput' $IN{'JS'}>\n!;

    if (ref($IN{'VALUES'}) eq 'ARRAY') {
        my @values = @{ $IN{'VALUES'} };
        $IN{'VALUES'} = {};
        for (@values) {
            $IN{'VALUES'}->{$_} = 1;
        }
    } else {
        my $value = $IN{'VALUES'};
        $IN{'VALUES'} = {};
        $IN{'VALUES'}->{$value} = 1;
    }

    for my $i (@{ $IN{'DATA'} }) {
        my $selected = ' selected' if $i->{'VALUE'} ne '' and exists $IN{'VALUES'}->{ $i->{'VALUE'} };
        $return .= qq! <option value="$i->{'VALUE'}"$selected>$i->{'NAME'}</option>\n!;
    }

    $return .= '</select>';
                  
    return qq~
    <tr>
    <td bgcolor='#FFFFFF' width='40%' align='left' valign='top'><font class='t'>&nbsp;&nbsp;&nbsp;&nbsp;$IN{'TEXT'}$req</font></td>
    <td bgcolor='#FFFFFF' width='60%' align='left'>$return $text</td>
    </tr>
    ~;
}


#########################

sub td_textarea {
    my $obj = shift;

    my %IN = ( TEXT  => "",
               NAME  => "",
               VALUE => "",
               REQ   => "",
               ROWS  => "",
               SPAN  => "",
               NO_PARSE => "",
               @_,
             );

    $IN{'ROWS'} ||= 6;

    my $req = $IN{'REQ'} ? " <font class='h'>*</font>" : '';
    $IN{'VALUE'} = $obj->formalize($IN{'VALUE'}) unless $IN{'NO_PARSE'};


    if ($IN{'SPAN'}) {
        return qq~
        <tr>
        <td bgcolor='#FFFFFF' colspan='2' align='center'><font class='t'>&nbsp;&nbsp;&nbsp;&nbsp;$IN{'TEXT'}$req</font><br><textarea rows='$IN{'ROWS'}' cols='70' wrap='virtual' class='forminput' name='$IN{'NAME'}'>$IN{'VALUE'}</textarea></td>
        </tr>
        ~;
    } else {

        return qq~
        <tr>
        <td bgcolor='#FFFFFF' width='40%' align='left' valign='top'><font class='t'>&nbsp;&nbsp;&nbsp;&nbsp;$IN{'TEXT'}$req</font></td>
        <td bgcolor='#FFFFFF' width='60%' align='left' nowrap><textarea rows='$IN{'ROWS'}' cols='55' wrap='virtual' class='forminput' name='$IN{'NAME'}'>$IN{'VALUE'}</textarea></td>
        </tr>
        ~;
    }

}

#########################

sub td_submit {
    my $obj = shift;

    my %IN = ( NAME    => "",
               VALUE   => "",
               COLSPAN => "",
               @_,
             );

    $IN{'NAME'} = " name='$IN{'NAME'}' " if $IN{'NAME'};
    $IN{'COLSPAN'} ||= 2;

    return qq~
    <tr>
    <td bgcolor='#FFFFFF' colspan='$IN{'COLSPAN'}' align='center'><br><input type='submit' $IN{'NAME'} value='$IN{'VALUE'}'></td>
    </tr>
    ~;
}

#########################
#########################

sub begin_table {
    my $obj = shift;

    return qq~
    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='4' width='100%' align='center' border='0'>
            <tr>
            ~;

}

#########################

sub section_header {
    my $obj = shift;

    my %IN = ( TITLE   => "",
               TEXT    => "",
               COLSPAN => "",
               @_,
             );

    $IN{'TEXT'} =~ s!<%!&lt;%!g;
    $IN{'TEXT'} =~ s!%>!%&gt;!g;
    $IN{'COLSPAN'} ||= 2;

    $IN{'TEXT'} = "<br>&nbsp;&nbsp;&nbsp;&nbsp;".$IN{'TEXT'} if $IN{'TEXT'};

    return qq~
    <tr>
    <td bgcolor='#EEEEEEF' colspan='$IN{'COLSPAN'}' align='left' valign='top'><font class='h'>&gt;</font>&nbsp;&nbsp;<font class='t'><b>$IN{'TITLE'}</b>$IN{'TEXT'}</font></td>
    </tr>
    ~;
}

#########################

sub end_table {
    my $obj = shift;

    return qq~
    </table>
    </td>
    </tr>
    </table>
    ~;
}

#########################

sub hidden_fields {
    my ($obj, $hidden) = @_;

    my $return;

    for my $i (keys %{$hidden}) {
        $return .= qq[ <input type='hidden' name='$i' value='$hidden->{$i}'>\n];
    }
    
    $return .= qq[ <input type='hidden' name='s' value='$iB::SESSION'>\n<input type='hidden' name='AD' value='1'>\n];

    return $return;
}

#########################

sub form_start {
    my $obj = shift;

    return qq~<form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION' method='post' name='TheForm'>~;
}

#########################

sub form_end {
    my $obj = shift;
    return qq~</form>~;
}

#########################
#########################
1;
