package Admin::Options;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


sub active {
    my ($obj, $db) = @_;

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my $html  = $SKIN->title( TITLE => 'Active Users Hi-Lighting', TEXT => 'You can change the way the active users are formatted' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'do_active'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Please enter the prefix and suffix code. You may use HTML", TEXT => "You may leave both fields blank to remove any special formatting");


    $html .= qq~

        <tr>
        <td bgcolor='#FFFFFF' align='left' class='t'><b><i>Example Only</i></b></td>
        <td bgcolor='#FFFFFF' class='t'><input type='text' class='forminput' readonly style='width:150px' name='EX' value='&lt;span style="color:red"&gt;'>&nbsp;Member Name&nbsp;<input type='text' readonly class='forminput' style='width:150px' name='EX' value='&lt;/span&gt;'>&nbsp;=&nbsp;<span style="color:red">Member Name</span></td>
        </tr>

    ~;

    for my $group (@{ $mem_groups }) {

        my ($st, $end);
        if ($iB::INFO->{AU_FORMAT} =~ /(^|\|)$group->{ID}\~(.+?),(.+?)($|\|)/) {
            $st  = $2;
            $end = $3;
        }

        $html .= qq~

            <tr>
            <td bgcolor='#FFFFFF' align='left' class='t'><b>$group->{'TITLE'}</b></td>
            <td bgcolor='#FFFFFF' class='t'><input type='text' class='forminput' style='width:150px' name='P_$group->{ID}' value='$st'>&nbsp;Member Name&nbsp;<input type='text' class='forminput' style='width:150px' name='S_$group->{ID}' value='$end'>&nbsp;=&nbsp;$st Member Name $end</td>
            </tr>

        ~;
    }
    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Change the formatting' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'Active Users Hi-Lighting', PRINT => $html);
}

sub do_active {
    my ($obj, $db) = @_;

    # Collect the data
    
    my @formats = grep { /^P_(\d+)$/ } $iB::CGI->param();

    my $OLD = Boardinfo->new();
    $OLD->{AU_FORMAT} = "";
    for my $f (@formats) {
        $f =~ /^P_(\d+)$/;
        my $id = $1;
        my $start = $iB::CGI->param('P_'.$1);
        my $end   = $iB::CGI->param('S_'.$1);
        next unless $start and $end;
        # Make them safe:
        $start =~ s/!/&#033;/g;
        $start =~ s/\|/&#124;/g;
        $start =~ s/\~/&#126;/g;
        $start =~ s/,/&#044;/g;
        $end   =~ s/!/&#033;/g;
        $end   =~ s/\|/&#124;/g;
        $end   =~ s/\~/&#126;/g;
        $end   =~ s/,/&#044;/g;

        $OLD->{AU_FORMAT} .= qq($id~$start,$end|);
    }

    # Remove trailing pipe

    $OLD->{AU_FORMAT} =~ s/\|$//;


    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );    

    $ADMIN->static_screen( URL   => "act=ops&CODE=active",
                           TITLE => "The Active user formatting has been modified",
                           TEXT  => "The changes were successful"
                         );

}



#+------------------------ Skin/Lang Defaults Section ------------------------


sub defaults {
    my ($obj, $db) = @_;

    my @editable; 
    my @skins = split( /\|\&\|/, $INFO->{'SKINS'} );
    for my $s (@skins) {
        @_ = split /\:/, $s;
        push @editable, { NAME => $_[2], VALUE => $_[1] };
    }

    my @sorted_lang_files;

    for my $l ( split( /\|\&\|/, $iB::INFO->{'LANGUAGES'} ) ) {
        my ($dir, $name) = split /:/, $l;
        push @sorted_lang_files, { NAME => $name, VALUE => $dir };
    }

    my $l_size = scalar @sorted_lang_files + 1;

    my $size = scalar @editable + 1;

    my $html  = $SKIN->title( TITLE => 'Skin/Language Defaults', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'dodefaults'
                                      } );

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Please choose a default skin" );

    $html .= $SKIN->td_select( TEXT     => 'Installed Skins',
                               NAME     => 'DEFAULT_SKIN',
                               SIZE     => $size,
                               VALUES   => $INFO->{'DEFAULT_SKIN'},
                               DATA     => \@editable,
                             );

    $html .= $SKIN->section_header( TITLE => "Please choose a default language" );

    $html .= $SKIN->td_select( TEXT     => "Current Installed Languages",
                               NAME     => 'DEFAULT_LANGUAGE',
                               SIZE     => $l_size,
                               VALUES   => $INFO->{'DEFAULT_LANGUAGE'},
                               DATA     => \@sorted_lang_files
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Set these defaults' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'Styles/Skin Defaults', PRINT => $html);

}


sub do_defaults {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();
  
    $OLD->{'DEFAULT_LANGUAGE'} = $iB::IN{'DEFAULT_LANGUAGE'};
    $OLD->{'DEFAULT_SKIN'}     = $iB::IN{'DEFAULT_SKIN'};


    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=defaults",
                           TITLE => "Default skin/language information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Board Paths Section ------------------------


sub show_paths {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Edit the Board Paths', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'doPaths'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Board URL's", TEXT => "Please DO NOT add a trailing slash");

    $html .= $SKIN->td_input ( TEXT => 'CGI URL (Board URL)',            NAME => 'cgi_url', VALUE=> "$INFO->{'BOARD_URL'}" ,   REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Non CGI URL (Root Images Path)', NAME => 'img_url', VALUE=> "$INFO->{'IMAGES_URL'}",   REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Website URL',                    NAME => 'web_url', VALUE=> "$INFO->{'HOME_URL'}"  ,   REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Uploads URL',                    NAME => 'upl_url', VALUE=> "$INFO->{'UPLOAD_URL'}"  ,   REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Directory Paths", TEXT => "Please enter the information carefully" );

    $html .= $SKIN->td_input ( TEXT => 'CGI Directory Path',             NAME => 'cgi_dir', VALUE=> "$INFO->{'IKON_DIR'}"    , REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Non CGI Directory Path',         NAME => 'img_dir', VALUE=> "$INFO->{'HTML_DIR'}"    , REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Uploads Directory',              NAME => 'ups_dir', VALUE=> "$INFO->{'PUBLIC_UPLOAD'}", REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Backups Directory',              NAME => 'bak_dir', VALUE=> "$INFO->{'BACKUP_DIR'}",   REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Perl Script Extension',          NAME => 'perl_ex', VALUE=> "$INFO->{'CGI_EXT'}"  ,    REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Perl Path',                      NAME => 'perl_pa', VALUE=> "$INFO->{'PERL_PATH'}",    REQ => 1 );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Board Paths and Directories", PRINT => $html);

}

sub do_paths {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();

    my $NEW = {
                BOARD_URL    => ['cgi_url', 'CGI URL (Board URL)'           ],
                IMAGES_URL   => ['img_url', 'Non CGI URL (Root Images Path)'],
                HOME_URL     => ['web_url', 'Website URL'                   ],
                IKON_DIR     => ['cgi_dir', 'CGI Directory Path'            ],
                HTML_DIR     => ['img_dir', 'Non CGI Directory Path'        ],
                BACKUP_DIR   => ['bak_dir', 'Back-up Directory'             ],
                CGI_EXT      => ['perl_ex', 'Perl Script Extension'         ],
                PERL_PATH    => ['perl_pa', 'Perl Path'                     ],
                UPLOAD_URL   => ['upl_url', 'Upload URL'                    ],
                PUBLIC_UPLOAD => ['ups_dir', 'Upload Path'                   ],
             };

    for my $i (keys %{$NEW}) {
        if ($iB::IN{ $NEW->{$i}[0] } eq '') {
            $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a value for: $NEW->{$i}[1]");
        } else {
            $OLD->{ $i } = $iB::CGI->param( $NEW->{$i}[0] );
        }
    }
    
    # Remove Trailing slashes, because people cant read :D    

    $OLD->{'BOARD_URL'}  =~ s!/+\Z!!;
    $OLD->{'IMAGES_URL'} =~ s!/+\Z!!;
    $OLD->{'HOME_URL'}   =~ s!/+\Z!!;

    # Add trailing slashes because people don't care :D

    $OLD->{'IKON_DIR'}      .= '/' unless $OLD->{'IKON_DIR'}     =~ m!/+\Z!;
    $OLD->{'HTML_DIR'}      .= '/' unless $OLD->{'HTML_DIR'}     =~ m!/+\Z!;
    $OLD->{'TEMPLATE_DIR'}  .= '/' unless $OLD->{'TEMPLATE_DIR'} =~ m!/+\Z!;
    $OLD->{'BACKUP_DIR'}    .= '/' unless $OLD->{'BACKUP_DIR'}   =~ m!/+\Z!;
    $OLD->{'PUBLIC_UPLOAD'} .= '/' unless $OLD->{'PUBLIC_UPLOAD'}   =~ m!/+\Z!;

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=showPaths",
                           TITLE => "Board Path information changes applied",
                           TEXT  => "The changes were successful"
                         );
}

#+------------------------ Board OPTIONS Section ------------------------


sub show_ops {
    my ($obj, $db) = @_;

    my ($joined, $short, $long) = split /\|&\|/, $INFO->{'CLOCK_STYLE'};

    my @time_zone;
    for (-24 .. 24) {
        push @time_zone, { NAME => $_, VALUE => $_ };
    }

    $iB::INFO->{'USE_SSI'} ||= 0;

    my $time_now = $std->get_date( TIME=> time, METHOD => 'LONG' );

    my $html  = $SKIN->title( TITLE => 'Edit the Board Settings', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'doOps'
                                      } );



    $html .= $SKIN->section_header( TITLE => "Board Details");

    $html .= $SKIN->td_select( TEXT     => "Enable SSI file creation?<br>&nbsp;&nbsp;&nbsp;&nbsp;This will update txt files for SSI/PHP inclusion",
                               NAME     => 'USE_SSI',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'USE_SSI'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_input ( TEXT => 'Board Name',        NAME => 'BOARDNAME',  VALUE=> "$INFO->{'BOARDNAME'}" ,   REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Board Description', NAME => 'BOARD_DESC', VALUE=> "$INFO->{'BOARD_DESC'}");
    $html .= $SKIN->td_input ( TEXT => 'Website Name',      NAME => 'HOME_NAME',  VALUE=> "$INFO->{'HOME_NAME'}" ,   REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Your Copyright<br>(&copy;) symbol added automatically', NAME => 'COPYRIGHT_INFO',  VALUE=> "$INFO->{'COPYRIGHT_INFO'}");

    $html .= $SKIN->section_header( TITLE => "Cookie Settings");

    $html .= $SKIN->td_input ( TEXT => 'Cookie ID<br>&nbsp;&nbsp;&nbsp;&nbsp;(To make them unique to this iB)',   NAME => 'COOKIE_ID',   VALUE=> "$INFO->{'COOKIE_ID'}"  , REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Cookie Path<br>&nbsp;&nbsp;&nbsp;&nbsp;(Path from domain to the board - optional)',  NAME => 'COOKIE_PATH', VALUE=> "$INFO->{'COOKIE_PATH'}" );
    $html .= $SKIN->td_input ( TEXT => 'Cookie Domain<br>&nbsp;&nbsp;&nbsp;&nbsp;(Makes your cookies sitewide - optional)<br>&nbsp;&nbsp;&nbsp;&nbsp;IE: If the URL was "www.ikonboard.com" the cookie domain would be ".ikonboard.com"',  NAME => 'COOKIE_DOMAIN', VALUE=> "$INFO->{'COOKIE_DOMAIN'}" );
   
    $html .= $SKIN->section_header( TITLE => "Time and Date settings");

    $html .= $SKIN->td_select( TEXT     => "Board Time Adjust<br>Time is: $time_now",
                               NAME     => 'TIME_ZONE',
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'TIME_ZONE'},
                               DATA     => \@time_zone,
                             );

    $html .= $SKIN->td_select( TEXT     => "Clock Type",
                               NAME     => 'CLOCK_TYPE',
                               SIZE     => 2,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'CLOCK_TYPE'},
                               DATA     => [ { NAME => '24 Hour', VALUE => '24h' },
                                             { NAME => '12 Hour', VALUE => '12h' }, ]
                             );

    $html .= $SKIN->td_input ( TEXT => 'Time Zone Name', NAME => 'BASE_TIME', VALUE=> "$INFO->{'BASE_TIME'}", REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Time and Date Style", TEXT => "You can use any seperating characters. Example values for clock display: YEAR = 2000, MONTH_NUMBER = 5 (For May), MONTH_NAME = May, DATE_NUMBER = 15, DAY_NAME = Monday, HOUR = 3 (For 3 o'clock), MIN = 23 (For 23 mins)");

    $html .= $SKIN->td_input ( TEXT => 'Clock Style: <b>Joined Date</b>', NAME => 'CLOCK_JOINED', VALUE=> $joined,  REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Clock Style: <b>Short Date</b>',  NAME => 'CLOCK_SHORT',  VALUE=> $short ,  REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Clock Style: <b>Long Date</b>',   NAME => 'CLOCK_LONG' ,  VALUE=> $long  ,  REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Set a load limit (*NIX ONLY)", TEXT => "You may enter a limit for the server load before a user gets a \"server busy\" message. 1.0 is 100% for single processor machines, 2.0 is 100% for dual processor machines. Leave blank if you do not want to set a limit. If a limit is set, the current load will be displayed with the admin stats");

    $html .= $SKIN->td_input ( TEXT => 'Server Load Limit',   NAME => 'LOAD_LIMIT' ,  VALUE=> $iB::INFO->{'LOAD_LIMIT'} );


    $html .= $SKIN->section_header( TITLE => "Basic Security Settings");

    $html .= $SKIN->td_input ( TEXT => 'Flood Control Wait (in seconds)<br>Leave blank, or enter 0 to switch it off',   NAME => 'FLOOD_CONTROL'     ,VALUE=> $INFO->{'FLOOD_CONTROL'}     ,REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Length of user sessions after log in<br>(in seconds: 3600 seconds = 1 hour)',   NAME => 'SESSION_EXPIRATION',VALUE=> $INFO->{'SESSION_EXPIRATION'},REQ => 1 );
  
    $html .= $SKIN->td_select( TEXT     => "Validate the users browser as part of the authorize procedure?",
                               NAME     => 'CHECK_USER_AGENT',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'CHECK_USER_AGENT'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow dynamic pages in IMG tags?<br>&nbsp;&nbsp;&nbsp;&nbsp;Enabling this poses a security risk.",
                               NAME     => 'ALLOW_DYNAMIC_IMG',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'ALLOW_DYNAMIC_IMG'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );
    
    $html .= $SKIN->section_header( TITLE => "Other Settings");

    $html .= $SKIN->td_input( TEXT   => "Your default charset<br>&nbsp;&nbsp;&nbsp;&nbsp;Default is ISO-8859-1",
                              NAME   => 'CHARSET',
                              REQ   => 0,
                              VALUE  => $iB::INFO->{'CHARSET'},
                           );
#############
#
# Added by Infection
#
    $html .= $SKIN->td_select( TEXT     => "Show Board Calendar? (Must have \"Show online users\" on for this)",
                               NAME     => 'CALENDAR',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'CALENDAR'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );
#
#
#############
    $html .= $SKIN->td_select( TEXT     => "Show Board Statistics?<br>(Total Users, Posts ..etc)",
                               NAME     => 'SHOW_STATS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'SHOW_STATS'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Show users online in board index?",
                               NAME     => 'SHOW_ONLINE',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'SHOW_ONLINE'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Show link to users online page?<br>&nbsp;&nbsp;&nbsp;&nbsp;(If you choose to show online users in the board index)",
                               NAME     => 'ALLOW_ONLINE_LIST',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'ALLOW_ONLINE_LIST'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Enable Invite a Friend feature?",
                               NAME     => 'INVITE_FRIEND',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'INVITE_FRIEND'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Force everyone to log in before viewing the board?",
                               NAME     => 'FORCE_LOGIN',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'FORCE_LOGIN'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Enable the Skins feature?",
                               NAME     => 'ALLOW_SKINS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'ALLOW_SKINS'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Enable iB Template Tags?<br>&nbsp;&nbsp;&nbsp;&nbsp;Allows the use of SSI in the global templates",
                               NAME     => 'TEMPLATE_TAGS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'TEMPLATE_TAGS'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Compress HTML (removes newlines and multiple spaces)",
                               NAME     => 'COMPRESS_HTML',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{'COMPRESS_HTML'},
                               DATA     => [ { NAME => 'Yes', VALUE => '1' },
                                             { NAME => 'No',  VALUE => '0' }, ]
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Board Options", PRINT => $html);

}


sub do_ops {
    my ($obj, $db) = @_;

    my $NEW = {
                BOARDNAME          => ['Board Name'           , '1'  ],
                BOARD_DESC         => ['Board Description'    , '1'  ],
                HOME_NAME          => ['Website Name'         , '1'  ],
                COPYRIGHT_INFO     => ['Copyright Information', '0'  ],
                COOKIE_ID          => ['Cookie ID'            , '0'  ],
                COOKIE_PATH        => ['Cookie Path'          , '0'  ],
                TIME_ZONE          => ['Time Zone'            , '1'  ],
                CLOCK_TYPE         => ['Clock Type'           , '1'  ],
                BASE_TIME          => ['Time Zone Name'       , '1'  ],
                FLOOD_CONTROL      => ['Flood Control'        , '0'  ],
                SESSION_EXPIRATION => ['Session Expiration'   , '1'  ],
                CHECK_USER_AGENT   => ['Validate Browser'     , '1'  ],
                SHOW_STATS         => ['Show Statistics'      , '1'  ],
                FORCE_LOGIN        => ['Force Log in'         , '1'  ],
                ALLOW_SKINS        => ['Allow Skins'          , '1'  ],
                INVITE_FRIEND      => ['Invite Friend Feature', '1'  ],
                ALLOW_ONLINE_LIST  => ['','0'],
                SHOW_ONLINE        => ['','0'],
                ALLOW_DYNAMIC_IMG  => ['','0'],
                USE_SSI            => ['','0'],
                LOAD_LIMIT         => ['','0'],
                COOKIE_DOMAIN      => ['','0'],
                TEMPLATE_TAGS      => ['','0'],
                COMPRESS_HTML      => ['','0'],
                CHARSET            => ['Default charset','0'],
####### Added by Infection
                CALENDAR           => ['Board Calendar','1'],
####
             };

    my $OLD = Boardinfo->new();

    $OLD->{'CLOCK_STYLE'} = $iB::IN{'CLOCK_JOINED'}."|&|".$iB::IN{'CLOCK_SHORT'}."|&|".$iB::IN{'CLOCK_LONG'};

    for my $i (keys %{$NEW}) {
        if ($iB::IN{ $i } eq '' and $NEW->{$i}[1]) {
            $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a value for: $NEW->{$i}[0]");
        } else {
            $OLD->{ $i } = $iB::IN{ $i };
        }
    }

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=showOps",
                           TITLE => "Board Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Forum Section ------------------------

sub forum {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Forum Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'doforum'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Forum Options");

    $html .= $SKIN->td_input ( TEXT => 'No. posts before it\'s a hot topic',     NAME => 'HOT_TOPIC',          VALUE=> "$INFO->{'HOT_TOPIC'}"         ,   REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Topics per page',                        NAME => 'DISPLAY_MAX_TOPICS', VALUE=> "$INFO->{'DISPLAY_MAX_TOPICS'}",   REQ => 1 );
    
    $html .= $SKIN->td_select( TEXT     => "Default cut off date for topic display",
                               NAME     => 'PRUNE_DAYS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'PRUNE_DAYS'},
                               DATA     => [ { NAME => 'Today'       ,  VALUE => '1'   },
                                             { NAME => 'Last 5 Days' ,  VALUE => '5'   }, 
                                             { NAME => 'Last 7 Days' ,  VALUE => '7'   },
                                             { NAME => 'Last 10 Days',  VALUE => '10'  },
                                             { NAME => 'Last 15 Days',  VALUE => '15'  },
                                             { NAME => 'Last 20 Days',  VALUE => '20'  },
                                             { NAME => 'Last 25 Days',  VALUE => '25'  },
                                             { NAME => 'Last 30 Days',  VALUE => '30'  },
                                             { NAME => 'Last 60 Days',  VALUE => '60'  },
                                             { NAME => 'Last 90 Days',  VALUE => '90'  },
                                             { NAME => 'Show all'    ,  VALUE => '100' },
                                            ]
                             );


    $html .= $SKIN->section_header( TITLE => "Default Forum Order", TEXT => "Your members can override this setting. You can also override these settings on a forum per forum basis" );

    $html .= $SKIN->td_select( TEXT     => "Default sort key",
                               NAME     => 'SORT_KEY',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'SORY_KEY'},
                               DATA     => [ { VALUE => 'TOPIC_LAST_DATE' ,  NAME => 'Date of the last post'     },
                                             { VALUE => 'TOPIC TITLE'     ,  NAME => 'Topic Title'               }, 
                                             { VALUE => 'TOPIC_STARTER_N' ,  NAME => 'Topic Starters Name'       },
                                             { VALUE => 'TOPIC_POSTS'     ,  NAME => 'Topic Posts'               },
                                             { VALUE => 'TOPIC_VIEWS'     ,  NAME => 'Topic Posts'               },
                                             { VALUE => 'TOPIC_START_DATE',  NAME => 'Date the topic was started'},
                                             { VALUE => 'TOPIC_LASTP_N'   ,  NAME => 'Name of the last poster'   },
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Default sort order",
                               NAME     => 'FORUM_SORT_ORDER',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'FORUM_SORT_ORDER'},
                               DATA     => [ { VALUE => 'Z-A' ,  NAME => 'Descending (Z - A, 10 - 0)' },
                                             { VALUE => 'A-Z' ,  NAME => 'Ascending  (A - Z, 0 - 10)' }, 
                                           ]
                             );

    $html .= $SKIN->section_header( TITLE => "Forum Thread Prefixes");

    $html .= $SKIN->td_input ( TEXT => 'Prefex for Pinned Topics',NAME => 'PRE_PINNED',VALUE=> "$INFO->{'PRE_PINNED'}", NO_PARSE => 1);
    $html .= $SKIN->td_input ( TEXT => 'Prefex for Moved Topics', NAME => 'PRE_MOVED', VALUE=> "$INFO->{'PRE_MOVED'}", NO_PARSE => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Prefex for Polls',        NAME => 'PRE_POLLS', VALUE=> "$INFO->{'PRE_POLLS'}", NO_PARSE => 1 );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Default Forum Options", PRINT => $html);

}


sub do_forum {
    my ($obj, $db) = @_;

    my $NEW = {
                HOT_TOPIC          => ['No. Posts for Hot Topic', '1'  ],
                DISPLAY_MAX_TOPICS => ['Topics per page'        , '1'  ],
                SORT_KEY           => ['Sort Key'               , '1'  ],
                FORUM_SORT_ORDER   => ['Sort Order'             , '1'  ],
                PRUNE_DAYS         => ['Cut off topic days'     , '1'  ],
                PRE_PINNED         => [ ],
                PRE_MOVED          => [ ],
                PRE_POLLS          => [ ],
             };

    my $OLD = Boardinfo->new();
  
    for my $i (keys %{$NEW}) {
        if ($iB::IN{ $i } eq '' and $NEW->{$i}[1]) {
            $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a value for: $NEW->{$i}[0]");
        } else {
            $OLD->{ $i } = $iB::IN{ $i };
            # Allow basic HTML tags
            $OLD->{ $i } =~ s/&lt;/</g;
            $OLD->{ $i } =~ s/&gt;/>/g;
            $OLD->{ $i } =~ s/&amp;/&/g;
        }
    }

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=forum",
                           TITLE => "Forum Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Email Section ------------------------


sub email {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Email Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'doemail'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Email Addresses");

    $html .= $SKIN->td_input ( TEXT => 'Outgoing Email Address', NAME => 'ADMIN_EMAIL_OUT', VALUE=> "$INFO->{'ADMIN_EMAIL_OUT'}",   REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Incoming Email Address', NAME => 'ADMIN_EMAIL_IN',  VALUE=> "$INFO->{'ADMIN_EMAIL_IN'}",    REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Mail Options");

    $html .= $SKIN->td_select( TEXT     => "Send mail using:",
                               NAME     => 'EMAIL_TYPE',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'EMAIL_TYPE'},
                               DATA     => [ { NAME => 'SMTP'    ,  VALUE => 'smtp'      },
                                             { NAME => 'SendMail',  VALUE => 'send_mail' }, 
                                            ]
                             );


    $html .= $SKIN->td_select( TEXT     => "Email Content:",
                               NAME     => 'EMAIL_CONTENT',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'EMAIL_CONTENT'},
                               DATA     => [ { NAME => 'HTML',  VALUE => 'html' },
                                             { NAME => 'Text',  VALUE => 'text' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Use a form for when members email other members?<br>&nbsp;&nbsp;&nbsp;&nbsp;This keeps all email addresses private",
                               NAME     => 'USE_MAIL_FORM',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'USE_MAIL_FORM'},
                               DATA     => [ { NAME => 'Yes',  VALUE => 1 },
                                             { NAME => 'No' ,  VALUE => 0 }, 
                                            ]
                             );

    $html .= $SKIN->td_input ( TEXT => 'SMTP Server (If using SMTP)',       NAME => 'SMTP_SERVER', VALUE=> "$INFO->{'SMTP_SERVER'}",REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Sendmail Path (If using Sendmail)', NAME => 'SEND_MAIL',   VALUE=> "$INFO->{'SEND_MAIL'}",  REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Default Email Content");

    $html .= $SKIN->td_textarea( TEXT => "Email Header", NAME => 'EMAIL_HEADER', VALUE => $INFO->{'EMAIL_HEADER'} );
    $html .= $SKIN->td_textarea( TEXT => "Email Footer", NAME => 'EMAIL_FOOTER', VALUE => $INFO->{'EMAIL_FOOTER'} );
    $html .= $SKIN->td_textarea( TEXT => "Signature",    NAME => 'SIGNATURE',    VALUE => $INFO->{'SIGNATURE'} );

    $html .= $SKIN->section_header( TITLE => "Email Logging");

    $html .= $SKIN->td_select( TEXT     => "Log all emails sent from this board?",
                               NAME     => 'LOG_EMAILS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'LOG_EMAILS'},
                               DATA     => [ { NAME => 'Yes' ,  VALUE => '1' },
                                             { NAME => 'No'  ,  VALUE => '0' }, 
                                           ]
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Email Options", PRINT => $html);

}

sub do_email {
    my ($obj, $db) = @_;

    my $NEW = {
                ADMIN_EMAIL_IN  => ['Incoming Email address'        , '1'  ],
                ADMIN_EMAIL_OUT => ['Outgoing Email address'        , '1'  ],
                SMTP_SERVER     => [''                              , '0'  ],
                SEND_MAIL       => [''                              , '0'  ],
                EMAIL_TYPE      => ['Email sending program'         , '1'  ],
                EMAIL_CONTENT   => [''                              , '0'  ],
                EMAIL_HEADER    => [''                              , '0'  ],
                EMAIL_FOOTER    => [''                              , '0'  ],
                SIGNATURE       => [''                              , '0'  ],
                LOG_EMAILS      => ['Log Emails from Invite Friend' , '1'  ],
                USE_MAIL_FORM   => ['use mail form', '1'],
             };

    my $OLD = Boardinfo->new();
  
    for my $i (keys %{$NEW}) {
        if ($iB::IN{ $i } eq '' and $NEW->{$i}[1]) {
            $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a value for: $NEW->{$i}[0]");
        } else {
            $OLD->{ $i } = $iB::IN{ $i };
        }
    }

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=email",
                           TITLE => "Email Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Topic Settings ------------------------


sub topic {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Topic Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'dotopic'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Topic Options");

    $html .= $SKIN->td_input ( TEXT => 'Posts per page', NAME => 'DISPLAY_MAX_POSTS', VALUE=> "$INFO->{'DISPLAY_MAX_POSTS'}",   REQ => 1 );
    
    $html .= $SKIN->td_select( TEXT     => "Allow votes to bump a poll?",
                               NAME     => 'ALLOW_POLL_BUMP',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_POLL_BUMP'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1'   },
                                             { NAME => 'No' ,  VALUE => '0'   }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow the poll creator to vote?",
                               NAME     => 'ALLOW_CREATOR_VOTE',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_CREATOR_VOTE'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1'   },
                                             { NAME => 'No' ,  VALUE => '0'   }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Post display order",
                               NAME     => 'TOPIC_SORT_ORDER',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'TOPIC_SORT_ORDER'},
                               DATA     => [ { VALUE => 'A-Z' ,  NAME => 'Older Posts First' },
                                             { VALUE => 'Z-A' ,  NAME => 'Newer Posts First' }, 
                                           ]
                             );

    $INFO->{'IMG_ATT_SHOW'} ||= 0;

    $html .= $SKIN->td_select( TEXT     => "Show uploaded images in posts (rather than a link to the attachment)?",
                               NAME     => 'IMG_ATT_SHOW',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'IMG_ATT_SHOW'},
                               DATA     => [ { NAME => 'Yes - include with post'            ,  VALUE => '1'   },
                                             { NAME => 'No - handle as a normal attachment' ,  VALUE => '0'   }, 
                                            ]
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Topic Options", PRINT => $html);

}

sub do_topic {
    my ($obj, $db) = @_;

    my $NEW = {
                DISPLAY_MAX_POSTS  => ['No. Posts per page'         , '1'  ],
                ALLOW_POLL_BUMP    => ['Allow polls to bump'        , '1'  ],
                ALLOW_CREATOR_VOTE => ['Allow poll creator to vote' , '1'  ],
                TOPIC_SORT_ORDER   => ['Sort Order'                 , '1'  ],
                IMG_ATT_SHOW       => ['','0'],
             };

    my $OLD = Boardinfo->new();
  
    for my $i (keys %{$NEW}) {
        if ($iB::IN{ $i } eq '' and $NEW->{$i}[1]) {
            $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a value for: $NEW->{$i}[0]");
        } else {
            $OLD->{ $i } = $iB::IN{ $i };
        }
    }

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=topic",
                           TITLE => "Topic Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}



#+------------------------ Search Options ------------------------


sub search {
    my ($obj, $db) = @_;

    my @words = split (/\|/, $INFO->{'SKIP_WORDS'});
    $INFO->{'SKIP_WORDS'} = join "\n",@words;

    my $html  = $SKIN->title( TITLE => 'Search Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'dosearch'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Search Options", TEXT => "TIP: Set the maximum character limit to around 250, and add common words<br>&nbsp;&nbsp;&nbsp;&nbsp;in the 'Skip these words box' for an efficient search set-up");

    $html .= $SKIN->td_select( TEXT     => "Allow the use of search?:",
                               NAME     => 'ALLOW_SEARCH',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_SEARCH'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1'      },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );



    $html .= $SKIN->td_input ( TEXT => 'No. of characters to store<br>&nbsp;&nbsp;&nbsp;&nbsp;(Leave blank to store complete post)', NAME => 'MAX_CHARS', VALUE=> "$INFO->{'MAX_CHARS'}" );

    $html .= $SKIN->td_textarea( TEXT => "Skip these words:<br>&nbsp;&nbsp;&nbsp;&nbsp;(Case Insensitive - One per line)",  NAME => 'SKIP_WORDS', VALUE => $INFO->{'SKIP_WORDS'} );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Search Options", PRINT => $html);

}

sub do_search {
    my ($obj, $search) = @_;

    my $OLD = Boardinfo->new();
  
    $OLD->{'ALLOW_SEARCH'} = $iB::IN{'ALLOW_SEARCH'} || 0;
    $OLD->{'MAX_CHARS'}    = $iB::IN{'MAX_CHARS'}    || 'all';

    $iB::IN{'SKIP_WORDS'} =~ s!\r!!;
    $iB::IN{'SKIP_WORDS'} =~ s!\n\n!!;
    $iB::IN{'SKIP_WORDS'} =~ s!<br>!|!ig;

    $OLD->{'SKIP_WORDS'}  = $iB::IN{'SKIP_WORDS'};

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=search",
                           TITLE => "Search Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Register Options ------------------------


sub register {
    my ($obj, $db) = @_;

    my $rules = $db->select(  TABLE  => 'forum_rules',
                              KEY    => '00',
                           );

    $rules->{'TEXT'} =~ s!<br>!\n!g;

    my @words = split (/\|/, $INFO->{'SAVED_NAMES'});
    $INFO->{'SAVED_NAMES'} = join "\n",@words;

    my $html  = $SKIN->title( TITLE => 'Register Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'doregister'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Register Permissions" );

    $html .= $SKIN->td_select( TEXT     => "Allow new users to register?",
                               NAME     => 'ALLOW_REGISTER',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_REGISTER'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Send email to validate registrations?",
                               NAME     => 'VALIDATE_REGISTER',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'VALIDATE_REGISTER'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Preview all registrations before enabling posting rights?",
                               NAME     => 'PREVIEW_REG',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'PREVIEW_REG'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Get notified via email for each new registration?",
                               NAME     => 'USER_NOTIFY',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'USER_NOTIFY'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "ALLOW multiple use of the same email address?",
                               NAME     => 'ALLOW_MULT_EMAIL',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_MULT_EMAIL'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->section_header( TITLE => "Board Rules" );

    $html .= $SKIN->td_select( TEXT     => "Show board rules on registration?",
                               NAME     => 'SHOW_BOARD_RULES',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'SHOW_BOARD_RULES'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_input ( TEXT => 'Board Rules Title',    NAME => 'BOARD_RULES_NAME', VALUE=> $rules->{'RULES_TITLE'} );

    $html .= $SKIN->td_textarea( TEXT => "Edit Board Rules:",  NAME => 'BOARD_RULES_REG', VALUE => $rules->{'RULES_TEXT'} );

    $html .= $SKIN->td_input ( TEXT => 'How long to allow validation via email?<br>&nbsp;&nbsp;&nbsp;&nbsp;(In days)', NAME => 'AUTHORISE_PRUNE', VALUE=> "$INFO->{'AUTHORISE_PRUNE'}" );

    $html .= $SKIN->section_header( TITLE => "Reserved Names", TEXT => "One name per line, add/edit or delete usernames in your reserved names list" );

    $html .= $SKIN->td_textarea( TEXT => "Reserved Names:<br>&nbsp;&nbsp;&nbsp;&nbsp;(Case Insensitive - One per line)",  NAME => 'SAVED_NAMES', VALUE => $INFO->{'SAVED_NAMES'} );

    $html .= $SKIN->td_submit( NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Registration Options", PRINT => $html);

}

sub do_register {
    my ($obj, $db) = @_;

    if ($iB::IN{'BOARD_RULES_REG'} and $iB::IN{'BOARD_RULES_NAME'}) {
        $db->update( TABLE  => 'forum_rules',
                     KEY    => '00',
                     VALUES => { RULES_TITLE => $iB::IN{'BOARD_RULES_NAME'},
                                 RULES_TEXT  => $iB::IN{'BOARD_RULES_REG'},
                                 LAST_UPDATE => time,
                               }
                   );
    }

    my $OLD = Boardinfo->new();
  
    $OLD->{'ALLOW_REGISTER'}    = $iB::IN{'ALLOW_REGISTER'};
    $OLD->{'VALIDATE_REGISTER'} = $iB::IN{'VALIDATE_REGISTER'} || 0;
    $OLD->{'PREVIEW_REG'}       = $iB::IN{'PREVIEW_REG'}       || 0;
    $OLD->{'USER_NOTIFY'}       = $iB::IN{'USER_NOTIFY'}       || 0;
    $OLD->{'SHOW_BOARD_RULES'}  = $iB::IN{'SHOW_BOARD_RULES'}  || 0;
    $OLD->{'AUTHORISE_PRUNE'}   = $iB::IN{'AUTHORISE_PRUNE'}   || 30;
    $OLD->{'ALLOW_MULT_EMAIL'}  = $iB::IN{'ALLOW_MULT_EMAIL'};

    $iB::IN{'SAVED_NAMES'} =~ s!\r!!;
    $iB::IN{'SAVED_NAMES'} =~ s!\n\n!!;
    $iB::IN{'SAVED_NAMES'} =~ s!<br>!|!ig;

    $OLD->{'SAVED_NAMES'}  = $iB::IN{'SAVED_NAMES'};

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=register",
                           TITLE => "Registration Option changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Post Options ------------------------


sub post {
    my ($obj, $db) = @_;

    my @ext = split (/\|/, $INFO->{'IMG_EXT'});
    $INFO->{'IMG_EXT'} = join "\n", @ext;

    # Re-arrange the word filter

    my @words = split (/\|/, $INFO->{'WORD_FILTER'});
    my $words_for_textarea;
    for (@words) {
        if (/(.+?)\:e\:(.+?)\Z/) {
            $words_for_textarea .= "{".$1."=".$2."}\n";
        }
        elsif (/(.+?)\:\:(.+?)\Z/) {
            $words_for_textarea .= $1."=".$2."\n";
        }
        elsif (/(.+?)\:e\:\Z/) {
            $words_for_textarea .= "{".$1."}\n";
        }
        elsif (/(.+?)\:\:\Z/) {
            $words_for_textarea .= $1."\n";
        }
    }

    my $html  = $SKIN->title( TITLE => 'Post Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'dopost'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Post Permissions" );

    $html .= $SKIN->td_input ( TEXT => 'Smilies per row in Clickable Table',    NAME => 'EMO_PER_ROW'     , VALUE=> $INFO->{'EMO_PER_ROW'} );

    $html .= $SKIN->td_select( TEXT     => "Allow Polls?",
                               NAME     => 'ALLOW_POLLS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_POLLS'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow Images to be posted?",
                               NAME     => 'ALLOW_IMAGES',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_IMAGES'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );
    $html .= $SKIN->td_input ( TEXT => 'Max (in kb) Post Length',        NAME => 'MAX_POST_LENGTH', VALUE=> $INFO->{'MAX_POST_LENGTH'} );
    $html .= $SKIN->td_input ( TEXT => 'Maximum no. images per post',    NAME => 'MAX_IMAGES'     , VALUE=> $INFO->{'MAX_IMAGES'} );
    $html .= $SKIN->td_input ( TEXT => 'Maximum no. emoticons per post', NAME => 'MAX_EMOS'       , VALUE=> $INFO->{'MAX_EMOS'} );
    
    $html .= $SKIN->td_textarea( TEXT => "Allowed Image Extensions:<br>&nbsp;&nbsp;&nbsp;&nbsp;(Case Insensitive, one per line)",  NAME => 'IMG_EXT', VALUE => $INFO->{'IMG_EXT'} );

    $html .= $SKIN->section_header( TITLE => "Flash Permissions" );

    $html .= $SKIN->td_select( TEXT     => "Allow Flash to be posted?",
                               NAME     => 'ALLOW_FLASH',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ALLOW_FLASH'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_input ( TEXT => 'Max Flash Movie Width',    NAME => 'MAX_W_FLASH', VALUE=> $INFO->{'MAX_W_FLASH'} );
    $html .= $SKIN->td_input ( TEXT => 'Max Flash Movie Height',   NAME => 'MAX_H_FLASH', VALUE=> $INFO->{'MAX_H_FLASH'} );


    $html .= $SKIN->section_header( TITLE => "Word Filter", TEXT => "One entry per line in the following format<br>&nbsp;&nbsp;&nbsp;&nbsp;To match exactly, with a value to replace it with <u>{badword=goodword}</u><br>&nbsp;&nbsp;&nbsp;&nbsp;To match exactly, allowing '#' sign to blank out word: <u>{badword}</u><br>&nbsp;&nbsp;&nbsp;&nbsp;To match partly (badword 'hell' blanks hello: ####o) <u>badword</u><br>&nbsp;&nbsp;&nbsp;&nbsp;To match partly, with a word to be replaced <u>badword=goodword</u>" );

    $html .= $SKIN->td_textarea( TEXT => "Words:",  NAME => 'WORD_FILTER', VALUE => $words_for_textarea );

    $html .= $SKIN->section_header( TITLE => "New Topic Etiquette Filter", TEXT => "This enables you to automagically remove excess exclamation marks / question marks and to stop members 'SHOUTING LIKE THIS' in topic titles" );

    $INFO->{'ETFILTER_PUNCT'} ||= 0;
    $INFO->{'ETFILTER_SHOUT'} ||= 0;

    $html .= $SKIN->td_select( TEXT     => "Remove Excess Exclamation Marks and Question Marks?",
                               NAME     => 'ETFILTER_PUNCT',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ETFILTER_PUNCT'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Stop members from SHOUTING?",
                               NAME     => 'ETFILTER_SHOUT',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'ETFILTER_SHOUT'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_submit( NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Post Options", PRINT => $html);

}

sub do_post {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();

    if ($iB::IN{'WORD_FILTER'}) {
        $iB::IN{'WORD_FILTER'} =~ s|&#123;|\{|g;
        $iB::IN{'WORD_FILTER'} =~ s|&#125;|\}|g;
        $iB::IN{'WORD_FILTER'} =~ s|\$|&#036;|g;

        my $word;
        for ( split (/<br>/, $iB::IN{'WORD_FILTER'}) ) {
            if (/\A{(.+?)=(.+?)}\Z/) {
                $word .= $1.":e:".$2."|";
            }
            elsif (/\A(.+?)=(.+?)\Z/) {
                $word .= $1."::".$2."|";
            }
            elsif (/\A{(.+?)}\Z/) {
                $word .= $1.":e:|";
            }
            elsif (/\A(.+?)\Z/) {
                $word .= $1."::|";
            }
        }
        $OLD->{'WORD_FILTER'} = $word;
    }

    $OLD->{'ALLOW_POLLS'}     = $iB::IN{'ALLOW_POLLS'};
    $OLD->{'MAX_IMAGES'}      = $iB::IN{'MAX_IMAGES'};
    $OLD->{'MAX_EMOS'}        = $iB::IN{'MAX_EMOS'};
    $OLD->{'ALLOW_IMAGES'}    = $iB::IN{'ALLOW_IMAGES'}     || 0;
    $OLD->{'ALLOW_FLASH'}     = $iB::IN{'ALLOW_FLASH'}       || 0;
    $OLD->{'MAX_H_FLASH'}     = $iB::IN{'MAX_H_FLASH'}       || 200;
    $OLD->{'MAX_W_FLASH'}     = $iB::IN{'MAX_W_FLASH'}      || 200;
    $OLD->{'MAX_POST_LENGTH'} = $iB::IN{'MAX_POST_LENGTH'} || 75;
    $OLD->{'EMO_PER_ROW'}     = $iB::IN{'EMO_PER_ROW'} || 75;
    $OLD->{ETFILTER_SHOUT}    = $iB::IN{ETFILTER_SHOUT};
    $OLD->{ETFILTER_PUNCT}    = $iB::IN{ETFILTER_PUNCT};
    $iB::IN{'IMG_EXT'} =~ s!\r!!g;
    $iB::IN{'IMG_EXT'} =~ s!\n{1,}!!g;
    $iB::IN{'IMG_EXT'} =~ s!<br>!|!ig;
    $iB::IN{'IMG_EXT'} =~ s!(?:\|+)$!!;

    $OLD->{'IMG_EXT'}  = $iB::IN{'IMG_EXT'};

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=post",
                           TITLE => "Post Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Member Options ------------------------


sub member {
    my ($obj, $db) = @_;

    my @ext = split (/\|/, $INFO->{'AV_EXT'});
    $INFO->{'AV_EXT'} = join "\n", @ext;

    my $html  = $SKIN->title( TITLE => 'Member Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'domember'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Member Permissions" );

    $html .= $SKIN->td_input ( TEXT => 'No. posts before the user can change their own member title<br>&nbsp;&nbsp;&nbsp;&nbsp;Or leave blank if you do not want them to change it.',  NAME => 'POST_TITLECHANGE', VALUE=> $iB::INFO->{'POST_TITLECHANGE'} );

    $html .= $SKIN->td_select( TEXT     => "Allow Avatars?",
                               NAME     => 'AVATARS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'AVATARS'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow users to input a URL for an Avatar?",
                               NAME     => 'AV_ALLOW_URL',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'AV_ALLOW_URL'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow HTML in signatures?",
                               NAME     => 'SIG_ALLOW_HTML',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'SIG_ALLOW_HTML'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow iB CODE in signatures?",
                               NAME     => 'SIG_ALLOW_IBC',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'SIG_ALLOW_IBC'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow smilies in signatures?",
                               NAME     => 'SIG_ALLOW_EMOTICONS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'SIG_ALLOW_EMOTICONS'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    my ($av_w  , $av_h)   = split ("x", $INFO->{'AV_DIMS'});
    my ($d_av_w, $d_av_h) = split ("x", $INFO->{'DEF_AV_DIMS'});

    $html .= $SKIN->td_input ( TEXT => 'Maximum Custom Avatar Width (in px)',  NAME => 'AVATAR_WIDTH', VALUE=> $av_w, REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Maximum Custom Avatar Height (in px)', NAME => 'AVATAR_HEIGHT',VALUE=> $av_h, REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Pre-Installed Avatar Width (in px)',  NAME => 'D_AVATAR_WIDTH', VALUE=> $d_av_w, REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Pre-Installed Avatar Height (in px)', NAME => 'D_AVATAR_HEIGHT',VALUE=> $d_av_h, REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Maximum Signature Length (in characters)', NAME => 'MAX_SIG_LENGTH',VALUE=> $INFO->{'MAX_SIG_LENGTH'}, REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Maximum Interests Length (in characters)', NAME => 'MAX_INTEREST_LENGTH',VALUE=> $INFO->{'MAX_INTEREST_LENGTH'}, REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'Maximum Location Length  (in characters - cannot be greater than 128)', NAME => 'MAX_LOCATION_LENGTH',VALUE=> $INFO->{'MAX_LOCATION_LENGTH'}, REQ => 1 );

    $html .= $SKIN->td_textarea( TEXT => "Allowed Avatar Extensions:<br>&nbsp;&nbsp;&nbsp;&nbsp;(Case Insensitive, one per line)",  NAME => 'AV_EXT', VALUE => $INFO->{'AV_EXT'} );

    $html .= $SKIN->td_submit( NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Member Options", PRINT => $html);

}

sub do_member {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();
    
    $iB::IN{'MAX_LOCATION_LENGTH'} = 128 if $iB::IN{'MAX_LOCATION_LENGTH'} > 128;

    $OLD->{'AVATARS'}             = $iB::IN{'AVATARS'};
    $OLD->{'AV_ALLOW_URL'}        = $iB::IN{'AV_ALLOW_URL'};
    $OLD->{'MAX_SIG_LENGTH'}      = $iB::IN{'MAX_SIG_LENGTH'}       || 500;
    $OLD->{'MAX_INTEREST_LENGTH'} = $iB::IN{'MAX_INTEREST_LENGTH'}  || 100;
    $OLD->{'MAX_LOCATION_LENGTH'} = $iB::IN{'MAX_LOCATION_LENGTH'}  || 128;

    $iB::IN{'AV_EXT'} =~ s!\r!!;
    $iB::IN{'AV_EXT'} =~ s!\n\n!!;
    $iB::IN{'AV_EXT'} =~ s!<br>!|!ig;

    $OLD->{'AV_DIMS'}     = $iB::IN{'AVATAR_WIDTH'}   ."x". $iB::IN{'AVATAR_HEIGHT'};
    $OLD->{'DEF_AV_DIMS'} = $iB::IN{'D_AVATAR_WIDTH'} ."x". $iB::IN{'D_AVATAR_HEIGHT'};
    $OLD->{'AV_EXT'}  = $iB::IN{'AV_EXT'};
    $OLD->{'SIG_ALLOW_IBC'}        = $iB::IN{'SIG_ALLOW_IBC'};
    $OLD->{'SIG_ALLOW_HTML'}       = $iB::IN{'SIG_ALLOW_HTML'};
    $OLD->{'SIG_ALLOW_EMOTICONS'}  = $iB::IN{'SIG_ALLOW_EMOTICONS'};
    $OLD->{'POST_TITLECHANGE'}     = $iB::IN{'POST_TITLECHANGE'} || '';

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=member",
                           TITLE => "Member Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


#+------------------------ Member Options ------------------------


sub pm {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Messenger Options', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'dopm'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Messenger Permissions" );

    $html .= $SKIN->td_select( TEXT     => "Allow HTML in the PM's?",
                               NAME     => 'MSG_ALLOW_HTML',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'MSG_ALLOW_HTML'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow iB code in the PM's?",
                               NAME     => 'MSG_ALLOW_CODE',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'MSG_ALLOW_CODE'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_input ( TEXT => 'Maximum Messages each user can store',   NAME => 'MAX_MESSAGES',   VALUE=> $INFO->{'MAX_MESSAGES'},  REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'Maximum Message Size (in Kb)',           NAME => 'MAX_MSG_SIZE',   VALUE=> $INFO->{'MAX_MSG_SIZE'},  REQ => 1 );

    $html .= $SKIN->td_input ( TEXT => 'No. of days before messages are pruned', NAME => 'MSG_PRUNE_DAYS', VALUE=> $INFO->{'MSG_PRUNE_DAYS'}, REQ => 1 );

    $html .= $SKIN->td_submit( NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Messenger Options", PRINT => $html);

}

sub do_pm {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();

    $OLD->{'MAX_MESSAGES'}    = $iB::IN{'MAX_MESSAGES'}    || 20;
    $OLD->{'MAX_MSG_SIZE'}    = $iB::IN{'MAX_MSG_SIZE'}    || 40;
    $OLD->{'MSG_ALLOW_HTML'}  = $iB::IN{'MSG_ALLOW_HTML'}  || 0;
    $OLD->{'MSG_ALLOW_CODE'}  = $iB::IN{'MSG_ALLOW_CODE'}  || 0;
    $OLD->{'MSG_PRUNE_DAYS'}  = $iB::IN{'MSG_PRUNE_DAYS'}  || 0;

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=pm",
                           TITLE => "Messenger Option information changes applied",
                           TEXT  => "The changes were successful"
                         );
}


sub report {
    my ($obj, $db) = @_;
    
    $INFO->{'REPORT_POST_ENABLED'} ||= '0';
    $INFO->{'REPORT_POST_METHOD'}  ||= '0';
    
    my $message = qq~Reporting a post to a moderator:\n\n================================\n\nLink to Post: <#LINK TO POST#>\nTopic Title: <#TOPIC_TITLE#>\nForum: <#FORUM#>
                     Reported by: <#MEMBER NAME#>\n\nIP Address of sender: <#IP ADDRESS#>\n\nEmail address of sender: <#EMAIL#>\n\nReported on: <#DATE#>\n\nMessage:\n<#MESSAGE#>~;
    
    my $temp = $db->select( TABLE  => 'email_templates',
                            KEY    => 'report_post',
                          );
                          
    $temp->{'TEMPLATE'} ||= $message;

    my $html  = $SKIN->title( TITLE => '"Report this post" setup', TEXT => 'This will enable you to define how the "Report this post to a moderator" feature works and acts.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'ops',
                                        CODE  => 'do_report'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Configuration" );

    $html .= $SKIN->td_select( TEXT     => "Enable this feature?",
                               NAME     => 'REPORT_POST_ENABLED',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'REPORT_POST_ENABLED'},
                               DATA     => [ { NAME => 'Yes',  VALUE => '1' },
                                             { NAME => 'No' ,  VALUE => '0' }, 
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Which method do you wish to use to contact the moderator?",
                               NAME     => 'REPORT_POST_METHOD',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $INFO->{'REPORT_POST_METHOD'},
                               DATA     => [ { NAME => 'Via Email and Private Message',  VALUE => '2' },
                                             { NAME => 'Via Email'                    ,  VALUE => '1' },
                                             { NAME => 'Via Private Message'          ,  VALUE => '0' },
                                            ]
                             );

    $html .= $SKIN->td_textarea( TEXT => "Message to be sent to the moderators:<br>&nbsp;&nbsp;&nbsp;&nbsp;(Do not rename the &lt;#TAGS#&gt;)",  NAME => 'MESSAGE', VALUE => $temp->{'TEMPLATE'} );

    $html .= $SKIN->td_submit( NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => "Report Post set up", PRINT => $html);

}

sub do_report {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();

    $OLD->{'REPORT_POST_ENABLED'}    = $iB::IN{'REPORT_POST_ENABLED'};
    $OLD->{'REPORT_POST_METHOD'}     = $iB::IN{'REPORT_POST_METHOD'};

    # Update the DB
    
    my $temp = $db->select( TABLE  => 'email_templates',
                            KEY    => 'report_post',
                          );

    if ($temp->{'TEMPLATE'}) {
        $db->update( TABLE   => 'email_templates',
                     KEY     => 'report_post',
                     VALUES  => { TEMPLATE  => $iB::CGI->param('MESSAGE') },
                   );
    } else {
        $db->insert( TABLE   => 'email_templates',
                     VALUES  => { ID       => 'report_post',
                                  TYPE     => '1',
                                  TEMPLATE => $iB::CGI->param('MESSAGE'),
                                },
                   );
    }

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=ops&CODE=report",
                           TITLE => "Report post information changes applied",
                           TEXT  => "The changes were successful"
                         );
}

#+------------------------ Blah ------------------------



sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'showPaths'    => \&show_paths,
                 'doPaths'      => \&do_paths,

                 'showOps'      => \&show_ops,
                 'doOps'        => \&do_ops,

                 'forum'        => \&forum,
                 'doforum'      => \&do_forum,

                 'topic'        => \&topic,
                 'dotopic'      => \&do_topic,

                 'email'        => \&email,
                 'doemail'      => \&do_email,

                 'search'       => \&search,
                 'dosearch'     => \&do_search,

                 'register'     => \&register,
                 'doregister'   => \&do_register,

                 'post'         => \&post,
                 'dopost'       => \&do_post,

                 'member'       => \&member,
                 'domember'     => \&do_member,

                 'pm'           => \&pm,
                 'dopm'         => \&do_pm,

                 'defaults'     => \&defaults,
                 'dodefaults'   => \&do_defaults,

                 'active'       => \&active,
                 'do_active'    => \&do_active,
                 
                 'report'       => \&report,
                 'do_report'    => \&do_report,

               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : error($obj,$db);
} 

sub error {
    my ($obj, $db) = @_;
    die "Error!";
}


1;