package Admin::Online;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;


    my $html  = $SKIN->title( TITLE => 'Board Status Control');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'online',
                                        CODE  => 'edit'
                                      } );

    my $do = $INFO->{'B_ONLINE'} ? 0 : 1;

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Please select an option", TEXT => "If you have permission to enter the board when it's off line, this will not affect you." );

    $html .= $SKIN->td_select( TEXT     => 'Turn This Board:',
                               NAME     => 'B_ONLINE',
                               VALUES   => $do,
                               DATA     => [ { NAME => 'Online', VALUE => 1 },
                                             { NAME => 'Offline' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_textarea( TEXT  => "Offline Message:",
                                 NAME  => 'OFFLINE_MESSAGE',
                                 VALUE => $INFO->{'OFFLINE_MESSAGE'},
                                 ROWS  => 20
                                );



    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MAINTAIN', NAV_ONE => 'Board Status', PRINT => $html);

}


sub edit {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();

    $OLD->{'B_ONLINE'}        = $iB::IN{'B_ONLINE'};
    $OLD->{'OFFLINE_MESSAGE'} = $iB::IN{'OFFLINE_MESSAGE'};

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $ADMIN->write_log( TITLE => 'Board Status Changed');

    $ADMIN->static_screen( URL   => "act=online",
                           TITLE => "Board Status Changed",
                           TEXT  => "The changes were successful<br>"
                         );
}
            


##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'        => \&edit,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
