package Admin::ModControl;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}



sub splash {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'add',
                      BUTTON => 'Add Moderator to the selected forum(s)',
                      TYPE   => 'checkbox',
                      TEXT   => 'Add a moderator to the selected forum(s)',
                      DB     => $db
                    );
}

sub edit {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'doedit',
                      BUTTON => 'Choose a moderator to edit',
                      TYPE   => 'radio',
                      TEXT   => 'Editing a moderator',
                      DB     => $db
                    );
}


sub delete {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'dodel',
                      BUTTON => 'Delete Selected Moderators',
                      TYPE   => 'checkbox',
                      TEXT   => 'Choose Moderators to delete',
                      DB     => $db
                    );
}

sub print_list {
    my $obj = shift;

    my %IN = ( CODE    => "",
               BUTTON  => "",
               TYPE    => "",
               TEXT    => "",
               DB      => "",
               @_,
              );

    my $db = $IN{'DB'};

    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        COLUMNS   => ['CAT_NAME', 'CAT_ID'],
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_MODS'}   = $db->query(TABLE     => 'forum_moderators',
                                        SORT_KEY  => 'MEMBER_NAME',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};


    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; Your Forums</font><br>
    <font class='t'>&nbsp;&nbsp;$IN{'TEXT'}</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&CODE=view' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='mods'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='$IN{'CODE'}'>

    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#8888AA' width='10%' align='center'>&nbsp;</td>
            <td bgcolor='#8888AA' width='30%'><font class='t' style='color:white'><b>Forum Name</b></font></td>
            <td bgcolor='#8888AA' width='15%' align='center'><font class='t' style='color:white'><b>Forum ID</b></font></td>
            <td bgcolor='#8888AA' width='8%' align='center'><font class='t' style='color:white'><b>Topics</b></font></td>
            <td bgcolor='#8888AA' width='8%' align='center'><font class='t' style='color:white'><b>Posts</b></font></td>
            <td bgcolor='#8888AA' width='30%'><font class='t' style='color:white'><b>Last Post</b></font></td>
            </tr>
    ~;


    for my $this_cat (@{ $obj->{'TOTAL_CATS'} }) {

        $html .= qq~
        <tr>
        <td bgcolor='#CCCCCC' align='left' colspan='6'><font class='large'>&gt; $this_cat->{'CAT_NAME'}</font></td>
        </tr>
        ~;

        for my $forum (grep { $_->{'CATEGORY'} == $this_cat->{'CAT_ID'} } @{ $obj->{'TOTAL_FORUMS'} }) {
           
            $forum->{'FORUM_LAST_POST'} = $forum->{'FORUM_LAST_POST'}
                                        ? $std->get_date(TIME=>$forum->{'FORUM_LAST_POST'}, METHOD=>'LONG')
                                        : 'never';

            if ($IN{'CODE'} eq 'dodel' or $IN{'CODE'} eq 'doedit') {

                $html .= qq~

                <tr>
                <td bgcolor='#FFFFFF' align='center'>&nbsp;</td>
                <td bgcolor='#FFFFFF'><font class='t'>&gt;&gt;$forum->{'FORUM_NAME'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_ID'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_TOPICS'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_POSTS'}</font></td>
                <td bgcolor='#FFFFFF'><font class='t'>$forum->{'FORUM_LAST_POST'}</font></td>
                </tr>
                ~;

                my @mods = grep { $forum->{'FORUM_ID'} == $_->{'FORUM_ID'} } @{ $obj->{'TOTAL_MODS'} };
                for ( @mods ) {
                    $html .= qq~
                        <tr>
                        <td bgcolor='#DDDDDD' align='center'>&nbsp;</td>
                        <td bgcolor='#DDDDDD' align='left' colspan='5'><input type='$IN{'TYPE'}' name='mod_id' value='$_->{'MODERATOR_ID'}' style='border:none'><font class='t'>$_->{'MEMBER_NAME'}</font></td>
                        </tr>
                    ~;
                }

            } else {

                my @mods;
                for ( grep { $forum->{'FORUM_ID'} == $_->{'FORUM_ID'} } @{ $obj->{'TOTAL_MODS'} }  ) {
                    push @mods, "<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION;act=Profile;CODE=03;MID=$_->{'MEMBER_ID'}' class='highlight' target='_blank'>$_->{'MEMBER_NAME'}</a>";
                }

                $forum->{'MODERATOR'}   = 'Current Moderators: ' . join ", ", @mods if @mods > 0;
                $forum->{'MODERATOR'} ||= '<b><i>Currently Unmoderated</i></b>';

                $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' align='center'><input type='$IN{'TYPE'}' name='f' value='$forum->{'FORUM_ID'}' style='border:none'></td>
                <td bgcolor='#FFFFFF'><font class='t'>&gt;&gt;$forum->{'FORUM_NAME'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_ID'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_TOPICS'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_POSTS'}</font></td>
                <td bgcolor='#FFFFFF'><font class='t'>$forum->{'FORUM_LAST_POST'}</font></td>
                </tr>
                <tr>
                <td bgcolor='#FFFFFF' align='center'>&nbsp;</td>
                <td bgcolor='#DDDDDD' align='left' colspan='5'><font class='t'>$forum->{'MODERATOR'}</font></td>
                </tr>
                ~;
            }

        }
    }

    if ($IN{'CODE'} eq 'add') {

        $html .= qq~<tr><td colspan='6'><br><br><table cellspacing='1' cellpadding='3' width='100%'>~;

        $html .= $SKIN->section_header( TITLE => "Enter the moderators name", TEXT => "Or enter a partial string to search by" );

        $html .= $SKIN->td_input (TEXT => 'Members Name', NAME => 'MEMBER_NAME', VALUE=> '', REQ => 1 );

        $html .= qq~</table></td></tr>~;

    }


    $html .= qq~
            
            <tr>
            <td colspan='6' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='$IN{'BUTTON'}'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;


    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => 'Forum Control', PRINT => $html);

}




####################################################################################
#
# Add Moderators
#
####################################################################################

sub add {
    my ($obj, $db) = @_;

    my @forums_to_add = $iB::CGI->param('f');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No forums selected, please try again") unless scalar @forums_to_add > 0;

    my $forum_keys = join "+", @forums_to_add;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a Members Name") unless $iB::IN{'MEMBER_NAME'};

    my $member = $mem->LoadMember( DB => $db, KEY => $iB::IN{'MEMBER_NAME'}, METHOD => 'by_name' );


    #XXX Load, and build our forum array.

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};


    my $forum_names;

    for my $f (@{$obj->{'TOTAL_FORUMS'}}) {
        if (grep { $_ == $f->{'FORUM_ID'} } @forums_to_add) {
            $forum_names .= $f->{'FORUM_NAME'}.', ';
        }
    }

    $forum_names =~ s!,\s{0,}$!!;


    my $html  = $SKIN->title( TITLE => "Adding a Moderator");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act   => 'mods',
                                        CODE  => 'doadd',
                                        f_keys => $forum_keys,
                                      } );


    #XXX Do we have an exact member name match?

    if ($member->{'MEMBER_ID'}) {

        $html .= $SKIN->td_input (TEXT => 'Members Name', NAME => 'MEMBER_NAME', VALUE=> $member->{'MEMBER_NAME'}, REQ => 1 );
        $html .= $SKIN->hidden_fields( { MEMBER_ID  => $member->{'MEMBER_ID'} } );

    } else {

        #XXX No, ok, lets pull all the names that are similar

        $iB::IN{'MEMBER_NAME'} =~ s!\[!\\\\[!g;
        $iB::IN{'MEMBER_NAME'} =~ s!\]!\\\\]!g;

        my $query_stm =  "MEMBER_NAME LIKE /%$iB::IN{'MEMBER_NAME'}%/";

        my $member_query = $db->query( TABLE    => 'member_profiles',
                                       COLUMNS  => ['MEMBER_NAME', 'MEMBER_ID'],
                                       WHERE    => $query_stm,
                                       SORT_KEY => 'MEMBER_NAME'
                                     );

        #XXX Crash and burn if we don't get any matches

        unless (scalar (@{$member_query}) > 0) {
            $ADMIN->Error( DB=>"", STD=>"", MSG => "No matches found for that Member Name");
        }

        my @poss_members;
        for my $m (@{$member_query}) {
            push @poss_members, { NAME => $m->{'MEMBER_NAME'}, VALUE => $m->{'MEMBER_ID'} };
        }

        #XXX Warn the admin that (s)he needs to choose from the list.

        $html .= $SKIN->section_header( TITLE => "EXACT MEMBER NAME MATCH NOT FOUND", TEXT => "We could not find an exact match for that member name. Please choose from the list below, or go back and try again" );                           

        $html .= $SKIN->td_select( TEXT     => "Choose a member",
                                   NAME     => 'MEMBER_ID',
                                   SIZE     => '',
                                   REQ      => 1,
                                   VALUES   => '',
                                   DATA     => \@poss_members,
                             );

    }

    
    #XXX Ok, lets set up the permissions.


    $html .= $SKIN->section_header( TITLE => "Moderator Permissions", TEXT => "These permissions are only applicable to this member in this forum<br>Adding into <span style='color:red'>$forum_names</span>" );


    $html .= $SKIN->td_select( TEXT     => 'Can edit all posts?:',
                               NAME     => 'EDIT_POST',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete posts?',
                               NAME     => 'DELETE_POST',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete queued posts?',
                               NAME     => 'POST_Q',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can edit all Topics?<br>&nbsp;&nbsp;&nbsp;&nbsp;Topic titles, etc',
                               NAME     => 'EDIT_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete topics?',
                               NAME     => 'DELETE_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete queued topics?',
                               NAME     => 'TOPIC_Q',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can open topics?',
                               NAME     => 'OPEN_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can close topics?',
                               NAME     => 'CLOSE_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can Move topics?',
                               NAME     => 'MOVE_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );


    $html .= $SKIN->td_select( TEXT     => 'Can pin topics?',
                               NAME     => 'PIN_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can unpin topics?',
                               NAME     => 'UNPIN_TOPIC',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can mass move topics?',
                               NAME     => 'MASS_MOVE',
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can mass prune topics?',
                               NAME     => 'MASS_PRUNE',
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can view poster IPs?',
                               NAME     => 'VIEW_IP',
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Can privately warn other members?",
                               NAME     => 'ALLOW_WARN',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Add Moderator to these forum(s)' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => qq[<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=mods' target='BODY'>Moderator Control</a>], NAV_TWO => "Adding a Moderator", PRINT => $html);


}

sub do_add {
    my ($obj, $db) = @_;

    my @forums;

    if ($iB::IN{'f_keys'} =~ m!\+!) {
        @forums = split (/\+/, $iB::IN{'f_keys'});
    } else {
        $forums[0] = $iB::IN{'f_keys'};
    }


    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a Moderators Name") unless $iB::IN{'MEMBER_ID'};

    my $member = $db->select( TABLE   => 'member_profiles',
                              ID      => $iB::IN{'MEMBER_ID'},
                              KEY     => $iB::IN{'MEMBER_ID'},
                              COLUMNS => ['MEMBER_NAME', 'MEMBER_ID'],
                            );

    $ADMIN->Error( DB => $db, STD => $std, MSG => "Could not find that member!") unless $member->{'MEMBER_ID'};

    # Add the data into the DB

    for my $f (@forums) {
        $db->insert( TABLE  => 'forum_moderators', 
                     VALUES => { FORUM_ID                => $f,
                                 MEMBER_NAME             => $member->{'MEMBER_NAME'},
                                 MEMBER_ID               => $member->{'MEMBER_ID'},
                                 EDIT_POST               => $iB::IN{'EDIT_POST'},
                                 EDIT_TOPIC              => $iB::IN{'EDIT_TOPIC'},
                                 DELETE_POST             => $iB::IN{'DELETE_POST'},
                                 DELETE_TOPIC            => $iB::IN{'DELETE_TOPIC'},
                                 VIEW_IP                 => $iB::IN{'VIEW_IP'},
                                 OPEN_TOPIC              => $iB::IN{'OPEN_TOPIC'},
                                 CLOSE_TOPIC             => $iB::IN{'CLOSE_TOPIC'},
                                 MOVE_TOPIC              => $iB::IN{'MOVE_TOPIC'},
                                 MASS_MOVE               => $iB::IN{'MASS_MOVE'},
                                 MASS_PRUNE              => $iB::IN{'MASS_PRUNE'},
                                 MOVE_TOPIC              => $iB::IN{'MOVE_TOPIC'},
                                 PIN_TOPIC               => $iB::IN{'PIN_TOPIC'},
                                 UNPIN_TOPIC             => $iB::IN{'UNPIN_TOPIC'},
                                 POST_Q                  => $iB::IN{'POST_Q'},
                                 TOPIC_Q                 => $iB::IN{'TOPIC_Q'},
                                 ALLOW_WARN              => $iB::IN{'ALLOW_WARN'},
                               }
                  );
    }

    $ADMIN->write_log( TITLE => 'Forum Moderator Added', EXTRA => "Forum ID: $iB::IN{'FORUM_ID'}");

    $ADMIN->static_screen( URL   => "act=mods",
                           TITLE => "Forum Moderator Added",
                           TEXT  => "The changes were successful"
                         );
}


####################################################################################
#
# DELETE Moderators
#
####################################################################################

sub do_delete {
    my ($obj, $db) = @_;

    my @mods_to_delete = $iB::CGI->param('mod_id');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Moderators to delete, please try again") unless scalar @mods_to_delete > 0;

    my $mod_keys = join "+", @mods_to_delete;

    my $html  = $SKIN->title( TITLE => "Deleting Moderators", TEXT => "WARNING: THIS ACTION CANNOT BE UNDONE");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act    => 'mods'    ,
                                        CODE   => 'moddel'  ,
                                        mods   => $mod_keys
                                      } );

    $html .= $SKIN->section_header( TITLE => "Moderators to delete:");

    for my $f (@mods_to_delete) {

        my $mod   = $db->select( TABLE   => 'forum_moderators',
                                 COLUMNS => ['MEMBER_NAME', 'FORUM_ID'],
                                 KEY     => $f,
                               );

        my $forum = $db->select( TABLE   => 'forum_info',
                                 COLUMNS => ['FORUM_NAME'],
                                 KEY     => $mod->{'FORUM_ID'},
                               );
        $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'>Moderator: $mod->{'MEMBER_NAME'}</font></td>
                <td bgcolor='#FFFFFF' width='60%' align='left'><font class='t'>Forum Name: <b>$forum->{'FORUM_NAME'}</b></font></td>
                </tr>
                ~;
    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'DELETE THESE MODERATORS' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE=>"Deleting Moderators", PRINT => $html);

}


sub oh_just_do_it_already {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Moderators to delete, please try again") unless $iB::IN{'mods'};

    my @mods;

    if ($iB::IN{'mods'} =~ m!\+!) {
        @mods = split (/\+/, $iB::IN{'mods'});
    } else {
        $mods[0] = $iB::IN{'mods'};
    }

   
    $db->delete( TABLE => 'forum_moderators',
                 KEY   => \@mods,
               );
    $ADMIN->write_log( TITLE => 'Forum Moderator(s) Deleted');

    $ADMIN->static_screen( URL   => "act=mods",
                           TITLE => "Forum Moderator(s) Deleted",
                           TEXT  => "The changes were successful"
                         );
}


####################################################################################
#
# EDIT Moderators
#
####################################################################################

sub do_edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No moderator to edit") unless $iB::IN{'mod_id'};

    my $mod   = $db->select( TABLE   => 'forum_moderators',
                             KEY     => $iB::IN{'mod_id'},
                           );


    #XXX Load, and build our forum array.

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};

    my @forums;
    for my $f (@{ $obj->{'TOTAL_FORUMS'} } ) {
        push @forums, { NAME => "&gt;--".$f->{'FORUM_NAME'}, VALUE => $f->{'FORUM_ID'} };
    }
    



    my $html  = $SKIN->title( TITLE => "Editing Moderator: $mod->{'MEMBER_NAME'}");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act    => 'mods',
                                        CODE   => 'confirmedit',
                                        mod_id => $iB::IN{'mod_id'}
                                      } );

    $html .= $SKIN->td_select( TEXT     => 'Moderates which forum?',
                               NAME     => 'FORUM_ID',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $mod->{'FORUM_ID'},
                               DATA     => \@forums,
                             );

    #XXX Ok, lets set up the permissions.

    $html .= $SKIN->section_header( TITLE => "Moderator Permissions", TEXT => "These permissions are only applicable to this member in this forum" );


    $html .= $SKIN->td_select( TEXT     => 'Can edit all posts?:',
                               NAME     => 'EDIT_POST',
                               VALUES   => $mod->{'EDIT_POST'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete posts?',
                               NAME     => 'DELETE_POST',
                               VALUES   => $mod->{'DELETE_POST'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete queued posts?',
                               NAME     => 'POST_Q',
                               VALUES   => $mod->{'POST_Q'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can edit all Topics?<br>&nbsp;&nbsp;&nbsp;&nbsp;Topic titles, etc',
                               NAME     => 'EDIT_TOPIC',
                               VALUES   => $mod->{'EDIT_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete topics?',
                               NAME     => 'DELETE_TOPIC',
                               VALUES   => $mod->{'DELETE_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can delete queued topics?',
                               NAME     => 'TOPIC_Q',
                               VALUES   => $mod->{'TOPIC_Q'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can open topics?',
                               NAME     => 'OPEN_TOPIC',
                               VALUES   => $mod->{'OPEN_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can close topics?',
                               NAME     => 'CLOSE_TOPIC',
                               VALUES   => $mod->{'CLOSE_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can Move topics?',
                               NAME     => 'MOVE_TOPIC',
                               VALUES   => $mod->{'MOVE_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );


    $html .= $SKIN->td_select( TEXT     => 'Can pin topics?',
                               NAME     => 'PIN_TOPIC',
                               VALUES   => $mod->{'PIN_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can unpin topics?',
                               NAME     => 'UNPIN_TOPIC',
                               VALUES   => $mod->{'UNPIN_TOPIC'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can mass move topics?',
                               NAME     => 'MASS_MOVE',
                               VALUES   => $mod->{'MASS_MOVE'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can mass prune topics?',
                               NAME     => 'MASS_PRUNE',
                               VALUES   => $mod->{'MASS_PRUNE'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Can view poster IPs?',
                               NAME     => 'VIEW_IP',
                               VALUES   => $mod->{'VIEW_IP'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Can privately warn other members?",
                               NAME     => 'ALLOW_WARN',
                               REQ      => 1,
                               VALUES   => $mod->{'ALLOW_WARN'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Edit this moderator' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => qq[Editing Moderator], PRINT => $html);


}

sub confirm_edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No moderator to edit!") unless $iB::IN{'mod_id'};

    $db->update( TABLE  => 'forum_moderators',
                 KEY    => $iB::IN{'mod_id'},
                 VALUES => { FORUM_ID                => $iB::IN{'FORUM_ID'},
                             EDIT_POST               => $iB::IN{'EDIT_POST'},
                             EDIT_TOPIC              => $iB::IN{'EDIT_TOPIC'},
                             DELETE_POST             => $iB::IN{'DELETE_POST'},
                             DELETE_TOPIC            => $iB::IN{'DELETE_TOPIC'},
                             VIEW_IP                 => $iB::IN{'VIEW_IP'},
                             OPEN_TOPIC              => $iB::IN{'OPEN_TOPIC'},
                             CLOSE_TOPIC             => $iB::IN{'CLOSE_TOPIC'},
                             MOVE_TOPIC              => $iB::IN{'MOVE_TOPIC'},
                             MASS_MOVE               => $iB::IN{'MASS_MOVE'},
                             MASS_PRUNE              => $iB::IN{'MASS_PRUNE'},
                             MOVE_TOPIC              => $iB::IN{'MOVE_TOPIC'},
                             PIN_TOPIC               => $iB::IN{'PIN_TOPIC'},
                             UNPIN_TOPIC             => $iB::IN{'UNPIN_TOPIC'},
                             POST_Q                  => $iB::IN{'POST_Q'},
                             TOPIC_Q                 => $iB::IN{'TOPIC_Q'},
                             ALLOW_WARN              => $iB::IN{'ALLOW_WARN'},
                           }
              );

    $ADMIN->write_log( TITLE => 'Moderator Edited', EXTRA => "Forum ID: $iB::IN{'FORUM_ID'}");

    $ADMIN->static_screen( URL   => "act=mods",
                           TITLE => "Moderator Edited",
                           TEXT  => "The changes were successful"
                         );
}

####################################################################################
#
# PROCESS
#
####################################################################################

sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( add         => \&add,
                 doadd       => \&do_add,

                 edit        => \&edit,
                 doedit      => \&do_edit,
                 confirmedit => \&confirm_edit,

                 del         => \&delete,
                 dodel       => \&do_delete,
                 moddel      => \&oh_just_do_it_already
               );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 




1;
__END__
