package Admin::Mimetypes;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;

    # Do we have a MIME types file?
    my $mime_cfg = $iB::INFO->{'IKON_DIR'}."Data/MimeTypes.cfg";
    unless (-e $mime_cfg) {
            $ADMIN->Error( DB=>,"", STD=>"", MSG => "Cannot locate /Data/MimeTypes.cfg")
    }
    # Is it writable?
    unless (-w $mime_cfg) {
            $ADMIN->Error( DB=>,"", STD=>"", MSG => "Cannot write to /Data/MimeTypes.cfg. Please CHMOD to 0777")
    }

    # Suck it in

    do 'Data/MimeTypes.cfg';

    my $mime = MimeTypes->new();


    my $html  = $SKIN->title( TITLE => 'Mime Control', "You may edit the allowed MIME types for upload files");


       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'mime',
                                        CODE  => 'edit'
                                      } );

    #+-----------------------------------
    $html .= $SKIN->section_header( TITLE => "Please Edit the MIME types below",TEXT=> qq~Or leave the fields blank to remove~, COLSPAN => 4);
    $html .= qq~
    <tr>
    <td bgcolor='#8888AA' width='30%' align='left' class='t' style='color:white'><b>Mime Type</b></td>
    <td bgcolor='#8888AA' width='30%' align='left' class='t' style='color:white'><b>Mime Description</b></td>
    <td bgcolor='#8888AA' width='20%' align='left' class='t' style='color:white'><b>Mime Image</b></td>
    <td bgcolor='#8888AA' width='20%' align='left' class='t' style='color:white'><b>Allow use?</b></td>
    </tr>
    ~;

    my $cnt = 0;
    for my $m (sort { $a cmp $b } keys %{$mime}) {

        my $click = "<select name='ALLOW_$cnt' class='forminput'>";
        $click .= $mime->{ $m }[0]
                ? "<option value='1' selected>Yes</option><option value='0'>No</option>"
                : "<option value='1'>Yes</option><option value='0' selected>No</option>";

        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' align='left'><input type='text' name='TYPE_$cnt' value='$m' style='width:95%'></td>
            <td bgcolor='#FFFFFF' align='left'><input type='text' name='DESC_$cnt' value='$mime->{ $m }[2]' style='width:95%'></td>
            <td bgcolor='#FFFFFF' align='left'><input type='text' name='IMG_$cnt'  value='$mime->{ $m }[1]'></td>
            <td bgcolor='#FFFFFF' align='left'>$click</select></td>
            </tr>
        ~;
        $cnt++;

    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply these changes', COLSPAN => 4 );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'MIME Control', PRINT => $html);

}


sub doedit {
    my ($obj, $db) = @_;

    # Suck it in
    require 'Data/MimeTypes.cfg';
    my $old_mime = MimeTypes->new();

    my @mime_in = grep { /^TYPE_(\d+)$/ } $iB::CGI->param();

    my $new_mime = { };

    for my $m (@mime_in) {
        $m     =~ m#^TYPE_(\d+)$#;
        my $n = $1;
        next unless $iB::IN{'TYPE_'.$n} and $iB::IN{'DESC_'.$n};
        $iB::IN{'ALLOW_'.$n} ||= 0;
        $new_mime->{ $iB::CGI->param( 'TYPE_'.$n ) } = [
                                                            $iB::CGI->param( 'ALLOW_'.$n ),
                                                            $iB::CGI->param( 'IMG_'.$n )  ,
                                                            $iB::CGI->param( 'DESC_'.$n ) ,
                                                       ];
    }


    $ADMIN->make_module( FILE     => "MimeTypes.cfg",
                         PKG_NAME => 'MimeTypes',
                         VALUES   => $new_mime
                       );

    $ADMIN->write_log( TITLE => 'Mime Types edited');

    $ADMIN->static_screen( URL   => "act=mime",
                           TITLE => "MIME types edited",
                           TEXT  => "The changes were successful"
                         );
}



##########################################################################################
#
# ADDING EMOTICONS
#
##########################################################################################



sub add {
    my ($obj, $db) = @_;

    # Do we have a MIME types file?
    my $mime_cfg = $iB::INFO->{'IKON_DIR'}."Data/MimeTypes.cfg";
    unless (-e $mime_cfg) {
            $ADMIN->Error( DB=>,"", STD=>"", MSG => "Cannot locate /Data/MimeTypes.cfg")
    }
    # Is it writable?
    unless (-w $mime_cfg) {
            $ADMIN->Error( DB=>,"", STD=>"", MSG => "Cannot write to /Data/MimeTypes.cfg. Please CHMOD to 0777")
    }


    my $html  = $SKIN->title( TITLE => 'Mime Control', "You may add allowed MIME types for upload files");


       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'mime',
                                        CODE  => 'doadd'
                                      } );

    #+-----------------------------------
    $html .= $SKIN->section_header( TITLE => "Please add the MIME types below",TEXT=> qq~You do not need to use all the entry fields~, COLSPAN => 4);
    $html .= qq~
    <tr>
    <td bgcolor='#8888AA' width='30%' align='left' class='t' style='color:white'><b>Mime Type</b></td>
    <td bgcolor='#8888AA' width='30%' align='left' class='t' style='color:white'><b>Mime Description</b></td>
    <td bgcolor='#8888AA' width='20%' align='left' class='t' style='color:white'><b>Mime Image</b></td>
    <td bgcolor='#8888AA' width='20%' align='left' class='t' style='color:white'><b>Allow use?</b></td>
    </tr>
    ~;


    for my $cnt (1 .. 10) {

        my $click = "<select name='ALLOW_$cnt' class='forminput'>";
        $click .= "<option value='1' selected>Yes</option><option value='0'>No</option>";

        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' align='left'><input type='text' name='TYPE_$cnt' value='' style='width:95%'></td>
            <td bgcolor='#FFFFFF' align='left'><input type='text' name='DESC_$cnt' value='' style='width:95%'></td>
            <td bgcolor='#FFFFFF' align='left'><input type='text' name='IMG_$cnt'  value=''></td>
            <td bgcolor='#FFFFFF' align='left'>$click</select></td>
            </tr>
        ~;

    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Add these MIME types', COLSPAN => 4 );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'MIME Control', PRINT => $html);
}




sub doadd {
    my ($obj, $db) = @_;

    my @mime_in = grep { /^TYPE_(\d+)$/ } $iB::CGI->param();

    # Suck it in
    require 'Data/MimeTypes.cfg';
    my $new_mime = MimeTypes->new();

    for my $m (@mime_in) {
        $m     =~ m#^TYPE_(\d+)$#;
        my $n = $1;
        next unless  $iB::IN{'TYPE_'.$n} and $iB::IN{'DESC_'.$n};
        $iB::IN{'ALLOW_'.$n} ||= 0;
        $new_mime->{ $iB::CGI->param( 'TYPE_'.$n ) } = [
                                                            $iB::CGI->param( 'ALLOW_'.$n ),
                                                            $iB::CGI->param( 'IMG_'.$n )  ,
                                                            $iB::CGI->param( 'DESC_'.$n ) ,
                                                       ];
    }


    $ADMIN->make_module( FILE     => "MimeTypes.cfg",
                         PKG_NAME => 'MimeTypes',
                         VALUES   => $new_mime
                       );

    $ADMIN->write_log( TITLE => 'Mime Types added');

    $ADMIN->static_screen( URL   => "act=mime",
                           TITLE => "MIME types added",
                           TEXT  => "The changes were successful"
                         );
}



sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'        => \&doedit,
                 'add'         => \&add,
                 'doadd'       => \&doadd,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 





1;
