package Admin::MemberGroups;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}


my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}



sub forummask {
    my ($obj, $db) = @_;

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my @groups;

    for (@{$mem_groups}) {
        push @groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }

    my $html  = $SKIN->title( TITLE => 'MemberGroups Forum Mask',
                              TEXT  => "This will allow you to change the forum mask permissions for the chosen membergroup in all forums. This is handy if you've just added a new membergroup and want to add permissions to multiple forums"
                           );

       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'group',
                                        CODE  => 'doforummask',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Which member group do you wish to adjust?");

    $html .= $SKIN->td_select( TEXT     => "Available membergroups",
                               NAME     => 'GROUP',
                               REQ      => 1,
                               VALUES   => "",
                               DATA     => \@groups,
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Adjust this group' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Membergroup forum masks', PRINT => $html);


}


sub doforummask {
    my ($obj, $db) = @_;

    my $membergroup = $db->select(  TABLE  => "mem_groups",
                                    KEY    => $iB::IN{GROUP}
                                 );

    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        COLUMNS   => ['CAT_NAME', 'CAT_ID'],
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};



    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; Changing the forum mask permissions for: $membergroup->{TITLE}</font>
    <br><br><font class='t'>&nbsp;&nbsp;You may adjust the forum permission mask settings for "$membergroup->{TITLE}".</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&CODE=view' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='group'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='setforummask'>
    <input type='hidden' name='GROUP' value='$iB::IN{GROUP}'>
    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#8888AA' width='28%'><font class='t' style='color:white'><b>Forum Name</b></font></td>
            <td bgcolor='#8888AA' width='15%' align='center'><font class='t' style='color:white'><b>Forum ID</b></font></td>
            <td bgcolor='#8888AA' width='8%' align='center'><font class='t' style='color:white'><b>Topics</b></font></td>
            <td bgcolor='#8888AA' width='8%' align='center'><font class='t' style='color:white'><b>Posts</b></font></td>
            <td bgcolor='#8888AA' width='40%' align='center'><font class='t' style='color:white'>&nbsp;</t></td>
            </tr>
    ~;

    for my $this_cat (@{ $obj->{'TOTAL_CATS'} }) {

        $html .= qq~
        <tr>
        <td bgcolor='#DDDDDD' align='left' colspan='5'><font class='large'>&gt; $this_cat->{'CAT_NAME'}</font></td>
        </tr>
        ~;
    
        my @all_forums = grep { $_->{'CATEGORY'} == $this_cat->{'CAT_ID'} } @{ $obj->{'TOTAL_FORUMS'} };

        for my $forum (@all_forums) {

            my ($r_checked, $x_checked, $s_checked, $r_val, $x_val, $s_val);

            if ($forum->{'FORUM_VIEW_THREADS'} eq '*') {
                $r_val = "<input type='hidden' name='$forum->{'FORUM_ID'}_R' value='*'><span style='color:gray'>[GLOBAL]</span>";
            } else {
                $r_checked = $forum->{FORUM_VIEW_THREADS} =~ /$iB::IN{GROUP}\s*(,|$)/ ? 'checked' : '';
                $r_val = qq~<input type='checkbox' name='$forum->{'FORUM_ID'}_R' value='1' $r_checked>~;
            }

            if ($forum->{'FORUM_START_THREADS'} eq '*') {
                $s_val = "<input type='hidden' name='$forum->{'FORUM_ID'}_S' value='*'><span style='color:gray'>[GLOBAL]</span>";
            } else {
                $s_checked = $forum->{FORUM_START_THREADS} =~ /$iB::IN{GROUP}\s*(,|$)/ ? 'checked' : '';
                $s_val = qq~<input type='checkbox' name='$forum->{'FORUM_ID'}_S' value='1' $s_checked>~;
            }

            if ($forum->{'FORUM_REPLY_THREADS'} eq '*') {
                $x_val = "<input type='hidden' name='$forum->{'FORUM_ID'}_X' value='*'><span style='color:gray'>[GLOBAL]</span>";
            } else {
                $x_checked = $forum->{FORUM_REPLY_THREADS} =~ /$iB::IN{GROUP}\s*(,|$)/ ? 'checked' : '';
                $x_val = qq~<input type='checkbox' name='$forum->{'FORUM_ID'}_X' value='1' $x_checked>~;
            } 


            $html .= qq~

            <tr>
            <td bgcolor='#FFFFFF'><font class='t'>$forum->{'FORUM_NAME'}</font></td>
            <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_ID'}</font></td>
            <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_TOPICS'}</font></td>
            <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_POSTS'}</font></td>
            <td bgcolor='#FFFFFF'><font class='t'>
                Read topics? &nbsp; $r_val
                <br>Reply in topics? &nbsp; $x_val
                <br>Start new topics? &nbsp; $s_val
                </font></td>
            </tr>
            ~;
        }
    }

    $html .= qq~
            
            <tr>
            <td colspan='5' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='Adjust the permissions'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Membergroup forum masks', PRINT => $html);
}


sub setforummask {
    my ($obj, $db) = @_;

    my $group = $iB::IN{'GROUP'};

    my $forums = $db->query( TABLE     => 'forum_info',
                             SORT_KEY  => 'FORUM_POSITION',
                             SORT_BY   => 'A-Z',
                             MATCH     => 'ALL'
                           );

    #Start the loop

    for my $f (@{$forums}) {
        my ($view, $start, $reply);
        #---------- VIEW THREADS
        if ($f->{'FORUM_VIEW_THREADS'} eq '*') {
            $view = '*';
        } else {
            # Split all the groups
            for (split /,/,$f->{'FORUM_VIEW_THREADS'}) {
                # Next if it's the group we've edited
                next if $_ == $group;
                $view .= "$_,";
            }
            # If the box was checked...
            if ($iB::IN{ $f->{'FORUM_ID'}.'_R'} ) {
                $view .= "$group,";
            }  
            # Remove trailing comma
            $view =~ s/,$//;
        }
        #---------- START THREADS
        if ($f->{'FORUM_START_THREADS'} eq '*') {
            $start = '*';
        } else {
            # Split all the groups
            for (split /,/,$f->{'FORUM_START_THREADS'}) {
                # Next if it's the group we've edited
                next if $_ == $group;
                $start .= "$_,";
            }
            # If the box was checked...
            if ($iB::IN{ $f->{'FORUM_ID'}.'_S'} ) {
                $start .= "$group,";
            }  
            # Remove trailing comma
            $start =~ s/,$//;
        }
        #---------- REPLY THREADS
        if ($f->{'FORUM_REPLY_THREADS'} eq '*') {
            $reply = '*';
        } else {
            # Split all the groups
            for (split /,/,$f->{'FORUM_REPLY_THREADS'}) {
                # Next if it's the group we've edited
                next if $_ == $group;
                $reply .= "$_,";
            }
            # If the box was checked...
            if ($iB::IN{ $f->{'FORUM_ID'}.'_X'} ) {
                $reply .= "$group,";
            }  
            # Remove trailing comma
            $reply =~ s/,$//;
        }

        #---------- Update the DB
    
        $db->update(  TABLE  => "forum_info",
                      KEY    => $f->{'FORUM_ID'},
                      VALUES => {
                                  FORUM_VIEW_THREADS  => $view,
                                  FORUM_START_THREADS => $start,
                                  FORUM_REPLY_THREADS => $reply,
                                },
                   );

    } # Loop over

    $ADMIN->static_screen( URL   => "act=group&CODE=doforummask&GROUP=$iB::IN{GROUP}",
                           TITLE => "Membergroup forum mask permissions edited",
                           TEXT  => "The changes were successful"
                         );


}





sub splash {

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You do not have permission for this action") unless defined $iB::MEMBER_GROUP->{'EDIT_GROUPS'};

    my ($obj, $db) = @_;

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; MemberGroups</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=groups&s=$iB::SESSION&CODE=edit' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='group'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='edit'>

    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#666699' width='10%' align='center'>&nbsp;</td>
            <td bgcolor='#666699' width='90%'><font class='t'><b>Group Name</b></font></td>
            </tr>
    ~;


    for my $group (@{ $mem_groups }) {

        $html .= qq~

            <tr>
            <td bgcolor='#FFFFFF' align='center'><input type='radio' name='g' value='$group->{'ID'}' style='border:none'></td>
            <td bgcolor='#FFFFFF'><font class='t'>$group->{'TITLE'}</font></td>
            </tr>

        ~;
    }

    $html .= qq~
            
            <tr>
            <td colspan='6' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='Edit Selected Group'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;


    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'MemberGroup Control', PRINT => $html);


}



sub edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'EDIT_GROUPS'};

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a group to edit!") unless defined $iB::IN{'g'};

    my $group = $db->select( TABLE  => 'mem_groups',
                             KEY    => $iB::IN{'g'},
                           );



    my $html  = $SKIN->title( TITLE => 'Member Group Settings', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'group',
                                        CODE  => 'doedit',
                                        g     => $iB::IN{'g'}
                                      } );

    $html .= $SKIN->section_header( TITLE => "Main Settings");

    $html .= $SKIN->td_input ( TEXT     => 'Group Name', NAME => 'TITLE', VALUE=> "$group->{'TITLE'}", REQ => 1 );

    $html .= $SKIN->td_input ( TEXT     => 'Replace Pips with this image?<br>&nbsp;&nbsp;&nbsp;&nbsp;Image must be uploaded into iB_html/non-cgi/team_icons<br>&nbsp;&nbsp;&nbsp;&nbsp;Just enter icon name, not the full URL<br>&nbsp;&nbsp;&nbsp;&nbsp;For example: <b>admin.gif</b>', NAME => 'TEAM_ICON', VALUE=> $group->{'TEAM_ICON'}, REQ => 1 );

    $html .= $SKIN->td_input ( TEXT     => 'Maximum Upload file size (in k)', NAME => 'ATTACH_MAX', VALUE=> "$group->{'ATTACH_MAX'}", REQ => 1 );

    $html .= $SKIN->td_select( TEXT     => "Can view board?",
                               NAME     => 'VIEW_BOARD',
                               REQ      => 1,
                               VALUES   => $group->{'VIEW_BOARD'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can view member profile information?",
                               NAME     => 'MEM_INFO',
                               REQ      => 1,
                               VALUES   => $group->{'MEM_INFO'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can view other members topics?",
                               NAME     => 'OTHER_TOPICS',
                               REQ      => 1,
                               VALUES   => $group->{'OTHER_TOPICS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the search feature?",
                               NAME     => 'USE_SEARCH',
                               REQ      => 1,
                               VALUES   => $group->{'USE_SEARCH'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the 'Send Topic to Friend' feature?",
                               NAME     => 'EMAIL_FRIEND',
                               REQ      => 1,
                               VALUES   => $group->{'EMAIL_FRIEND'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the 'Invite Friend' feature?",
                               NAME     => 'INVITE_FRIEND',
                               REQ      => 1,
                               VALUES   => $group->{'INVITE_FRIEND'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can edit own profile information?",
                               NAME     => 'EDIT_PROFILE',
                               REQ      => 1,
                               VALUES   => $group->{'EDIT_PROFILE'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the private messenger?",
                               NAME     => 'USE_PM',
                               REQ      => 1,
                               VALUES   => $group->{'USE_PM'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->section_header( TITLE => "Posting Permissions");

    $html .= $SKIN->td_select( TEXT     => "Post new topics?",
                               NAME     => 'POST_NEW_TOPICS',
                               REQ      => 1,
                               VALUES   => $group->{'POST_NEW_TOPICS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );


    $html .= $SKIN->td_select( TEXT     => "Reply to other members topics?",
                               NAME     => 'REPLY_OTHER_TOPICS',
                               REQ      => 1,
                               VALUES   => $group->{'REPLY_OTHER_TOPICS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Edit own posts?",
                               NAME     => 'EDIT_OWN_POSTS',
                               REQ      => 1,
                               VALUES   => $group->{'EDIT_OWN_POSTS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Delete own posts?",
                               NAME     => 'DELETE_OWN_POSTS',
                               REQ      => 1,
                               VALUES   => $group->{'DELETE_OWN_POSTS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Open and close own topics?",
                               NAME     => 'OPEN_CLOSE_TOPICS',
                               REQ      => 1,
                               VALUES   => $group->{'OPEN_CLOSE_TOPICS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Delete own topics?",
                               NAME     => 'DELETE_OWN_TOPICS',
                               REQ      => 1,
                               VALUES   => $group->{'DELETE_OWN_TOPICS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Post Polls?",
                               NAME     => 'POST_POLLS',
                               REQ      => 1,
                               VALUES   => $group->{'POST_POLLS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Vote in Polls?",
                               NAME     => 'VOTE_POLLS',
                               REQ      => 1,
                               VALUES   => $group->{'VOTE_POLLS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Reply to own topics?",
                               NAME     => 'REPLY_OWN_TOPICS',
                               REQ      => 1,
                               VALUES   => $group->{'REPLY_OWN_TOPICS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Append 'Edited by' after a post edit?",
                               NAME     => 'APPEND_EDIT',
                               REQ      => 1,
                               VALUES   => $group->{'APPEND_EDIT'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Avoid Moderation Queue?",
                               NAME     => 'AVOID_Q',
                               REQ      => 1,
                               VALUES   => $group->{'AVOID_Q'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Avoid Flood Control?",
                               NAME     => 'AVOID_FLOOD',
                               REQ      => 1,
                               VALUES   => $group->{'AVOID_FLOOD'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );


    $html .= $SKIN->td_select( TEXT     => "Can view an OFFLINE board?",
                               NAME     => 'ACCESS_OFFLINE',
                               REQ      => 1,
                               VALUES   => $group->{'ACCESS_OFFLINE'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );



    $html .= $SKIN->section_header( TITLE => "Administrative Permissions");

    $html .= $SKIN->td_select( TEXT     => "Is Super (Global) Moderator?",
                               NAME     => 'IS_SUPMOD',
                               REQ      => 1,
                               VALUES   => $group->{'IS_SUPMOD'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can access the Admin CP?",
                               NAME     => 'ACCESS_CP',
                               REQ      => 1,
                               VALUES   => $group->{'ACCESS_CP'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->section_header( TITLE => "Administration CP Permissions", TEXT => "This only applies if the group has permission to access the admin CP");

    $html .= $SKIN->td_select( TEXT     => "Can read the Admin logs?",
                               NAME     => 'READ_AD_LOGS',
                               REQ      => 1,
                               VALUES   => $group->{'READ_AD_LOGS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can delete the Admin logs?",
                               NAME     => 'DELETE_AD_LOGS',
                               REQ      => 1,
                               VALUES   => $group->{'DELETE_AD_LOGS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can edit member groups?",
                               NAME     => 'EDIT_GROUPS',
                               REQ      => 1,
                               VALUES   => $group->{'EDIT_GROUPS'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => "MemberGroup Preferences", PRINT => $html);

}


sub do_edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a group to edit!") unless defined $iB::IN{'g'};

    my $group = $db->select( TABLE  => 'mem_groups',
                             KEY    => $iB::IN{'g'},
                           );

    $db->update( TABLE   => 'mem_groups',
                 KEY     => $iB::IN{'g'},
                 VALUES  => {   VIEW_BOARD          =>  $iB::IN{'VIEW_BOARD'},
                                MEM_INFO            =>  $iB::IN{'MEM_INFO'},
                                OTHER_TOPICS        =>  $iB::IN{'OTHER_TOPICS'},
                                USE_SEARCH          =>  $iB::IN{'USE_SEARCH'},
                                EMAIL_FRIEND        =>  $iB::IN{'EMAIL_FRIEND'},
                                INVITE_FRIEND       =>  $iB::IN{'INVITE_FRIEND'},
                                EDIT_PROFILE        =>  $iB::IN{'EDIT_PROFILE'},
                                POST_NEW_TOPICS     =>  $iB::IN{'POST_NEW_TOPICS'},
                                REPLY_OWN_TOPICS    =>  $iB::IN{'REPLY_OWN_TOPICS'},
                                REPLY_OTHER_TOPICS  =>  $iB::IN{'REPLY_OTHER_TOPICS'},
                                EDIT_OWN_POSTS      =>  $iB::IN{'EDIT_OWN_POSTS'},
                                DELETE_OWN_POSTS    =>  $iB::IN{'DELETE_OWN_POSTS'},
                                OPEN_CLOSE_TOPICS   =>  $iB::IN{'OPEN_CLOSE_TOPICS'},
                                DELETE_OWN_TOPICS   =>  $iB::IN{'DELETE_OWN_TOPICS'},
                                POST_POLLS          =>  $iB::IN{'POST_POLLS'},
                                VOTE_POLLS          =>  $iB::IN{'VOTE_POLLS'},
                                USE_PM              =>  $iB::IN{'USE_PM'},
                                IS_SUPMOD           =>  $iB::IN{'IS_SUPMOD'},
                                ACCESS_CP           =>  $iB::IN{'ACCESS_CP'},
                                TITLE               =>  $iB::IN{'TITLE'},
                                CAN_REMOVE          =>  $group->{'CAN_REMOVE'},
                                READ_AD_LOGS        =>  $iB::IN{'READ_AD_LOGS'},
                                DELETE_AD_LOGS      =>  $iB::IN{'DELETE_AD_LOGS'},
                                EDIT_GROUPS         =>  $iB::IN{'EDIT_GROUPS'},
                                APPEND_EDIT         =>  $iB::IN{'APPEND_EDIT'},
                                ACCESS_OFFLINE      =>  $iB::IN{'ACCESS_OFFLINE'},
                                AVOID_Q             =>  $iB::IN{'AVOID_Q'},
                                AVOID_FLOOD         =>  $iB::IN{'AVOID_FLOOD'},
                                TEAM_ICON           =>  $iB::IN{'TEAM_ICON'},
                                ATTACH_MAX          =>  $iB::IN{'ATTACH_MAX'},
                           },
              );

    $ADMIN->static_screen( URL   => "act=group&CODE=edit&g=$iB::IN{'g'}",
                           TITLE => "Membergroup permissions edited",
                           TEXT  => "The changes were successful"
                         );

}

sub default {
    my ($obj, $db) = @_;

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my @groups;

    for (@{$mem_groups}) {
        push @groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }

    my $html  = $SKIN->title( TITLE => 'User Default Grouping',
                              TEXT  => "Please double check all the data before submitting the changes.
                                        <br><br><b>Information on MemberGroups</b>
                                        <br><br>
                                        <b>Super Administrators</b> are the highest level member. This gives you the ability to have a level <i>above</i> administrators. This is useful if you have a team of administrators that you wish to restrict certain areas of the Admin CP.
                                        Only other Super Administrators can promote members to this level.
                                       ",
                           );

       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'group',
                                        CODE  => 'dodefault',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Member group for...");

    $html .= $SKIN->td_select( TEXT     => "Super Administrators",
                               NAME     => 'SUPAD_GROUP',
                               REQ      => 1,
                               VALUES   => $INFO->{'SUPAD_GROUP'},
                               DATA     => \@groups,
                             );

    $html .= $SKIN->td_select( TEXT     => "Unregistered/Not Logged in",
                               NAME     => 'GUEST_GROUP',
                               REQ      => 1,
                               VALUES   => $INFO->{'GUEST_GROUP'},
                               DATA     => \@groups,
                             );

    $html .= $SKIN->td_select( TEXT     => "Registered Members (Default Group)",
                               NAME     => 'MEMBER_GROUP',
                               REQ      => 1,
                               VALUES   => $INFO->{'MEMBER_GROUP'},
                               DATA     => \@groups,
                             );

    $html .= $SKIN->td_select( TEXT     => "Awaiting Authorisation to Post",
                               NAME     => 'AUTHORISE_GROUP',
                               REQ      => 1,
                               VALUES   => $INFO->{'AUTHORISE_GROUP'},
                               DATA     => \@groups,
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => "User Grouping", PRINT => $html);

}

sub do_default {
    my ($obj, $search) = @_;

    my $OLD = Boardinfo->new();
  
    $OLD->{'GUEST_GROUP'}     = $iB::IN{'GUEST_GROUP'}     || 0;
    $OLD->{'MEMBER_GROUP'}    = $iB::IN{'MEMBER_GROUP'}    || 0;
    $OLD->{'SUPAD_GROUP'}     = $iB::IN{'SUPAD_GROUP'}     || 0;
    $OLD->{'AUTHORISE_GROUP'} = $iB::IN{'AUTHORISE_GROUP'} || 0;

    # Update the Boardinfo.pm file

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->static_screen( URL   => "act=group&CODE=default",
                           TITLE => "User Group changes applied",
                           TEXT  => "The changes were successful"
                         );
}

sub add {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'EDIT_GROUPS'};

    my $html  = $SKIN->title( TITLE => 'Add a Member Group', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'group',
                                        CODE  => 'doadd',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Main Settings");

    $html .= $SKIN->td_input ( TEXT     => 'Group Name', NAME => 'TITLE', VALUE=> "", REQ => 1 );

    $html .= $SKIN->td_input ( TEXT     => 'Replace Pips with an image?<br>&nbsp;&nbsp;&nbsp;&nbsp;Image must be uploaded into iB_html/non-cgi/team_icons<br>&nbsp;&nbsp;&nbsp;&nbsp;Just enter icon name, not the full URL<br>&nbsp;&nbsp;&nbsp;&nbsp;For example: <b>admin.gif</b>', NAME => 'TEAM_ICON', VALUE=> "", REQ => 1 );

    $html .= $SKIN->td_input ( TEXT     => 'Maximum Upload file size (in k)', NAME => 'ATTACH_MAX', VALUE=> "", REQ => 1 );

    $html .= $SKIN->td_select( TEXT     => "Can view board?",
                               NAME     => 'VIEW_BOARD',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can view member profile information?",
                               NAME     => 'MEM_INFO',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can view other members topics?",
                               NAME     => 'OTHER_TOPICS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the search feature?",
                               NAME     => 'USE_SEARCH',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the 'Send Topic to Friend' feature?",
                               NAME     => 'EMAIL_FRIEND',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the 'Invite Friend' feature?",
                               NAME     => 'INVITE_FRIEND',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can edit own profile information?",
                               NAME     => 'EDIT_PROFILE',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can use the private messenger?",
                               NAME     => 'USE_PM',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->section_header( TITLE => "Posting Permissions");

    $html .= $SKIN->td_select( TEXT     => "Post new topics?",
                               NAME     => 'POST_NEW_TOPICS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Reply to own topics?",
                               NAME     => 'REPLY_OWN_TOPICS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Reply to other members topics?",
                               NAME     => 'REPLY_OTHER_TOPICS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Edit own posts?",
                               NAME     => 'EDIT_OWN_POSTS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Delete own posts?",
                               NAME     => 'DELETE_OWN_POSTS',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Open and close own topics?",
                               NAME     => 'OPEN_CLOSE_TOPICS',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Delete own topics?",
                               NAME     => 'DELETE_OWN_TOPICS',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Post Polls?",
                               NAME     => 'POST_POLLS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Vote in Polls?",
                               NAME     => 'VOTE_POLLS',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Append 'Edited by' after a post edit?",
                               NAME     => 'APPEND_EDIT',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Avoid Moderation Queue?",
                               NAME     => 'AVOID_Q',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Avoid Flood Control?",
                               NAME     => 'AVOID_FLOOD',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can view an OFFLINE board?",
                               NAME     => 'ACCESS_OFFLINE',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );


    $html .= $SKIN->section_header( TITLE => "Administrative Permissions");

    $html .= $SKIN->td_select( TEXT     => "Is Super (Global) Moderator?",
                               NAME     => 'IS_SUPMOD',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can access the Admin CP?",
                               NAME     => 'ACCESS_CP',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->section_header( TITLE => "Administration CP Permissions", TEXT => "This only applies if the group has permission to access the admin CP");

    $html .= $SKIN->td_select( TEXT     => "Can read the Admin logs?",
                               NAME     => 'READ_AD_LOGS',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can delete the Admin logs?",
                               NAME     => 'DELETE_AD_LOGS',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_select( TEXT     => "Can edit member groups?",
                               NAME     => 'EDIT_GROUPS',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Add This Group' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => "Adding MemberGroup", PRINT => $html);

}

sub do_add {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a group title!") unless defined $iB::IN{'TITLE'};

    my $new_id = 
    $db->insert( TABLE   => 'mem_groups',
                 VALUES  => {   VIEW_BOARD          =>  $iB::IN{'VIEW_BOARD'},
                                MEM_INFO            =>  $iB::IN{'MEM_INFO'},
                                OTHER_TOPICS        =>  $iB::IN{'OTHER_TOPICS'},
                                USE_SEARCH          =>  $iB::IN{'USE_SEARCH'},
                                EMAIL_FRIEND        =>  $iB::IN{'EMAIL_FRIEND'},
                                INVITE_FRIEND       =>  $iB::IN{'INVITE_FRIEND'},
                                EDIT_PROFILE        =>  $iB::IN{'EDIT_PROFILE'},
                                POST_NEW_TOPICS     =>  $iB::IN{'POST_NEW_TOPICS'},
                                REPLY_OWN_TOPICS    =>  $iB::IN{'REPLY_OWN_TOPICS'},
                                REPLY_OTHER_TOPICS  =>  $iB::IN{'REPLY_OTHER_TOPICS'},
                                EDIT_OWN_POSTS      =>  $iB::IN{'EDIT_OWN_POSTS'},
                                DELETE_OWN_POSTS    =>  $iB::IN{'DELETE_OWN_POSTS'},
                                OPEN_CLOSE_TOPICS   =>  $iB::IN{'OPEN_CLOSE_TOPICS'},
                                DELETE_OWN_TOPICS   =>  $iB::IN{'DELETE_OWN_TOPICS'},
                                POST_POLLS          =>  $iB::IN{'POST_POLLS'},
                                VOTE_POLLS          =>  $iB::IN{'VOTE_POLLS'},
                                USE_PM              =>  $iB::IN{'USE_PM'},
                                IS_SUPMOD           =>  $iB::IN{'IS_SUPMOD'},
                                ACCESS_CP           =>  $iB::IN{'ACCESS_CP'},
                                TITLE               =>  $iB::IN{'TITLE'},
                                CAN_REMOVE          =>  1,
                                READ_AD_LOGS        =>  $iB::IN{'READ_AD_LOGS'},
                                DELETE_AD_LOGS      =>  $iB::IN{'DELETE_AD_LOGS'},
                                EDIT_GROUPS         =>  $iB::IN{'EDIT_GROUPS'},
                                APPEND_EDIT         =>  $iB::IN{'APPEND_EDIT'},
                                ACCESS_OFFLINE      =>  $iB::IN{'ACCESS_OFFLINE'},
                                AVOID_Q             =>  $iB::IN{'AVOID_Q'},
                                AVOID_FLOOD         =>  $iB::IN{'AVOID_FLOOD'},
                                TEAM_ICON           =>  $iB::IN{'TEAM_ICON'},
                                ATTACH_MAX          =>  $iB::IN{'ATTACH_MAX'},    
                           },
              );

    $ADMIN->static_screen( URL   => "act=group",
                           TITLE => "Membergroup Added",
                           TEXT  => "The changes were successful"
                         );

}


sub delete {

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'EDIT_GROUPS'};

    my ($obj, $db) = @_;

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; MemberGroups (DELETING)</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=groups&s=$iB::SESSION&CODE=dodel' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='group'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='dodel'>

    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#666699' width='10%' align='center'>&nbsp;</td>
            <td bgcolor='#666699' width='90%'><font class='t'><b>Group Name</b></font></td>
            </tr>
    ~;


    for my $group (@{ $mem_groups }) {

        my ($check, $txt);

        if ($group->{'CAN_REMOVE'}) {
            $check = "<input type='checkbox' name='g' value='$group->{'ID'}' style='border:none'>";
        } else {
            $check = "&nbsp;";
            $txt   = "[ Cannot Delete ]";
        }

        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' align='center'>$check</td>
            <td bgcolor='#FFFFFF'><font class='t'>$group->{'TITLE'} $txt</font></td>
            </tr>

        ~;
    }

    $html .= qq~
            
            <tr>
            <td colspan='6' align='center' bgcolor='#FFFFFF'><br><font class='t'>
            <b>WARNING: Members in the group(s) you're about to delete will be put into the Default Member Group</b>
            <br><br>
            <input type='submit' value='Delete Selected Groups'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;


    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'MemberGroup Control', PRINT => $html);

}


sub dodelete {
    my ($obj, $db) = @_;

    my @groups_to_delete = $iB::CGI->param('g');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Groups to delete, please try again") unless scalar @groups_to_delete > 0;

    my $group_keys = join "+", @groups_to_delete;

    my $html  = $SKIN->title( TITLE => "Deleting Member Groups", TEXT => "WARNING: THIS ACTION CAN NOT BE UNDONE");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act    => 'group'    ,
                                        CODE   => 'finaldelete'   ,
                                        groups => $group_keys
                                      } );

    $html .= $SKIN->section_header( TITLE => "Groups to delete:");

    for my $f (@groups_to_delete) {

        my $forum = $db->select( TABLE => 'mem_groups',
                                 KEY   => $f,
                               );
        $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'>Group ID: $f</font></td>
                <td bgcolor='#FFFFFF' width='60%' align='left'><font class='t'>Group Name: <b>$forum->{'TITLE'}</b></font></td>
                </tr>
                ~;
    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'DELETE THESE GROUPS' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => "Deleting Member Groups", PRINT => $html);

}

sub yes_i_mean_it {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Groups to delete, please try again") unless $iB::IN{'groups'};

    my @groups;

    if ($iB::IN{'groups'} =~ m!\+!) {
        @groups = split (/\+/, $iB::IN{'groups'});
    } else {
        $groups[0] = $iB::IN{'groups'};
    }

    #XXX Remove the Group entrie(s) from the DB

    $db->delete( TABLE => 'mem_groups',
                 KEY   => \@groups,
               );

    #XXX Update any members who used to have one of those groups

    my $q;
    if ($iB::IN{'groups'} =~ m!\+!) {
        for (@groups) {
            next unless $_;
            $q .= "MEMBER_GROUP == '$_' or ";
        }
        $q =~ s!or \Z!!;
    } else {
        $q = "MEMBER_GROUP == '$groups[0]'";
    }
        
    $db->update( TABLE   => 'member_profiles',
                 WHERE   => $q,
                 VALUES  => { MEMBER_GROUP => $INFO->{'MEMBER_GROUP'} }
               );

    $ADMIN->static_screen( URL   => "act=group",
                           TITLE => "Membergroups Deleted",
                           TEXT  => "The changes were successful"
                         );

}


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'        => \&edit,
                 'doedit'      => \&do_edit,
                 'default'     => \&default,
                 'dodefault'   => \&do_default,
                 'add'         => \&add,
                 'doadd'       => \&do_add,
                 'del'         => \&delete,
                 'dodel'       => \&dodelete,
                 'finaldelete' => \&yes_i_mean_it,
                 'forummask'   => \&forummask,
                 'doforummask' => \&doforummask,
                 'setforummask'=> \&setforummask,


               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 




1;
__END__
