package Admin::MemberControl;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}


my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


sub splash {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Member Control' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'member',
                                        CODE  => 'edit',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Choose a member to edit");

    $html .= qq~
        <tr>
        <td colspan='2' bgcolor='#EEEEEEF'><font class='t'>Find user <input type='text' size='30' name='USER_KEY' class='forminput' style="width:200px"> by
        <select name='KEY_TYPE' class='forminput' style="width:100px"><option value='NAME'>name<option value='ID'>member ID</select>
        &nbsp;&nbsp;<input type='submit' class='forminput' style="width:50px" value='Go!'>
        ~;

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Member Control', PRINT => $html);


}



sub edit {
    my ($obj, $db) = @_;
    my $html;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a name or user ID to look for!") unless defined $iB::IN{'USER_KEY'};

    my $method = $iB::IN{'KEY_TYPE'} eq 'NAME' ? 'by name' : 'by id';

    my $member = $mem->LoadMember( DB => $db, KEY => $iB::IN{'USER_KEY'}, METHOD => $method );

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my @groups;

    for (@{$mem_groups}) {
        next if ( ($_->{'ID'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) );
        push @groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }

    my $size   = scalar (@groups) + 1;


    #XXX No member found? Lets query the DB to find a near match

    unless ($member->{'MEMBER_ID'}) {

        # Make safe:
        
        $iB::IN{'USER_KEY'} =~ s!\[!\\\\[!g;
        $iB::IN{'USER_KEY'} =~ s!\]!\\\\]!g;
        
        my $query_stm = $iB::IN{'KEY_TYPE'} eq 'NAME' ? "MEMBER_NAME LIKE /".$iB::IN{'USER_KEY'}."%/"
                                                      : "MEMBER_ID LIKE /%".$iB::IN{'USER_KEY'}."%/";

        my $member_query = $db->query( TABLE    => 'member_profiles',
                                       COLUMNS  => ['MEMBER_NAME', 'MEMBER_ID', 'MEMBER_GROUP', 'MEMBER_EMAIL', 'MEMBER_POSTS'],
                                       WHERE    => $query_stm,
                                       SORT_KEY => 'MEMBER_NAME'
                                     );
                                     
                                     #die "statement ".$db->show_query;


        unless (scalar (@{$member_query}) > 0) {
            $ADMIN->Error( DB=>"", STD=>"", MSG => "No matches found for that member data");
        }



        my $html = qq~

        <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
        <tr>
        <td>
        <font class='large'>&gt;&gt; Possible Member Matches</font>
    
        <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&act=cat&s=$iB::SESSION&CODE=00' method='post'>
        <input type='hidden' name='AD' value='1'>
        <input type='hidden' name='act' value='member'>
        <input type='hidden' name='s' value='$iB::SESSION'>
        <input type='hidden' name='CODE' value='edit'>
        <input type='hidden' name='KEY_TYPE' value='ID'>

        <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#666699' width='10%' align='center'>&nbsp;</td>
            <td bgcolor='#666699' width='30%'><font class='t'><b>Member Name</b></font></td>
            <td bgcolor='#666699' width='15%' align='center'><font class='t'><b>Member Group</b></font></td>
            <td bgcolor='#666699' width='8%' align='center'><font class='t'><b>Member Email</b></font></td>
            <td bgcolor='#666699' width='8%' align='center'><font class='t'><b>Member Posts</b></font></td>

            </tr>
        ~;


        for my $this_mem (@{$member_query}) {

            my $this_mem_g = {} ;
            for (@{$mem_groups}) {
                next if ( ($_->{'ID'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) );
                $this_mem_g = $_ if $_->{'ID'} == $this_mem->{'MEMBER_GROUP'};
            }

            $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' align='center'><input type='radio' name='USER_KEY' value='$this_mem->{'MEMBER_ID'}' style='border:none'></td>
                <td bgcolor='#FFFFFF'><font class='t'>$this_mem->{'MEMBER_NAME'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$this_mem_g->{'TITLE'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$this_mem->{'MEMBER_EMAIL'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$this_mem->{'MEMBER_POSTS'}</font></td>
                </tr>
                ~;
        }


        $html .= qq~
            
                <tr>
                <td colspan='6' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='Edit Selected Member'></td>
                </tr>
                </table>
            </td>
            </tr>
        </table>
        </form>
        </td>
        </tr>
        </table>
        ~;

        $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Member Control', PRINT => $html);
    }


    if ( ($member->{'MEMBER_GROUP'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) ) {
        $ADMIN->Error( DB=>"", STD=>"", MSG => "You do not have permission to edit that member");
    }

    #XXX If we get here, we must have found an exact match.

    $member->{'SIGNATURE'} = $SKIN->formalize($member->{'SIGNATURE'});
    $member->{'INTERESTS'} = $SKIN->formalize($member->{'INTERESTS'});

    my ($width, $height) = split "x", $member->{'AVATAR_DIMS'};

    $member->{'ALLOW_POST'} ||= 0;

    $html  = $SKIN->title( TITLE => "Member Settings for $member->{'MEMBER_NAME'}<br>IP Address: $member->{'MEMBER_IP'}", TEXT => 'Please double check all the data before submitting the changes.' );
    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( {    act   => 'member',
                                        CODE  => 'doedit',
                                        ID    => $member->{'MEMBER_ID'},
                                        NAME  => $member->{'MEMBER_NAME'},
                                        OLD_P => $member->{'MEMBER_PASSWORD'},
                                      } );

    $html .= $SKIN->section_header( TITLE => "Main Settings");

    $html .= $SKIN->td_select( TEXT     => "Allow this member to post where allowed?",
                               NAME     => 'ALLOW_POST',
                               REQ      => 1,
                               VALUES   => $member->{'ALLOW_POST'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );


    $html .= $SKIN->td_select( TEXT     => 'Member Group:',
                               NAME     => 'MEMBER_GROUP',
                               SIZE     => $size,
                               VALUES   => $member->{'MEMBER_GROUP'},
                               DATA     => \@groups
                             );

    $html .= $SKIN->td_input ( TEXT     => 'Title',         NAME => 'MEMBER_TITLE',  VALUE=> "$member->{'MEMBER_TITLE'}");

    $html .= $SKIN->td_input ( TEXT     => 'Email Address', NAME => 'MEMBER_EMAIL',  VALUE=> "$member->{'MEMBER_EMAIL'}",  REQ => 1 );

    $html .= $SKIN->td_input ( TEXT     => 'Avatar',        NAME => 'MEMBER_AVATAR', VALUE=> "$member->{'MEMBER_AVATAR'}");

    $html .= $SKIN->td_input ( TEXT     => 'Avatar Width',  NAME => 'AVATAR_W',      VALUE=> $width);

    $html .= $SKIN->td_input ( TEXT     => 'Avatar Height', NAME => 'AVATAR_H',      VALUE=> $height);

    $html .= $SKIN->td_input ( TEXT     => 'Posts',         NAME => 'MEMBER_POSTS',  VALUE=> "$member->{'MEMBER_POSTS'}");

    $html .= $SKIN->td_input ( TEXT     => 'Photo',         NAME => 'PHOTO',         VALUE=> "$member->{'PHOTO'}");

    $html .= $SKIN->td_input ( TEXT     => 'AIM Name',      NAME => 'AOLNAME',       VALUE=> "$member->{'AOLNAME'}");

    $html .= $SKIN->td_input ( TEXT     => 'ICQ No.',       NAME => 'ICQNUMBER',     VALUE=> "$member->{'ICQNUMBER'}");

    $html .= $SKIN->td_input ( TEXT     => 'Yahoo Name',    NAME => 'YAHOONAME',     VALUE=> "$member->{'YAHOONAME'}");

    $html .= $SKIN->td_input ( TEXT     => 'MSN Name',      NAME => 'MSN_NAME',      VALUE=> "$member->{'MSN_NAME'}");

    $html .= $SKIN->td_input ( TEXT     => 'Location',      NAME => 'LOCATION',      VALUE=> "$member->{'LOCATION'}");

    $html .= $SKIN->td_input ( TEXT     => 'Website',       NAME => 'WEBSITE',       VALUE=> "$member->{'WEBSITE'}");

    $html .= $SKIN->td_textarea( TEXT => "Signature",       NAME => 'SIGNATURE',     VALUE => "$member->{'SIGNATURE'}");

    $html .= $SKIN->td_textarea( TEXT => "Interests",       NAME => 'INTERESTS',     VALUE => "$member->{'INTERESTS'}");

    $html .= $SKIN->td_select( TEXT     => "Email Hidden?",
                               NAME     => 'HIDE_EMAIL',
                               REQ      => 1,
                               VALUES   => $member->{'HIDE_EMAIL'},
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->section_header( TITLE => "Reset Members Password?", TEXT => 'Leave blank unless you want to change it!');

    $html .= $SKIN->td_input ( TEXT     => 'Enter a new password here<br>&nbsp;&nbsp;&nbsp;&nbsp;If you wish to reset the pass',         NAME => 'MEMBER_PASSWORD');


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => "Member Preferences", PRINT => $html);

}


sub do_edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a member to edit!") unless defined $iB::IN{'ID'};

    my $pass;

    if (length($iB::CGI->param('MEMBER_PASSWORD')) > 0) {
        $pass = $mem->Crypt($iB::CGI->param('NAME'),$iB::CGI->param('MEMBER_PASSWORD'));
    } else {
        $pass = $iB::CGI->param('OLD_P');
    }

    $iB::IN{'INTERESTS'}     = $SKIN->htmlalize($iB::IN{'INTERESTS'});
    $iB::IN{'AVATAR_DIMS'}   = $iB::IN{'AVATAR_W'}.'x'.$iB::IN{'AVATAR_H'};

    $db->update( TABLE   => 'member_profiles',
                 KEY     => $iB::IN{'ID'},
                 ID      => $iB::IN{'ID'},
                 VALUES  => {   MEMBER_GROUP   => $iB::IN{'MEMBER_GROUP'},
                                MEMBER_PASSWORD => $pass,
                                MEMBER_EMAIL   => $iB::IN{'MEMBER_EMAIL'},
                                MEMBER_TITLE   => $iB::IN{'MEMBER_TITLE'},
                                MEMBER_AVATAR  => $iB::IN{'MEMBER_AVATAR'},
                                AVATAR_DIMS    => $iB::IN{'AVATAR_DIMS'},
                                MEMBER_POSTS   => $iB::IN{'MEMBER_POSTS'},
                                PHOTO          => $iB::IN{'PHOTO'},
                                AOLNAME        => $iB::IN{'AOLNAME'},
                                ICQNUMBER      => $iB::IN{'ICQNUMBER'},
                                YAHOONAME      => $iB::IN{'YAHOO_NAME'},
                                MSN_NAME       => $iB::IN{'MSN_NAME'},
                                LOCATION       => $iB::IN{'LOCATION'},
                                WEBSITE        => $iB::IN{'WEBSITE'},
                                SIGNATURE      => $iB::CGI->param('SIGNATURE'),
                                INTERESTS      => $iB::IN{'INTERESTS'},
                                ALLOW_POST     => $iB::IN{'ALLOW_POST'},
                                HIDE_EMAIL     => $iB::IN{'HIDE_EMAIL'},
                           },
              );

    $ADMIN->write_log( TITLE => 'Member Changed', EXTRA => "MemberName: $iB::IN{'NAME'}");

    $ADMIN->static_screen( URL   => "act=member&CODE=edit&USER_KEY=$iB::IN{'ID'}",
                           TITLE => "Member edited",
                           TEXT  => "The changes were successful"
                         );

}

sub ban {
    my ($obj, $db) = @_;

    my @bans = split /\|\&\|/, $INFO->{'IP_FILTER'};
    my $banned = join "\n", @bans;

    my @email = split /\|\&\|/, $INFO->{'EMAIL_FILTER'};
    my $emails = join "\n", @email;

    my $html  = $SKIN->title( TITLE => 'Ban Filter Control');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'member',
                                        CODE  => 'doban'
                                      } );

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Please edit your IP filters", TEXT => "You may use '*' as a wildcard. For example: 212.234.* will ban any user with an IP that starts with 212.234" );


    $html .= $SKIN->td_textarea( TEXT  => "Banned IP's<br>&nbsp;&nbsp;&nbsp;&nbsp;Add,edit or remove<br>&nbsp;&nbsp;&nbsp;&nbsp;One per line",
                                 NAME  => 'IP_FILTER',
                                 VALUE => $banned,
                                );

    $html .= $SKIN->section_header( TITLE => "Please edit your Email filters", TEXT => "You may use '*' as a wildcard. For example: '*\@yahoo.com' will ban any user with a 'yahoo' email address, and/or not let the register" );

    $html .= $SKIN->td_textarea( TEXT  => "Banned Email Addresses<br>&nbsp;&nbsp;&nbsp;&nbsp;Add,edit or remove<br>&nbsp;&nbsp;&nbsp;&nbsp;One per line",
                                 NAME  => 'EMAIL_FILTER',
                                 VALUE => $emails,
                                );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Ban Control', PRINT => $html);

}

sub doban {
    my ($obj, $db) = @_;

    my $OLD = Boardinfo->new();

    $iB::IN{'EMAIL_FILTER'} =~ s!<br>!\|\&\|!g;
    $iB::IN{'IP_FILTER'}    =~ s!<br>!\|\&\|!g;


    $OLD->{'EMAIL_FILTER'}  = $iB::IN{'EMAIL_FILTER'};
    $OLD->{'IP_FILTER'}     = $iB::IN{'IP_FILTER'} ;

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $ADMIN->write_log( TITLE => 'Board Control Changed');

    $ADMIN->static_screen( URL   => "act=member",
                           TITLE => "Ban Filters Changed",
                           TEXT  => "The changes were successful<br>"
                         );
}


sub reg {
    my ($obj, $db) = @_;

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my @groups;

    for (@{$mem_groups}) {
        next if ( ($_->{'ID'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) );
        push @groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }


    my $html  = $SKIN->title( TITLE => "Member pre-registration", TEXT => 'Please double check all the data before submitting.' );
    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( {    act   => 'member',
                                        CODE  => 'doreg',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Member Settings");

    $html .= $SKIN->td_input ( TEXT => 'Member Name',          NAME => 'MEMBER_NAME',  VALUE=> '', REQ => 1);

    $html .= $SKIN->td_input ( TEXT => 'Member Password',       NAME => 'MEMBER_PASS',  VALUE=> '', REQ => 1);

    $html .= $SKIN->td_input ( TEXT => 'Member Email Address',  NAME => 'EMAIL',  VALUE=> '', REQ => 1);

    $html .= $SKIN->td_input ( TEXT => 'Member Post count',     NAME => 'POSTS',  VALUE=> '0', REQ => 1);

    $html .= $SKIN->td_select( TEXT     => 'Member Group:',
                               NAME     => 'MEMBER_GROUP',
                               VALUES   => "$INFO->{'MEMBER_GROUP'}",
                               DATA     => \@groups
                             );

    $html .= $SKIN->td_select( TEXT     => "Allow this member to post where allowed?",
                               NAME     => 'ALLOW_POST',
                               REQ      => 1,
                               VALUES   => '',
                               DATA     => [ { NAME => 'Yes', VALUE => 1 },
                                             { NAME => 'No' , VALUE => 0 } ],
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Pre Register this Member' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Member Control', PRINT => $html);

}


sub doreg {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must enter a membername") unless defined $iB::IN{'MEMBER_NAME'};
    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must enter a password")   unless defined $iB::IN{'MEMBER_PASS'};
    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must enter an email address") unless defined $iB::IN{'EMAIL'};

    unless ($std->CheckEmail($iB::IN{'EMAIL'})) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "Invalid email address");
    }

    my $name = $mem->CheckName( DB => $db, NAME => $iB::IN{'MEMBER_NAME'} );
    
    if ($name->{'MEMBER_NAME'}) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "$iB::IN{'MEMBER_NAME'} already exists!");
    }

    my $new_id = $mem->AddMember( DB     => $db,
                                  STD    => $std,
                                  MEMBER => {
                                               MEMBER_NAME      => $iB::IN{'MEMBER_NAME'},
                                               MEMBER_PASSWORD  => $iB::IN{'MEMBER_PASS'},
                                               MEMBER_EMAIL     => $iB::IN{'EMAIL'},
                                               MEMBER_GROUP     => $iB::IN{'MEMBER_GROUP'},
                                               ALLOW_POST       => $iB::IN{'ALLOW_POST'},
                                               MEMBER_POSTS     => $iB::IN{'POSTS'},
                                               MEMBER_LEVEL     => 1,
                                               MEMBER_AVATAR    => 'noavatar',
                                               MEMBER_IP        => $ENV{'REMOTE_ADDR'},
                                               TIME_ADJUST      => 0,
                                               LANGUAGE         => 'en',
                                               MEMBER_SKIN      => 'Default',
                                               MEMBER_JOINED    => time,
                                               VIEW_SIGS        => 1,
                                               VIEW_IMG         => 1,
                                               VIEW_AVS         => 1,
                                            }
                                 );

    my $num = $db->count( TABLE => 'member_profiles' );

    $num++;
    
    my $stats = {};
    $stats->{'TOTAL_MEMBERS'}      = '+1';
    $stats->{'LAST_REG_MEMBER_N'}  = $iB::IN{'MEMBER_NAME'};
    $stats->{'LAST_REG_MEMBER_ID'} = $new_id;
 
    $std->ib_stats($stats);

    my $pass = $iB::IN{'MEMBER_PASS'};

    $iB::IN{'MEMBER_PASS'} = 'xxxxxxxxxxx';
###################3
#
# Added by Infection
#

    if ($iB::INFO->{'CALENDAR'}) {

        my $day = $db->insert( TABLE  => 'calendar',
                               VALUES => {
                                           MEMBER_ID    => $new_id,
                                           MEMBER_NAME  => $iB::IN{'MEMBER_NAME'},
                                           DAY          => '0',
                                           MONTH        => '0',
                                           YEAR         => '0',
                                         },
                             );
    };
#
#
##################
    $ADMIN->write_log( TITLE => 'Member Pre-registered', EXTRA => "New Name: $iB::IN{'MEMBER_NAME'}");

    $ADMIN->static_screen( URL   => "act=member",
                           TITLE => "$iB::IN{'MEMBER_NAME'} has been registered",
                           TEXT  => "Member Name: $iB::IN{'MEMBER_NAME'}<br>Member Email: $iB::IN{'EMAIL'}<br>Member Password: $pass"
                         );
}

sub titles {
    my ($obj, $db) = @_;

    my @exempt = split /\:/, $iB::INFO->{'EXEMPT_GROUPS'};

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my $groups = qq!<option value=''>Don't Advance</option>!;
    my @member_groups;

    for (@{$mem_groups}) {
        push @member_groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
        next if ( ($_->{'ID'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) );
        $groups .= qq!<option value='$_->{ID}'>$_->{'TITLE'}</option>!;
    }

        

    my $mem_titles = $db->query( TABLE      => 'member_titles',
                                 SORT_KEY   => 'POSTS',
                                 SORT_BY    => 'A-Z',
                               );

    my $html  = $SKIN->title( TITLE => 'Member Title Set Up');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'member',
                                        CODE  => 'dotitles'
                                      } );


    $html .= $SKIN->section_header( TITLE => "Please edit the titles below",TEXT=> "Or leave both fields blank to remove<br>If you wish to use a picture instead of differing pip numbers, enter the image name in the \"pips for this level\" box. Image must be uploaded into iB_html/non-cgi/team_icons. Just enter icon name instead of number, not the full URL For example: <b>newmember.gif</b>" );

    $html .= qq~
    <tr>
    <td bgcolor='#EEEEEE' width='40%' align='left' valign='top'><font class='t'><b>Titles and Post numbers</b></font></td>
    <td bgcolor='#EEEEEE' width='60%' align='left'><font class='t'><b>Advance to a new member group?</b></font></td>
    </tr>
    ~;

    my $cnt = 0;

    for my $t (@{$mem_titles}) {

        my $n_groups = $groups;
        
        $n_groups =~ s!<option value='$t->{'ADVANCE_GROUP'}'!<option value='$t->{'ADVANCE_GROUP'}' selected!;

        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'><input type='text' name="TITLE_$t->{'ID'}" value='$t->{'TITLE'}' class='forminput' style='width:150px'><br>must have over <input type='text' name="POSTS_$t->{'ID'}" value='$t->{'POSTS'}' class='forminput' style='width:50px'> posts<br># pips for this level = <input type='text' name="PIPS_$t->{'ID'}" value='$t->{'PIPS'}' class='forminput' style='width:50px'></font></td>
            <td bgcolor='#FFFFFF' width='60%' align='left' valign='left' nowrap><select name='AD_$t->{ID}' class='forminput' style='width:60%'>$n_groups</select></td>
            </tr>
        ~;
        $cnt = $t->{'ID'} if $t->{'ID'} > $cnt;
    }

    $cnt++;

    $html .= $SKIN->section_header( TITLE => "Add new titles",TEXT=> "You do not have to use any/all the fields" );

    for (0 .. 10) {

        my $n_groups = $groups;
        
        $n_groups =~ s!<option value=''!<option value='' selected!;

        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'><input type='text' name="TITLE_$cnt" value='' class='forminput' style='width:150px'><br>must have over <input type='text' name="POSTS_$cnt" value='' class='forminput' style='width:50px'> posts<br># pips for this level = <input type='text' name="PIPS_$cnt" class='forminput' style='width:50px'></font></td>
            <td bgcolor='#FFFFFF' width='60%' align='left' valign='left' nowrap><select name='AD_$cnt' class='forminput' style='width:60%'>$n_groups</select></td>
            </tr>
        ~;
        $cnt++;
    }

    $html .= $SKIN->section_header( TITLE => "Exempt Groups",TEXT=> "You may not wish certain groups to be affected by the title/advance group changes<br>&nbsp;&nbsp;&nbsp;&nbsp;Especially those with Global Moderator/Admin priviledges (As a safety measure, Super Admins are always exempt)" );


    $html .= $SKIN->td_select( TEXT     => 'Exempt Groups:',
                               NAME     => 'EXEMPT_GROUPS',
                               MULTIPLE => 1,
                               VALUES   => \@exempt,
                               DATA     => \@member_groups
                             );


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Add/Edit Titles' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Member Title Control', PRINT => $html);
}

sub dotitles {
    my ($obj, $db) = @_;

    my $mem_titles = $db->query( TABLE      => 'member_titles',
                                 SORT_KEY   => 'POSTS',
                                 SORT_BY    => 'A-Z',
                               );

    my %title_hash = map {  $_->{'ID'} => $_->{'TITLE'}  } @{$mem_titles};

    my @titles     = grep { /^TITLE_(\d+)$/ } $iB::CGI->param();

    for my $t (@titles) {
        $t    =~ m#^TITLE_(\d+)$#;
        my $n = $1;
        if (defined $title_hash{$n}) {

            $db->update( TABLE    => 'member_titles',
                         KEY      => $n,
                         VALUES   => { TITLE         => $iB::IN{'TITLE_'.$n},
                                       POSTS         => $iB::IN{'POSTS_'.$n},
                                       ADVANCE_GROUP => $iB::IN{'AD_'.$n},
                                       PIPS          => $iB::IN{'PIPS_'.$n},
                                     }
                       );
        } else {

            next unless defined $iB::IN{'POSTS_'.$n};
            next unless $iB::IN{'TITLE_'.$n} ne '';

            $db->insert( TABLE    => 'member_titles',
                         VALUES   => { TITLE         => $iB::IN{'TITLE_'.$n},
                                       POSTS         => $iB::IN{'POSTS_'.$n},
                                       ADVANCE_GROUP => $iB::IN{'AD_'.$n},
                                       PIPS          => $iB::IN{'PIPS_'.$n},
                                     }
                       );
        }
    }

    #Remove dead..

    my $mem_titles = $db->query( TABLE      => 'member_titles',
                                 SORT_KEY   => 'POSTS',
                                 SORT_BY    => 'A-Z',
                               );

    for my $m (@{$mem_titles}) {
        if ($m->{'TITLE'} eq '') {
            $db->delete( TABLE    => 'member_titles',
                         KEY      => $m->{'ID'},
                       );
        }
    }

    my $OLD = Boardinfo->new();

    $OLD->{'EXEMPT_GROUPS'} = join ':', $iB::CGI->param('EXEMPT_GROUPS');

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );


    $ADMIN->write_log( TITLE => 'Member Titles Changed');

    $ADMIN->static_screen( URL   => "act=member&CODE=titles",
                           TITLE => "The changes were successful",
                         );
}

sub del {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Member Control' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'member',
                                        CODE  => 'delone',
                                      } );

    $html .= $SKIN->section_header( TITLE => "Choose a member to DELETE", TEXT => "Deleting a member physically removes them from the database, are you sure you wish to do this?");

    $html .= qq~
        <tr>
        <td colspan='2' bgcolor='#EEEEEEF'><font class='t'>Find user <input type='text' size='30' name='USER_KEY' class='forminput' style="width:200px"> by
        <select name='KEY_TYPE' class='forminput' style="width:100px"><option value='NAME'>name<option value='ID'>member ID</select>
        &nbsp;&nbsp;<input type='submit' class='forminput' style="width:50px" value='Go!'>
        ~;

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Member Control', PRINT => $html);


}



sub delone {
    my ($obj, $db) = @_;
    my $html;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a name or user ID to look for!") unless defined $iB::IN{'USER_KEY'};

    my $method = $iB::IN{'KEY_TYPE'} eq 'NAME' ? 'by name' : 'by id';
    
    $iB::IN{'USER_KEY'} =~ s!\[!\\\\[!g;
    $iB::IN{'USER_KEY'} =~ s!\]!\\\\]!g;

    my $query_stm = $iB::IN{'KEY_TYPE'} eq 'NAME' ? "MEMBER_NAME LIKE /%$iB::IN{'USER_KEY'}%/"
                                                  : "MEMBER_ID LIKE /%$iB::IN{'USER_KEY'}%/";

    my $member_query = $db->query( TABLE    => 'member_profiles',
                                   COLUMNS  => ['MEMBER_NAME', 'MEMBER_ID', 'MEMBER_GROUP', 'MEMBER_EMAIL', 'MEMBER_POSTS'],
                                   WHERE    => $query_stm,
                                   SORT_KEY => 'MEMBER_NAME'
                                 );


    unless (scalar (@{$member_query}) > 0) {
        $ADMIN->Error( DB=>"", STD=>"", MSG => "No matches found for that member data");
    }

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );
    my @groups;

    for (@{$mem_groups}) {
        next if ( ($_->{'ID'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) );
        push @groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }

        my $html = qq~

        <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
        <tr>
        <td>
        <font class='large'>&gt;&gt; Possible Member Matches for DELETION - You may choose more than one.<br><br><span style='color:red'>*ONLY PROCEED IF YOU WISH TO DELETE A MEMBER*</span></font>
    
        <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION' method='post'>
        <input type='hidden' name='AD' value='1'>
        <input type='hidden' name='act' value='member'>
        <input type='hidden' name='s' value='$iB::SESSION'>
        <input type='hidden' name='CODE' value='delfinal'>
        <input type='hidden' name='KEY_TYPE' value='ID'>

        <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#666699' width='10%' align='center'>&nbsp;</td>
            <td bgcolor='#666699' width='30%'><font class='t'><b>Member Name</b></font></td>
            <td bgcolor='#666699' width='15%' align='center'><font class='t'><b>Member Group</b></font></td>
            <td bgcolor='#666699' width='8%' align='center'><font class='t'><b>Member Email</b></font></td>
            <td bgcolor='#666699' width='8%' align='center'><font class='t'><b>Member Posts</b></font></td>

            </tr>
        ~;


        for my $this_mem (@{$member_query}) {

            my $this_mem_g = {} ;
            for (@{$mem_groups}) {
                next if ( ($_->{'ID'} == $INFO->{'SUPAD_GROUP'}) and ($iB::MEMBER->{'MEMBER_GROUP'} != $INFO->{'SUPAD_GROUP'}) );
                $this_mem_g = $_ if $_->{'ID'} == $this_mem->{'MEMBER_GROUP'};
            }

            $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' align='center'><input type='checkbox' name='USER_KEY' value='$this_mem->{'MEMBER_ID'}' style='border:none'></td>
                <td bgcolor='#FFFFFF'><font class='t'>$this_mem->{'MEMBER_NAME'}<br>ID: $this_mem->{'MEMBER_ID'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$this_mem_g->{'TITLE'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$this_mem->{'MEMBER_EMAIL'}</font></td>
                <td bgcolor='#FFFFFF' align='center'><font class='t'>$this_mem->{'MEMBER_POSTS'}</font></td>
                </tr>
                ~;
        }


        $html .= qq~
            
                <tr>
                <td colspan='6' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='DELETE Selected Member'></td>
                </tr>
                </table>
            </td>
            </tr>
        </table>
        </form>
        </td>
        </tr>
        </table>
        ~;

        $ADMIN->Output( WHERE => 'MEMBERS', NAV_ONE => 'Member Control', PRINT => $html);

}

sub delfinal {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must specify a member to delete!") unless defined $iB::IN{'USER_KEY'};


    my @keys = $iB::CGI->param('USER_KEY');

    for my $key (@keys) {

        my $member = $db->select( TABLE => 'member_profiles',
                                  KEY   => $key
                                );
  
        next unless $member->{'MEMBER_ID'};

        $db->delete( TABLE => 'member_profiles',
                     KEY   => $member->{'MEMBER_ID'}
                   );
##############
#
# Added by Infection
#
        $db->delete( TABLE => 'calendar',
                     KEY   => $member->{'MEMBER_ID'}
                   );
#
#
###########
        $db->update_index( TABLE     => 'member_profiles',
                           INDEX_KEY => 'MEMBER_EMAIL',
                           R_KEY     => $member->{'MEMBER_EMAIL'},
                           REMOVE    => 1
                         );

        $db->update_index( TABLE     => 'member_profiles',
                           INDEX_KEY => 'MEMBER_NAME',
                           R_KEY     => $member->{'MEMBER_NAME'},
                           REMOVE    => 1
                         );
    }

    $ADMIN->write_log( TITLE => 'Member(s) Deleted');

    $ADMIN->static_screen( URL   => "act=member",
                           TITLE => "The member was deleted",
                         );
}


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'        => \&edit,
                 'doedit'      => \&do_edit,
                 'ban'         => \&ban,
                 'doban'       => \&doban,
                 'reg'         => \&reg,
                 'doreg'       => \&doreg,
                 'titles'      => \&titles,
                 'dotitles'    => \&dotitles,
                 'del'         => \&del,
                 'delone'      => \&delone,
                 'delfinal'    => \&delfinal,


               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 




1;
__END__
