package Admin::Index;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub process {
    my ($obj, $db) = @_;


    # The easiest way to patch a bug in the pre RC1 releases.
    # This code does no harm at all, so it can be left in safely.

    my $cats = $db->query( TABLE  => 'categories');

    for my $c (@{$cats}) {
        if ($c->{SUB_CAT_ID} eq '-') {
            $c->{SUB_CAT_ID} = 0;
            $db->update( TABLE  => 'categories',
                         KEY    => $c->{CAT_ID},
                         VALUES => $c
                       );
        }
    }

    # Resume the normal program ;)


    my $reg_url = "$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&AD=1&act=auth";
    my $pre_url = "$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&AD=1&act=auth&CODE=preview";
    my $las_url = "$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&AD=1&act=auth&CODE=list_lost";

    # Get the awaiting authorisation details

    my $auth = $db->query( TABLE    => 'authorisation',
                           SORT_KEY => 'DATE_ENTERED',
                           SORT_BY  => 'Z-A',
                         );

    # Split up into the groups

    my (@register, @lostpass, @preview);

    my $reg_count  = 0;
    my $lost_count = 0;
    my $pre_count  = 0;

    for my $a (@{$auth}) {
        if ($a->{'_WHERE'} eq 'register') {
            # just get the top 10
            ++$reg_count;
            next if $reg_count > 10;
            push @register, $a;
        } elsif ($a->{'_WHERE'} eq 'lostpass') {
            # just get the top 10
            ++$lost_count;
            next if $lost_count > 10;
            push @lostpass, $a;
        } elsif ($a->{'_WHERE'} eq 'authorise') {
            ++$pre_count;
            next if $pre_count > 10;
            push @preview, $a;
        }
    }
    

    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%'>
     <tr>
        <td class='t'>Welcome to your Administrative Control Panel. Here you can control every aspect of the forum and change the way it looks and works.</td>
     </tr>
     <tr>
        <td>
          <table cellspacing='0' cellpadding='5' border='0' width='100%' style='border:1px solid black'>
    ~;


    # PREVIEWING MEMBERS...

    $html .= qq~<tr>
             <td bgcolor='#8888AA' class='t'><span style='color:white;font-size:11px'><b>$pre_count members awaiting an admin to preview their registration</b> (showing last 10)</span></td>
              </tr>
            ~;
    for my $m (@preview) {
        my $date = $std->get_date( TIME => $m->{'DATE_ENTERED'}, METHOD => 'LONG' );
        $html .= qq~
                      <tr>
                        <td bgcolor='#F1F1F1' class='t'>&nbsp;&nbsp;<span style='color:red'>&gt;</span><b>$m->{'MEMBER_NAME'}</b> (email address: $m->{'MEMBER_EMAIL'}) registered on <b>$date</b></td>
                      </tr>
                   ~;
    }

    $html .= qq~<tr>
                <td bgcolor='#F1F1F1' class='t' align='right'><a href='$pre_url' target='BODY'>PREVIEW THESE ACCOUNTS (Members cannot post until you do so)</a></td>
              </tr>
             </table>
           </td>
          </tr>
          <tr>
            <td>&nbsp;<br>&nbsp;</td>
          </tr>
          <tr>
          <td>
            <table cellspacing='0' cellpadding='5' border='0' width='100%' style='border:1px solid black'>
              <tr>
             <td bgcolor='#8888AA' class='t'><span style='color:white;font-size:11px'><b>$reg_count members processing their registration</b> (showing last 10)</span></td>
              </tr>
    ~;

    # Print out the details..
    for my $m (@register) {
        my $date = $std->get_date( TIME => $m->{'DATE_ENTERED'}, METHOD => 'LONG' );
        $html .= qq~
                      <tr>
                        <td bgcolor='#F1F1F1' class='t'>&nbsp;&nbsp;<span style='color:red'>&gt;</span><b>$m->{'MEMBER_NAME'}</b> (email address: $m->{'MEMBER_EMAIL'}) registered on <b>$date</b></td>
                      </tr>
                   ~;
    }
    
    $html .= qq~
              <tr>
                <td bgcolor='#F1F1F1' class='t' align='right'><a href='$reg_url' target='BODY'>Manually process these accounts? (You don't have to)</a></td>
              </tr>
             </table>
           </td>
          </tr>
          <tr>
            <td>&nbsp;<br>&nbsp;</td>
          </tr>
          <tr>
          <td>
            <table cellspacing='0' cellpadding='5' border='0' width='100%' style='border:1px solid black'>
              <tr>
               <td bgcolor='#8888AA' class='t'><span style='color:white;font-size:11px'><b>$lost_count members changing their passwords</b> (showing last 10)</span></td>
                </tr>
              ~;

    # Print out the details..
    for my $l (@lostpass) {
        my $date = $std->get_date( TIME => $l->{'DATE_ENTERED'}, METHOD => 'LONG' );
        $html .= qq~
                      <tr>
                        <td bgcolor='#F1F1F1' class='t'>&nbsp;&nbsp;<span style='color:red'>&gt;</span><b>$l->{'MEMBER_NAME'}</b> (email address: $l->{'MEMBER_EMAIL'}) requested a password change on <b>$date</b></td>
                      </tr>
                   ~;
    }
    
    $html .= qq~
              <tr>
                <td bgcolor='#F1F1F1' class='t' align='right'><a href='$las_url' target='BODY'>Manually process these accounts? (You don't have to)</a></td>
              </tr>
             </table>
          </td>
      </tr>
    </table>
    ~;

    $ADMIN->Output( WHERE => 'WELCOME', NAV_ONE => 'Welcome to your CP', PRINT => $html);

}  






1;
__END__









