package Admin::Import;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

use File::Path;
use Archive::Tar;

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();


my $TABLES = {
                0  => 'attachments',
                1  => 'active_sessions',
                2  => 'authorisation',
                3  => 'address_books',
                4  => 'categories',
                5  => 'email_templates',
                6  => 'forum_info',
                7  => 'forum_moderators',
                8  => 'forum_rules',
                9  => 'help',
                10 => 'member_profiles',
                11 => 'member_titles',
                12 => 'mem_groups',
                13 => 'message_stats',
                14 => 'mod_email',
                15 => 'mod_posts',
                16 => 'ssi_templates',
                17 => 'templates',
                
            };


               # 8  => 'forum_polls',
                #9  => 'forum_poll_voters',
                #12 => 'forum_subscriptions',
                #13 => 'forum_topics',
                #18 => 'message_data',
                #22 => 'search_log',
                #10 => 'forum_posts',             

sub new {
    my $pkg = shift;
    $iB::INFO->{'BACKUP_DIR'} ||= $iB::INFO->{'IKON_DIR'}."BACK_UP";
    my $obj = { 'back_up' => $iB::INFO->{'BACKUP_DIR'} };
    bless $obj, $pkg;
    return $obj;
}


sub splash {
    my ($obj, $db) = @_;
    $iB::INFO->{'BACKUP_DIR'} ||= $iB::INFO->{'IKON_DIR'}."BACK_UP";
    opendir (DIR, $iB::INFO->{'BACKUP_DIR'}) or die  "Cannot Open the Directory!";
    my @files =  grep  {   !/^\./ && /^EXPORT-(?:[\w\d]+)\.tar$/   } readdir DIR;
    closedir DIR;

    my @tar_files;

    for (@files) {
        my $time = $_;
        $time =~ s/^EXPORT-(.+?)\.tar$/$1/;
        $time = $std->get_date( TIME => $time, METHOD => "LONG" );
        push @tar_files, { NAME => "Exported on $time", VALUE => $_ };
    }

    my $html  = $SKIN->title( TITLE => 'Import Settings', TEXT => 'Please double check all the data before submitting the changes.' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'import',
                                        CODE  => 'start'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Import Settings", TEXT => "Please ensure that you have set up the database engine you are about to export to. You may receive errors if you do not do this. Also ensure that any back-ups that you wish to restore from are in the BACK_UPS directory or they will not be found");

    $html .= $SKIN->td_select( TEXT     => "Available Exported Databases",
                               NAME     => 'TAR',
                               REQ      => 1,
                               VALUES   => 'gz',
                               DATA     => \@tar_files,
                             );

    $html .= $SKIN->td_select( TEXT     => "Import into...",
                               NAME     => 'DB_DRIVER',
                               REQ      => 1,
                               VALUES   => 'DBM',
                               DATA     => [
                                              { NAME => 'DBM'   , VALUE => 'DBM'    },
                                              { NAME => 'mySQL' , VALUE => 'mySQL'  },
                                              { NAME => 'pgSQL' , VALUE => 'pgSQL'  },
                                             #{ NAME => 'MS-SQL', VALUE => 'MS-SQL' },
                                           ],
                             );

    #$html .= $SKIN->td_input ( TEXT => 'No. Members to import at a time',  NAME => 'MEMBERS', VALUE=> ""    , REQ => 1 );
    $html .= $SKIN->td_input ( TEXT => 'No. Topics to import at a time',   NAME => 'TOPICS', VALUE=> ""    , REQ => 1 );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Import Now' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'DATABASE', NAV_ONE => "Import Options", PRINT => $html);

}



sub start {
    my ($obj, $db) = @_;

    my $new_directory = $iB::IN{'TAR'};
    $new_directory    =~ s!\.tar$!!g;

    # Create the new Directory
    mkdir ($obj->{back_up}."/$new_directory", 0777);
    chmod (0777, $obj->{back_up}."/$new_directory");
    # Extract the .tar file

    {
        my $cwd = $iB::INFO->{'IKON_DIR'};
        my $tar = Archive::Tar->new();

        unless ($tar->read($obj->{back_up}."/$iB::IN{'TAR'}", 0)) {
    	        die "+>ERROR: Cannot read the .tar file (Is it there and uploaded in Binary?)\n";
        }

        chdir $obj->{back_up};
        my @files = $tar->list_files();

        for (@files) {
            if ($_ !~ /^(?:[\.\w\d\+\-\_\/\\]+)$/) {
                die "+>ERROR: Tar file is corrupted, please re-upload\n";
                
            }
        }

        $tar->extract(@files, $obj->{back_up});
        chdir $cwd;
    }


    my $url = "CODE=do_tables&dir=$new_directory&id=0&DB_DRIVER=$iB::IN{'DB_DRIVER'}&MEMBERS=$iB::IN{MEMBERS}&TOPICS=$iB::IN{TOPICS}";

    $obj->_redirect( $url, "Tar file extracted, preparing to create the new database" );
}





sub do_tables {
    my $obj = shift;
    my $db;
    my $id    = $iB::IN{'id'} || 0;
    my $table = $TABLES->{ $id };
    my $dir   = $obj->{back_up}."/$iB::IN{dir}";

    use iDatabase::SQL;
 
    my $db    = iDatabase::SQL->new( DATABASE  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_NAME'},
                                     DB_DIR    => $iB::INFO->{'DB_DIR'},
                                     IP        => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_IP'},
                                     PORT      => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PORT'},
                                     USERNAME  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_USER'},
                                     PASSWORD  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PASS'},
                                     DB_PREFIX => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PREFIX'},
                                     DB_DRIVER => $iB::IN{'DB_DRIVER'},
                                     ATTR      => { allow_create => 0,
                                                    allow_drop   => 0,
                                                  },
                                   );
                        
     # Check for errors
     &iB::catch_die( $db->error ) if $db->error;
 
 
     $db->table_import(  TABLE     => $table,
                         SOURCE    => $dir,
                         ID        => "",
                         DBID      => "",
                         START     => "",
                         PER_GO    => "",
                      );
 
     # Check for errors
     &iB::catch_die( $db->error ) if $db->error;

   



    # Increment the id number for the next iteration
    ++$id;
    my $tmp = 0;
    # Get the highest possible legal id number
    for (keys %{$TABLES}) {
        $tmp = $_ if $_ > $tmp;
    }
    
    my $Url = $id > $tmp ? "CODE=do_forums&dir=$iB::IN{dir}&id=0&DB_DRIVER=$iB::IN{'DB_DRIVER'}&MEMBERS=$iB::IN{MEMBERS}&TOPICS=$iB::IN{TOPICS}" : "CODE=do_tables&dir=$iB::IN{dir}&id=$id&DB_DRIVER=$iB::IN{'DB_DRIVER'}&MEMBERS=$iB::IN{MEMBERS}&TOPICS=$iB::IN{TOPICS}";

    $obj->_redirect( $Url, "Imported table $table into  $db->{name}, preparing to import into the next table" );
}


#############################################################
#
# PREPARE POSTS
#
# We ASS_U_ME that the posts table file is going to be large.
# As the sequences generated by mySQL and DBM/CSV are different
# we're going to need to re-assign the post/topic ID's for each
# post. This is potentially a heavy operation.
# So we do it in steps.
#
# The first step is to write a config of the forum ID's that we
# we have, then we need to extract all the topics and posts for that
# forum and write them into their own files ready for the next stage
# which physically imports them.
#
#############################################################


sub prepare_posts {
    my ($obj, $db) = @_;
    my $dir   = $obj->{back_up}."/$iB::IN{dir}";

    if ($iB::IN{'fid'}) {
        $obj->_do_forum();
    }
    else {

        open FORUMS, "$dir/forum_info.txt" or die "Cannot read the forums config file ($!)";
        my @forums = <FORUMS>;
        close FORUMS;

        my $cnt = 1;
        # Open up the temp forum info file
        open TEMP, ">$dir/tmp_forums" or die "Cannot save out the forums config file ($!)";
        for my $f (@forums) {
            $f =~ m/^-\|\*\|(\d+)\|\^\|/;
            my $id = $1;
            print TEMP "$cnt:$id;";
            ++$cnt;
        }
        print TEMP "$cnt:!!END!!";
        close TEMP;

        $obj->_redirect("CODE=prepare_posts&dir=$iB::IN{dir}&DB_DRIVER=$iB::IN{'DB_DRIVER'}&fid=1&MEMBERS=$iB::IN{MEMBERS}&TOPICS=$iB::IN{TOPICS}", "Written configuration file, starting to prepare the posts..." );
    }

}

# The format for each entry is:
# DBID-ID|*|values

sub import_forums {
    my $obj   = shift;
    my $dir   = $obj->{back_up}."/$iB::IN{dir}";
    my $id    = $iB::IN{gid} || 1;

    my $fcnt = 0;

    my $fids  = {};
    my $string;

    # We want to localise the default file line seperator, so
    # lets put this in it's own code block, then $/ will be restored
    # to it's normal value upon exiting.

    {
        # Parse the config file
        local $/ = undef;
        open FORUMS, "$dir/tmp_forums" or die "Cannot read the forums config file ($!)";
        $string = <FORUMS>;
        close FORUMS;
        chomp $string;
    }

    # Take our string of properly incremented number => forum id keys
    # and create a hash table

    for ( split /;/, $string ) {
        my ($k, $v) = split /\:/;
        $fids->{ $k } = $v;
        ++$fcnt;
    }

    if ($fids->{ $id } eq '!!END!!') {
        $obj->do_messages();
    }

    # Get a Database connection
    require iDatabase::SQL;

    my $perm = $iB::IN{'DB_DRIVER'} eq 'DBM' ? 1 : 0;

    my $db    = iDatabase::SQL->new( DATABASE  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_NAME'},
                                     DB_DIR    => $iB::INFO->{'DB_DIR'},
                                     IP        => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_IP'},
                                     PORT      => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PORT'},
                                     USERNAME  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_USER'},
                                     PASSWORD  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PASS'},
                                     DB_PREFIX => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PREFIX'},
                                     DB_DRIVER => $iB::IN{'DB_DRIVER'},
                                     ATTR      => { allow_create => $perm,
                                                    allow_drop   => 0,
                                                  },
                                   );

    # Load the config file for this table.

    # We are going to need to re-assign all the topic and post ID's
    # This is a labourious task, so lets try to reduce the server load.

    # First, lets create the new posts table (if needed)

    $db->create_table( TABLE  => 'forum_posts',
                       DBID   => 'f'.$fids->{ $id },
                     );

    my $ids = {};
    # Lets open the topic listings file.
    my $cnt = 0;
    my $real = 0;
    my $more;
    open THETOPICS, "$dir/tmp_topics-$fids->{ $id }"; # or die "Cannot locate file $! ($dir/tmp_topics-$fids->{ $id })";
    while (<THETOPICS>) {
        ++$cnt;
        unless ($cnt >= $iB::IN{LINE}) {
            next unless ( ($cnt - 1) == $iB::IN{LINE});
        }
   
        my $data = $db->rebuild_record( TABLE => 'forum_topics', STRING => $_ );
        my $old_id = $data->{TOPIC_ID};
        # We need to delete the primary key...
        delete( $data->{TOPIC_ID} );
        # Insert the new topic.
        my $new_id = $db->insert( TABLE  => 'forum_topics',
                                  ID     => $fids->{ $id },
                                  VALUES => $data,
                                );
        # For subscriptions and polls.
        $ids->{ $old_id } = $new_id;
        # Open up the posts file and import
        open F, "$dir/tmp_fposts-$fids->{ $id }-$old_id";
        while (defined($b=<F>)) {
            next unless $b;
            my $precord = $db->rebuild_record( TABLE => 'forum_posts', STRING => $b );
            next unless defined $precord->{'POST'};
            $precord->{TOPIC_ID} = $new_id;
            delete ( $precord->{POST_ID} );
            my $pid = $db->insert( TABLE  => 'forum_posts',
                                   DBID   => 'f'.$fids->{ $id },
                                   ID     => $new_id,
                                   VALUES => $precord,
                                 );
            # Add to search DB
            $precord->{POST} = $obj->convert_for_index($precord->{POST});
            $db->insert( TABLE   => 'search_log',
                         ID      => $fids->{ $id },
                         VALUES  => {
                                        AUTHOR_ID    => lc($precord->{'AUTHOR'}),
                                        MEMBER_NAME  => $data->{'TOPIC_LASTP_N'},
                                        DATE         => $precord->{'POST_DATE'},
                                        TOPIC_TITLE  => lc($data->{'TOPIC_TITLE'}),
                                        POST         => $precord->{'POST'},
                                        FORUM_ID     => $fids->{ $id },
                                        TOPIC_ID     => $new_id,
                                        POST_ID      => $pid,
                                        POSTER_IP    => $precord->{'IP_ADDR'},
                                    }
                       );


        }
        close F;
        
        ++$real;  # Incrememnt the number of topics converted.

        if ($iB::IN{TOPICS}) {
            if ($real >= $iB::IN{TOPICS}) {
                $more = 1;
                goto 'JUMP';
            } else {
                next;
            }
        }

    }
JUMP:
    #Rewind the file.
    seek (THETOPICS, 0, 0);
    close THETOPICS;

    # Next up, polls.
    my $poll_titles = {};
    open THEPOLLS, "$dir/forum_polls.txt";
    while (<THEPOLLS>) {
        my $pdata = ( split /\|\*\|/ )[1];
        my $data = $db->rebuild_record( TABLE => 'forum_polls', STRING => $pdata );
        next unless $data->{'FORUM_ID'} = $fids->{ $id };    
        next unless exists $ids->{ $data->{'POLL_ID'} };
        next if exists $poll_titles->{ $data->{POLL_TITLE} };
        $data->{POLL_ID} = $ids->{ $data->{'POLL_ID'} };
        delete ( $data->{ID} );
        $db->insert( TABLE  => 'forum_polls',
                     VALUES => $data,
                   );
        $poll_titles->{ $data->{POLL_TITLE} } = 1;
    }
    close THEPOLLS;

    # Next up, polls voters.
    open THEPOLLVOTERS, "$dir/forum_poll_voters.txt";
    while (<THEPOLLVOTERS>) {
        my $pdata = ( split /\|\*\|/ )[1];
        my $data = $db->rebuild_record( TABLE => 'forum_poll_voters', STRING => $pdata );
        next unless $data->{'FORUM_ID'} = $fids->{ $id };    
        next unless exists $ids->{ $data->{'POLL_ID'} };
        $data->{POLL_ID} = $ids->{ $data->{'POLL_ID'} };
        delete ( $data->{ID} );
        $db->insert( TABLE  => 'forum_poll_voters',
                     VALUES => $data,
                   );
    }
    close THEPOLLVOTERS;

    # Finally, forum subscriptions.
    open THESUBS, "$dir/forum_subscriptions.txt";
    while (<THESUBS>) {
        my $pdata = ( split /\|\*\|/ )[1];
        my $data = $db->rebuild_record( TABLE => 'forum_subscriptions', STRING => $pdata );
        next unless $data->{'FORUM_ID'} = $fids->{ $id };    
        next unless exists $ids->{ $data->{'TOPIC_ID'} };
        $data->{TOPIC_ID} = $ids->{ $data->{'TOPIC_ID'} };
        delete ( $data->{ID} );
        $db->insert( TABLE  => 'forum_subscriptions',
                     VALUES => $data,
                   );
    }
    close THESUBS;

    # At this point, it's probably a good time to get friendly with your
    # webhost and pull a vague expression when they ask you why their server load
    # has just spiralled... ;)

    my $this = $id;

    # Unless we have more to go, move on to the next forum...
    unless ($more == 1) {
        ++$id;
        # Reset the counter
        $cnt = -1;
    }

    # Increment the next line number to start from for the next batch of topics

    ++$cnt;

    $obj->_redirect("CODE=do_forums&dir=$iB::IN{dir}&DB_DRIVER=$iB::IN{'DB_DRIVER'}&gid=$id&MEMBERS=$iB::IN{MEMBERS}&TOPICS=$iB::IN{TOPICS}&LINE=$cnt", "IMPORTED $real topics of forum $this of $fcnt for import, moving on to the next batch..." );
}


############################################
#
# Prepares text for entry into the search DB
#
############################################

sub convert_for_index {
   my ($obj, $Txt) = @_;
   $Txt =~ s!<(.+?)>!!sg;
   $Txt =~ s!\b($iB::INFO->{'SKIP_WORDS'})\b!!ig;
   $Txt =~ s!  ! !g;
   $Txt =~ s!&.+?;!!g;
   $Txt = substr($Txt, 0, $iB::INFO->{'MAX_CHARS'}) unless $iB::INFO->{'MAX_CHARS'} eq 'ALL' or $iB::INFO->{'MAX_CHARS'} eq '';
   return lc($Txt);
}


############################################
#
# Imports all the private messages
#
############################################

sub do_messages {
    my $obj   = shift;
    my $dir   = $obj->{back_up}."/$iB::IN{dir}";


    # Get a Database connection
    require iDatabase::SQL;

    my $perm = $iB::IN{'DB_DRIVER'} eq 'DBM' ? 1 : 0;

    my $db    = iDatabase::SQL->new( DATABASE  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_NAME'},
                                     DB_DIR    => $iB::INFO->{'DB_DIR'},
                                     IP        => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_IP'},
                                     PORT      => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PORT'},
                                     USERNAME  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_USER'},
                                     PASSWORD  => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PASS'},
                                     DB_PREFIX => $iB::INFO->{$iB::IN{'DB_DRIVER'}.'_DB_PREFIX'},
                                     DB_DRIVER => $iB::IN{'DB_DRIVER'},
                                     ATTR      => { allow_create => $perm,
                                                    allow_drop   => 0,
                                                  },
                                   );
    # Open up the message data file and insert each record.

    open THESUBS, "$dir/message_data.txt";
    while (<THESUBS>) {
        my ($id, $pdata) = split /\|\*\|/ ;
        $id =~ s/^-//;
        my $data = $db->rebuild_record( TABLE => 'message_data', STRING => $pdata );
        next unless $data->{'MESSAGE_ID'};    
        delete ( $data->{MESSAGE_ID} );
        $db->insert( TABLE  => 'message_data',
                     ID     => $id,
                     VALUES => $data,
                   );
    }
    close THESUBS;

    $obj->_redirect("CODE=finish&dir=$iB::IN{dir}&DB_DRIVER=$iB::IN{'DB_DRIVER'}", "IMPORTED message_data, finishing up import." );

}


############################################
#
# Prepare a forum for importing
#
############################################

sub _do_forum {
    my $obj   = shift;
    my $dir   = $obj->{back_up}."/$iB::IN{dir}";
    my $id    = $iB::IN{fid} || 1;

    my $fcnt = 0;

    my $fids  = {};
    my $string;

    # We want to localise the default file line seperator, so
    # lets put this in it's own code block, then $/ will be restored
    # to it's normal value upon exiting.

    {
        # Parse the config file
        local $/ = undef;
        open FORUMS, "$dir/tmp_forums" or die "Cannot read the forums config file ($!)";
        $string = <FORUMS>;
        close FORUMS;
        chomp $string;
    }

    # Take our string of properly incremented number => forum id keys
    # and create a hash table

    for ( split /;/, $string ) {
        my ($k, $v) = split /\:/;
        $fids->{ $k } = $v;
        ++$fcnt;
    }

    if ($fids->{ $id } eq '!!END!!') {
        $obj->import_forums();
    }

    # PROCESS TOPICS
    # Open up a file to write to
    open SAVETOPICS, ">$dir/tmp_topics-$fids->{ $id }";
    # Open up the written DB file
    open TOPICS, "$dir/forum_topics.txt";

    while (<TOPICS>) {
        chomp;
        next unless /^\-$fids->{ $id }\|\*\|/;
        my $data = ( split /\|\*\|/ )[1];
        print SAVETOPICS $data."\n";
    }
    close TOPICS;
    close SAVETOPICS;

    # PROCESS POSTS
    open SAVEPOSTS, ">$dir/tmp_posts-$fids->{ $id }";
    open POSTS, "$dir/forum_posts.txt";
    while (<POSTS>) {
        chomp;
        next unless /^$fids->{ $id }\-/;
        print SAVEPOSTS $_."\n";
    }
    close POSTS;
    close SAVEPOSTS;

    # Now we need to split the posts up further by topic ID.
    # This will save us some processes on the next re-iteration.

    # So, we open up our topics file and save out the unique topic ID's
    # into a hash ref, pushing the line numbers into the hash value.
    # We then go back through and read the line numbers and store the values as appropriate.
    # We use a manual variable to store the line number, as $. oper won't be reset upon
    # a seek to the start of the file.

    my $topic_ids = { };
    my $cnt = 0;
    open THEPOSTS, "$dir/tmp_posts-$fids->{ $id }";
    while (<THEPOSTS>) {
        chomp;
        ++$cnt;
        next unless $_;
        /^$fids->{ $id }\-(.+?)\|\*\|/;
        my $k = $1;
        $topic_ids->{ $k } .= $cnt .':';
    }

    # Now we have the unique topic ID's, we need to spool through the posts file again
    # and use the sorted line numbers as a guide to where the topic posts are.

    for my $t (sort { $a <=> $b } keys %{$topic_ids}) {
        $topic_ids->{$t} = ':'.$topic_ids->{$t};
        # Reset the counter
        $cnt = 0;
        open F, ">$dir/tmp_fposts-$fids->{ $id }-$t";
        seek (THEPOSTS, 0, 0);
        while (<THEPOSTS>) {
            ++$cnt;
            next unless $topic_ids->{$t} =~ /\:$cnt\:/;
            my $data = ( split /\|\*\|/ )[1];
            print F $data;
        }
        close F;
    }
    close THEPOSTS;
    
    # Phew, that's it for that forum. If we have a server left, lets move onwards
    # to the next forum...

    my $this = $id;
    ++$id;

    $obj->_redirect("CODE=prepare_posts&dir=$iB::IN{dir}&DB_DRIVER=$iB::IN{'DB_DRIVER'}&fid=$id&MEMBERS=$iB::IN{MEMBERS}&TOPICS=$iB::IN{TOPICS}", "Prepared forum $this of $fcnt for import, moving on to the next..." );
}


sub finish {
    my $obj = shift;
    my $dir   = $obj->{back_up}."/$iB::IN{dir}";

    # remove the temp files.
    rmtree $dir;

    $ADMIN->static_screen( URL   => "&act=import",
                           TITLE => "The database has been imported.<br><br> If you have just imported into a DBM database, we strongly recommend you re-index your member_profiles table NOW. <a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=dbmclient'>Re-index member profiles</a>",
                         );

}



sub _redirect {
    my ($obj, $Url, $text) = @_;

        $Url = "?AD=1&s=$iB::SESSION&act=import&".$Url;

        print "Content-type: text/html\n\n";
        print qq~
        <html>
        <head>
        <title>iB::Exporting Database - Please Stand by...</title>
        <meta http-equiv="refresh" content="3; url=$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}$Url">
        <style type="text/css">
        #t        { font-family: Arial; font-size: 12px; color: #000003 }
        #large    { font-family: Arial; font-size: 14px; font-weight: bold; color: #000000 }
        </style>
        </head>
        <body bgcolor='#FFFFFFF'>
    
        <table cellpadding='0' cellspacing='0' border='0' width="$iB::SKIN->{'TABLE_WIDTH'}" align='center' height='85%'>
        <tr align='center' valign='middle'>
            <td>
            <table cellpadding='10' cellspacing='0' border='0' width="80%" align='center'>
            <tr>
                <td valign='middle' align='center' bgcolor='$iB::SKIN->{'MISCBACK_ONE'}' id='t'>
                <span id='large'>$text</span>
                <br><br>Continuing to import the database into...
                <br><br>
                (<a href='$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}$Url' >Click here if you do not wish to wait</a>)
                </td>
            </tr>
            </table>
            </td>
        </tr>
        </table>
        </body>
        </html>
        ~;
        iB::exit;
}





sub process {
    my ($obj, $db) = @_;

    # Only allow super admins access...

    #unless ($iB::MEMBER->{'MEMBER_GROUP'} == $iB::INFO->{'SUPAD_GROUP'}) {
    #    $ADMIN->Error( DB => $db, STD => $std, MSG => "Sorry, only the board owners have access to this part");
    #}

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'start'            => \&start,
                 'do_tables'        => \&do_tables,
                 'prepare_posts'    => \&prepare_posts,
                 'do_forums'        => \&import_forums,
                 'do_messages'      => \&do_messages,
                 'finish'           => \&finish,
               );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 







1;
