package Admin::Helpcontrol;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


sub splash {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'editform',
                      BUTTON => 'Edit selected Topic',
                      TYPE   => 'radio',
                      TEXT   => 'Choose a topic to edit',
                      DB     => $db
                    );

}

sub del {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'dodel',
                      BUTTON => 'Delete selected Topics',
                      TYPE   => 'checkbox',
                      TEXT   => 'Choose the topics to delete',
                      DB     => $db
                    );

}

##########################################################################################
#
# Generic Listing
#
##########################################################################################
sub print_list {
    my $obj = shift;

    my %IN = ( CODE    => "",
               BUTTON  => "",
               TYPE    => "",
               TEXT    => "",
               DB      => "",
               @_,
              );

    my $db = $IN{'DB'};

    my $help = $db->query( TABLE     => 'help',
                           SORT_KEY  => 'TITLE',
                           COLUMNS   => ['ID', 'TITLE'],
                           SORT_BY   => 'A-Z',
                        );



    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; Current Help Topics</font>
    <br><br><font class='t'>&nbsp;&nbsp;$IN{'TEXT'}</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='help'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='$IN{'CODE'}'>

    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#666699' width='10%' align='center'><font class='t'>&nbsp;</t></td>
            <td bgcolor='#666699' width='90%'><font class='t'><b>Help Topic Title</b></font></td>
            </tr>
    ~;

    for my $this (@{ $help }) {

            my $radio_check = qq!<input type='$IN{'TYPE'}' name='h' value='$this->{'ID'}' style='border:none'>!;

            $html .= qq~

            <tr>
            <td bgcolor='#FFFFFF' align='center'>$radio_check</td>
            <td bgcolor='#FFFFFF'><font class='t'>$this->{'TITLE'}</font></td>
            </tr>
            ~;
        
    }

    $html .= qq~
            
            <tr>
            <td colspan='2' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='$IN{'BUTTON'}'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;


    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'Help Topic Control', PRINT => $html);

}

##########################################################################################
#
# Edit form and action
#
##########################################################################################

sub editform {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'No Help file to edit') unless defined $iB::IN{'h'};

    my $help = $db->select( TABLE => 'help',
                            KEY   => $iB::IN{'h'}
                          );

    my $html  = $SKIN->title( TITLE => 'Editing Help Topic', TEXT => 'You may edit the following details' );
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'help',
                                        h     => $help->{'ID'},
                                        CODE  => 'doedit'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Editing: $help->{'TITLE'}" );

    $html .= $SKIN->td_input   ( TEXT => 'Title', NAME  => 'TITLE', VALUE => $help->{'TITLE'}, REQ => 1 );

    $html .= $SKIN->td_textarea( TEXT => "Text" , NAME  => 'TEXT' , VALUE => $help->{'TEXT'} , REQ => 1, ROWS => 10  );

    $html .= $SKIN->td_submit  ( NAME => ''     , VALUE => 'Apply Changes' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'Help Topic Control', PRINT => $html);

}

sub doedit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'No Help file to edit')     unless defined $iB::IN{'h'};
    $ADMIN->Error( DB => $db, STD => $std, MSG=>'You must enter a title')   unless defined $iB::IN{'TITLE'};
    $ADMIN->Error( DB => $db, STD => $std, MSG=>'You must enter some text') unless defined $iB::IN{'TEXT'};

    $db->update( TABLE  => 'help',
                 KEY    => $iB::IN{'h'},
                 VALUES => { TITLE => $iB::IN{'TITLE'},
                             TEXT  => $iB::IN{'TEXT'}
                           }
               );

    $ADMIN->write_log( TITLE => 'Help Topic Edited');

    $ADMIN->static_screen( URL   => "act=help",
                           TITLE => "Help Topic Edited",
                           TEXT  => "The changes were successful"
                         );
}

##########################################################################################
#
# Add form and action
#
##########################################################################################

sub add {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Adding Help Topic');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'help',
                                        CODE  => 'doadd'
                                      } );

    $html .= $SKIN->section_header( TITLE => "Adding Help Topic" );

    $html .= $SKIN->td_input   ( TEXT => 'Title', NAME  => 'TITLE', VALUE => '', REQ => 1 );

    $html .= $SKIN->td_textarea( TEXT => "Text" , NAME  => 'TEXT' , VALUE => '' , REQ => 1, ROWS => 10 );

    $html .= $SKIN->td_submit  ( NAME => ''     , VALUE => 'Add Help Topic' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'Help Topic Control', PRINT => $html);

}

sub doadd {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'You must enter a title')   unless defined $iB::IN{'TITLE'};
    $ADMIN->Error( DB => $db, STD => $std, MSG=>'You must enter some text') unless defined $iB::IN{'TEXT'};

    $db->insert( TABLE  => 'help',
                 VALUES => { TITLE => $iB::IN{'TITLE'},
                             TEXT  => $iB::IN{'TEXT'}
                           }
               );

    $ADMIN->write_log( TITLE => 'Help Topic Added');

    $ADMIN->static_screen( URL   => "act=help",
                           TITLE => "Help Topic Added",
                           TEXT  => "The changes were successful"
                         );
}

##########################################################################################
#
# Delete form and action
#
##########################################################################################

sub dodel {
    my ($obj, $db) = @_;

    my @topics_to_delete = $iB::CGI->param('h');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Topics to delete, please try again") unless scalar @topics_to_delete > 0;

    my $topic_keys = join "+", @topics_to_delete;

    my $html  = $SKIN->title( TITLE => "Deleting Help Topics", TEXT => "WARNING: THIS ACTION CAN NOT BE UNDONE");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act    => 'help'    ,
                                        CODE   => 'dodoagadoo'   ,
                                        topics => $topic_keys
                                      } );

    $html .= $SKIN->section_header( TITLE => "Forums to delete:");

    for my $f (@topics_to_delete) {

        my $topic = $db->select( TABLE   => 'help',
                                 COLUMNS => ['TITLE'],
                                 KEY     => $f,
                               );
        $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'>Topic ID: $f</font></td>
                <td bgcolor='#FFFFFF' width='60%' align='left'><font class='t'>Help Title: <b>$topic->{'TITLE'}</b></font></td>
                </tr>
                ~;
    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'DELETE THESE TOPICS' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'Help Topic Control', PRINT => $html);
}

sub indeed {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Topics to delete, please try again") unless $iB::IN{'topics'};

    my (@topics);

    if ($iB::IN{'topics'} =~ m!\+!) {
        @topics = split (/\+/, $iB::IN{'topics'});
    } else {
        $topics[0] = $iB::IN{'topics'};
    }


    $db->delete( TABLE => 'help',
                 KEY   => \@topics,
               );

    $ADMIN->write_log( TITLE => 'Help Topics Deleted', EXTRA => "Topic IDs: @topics");


    $ADMIN->static_screen( URL   => "act=help",
                           TITLE => "Help Topic Deleted",
                           TEXT  => "The changes were successful"
                         );
}


##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'add'           => \&add,
                 'doadd'         => \&doadd,
                 'edit'          => \&splash,
                 'editform'      => \&editform,
                 'doedit'        => \&doedit,
                 'del'           => \&del,
                 'dodel'         => \&dodel,
                 'dodoagadoo'    => \&indeed
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
