package Admin::Functions;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# Admin/Functions: Administration Functions.
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();


sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

######################################################################################
#
# Process
#
######################################################################################

sub process {
    my ($obj, $db) = @_;

    $obj->dologin($db) if $iB::IN{'act'} eq 'dologin';

    unless ($iB::MEMBER->{'MEMBER_ID'}) {
           $ADMIN->Print( DB     => $db,
                       STD    => $std,
                       OUTPUT => $SKIN->log_in("You are not logged in")
                     );
            return "0 but true";
    }


    unless ($iB::MEMBER_GROUP->{'ACCESS_CP'}) {
        open LOG, ">>".$INFO->{'DB_DIR'}."Temp/log-$iB::MEMBER->{'MEMBER_ID'}.cgi" or die $!;
        print LOG time."\n";
        close LOG or die $!;
        
        $db->update( TABLE   => 'member_profiles',
                     ID      => $iB::MEMBER->{'MEMBER_ID'},
                     KEY     => $iB::MEMBER->{'MEMBER_ID'},
                     VALUES  => { ALLOW_POST => 0 }
                   );

        $ADMIN->Error( DB      => $db,
                       LEVEL   => 5,
                       MSG     => 'not_admin'
                     );
        return "0 but true";
    }
    if (-e $INFO->{'DB_DIR'}."Temp/admin-$iB::MEMBER->{'MEMBER_ID'}.cgi") {
        open ADMIN, "<".$INFO->{'DB_DIR'}."Temp/admin-$iB::MEMBER->{'MEMBER_ID'}.cgi" or die $!;
        my $admin_time = <ADMIN>;
        close ADMIN or die $!;
        chomp $admin_time;
        unless ($admin_time > (time - 60*480)) {
            unlink $INFO->{'DB_DIR'}."Temp/admin-$iB::MEMBER->{'MEMBER_ID'}.cgi";
            $ADMIN->Print( DB     => $db,
                           STD    => $std,
                           OUTPUT => $SKIN->log_in("Your admin session expired"),
                           TARGET => '_parent',
                     );
            return "0 but true";
        } else {
            # Update the time...
            open ADMIN, ">".$INFO->{'DB_DIR'}."Temp/admin-$iB::MEMBER->{'MEMBER_ID'}.cgi" or die $!;
            print ADMIN time."\n";
            close ADMIN;
        }
    } else {
        $ADMIN->Print( DB     => $db,
                       STD    => $std,
                       OUTPUT => $SKIN->log_in("No admin session found")
                     );
        return "0 but true";
    }

    my %Mode = ( dologin  => \&dologin,
                 top      => \&top,
                 menu     => \&menu,
                 body     => \&body,
                 cat      => \&cat,
                 ops      => \&Ops,
                 bak      => \&back,
                 group    => \&group,
                 forum    => \&forum,
                 member   => \&member,
                 mods     => \&mods,
                 logs     => \&logs,
                 temps    => \&temps,
                 emoticon => \&emoticon,
                 template => \&template,
                 sess     => \&session,
                 online   => \&online,
                 stats    => \&stats,
                 styles   => \&styles,
                 help     => \&help,
                 lang     => \&lang,
                 convert  => \&convert,
                 auth     => \&auth,
                 mime     => \&mime,
                 skin     => \&skin,
                 file     => \&file,
                 board    => \&board,
                 import   => \&import,
                 dbHandler => \&dbHandler,
                 tools     => \&tools,
                 sqlclient => \&sqlclient,
                 dbmclient => \&dbmclient,
    
               );
    
    $Mode{ $iB::IN{'act'} } ? $Mode{ $iB::IN{'act'} }->($obj, $db) : Frames($obj, $db);
    return "0 but true";
}



######################################################################################
#
# Log in Stuff
#
######################################################################################

sub dologin {
    my ($obj, $db) = @_;

    unless ($iB::MEMBER->{'MEMBER_ID'}) {
           $ADMIN->Print( DB     => $db,
                       STD    => $std,
                       OUTPUT => $SKIN->log_in("You are not logged in")
                     );
            return "0 but true";
    }

    unless ($iB::IN{'UserName'}) {
           $ADMIN->Print( DB     => $db,
                       STD    => $std,
                       OUTPUT => $SKIN->log_in("You must enter a User Name!")
                     );
    }

    open ADMIN, ">".$INFO->{'DB_DIR'}."Temp/admin-$iB::MEMBER->{'MEMBER_ID'}.cgi" or die $!;
    print ADMIN time;
    close ADMIN or die $!;

    unlink $INFO->{'DB_DIR'}."Temp/log-$iB::MEMBER->{'MEMBER_ID'}.cgi";

    $ADMIN->redirect( TEXT => "Log in Successful, $iB::MEMBER->{'MEMBER_NAME'} - taking you to your CP", URL => "");
  
}

######################################################################################
#
# Printing Frame components
#
######################################################################################

sub top {
    my ($obj, $db) = @_;
    
    $ADMIN->Print( DB     => $db,
                   STD    => $std,
                   OUTPUT => $SKIN->top()
                 );
}


sub menu {
    my ($obj, $db) = @_;
    
    $ADMIN->Print( DB     => $db,
                   STD    => $std,
                   OUTPUT => $SKIN->menu()
                 );
}


sub body {
    my ($obj, $db) = @_;
    require 'Admin/Index.pm';
    my $idx = Admin::Index->new()->process($db);
}

######################################################################################
#
# Module Loaders
#
######################################################################################

sub tools {
    my ($obj, $db) = @_;
    require 'Admin/Tools.pm';
    my $idx = Admin::Tools->new()->process($db);
}
sub sqlclient {
    my ($obj, $db) = @_;
    require 'Admin/SQLclient.pm';
    my $idx = Admin::SQLclient->new()->process($db);
}
sub dbmclient {
    my ($obj, $db) = @_;
    require 'Admin/DBMclient.pm';
    my $idx = Admin::DBMclient->new()->process($db);
}
sub file {
    my ($obj, $db) = @_;
    require 'Admin/Filemanager.pm';
    my $idx = Admin::Filemanager->new()->process($db);
}
sub dbHandler {
    my ($obj, $db) = @_;
    require 'Admin/dbHandler.pm';
    my $idx = Admin::dbHandler->new()->process($db);
}
sub import {
    my ($obj, $db) = @_;
    require 'Admin/Import.pm';
    my $idx = Admin::Import->new()->process($db);
}
sub board {
    my ($obj, $db) = @_;
    require 'Admin/BoardTemplates.pm';
    my $idx = Admin::BoardTemplates->new()->process($db);
}
sub skin {
    my ($obj, $db) = @_;
    require 'Admin/SkinHandler.pm';
    my $idx = Admin::SkinHandler->new()->process($db);
}
sub mime {
    my ($obj, $db) = @_;
    require 'Admin/Mimetypes.pm';
    my $idx = Admin::Mimetypes->new()->process($db);
}
sub lang {
    my ($obj, $db) = @_;
    require 'Admin/LangControl.pm';
    my $idx = Admin::LangControl->new()->process($db);
}
sub auth {
    my ($obj, $db) = @_;
    require 'Admin/Authorise.pm';
    my $idx = Admin::Authorise->new()->process($db);
}
sub convert {
    my ($obj, $db) = @_;
    require 'Admin/Convert_ib.pm';
    my $idx = Admin::Convert_ib->new()->process($db);
}
sub logs {
    my ($obj, $db) = @_;
    require 'Admin/Adminlogs.pm';
    my $idx = Admin::Adminlogs->new()->process($db);
}
sub help {
    my ($obj, $db) = @_;
    require 'Admin/Helpcontrol.pm';
    my $idx = Admin::Helpcontrol->new()->process($db);
}
sub styles {
    my ($obj, $db) = @_;
    require Admin::SkinControl;
    my $idx = Admin::SkinControl->new()->process($db);
}
sub stats {
    my ($obj, $db) = @_;
    require 'Admin/Stats.pm';
    my $idx = Admin::Stats->new()->process($db);
}
sub session {
    my ($obj, $db) = @_;
    require 'Admin/Session.pm';
    my $idx = Admin::Session->new()->process($db);
}
sub online {
    my ($obj, $db) = @_;
    require 'Admin/Online.pm';
    my $idx = Admin::Online->new()->process($db);
}
sub template {
    my ($obj, $db) = @_;
    require 'Admin/Templates.pm';
    my $idx = Admin::Templates->new()->process($db);
}
sub emoticon {
    my ($obj, $db) = @_;
    require 'Admin/EmoticonControl.pm';
    my $idx = Admin::EmoticonControl->new()->process($db);
}
sub temps {
    my ($obj, $db) = @_;
    require 'Admin/Tempfiles.pm';
    my $idx = Admin::Tempfiles->new()->process($db);
}
sub cat {
    my ($obj, $db) = @_;
    require 'Admin/Category.pm';
    my $idx = Admin::Category->new()->process($db);
}
sub mods {
    my ($obj, $db) = @_;
    require 'Admin/ModControl.pm';
    my $idx = Admin::ModControl->new()->process($db);
}
sub member {
    my ($obj, $db) = @_;
    require 'Admin/MemberControl.pm';
    my $idx = Admin::MemberControl->new()->process($db);
}
sub forum {
    my ($obj, $db) = @_;
    require 'Admin/ForumControl.pm';
    my $idx = Admin::ForumControl->new()->process($db);
}

sub back {
    my ($obj, $db) = @_;
    require 'Admin/Backup.pm';
    my $idx = Admin::Backup->new()->process($db);
}
sub group {
    my ($obj, $db) = @_;
    require 'Admin/MemberGroups.pm';
    my $idx = Admin::MemberGroups->new()->process($db);
}

sub Ops {
    my ($obj, $db) = @_;
    require 'Admin/Options.pm';
    my $idx = Admin::Options->new()->process($db);
}

sub Frames {
    my ($obj, $db) = @_;
    my $html = $SKIN->do_frames();
    $ADMIN->Print( DB     => $db,
                   STD    => $std,
                   OUTPUT => $html,
                 );
}





1;
