package Admin::ForumControl;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}



sub splash {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'view',
                      BUTTON => 'Edit selected Forum',
                      TYPE   => 'radio',
                      TEXT   => 'Choose a forum to edit',
                      DB     => $db
                    );
}

sub list_rules {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'edit_rules',
                      BUTTON => 'Edit Forum Rules',
                      TYPE   => 'radio',
                      TEXT   => 'Choose a forum rule to edit',
                      DB     => $db
                    );
}

sub reorder {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'doreorder',
                      BUTTON => 'Reorder the forums',
                      TYPE   => 'REORDER',
                      TEXT   => "Reorder your forum. Each category has it's own position values.",
                      DB     => $db
                    );
}

sub delete {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'dodel',
                      BUTTON => 'Delete Selected Forums',
                      TYPE   => 'checkbox',
                      TEXT   => 'Choose forums to delete',
                      DB     => $db
                    );
}

sub recount {
    my ($obj, $db) = @_;

    $obj->print_list( CODE   => 'dorecount',
                      BUTTON => 'Recount the selected forum',
                      TYPE   => 'radio',
                      TEXT   => 'Choose a forum to reset the post/reply counter',
                      DB     => $db
                    );
}

sub print_list {
    my $obj = shift;

    my %IN = ( CODE    => "",
               BUTTON  => "",
               TYPE    => "",
               TEXT    => "",
               DB      => "",
               @_,
              );

    my $db = $IN{'DB'};

    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        COLUMNS   => ['CAT_NAME', 'CAT_ID'],
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};

    my $nbsp = $IN{'TYPE'} eq 'REORDER' ? 'Position' : '&nbsp;';


    my $html = qq~

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; Your Forums</font>
    <br><br><font class='t'>&nbsp;&nbsp;$IN{'TEXT'}</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&CODE=view' method='post'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='forum'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='$IN{'CODE'}'>

    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#8888AA' width='10%' align='center'><font class='t' style='color:white'>$nbsp</t></td>
            <td bgcolor='#8888AA' width='30%'><font class='t' style='color:white'><b>Forum Name</b></font></td>
            <td bgcolor='#8888AA' width='15%' align='center'><font class='t' style='color:white'><b>Forum ID</b></font></td>
            <td bgcolor='#8888AA' width='8%' align='center'><font class='t' style='color:white'><b>Topics</b></font></td>
            <td bgcolor='#8888AA' width='8%' align='center'><font class='t' style='color:white'><b>Posts</b></font></td>
            <td bgcolor='#8888AA' width='30%'><font class='t' style='color:white'><b>Last Post</b></font></td>
            </tr>
    ~;

    for my $this_cat (@{ $obj->{'TOTAL_CATS'} }) {

        $html .= qq~
        <tr>
        <td bgcolor='#DDDDDD' align='left' colspan='6'><font class='large'>&gt; $this_cat->{'CAT_NAME'}</font></td>
        </tr>
        ~;
    
        my @all_forums = grep { $_->{'CATEGORY'} == $this_cat->{'CAT_ID'} } @{ $obj->{'TOTAL_FORUMS'} };

        for my $forum (@all_forums) {
           
            $forum->{'FORUM_LAST_POST'} = $forum->{'FORUM_LAST_POST'}
                                        ? $std->get_date(TIME=>$forum->{'FORUM_LAST_POST'}, METHOD=>'LONG')
                                        : 'never';

            my $radio_check = qq!<input type='$IN{'TYPE'}' name='f' value='$forum->{'FORUM_ID'}' style='border:none'>!;

            if ($IN{'TYPE'} eq 'REORDER') {
                my $total_forums = scalar @all_forums;
                my $select = qq!<select name='FORUM_ID_$forum->{'FORUM_ID'}'>\n!;
                for (1 .. $total_forums) {
                    $select .= qq!<option value='$_'>&nbsp;$_&nbsp;</option>\n!;
                }
                $select =~ s!value='$forum->{'FORUM_POSITION'}'>!value='$forum->{'FORUM_POSITION'}' selected>!;
                $radio_check = $select . "</select>";
            }

            $html .= qq~

            <tr>
            <td bgcolor='#FFFFFF' align='center'>$radio_check</td>
            <td bgcolor='#FFFFFF'><font class='t'>$forum->{'FORUM_NAME'}</font></td>
            <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_ID'}</font></td>
            <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_TOPICS'}</font></td>
            <td bgcolor='#FFFFFF' align='center'><font class='t'>$forum->{'FORUM_POSTS'}</font></td>
            <td bgcolor='#FFFFFF'><font class='t'>$forum->{'FORUM_LAST_POST'}</font></td>
            </tr>
            ~;
        }
    }

    $html .= qq~
            
            <tr>
            <td colspan='6' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='$IN{'BUTTON'}'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;


    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => 'Forum Control', PRINT => $html);

}

sub doreorder {
    my ($obj, $db) = @_;

    my $forums   = $db->query( TABLE => 'forum_info' ) || die $db->{'error'};

    for my $forum (@{$forums}) {

        $db->update( TABLE  => 'forum_info',
                     KEY    => $forum->{'FORUM_ID'},
                     VALUES => { FORUM_POSITION => $iB::IN{'FORUM_ID_'.$forum->{'FORUM_ID'}} }
                   );
    }

    $ADMIN->write_log( TITLE => 'Forum Re-Ordered');

    $ADMIN->static_screen( URL   => "act=forum&CODE=reorder",
                           TITLE => "Forum Ordered",
                           TEXT  => "The database has been updated"
                         );

}



sub dorecount {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'no_forum') unless defined $iB::IN{'f'};

    my $post_count = $db->count( TABLE  => 'forum_posts',
                                 DBID   => 'f'.$iB::IN{'f'},
                                 ID     => '',
                                 WHERE  => "FORUM_ID == $iB::IN{'f'} and QUEUED != '1'",
                               );

    my $topic_count = $db->count( TABLE => 'forum_topics',
                                  ID    => $iB::IN{'f'},
                                  WHERE  => "FORUM_ID == $iB::IN{'f'} and APPROVED == 1",
                                );

    #XXX We need the replies only, so we substract the no. topics from the count

    $post_count -= $topic_count;

    $post_count  = 0 if $post_count  < 0;
    $topic_count = 0 if $topic_count < 0;

    $db->update( TABLE  => 'forum_info',
                 KEY    => $iB::IN{'f'},
                 VALUES => { FORUM_TOPICS   => $topic_count,
                             FORUM_POSTS    => $post_count,
                           }
               );

    $ADMIN->write_log( TITLE => 'Forum Recounted', EXTRA => "Forum ID: $iB::IN{'f'}");

    $ADMIN->static_screen( URL   => "act=forum&CODE=count",
                           TITLE => "Forum recounted",
                           TEXT  => "The database has been updated"
                         );
}

    

sub do_view {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'no_forum') unless defined $iB::IN{'f'};

    my $forum = $db->select( TABLE     => 'forum_info',
                             KEY       => $iB::IN{'f'},
                           );

    # What skins do we have installed?

    my @editable; 
    my @skins = split( /\|\&\|/, $INFO->{'SKINS'} );
    for my $s (@skins) {
        @_ = split /\:/, $s;
        push @editable, { NAME => $_[2], VALUE => $_[1] };
    }

    push @editable, { NAME => 'Use members choice', VALUE => 'none' };

    my $the_skin;

    # Do we already have a current skin for this forum?
    if ($INFO->{'FORUM_SKINS'}) {
        for my $sk ( split /\|\&\|/, $INFO->{'FORUM_SKINS'} ) {
            my ($forum_id, $skin_name) = split /\:/, $sk;
            if ($forum_id == $iB::IN{'f'}) {
                $the_skin = $skin_name;
                last;
            }
        }
    }
    $the_skin ||= 'none';


    my $cats       = $db->query( TABLE     => 'categories',
                                 COLUMNS   => ['CAT_NAME', 'CAT_ID'],
                                 SORT_KEY  => 'CAT_POS',
                                 SORT_BY   => 'A-Z',
                                 MATCH     => 'ALL',
                               ) || die $db->{'error'};

    my @cat_array;
    for (@{$cats}) {
        push @cat_array,   { NAME => $_->{'CAT_NAME'}, VALUE => $_->{'CAT_ID'} };
    }

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'no_forum') unless defined $forum->{'FORUM_ID'};

    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    my (@groups, @view_groups);

    push @view_groups, { NAME => 'Use Category Defaults',   VALUE => 'c' };
    push @view_groups, { NAME => '#ALL MEMBER GROUPS#',     VALUE => '*' };
    push @groups,      { NAME => '#ALL MEMBER GROUPS#',     VALUE => '*' };

    for (@{$mem_groups}) {
        push @groups,      { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
        push @view_groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }
    
    my @view  = $forum->{'FORUM_VIEW_THREADS'} !~ /,/ 
              ? ( 
                  $forum->{'FORUM_VIEW_THREADS'} eq '*' 
                    ? ( '*' )
                    : ( 'c' )
                )
              : (split/,/,$forum->{'FORUM_VIEW_THREADS'});


    my @start = $forum->{'FORUM_START_THREADS'} eq '*' 
              ? ( '*' )
              : (split/,/,$forum->{'FORUM_START_THREADS'});

    my @reply = $forum->{'FORUM_REPLY_THREADS'} eq '*' 
              ? ( '*' )
              : (split/,/,$forum->{'FORUM_REPLY_THREADS'});
    
    my $size   = scalar (@groups) + 1;

    my $html  = $SKIN->title( TITLE => "Forum Details: $forum->{'FORUM_NAME'}", TEXT => 'You may edit the following details' );
    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( { act   => 'forum',
                                     f     => $forum->{'FORUM_ID'},
                                     CODE  => 'edit'
                                    } );

    $html .= $SKIN->td_select( TEXT     => 'Turn this Forum...',
                               NAME     => 'FORUM_STATUS',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'FORUM_STATUS'},
                               DATA     => [ { VALUE => 1, NAME => 'On'  },
                                             { VALUE => 0, NAME => 'Off (Read Only)' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Board Category for this forum?',
                               NAME     => 'CATEGORY',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'CATEGORY'},
                               DATA     => \@cat_array,
                             );


    $html .= $SKIN->section_header( TITLE => "Forum Name" );

    $html .= $SKIN->td_input (   TEXT => 'Forum Name'       , NAME => 'FORUM_NAME', VALUE=> $forum->{'FORUM_NAME'}, REQ => 1 );

    $html .= $SKIN->td_textarea( TEXT => "Forum Description", NAME => 'FORUM_DESC', VALUE => $forum->{'FORUM_DESC'} );

    $html .= $SKIN->section_header( TITLE => "Forum Mask", TEXT => "These will OVERRIDE the base permissions for this category<br>&nbsp;&nbsp;&nbsp;&nbsp;Permissions for starting/replying to topics will only apply to those who's membergroup permissions allow.<br>&nbsp;&nbsp;&nbsp;&nbsp;ALL MEMBER GROUPS is relevant to all groups, current and any more you create" );

    $html .= $SKIN->td_select( TEXT     => 'Read Topics:',
                               NAME     => 'FORUM_READ_TOPICS',
                               SIZE     => $size,
                               MULTIPLE => 1,
                               VALUES   => \@view,
                               DATA     => \@view_groups,
                             );

    $html .= $SKIN->td_select( TEXT     => 'Start Topics:',
                               NAME     => 'FORUM_START_TOPICS',
                               SIZE     => $size,
                               MULTIPLE => 1,
                               REQ      => 1,
                               VALUES   => \@start,
                               DATA     => \@groups
                             );

    $html .= $SKIN->td_select( TEXT     => 'Reply to Topics:',
                               NAME     => 'FORUM_REPLY_TOPICS',
                               SIZE     => $size,
                               MULTIPLE => 1,
                               REQ      => 1,
                               VALUES   => \@reply,
                               DATA     => \@groups
                             );

    $html .= $SKIN->section_header( TITLE => "Protect Forum with Password?", TEXT => "This makes the forum visable to everyone, but requires a password to be entered<br>&nbsp;&nbsp;&nbsp;&nbsp;before reading, writing and viewing is allowed." );

    $html .= $SKIN->td_input ( TEXT     => 'Enter Password, or leave blank of you<br>&nbsp;&nbsp;&nbsp;&nbsp;do not wish to protect this forum', NAME => 'FORUM_PROTECT', VALUE=> $forum->{'FORUM_PROTECT'}, REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Forum Permissions" );

    $html .= $SKIN->td_select( TEXT     => 'Allow HTML to be posted?',
                               NAME     => 'FORUM_HTML',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'FORUM_HTML'},
                               DATA     => [ { VALUE => 1, NAME => 'On'  },
                                             { VALUE => 0, NAME => 'Off' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Allow iB CODE to be posted?',
                               NAME     => 'FORUM_IBC',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'FORUM_IBC'},
                               DATA     => [ { VALUE => 1, NAME => 'On'  },
                                             { VALUE => 0, NAME => 'Off' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Allow attachments to be posted?',
                               NAME     => 'ALLOW_ATTACH',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'ALLOW_ATTACH'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Moderator Queue?<br>&nbsp;&nbsp;&nbsp;&nbsp;(Require moderator to validate topics/posts before they are displayed)',
                               NAME     => 'MODERATE',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'MODERATE'},
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );



    $html .= $SKIN->section_header( TITLE => "Base Sorting Options", TEXT => 'This can be overridden by the member' );
   


    $html .= $SKIN->td_select( TEXT     => "Default cut off date for topic display",
                               NAME     => 'PRUNE_DAYS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $forum->{'PRUNE_DAYS'},
                               DATA     => [ { NAME => 'Today'       ,  VALUE => '1'   },
                                             { NAME => 'Last 5 Days' ,  VALUE => '5'   }, 
                                             { NAME => 'Last 7 Days' ,  VALUE => '7'   },
                                             { NAME => 'Last 10 Days',  VALUE => '10'  },
                                             { NAME => 'Last 15 Days',  VALUE => '15'  },
                                             { NAME => 'Last 20 Days',  VALUE => '20'  },
                                             { NAME => 'Last 25 Days',  VALUE => '25'  },
                                             { NAME => 'Last 30 Days',  VALUE => '30'  },
                                             { NAME => 'Last 60 Days',  VALUE => '60'  },
                                             { NAME => 'Last 90 Days',  VALUE => '90'  },
                                             { NAME => 'Show all'    ,  VALUE => '100' },
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Default sort key",
                               NAME     => 'SORT_KEY',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $forum->{'SORT_KEY'},
                               DATA     => [ { VALUE => 'TOPIC_LAST_DATE' ,  NAME => 'Date of the last post'     },
                                             { VALUE => 'TOPIC_TITLE'     ,  NAME => 'Topic Title'               }, 
                                             { VALUE => 'TOPIC_STARTER_N' ,  NAME => 'Topic Starters Name'       },
                                             { VALUE => 'TOPIC_POSTS'     ,  NAME => 'Topic Posts'               },
                                             { VALUE => 'TOPIC_VIEWS'     ,  NAME => 'Topic Posts'               },
                                             { VALUE => 'TOPIC_START_DATE',  NAME => 'Date the topic was started'},
                                             { VALUE => 'TOPIC_LASTP_N'   ,  NAME => 'Name of the last poster'   },
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Default sort order",
                               NAME     => 'SORT_ORDER',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $forum->{'SORT_ORDER'},
                               DATA     => [ { VALUE => 'Z-A' ,  NAME => 'Descending (Z - A, 10 - 0)' },
                                             { VALUE => 'A-Z' ,  NAME => 'Ascending  (A - Z, 0 - 10)' }, 
                                           ]
                             );

    $html .= $SKIN->section_header( TITLE => "Choose a skin option for this forum" );

    $html .= $SKIN->td_select( TEXT     => 'Installed Skins',
                               NAME     => 'THE_SKIN',
                               VALUES   => $the_skin,
                               DATA     => \@editable,
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => qq[<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=forum' target='BODY'>Forum Control</a>], NAV_TWO => "Editing $forum->{'FORUM_NAME'}", PRINT => $html);


}

sub do_edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Forum ID selected, please try again") unless defined $iB::IN{'f'};

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a Forum Name") unless $iB::IN{'FORUM_NAME'};

    my ($view, $start, $reply);

    if ($iB::CGI->param('FORUM_READ_TOPICS') eq 'c') {
        my $forum = $db->select( TABLE => 'forum_info', KEY => $iB::IN{'f'}         );
        my $cat   = $db->select( TABLE => 'categories', KEY => $forum->{'CATEGORY'} );
        $view = $cat->{'VIEW'};
    } elsif
        (grep { /\*/ } $iB::CGI->param('FORUM_READ_TOPICS')) {
        $view = '*';
    } else {
        $view = join ",", $iB::CGI->param('FORUM_READ_TOPICS');
    }

    if ( grep { /\*/ } $iB::CGI->param('FORUM_START_TOPICS') ) {
        $start = '*';
    } else {
        $start = join ",", $iB::CGI->param('FORUM_START_TOPICS');
    }

    if ( grep { /\*/ } $iB::CGI->param('FORUM_REPLY_TOPICS') ) {
        $reply = '*';
    } else {
        $reply = join ",", $iB::CGI->param('FORUM_REPLY_TOPICS');
    }

    $iB::IN{'FORUM_NAME'} = $SKIN->htmlalize($iB::IN{'FORUM_NAME'});
    $iB::IN{'FORUM_DESC'} = $SKIN->htmlalize($iB::IN{'FORUM_DESC'});
  
    $db->update( TABLE  => 'forum_info',
                 KEY    => $iB::IN{'f'},
                 VALUES => { FORUM_NAME              => $iB::IN{'FORUM_NAME'},
                             FORUM_DESC              => $iB::IN{'FORUM_DESC'},
                             FORUM_IBC               => $iB::IN{'FORUM_IBC'},
                             FORUM_HTML              => $iB::IN{'FORUM_HTML'},
                             FORUM_STATUS            => $iB::IN{'FORUM_STATUS'},
                             FORUM_START_THREADS     => $start,
                             FORUM_REPLY_THREADS     => $reply,
                             FORUM_VIEW_THREADS      => $view,
                             FORUM_PROTECT           => $iB::IN{'FORUM_PROTECT'},
                             CATEGORY                => $iB::IN{'CATEGORY'},
                             SORT_KEY                => $iB::IN{'SORT_KEY'},
                             SORT_ORDER              => $iB::IN{'SORT_ORDER'},
                             PRUNE_DAYS              => $iB::IN{'PRUNE_DAYS'},
                             ALLOW_ATTACH            => $iB::IN{'ALLOW_ATTACH'},
                             MODERATE                => $iB::IN{'MODERATE'},
                           }
              ) || $ADMIN->Error( DB => $db, STD => $std, MSG => $db->{'error'} );

    $ADMIN->write_log( TITLE => 'Forum Changed', EXTRA => "Forum ID: $iB::IN{'f'}");

    #XXX Rebuild the Forum Jump

    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};

    my $final_skins;

    my $OLD = Boardinfo->new();
    for my $sk ( split /\|\&\|/, $INFO->{'FORUM_SKINS'} ) {
        my ($forum_id, $skin_name) = split /\:/, $sk;
        unless ( $forum_id == $iB::IN{'f'} ) {
            $final_skins .= $forum_id.':'.$skin_name.'|&|';
        }
    }
    # Do we have a skin to add?
    if ($iB::IN{'THE_SKIN'} ne 'none') {
        $final_skins .= $iB::IN{'f'}.':'.$iB::IN{'THE_SKIN'}.'|&|';
    }
    $OLD->{'FORUM_SKINS'} = $final_skins;
    # Update the Boardinfo.pm file
    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $std->build_forumjump( DB     => $db,
                           CATS   => $obj->{'TOTAL_CATS'},
                           FORUMS => $obj->{'TOTAL_FORUMS'}
                         );

    $ADMIN->static_screen( URL   => "act=forum&CODE=view&f=$iB::IN{'f'}",
                           TITLE => "Forum changes applied",
                           TEXT  => "The changes were successful"
                         );
}


sub add {
    my ($obj, $db) = @_;

    my $cats       = $db->query( TABLE     => 'categories',
                                 COLUMNS   => ['CAT_NAME', 'CAT_ID'],
                                 SORT_KEY  => 'CAT_POS',
                                 SORT_BY   => 'A-Z',
                                 MATCH     => 'ALL',
                               ) || die $db->{'error'};


    my $mem_groups = $db->query( TABLE      => 'mem_groups',
                                 COLUMNS    => ['ID', 'TITLE', 'CAN_REMOVE'],
                                 SORT_KEY   => 'TITLE',
                                 SORT_BY    => 'A-Z',
                               );

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must create a category first") unless scalar @{$cats} > 0;

    # What skins do we have installed?

    my @editable; 
    my @skins = split( /\|\&\|/, $INFO->{'SKINS'} );
    for my $s (@skins) {
        @_ = split /\:/, $s;
        push @editable, { NAME => $_[2], VALUE => $_[1] };
    }

    push @editable, { NAME => 'Use members choice', VALUE => 'none' };

    my $the_skin;

    # Do we already have a current skin for this forum?
    if ($INFO->{'FORUM_SKINS'}) {
        for my $sk ( split /\|\&\|/, $INFO->{'FORUM_SKINS'} ) {
            my ($forum_id, $skin_name) = split /\:/, $sk;
            if ($forum_id == $iB::IN{'f'}) {
                $the_skin = $skin_name;
                last;
            }
        }
    }
    $the_skin ||= 'none';

    my (@groups, @view_groups, @cat_array);

    push @view_groups, { NAME => 'Use Category Defaults', VALUE => 'c' };
    push @view_groups, { NAME => '#ALL MEMBER GROUPS#',     VALUE => '*' };
    push @groups,      { NAME => '#ALL MEMBER GROUPS#',     VALUE => '*' };

    for (@{$mem_groups}) {
        push @groups,      { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
        push @view_groups, { NAME => $_->{'TITLE'}, VALUE => $_->{'ID'} };
    }

    for (@{$cats}) {
        push @cat_array,   { NAME => $_->{'CAT_NAME'}, VALUE => $_->{'CAT_ID'} };
    }
    
    my $size   = scalar (@groups) + 1;

    my $html  = $SKIN->title( TITLE => "Adding a Forum");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act   => 'forum',
                                        CODE  => 'do_add'
                                      } );

    $html .= $SKIN->td_select( TEXT     => 'Insert into which category?',
                               NAME     => 'CATEGORY',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => '',
                               DATA     => \@cat_array,
                             );

    $html .= $SKIN->td_select( TEXT     => 'Turn this Forum...',
                               NAME     => 'FORUM_STATUS',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'On'  },
                                             { VALUE => 0, NAME => 'Off (Read Only)' },
                                           ]
                             );

    $html .= $SKIN->section_header( TITLE => "Forum Name" );

    $html .= $SKIN->td_input (   TEXT => 'Forum Name'       , NAME => 'FORUM_NAME', VALUE=> '', REQ => 1 );

    $html .= $SKIN->td_textarea( TEXT => "Forum Description", NAME => 'FORUM_DESC', VALUE => '' );

    $html .= $SKIN->section_header( TITLE => "Forum Mask", TEXT => "These will OVERRIDE the base permissions for this category<br>&nbsp;&nbsp;&nbsp;&nbsp;Permissions for starting/replying to topics will only apply to those who's membergroup permissions allow.<br>&nbsp;&nbsp;&nbsp;&nbsp;ALL MEMBER GROUPS is relevant to all groups, current and any more you create" );

    $html .= $SKIN->td_select( TEXT     => 'Read Topics:',
                               NAME     => 'FORUM_READ_TOPICS',
                               SIZE     => $size,
                               MULTIPLE => 1,
                               VALUES   => '*',
                               DATA     => \@view_groups,
                             );

    $html .= $SKIN->td_select( TEXT     => 'Start Topics:',
                               NAME     => 'FORUM_START_TOPICS',
                               SIZE     => $size,
                               MULTIPLE => 1,
                               REQ      => 1,
                               VALUES   => '*',
                               DATA     => \@groups
                             );

    $html .= $SKIN->td_select( TEXT     => 'Reply to Topics:',
                               NAME     => 'FORUM_REPLY_TOPICS',
                               SIZE     => $size,
                               MULTIPLE => 1,
                               REQ      => 1,
                               VALUES   => '*',
                               DATA     => \@groups
                             );

    $html .= $SKIN->section_header( TITLE => "Protect Forum with Password?", TEXT => "This makes the forum visable to everyone, but requires a password to be entered<br>&nbsp;&nbsp;&nbsp;&nbsp;before reading, writing and viewing is allowed." );

    $html .= $SKIN->td_input ( TEXT     => 'Enter Password, or leave blank of you<br>&nbsp;&nbsp;&nbsp;&nbsp;do not wish to protect this forum', NAME => 'FORUM_PROTECT', VALUE=> '', REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Forum Permissions" );

    $html .= $SKIN->td_select( TEXT     => 'Allow HTML to be posted?',
                               NAME     => 'FORUM_HTML',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'On'  },
                                             { VALUE => 0, NAME => 'Off' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Allow iB CODE to be posted?',
                               NAME     => 'FORUM_IBC',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => 1,
                               DATA     => [ { VALUE => 1, NAME => 'On'  },
                                             { VALUE => 0, NAME => 'Off' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Allow members to attach files to posts?',
                               NAME     => 'ALLOW_ATTACH',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );

    $html .= $SKIN->td_select( TEXT     => 'Moderator Queue?<br>&nbsp;&nbsp;&nbsp;&nbsp;(Require moderator to validate topics/posts before they are displayed)',
                               NAME     => 'MODERATE',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => 0,
                               DATA     => [ { VALUE => 1, NAME => 'Yes'  },
                                             { VALUE => 0, NAME => 'No' },
                                           ]
                             );


    $html .= $SKIN->section_header( TITLE => "Base Sorting Options", TEXT => 'This can be overridden by the member' );
   

    $html .= $SKIN->td_select( TEXT     => "Default cut off date for topic display",
                               NAME     => 'PRUNE_DAYS',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{PRUNE_DAYS},
                               DATA     => [ { NAME => 'Today'       ,  VALUE => '1'   },
                                             { NAME => 'Last 5 Days' ,  VALUE => '5'   }, 
                                             { NAME => 'Last 7 Days' ,  VALUE => '7'   },
                                             { NAME => 'Last 10 Days',  VALUE => '10'  },
                                             { NAME => 'Last 15 Days',  VALUE => '15'  },
                                             { NAME => 'Last 20 Days',  VALUE => '20'  },
                                             { NAME => 'Last 25 Days',  VALUE => '25'  },
                                             { NAME => 'Last 30 Days',  VALUE => '30'  },
                                             { NAME => 'Last 60 Days',  VALUE => '60'  },
                                             { NAME => 'Last 90 Days',  VALUE => '90'  },
                                             { NAME => 'Show all'    ,  VALUE => '100' },
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Default sort key",
                               NAME     => 'SORT_KEY',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{SORT_KEY},
                               DATA     => [ { VALUE => 'TOPIC_LAST_DATE' ,  NAME => 'Date of the last post'     },
                                             { VALUE => 'TOPIC_TITLE'     ,  NAME => 'Topic Title'               }, 
                                             { VALUE => 'TOPIC_STARTER_N' ,  NAME => 'Topic Starters Name'       },
                                             { VALUE => 'TOPIC_POSTS'     ,  NAME => 'Topic Posts'               },
                                             { VALUE => 'TOPIC_VIEWS'     ,  NAME => 'Topic Posts'               },
                                             { VALUE => 'TOPIC_START_DATE',  NAME => 'Date the topic was started'},
                                             { VALUE => 'TOPIC_LASTP_N'   ,  NAME => 'Name of the last poster'   },
                                            ]
                             );

    $html .= $SKIN->td_select( TEXT     => "Default sort order",
                               NAME     => 'SORT_ORDER',
                               SIZE     => 1,
                               REQ      => 1,
                               VALUES   => $iB::INFO->{FORUM_SORT_ORDER},
                               DATA     => [ { VALUE => 'Z-A' ,  NAME => 'Descending (Z - A, 10 - 0)' },
                                             { VALUE => 'A-Z' ,  NAME => 'Ascending  (A - Z, 0 - 10)' }, 
                                           ]
                             );

    $html .= $SKIN->section_header( TITLE => "Choose a skin option for this forum" );

    $html .= $SKIN->td_select( TEXT     => 'Installed Skins',
                               NAME     => 'THE_SKIN',
                               VALUES   => $the_skin,
                               DATA     => \@editable,
                             );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Add forum' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => qq[<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=forum' target='BODY'>Forum Control</a>], NAV_TWO => "Adding a Forum", PRINT => $html);


}

sub do_add {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must enter a Forum Name") unless $iB::IN{'FORUM_NAME'};

    my $forums = $db->query( TABLE  => 'forum_info');

    my $forum = 0;

    for my $f (@{$forums}) {
        if ($f->{'FORUM_ID'} > $forum) {
            $forum = $f->{'FORUM_ID'};
        }
    }
    
    ++$forum; 

    $db->create_table( TABLE => 'forum_posts',
                       DBID  => 'f'.$forum,
                     );

    my ($view, $start, $reply);

    if (grep { /c/ } $iB::CGI->param('FORUM_READ_TOPICS')) {
        my $cat   = $db->select( TABLE => 'categories', KEY => $iB::IN{'CATEGORY'} );
        $view = $cat->{'VIEW'};
    } elsif
        (grep { /\*/ } $iB::CGI->param('FORUM_READ_TOPICS')) {
        $view = '*';
    } else {
        $view = join ",", $iB::CGI->param('FORUM_READ_TOPICS');
    }

    if ( grep { /\*/ } $iB::CGI->param('FORUM_START_TOPICS') ) {
        $start = '*';
    } else {
        $start = join ",", $iB::CGI->param('FORUM_START_TOPICS');
    }

    if ( grep { /\*/ } $iB::CGI->param('FORUM_REPLY_TOPICS') ) {
        $reply = '*';
    } else {
        $reply = join ",", $iB::CGI->param('FORUM_REPLY_TOPICS');
    }

    $iB::IN{'FORUM_NAME'} = $SKIN->htmlalize($iB::IN{'FORUM_NAME'});
    $iB::IN{'FORUM_DESC'} = $SKIN->htmlalize($iB::IN{'FORUM_DESC'});
  
    $db->insert( TABLE  => 'forum_info', 
                 VALUES => { FORUM_ID                => $forum,
                             FORUM_TOPICS            => 0,
                             FORUM_POSTS             => 0,
                             FORUM_LAST_POST         => undef,
                             FORUM_LAST_POSTER       => undef,
                             FORUM_LAST_POSTER_N     => undef,
                             FORUM_NAME              => $iB::IN{'FORUM_NAME'},
                             FORUM_DESC              => $iB::IN{'FORUM_DESC'},
                             FORUM_IBC               => $iB::IN{'FORUM_IBC'},
                             FORUM_POSITION          => $forum,
                             FORUM_HTML              => $iB::IN{'FORUM_HTML'},
                             FORUM_STATUS            => $iB::IN{'FORUM_STATUS'},
                             FORUM_START_THREADS     => $start,
                             FORUM_REPLY_THREADS     => $reply,
                             FORUM_VIEW_THREADS      => $view,
                             FORUM_PROTECT           => $iB::IN{'FORUM_PROTECT'},
                             CATEGORY                => $iB::IN{'CATEGORY'},
                             L_TOPIC_TITLE           => undef,
                             L_TOPIC_ID              => undef,
                             SORT_KEY                => $iB::IN{'SORT_KEY'},
                             SORT_ORDER              => $iB::IN{'SORT_ORDER'},
                             PRUNE_DAYS              => $iB::IN{'PRUNE_DAYS'},
                             ALLOW_ATTACH            => $iB::IN{'ALLOW_ATTACH'},
                             MODERATE                => $iB::IN{'MODERATE'},
                             SHOW_RULES              => undef,
                           }
              );

    $ADMIN->write_log( TITLE => 'Forum Added', EXTRA => "Forum ID: $forum");


    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};

    # Sort out the skins..

    if ($iB::IN{'THE_SKIN'} ne 'none') {

        my $OLD = Boardinfo->new();
        # Append w/new skin
        $OLD->{'FORUM_SKINS'} .= $forum.':'.$iB::IN{'THE_SKIN'}.'|&|';
        # Update the Boardinfo.pm file
        $ADMIN->make_module( FILE     => "Boardinfo.pm",
                             PKG_NAME => 'Boardinfo',
                             VALUES   => $OLD
                           );
    }


    $std->build_forumjump( DB     => $db,
                           CATS   => $obj->{'TOTAL_CATS'},
                           FORUMS => $obj->{'TOTAL_FORUMS'}
                         );

    $ADMIN->static_screen( URL   => "act=forum&CODE=view&f=$forum",
                           TITLE => "Forum Added",
                           TEXT  => "The changes were successful"
                         );
}


sub do_delete {
    my ($obj, $db) = @_;

    my @forums_to_delete = $iB::CGI->param('f');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Forums to delete, please try again") unless scalar @forums_to_delete > 0;

    my $forum_keys = join "+", @forums_to_delete;

    my $html  = $SKIN->title( TITLE => "Deleting Forums", TEXT => "WARNING: THIS ACTION CAN NOT BE UNDONE");
    $html    .= $SKIN->begin_table();
    $html    .= $SKIN->form_start();
    $html    .= $SKIN->hidden_fields( { act    => 'forum'    ,
                                        CODE   => 'fordel'   ,
                                        forums => $forum_keys
                                      } );

    $html .= $SKIN->section_header( TITLE => "Forums to delete:");

    for my $f (@forums_to_delete) {

        my $forum = $db->select( TABLE => 'forum_info',
                                 KEY   => $f,
                               );
        $html .= qq~
                <tr>
                <td bgcolor='#FFFFFF' width='40%' align='left'><font class='t'>Forum ID: $f</font></td>
                <td bgcolor='#FFFFFF' width='60%' align='left'><font class='t'>Forum Name: <b>$forum->{'FORUM_NAME'}</b></font></td>
                </tr>
                ~;
    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'DELETE THESE FORUMS' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => qq[<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=forum' target='BODY'>Forum Control</a>], NAV_TWO => "Deleting Forums", PRINT => $html);

}


sub really_I_mean_it_this_time {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Forums to delete, please try again") unless $iB::IN{'forums'};

    my (@tables, @forums);

    if ($iB::IN{'forums'} =~ m!\+!) {
        @forums = split (/\+/, $iB::IN{'forums'});
    } else {
        $forums[0] = $iB::IN{'forums'};
    }


    #XXX Here we go...
    #XXX Drop tables from "forum_posts", "forum_polls", "forum_poll_voters", "forum_subscriptions"

    for my $f (@forums) {
        push @tables, { TABLE => 'forum_posts'        , DBID => 'f'.$f };
    }

    
    $db->drop_tables( TABLES => \@tables );


    for my $f (@forums) {

        #XXX Remove information from the moderators table

        $db->delete( TABLE => 'forum_moderators',
                     WHERE => "FORUM_ID == $f",
                   );

        #XXX Remove information from the forum rules table

        $db->delete( TABLE => 'forum_rules',
                     KEY   => $f,
                   );

        #XXX Remove information from the forum topics table

        $db->delete( TABLE => 'forum_topics',
                     ID    => $f,
                     WHERE => "FORUM_ID == $f",
                   );

        #XXX Remove information from the forum info table

        $db->delete( TABLE => 'forum_info',
                     KEY   => $f,
                   );
    }

    # Adjust the skins..
    my $final_skins;
    if ($INFO->{'FORUM_SKINS'}) {
        my $OLD = Boardinfo->new();
        for my $sk ( split /\|\&\|/, $INFO->{'FORUM_SKINS'} ) {
            my ($forum_id, $skin_name) = split /\:/, $sk;
            unless ( grep { $forum_id == $_ } @forums) {
                $final_skins .= $forum_id.':'.$skin_name.'|&|';
            }
        }
        # Update the Boardinfo.pm file
        $OLD->{'FORUM_SKINS'} = $final_skins;
        $ADMIN->make_module( FILE     => "Boardinfo.pm",
                             PKG_NAME => 'Boardinfo',
                             VALUES   => $OLD
                           );
    }

    #XXX DONE!


    $ADMIN->write_log( TITLE => 'Forums Delete', EXTRA => "Forum IDs: @forums");


    $obj->{'TOTAL_CATS'}   = $db->query(TABLE     => 'categories',
                                        SORT_KEY  => 'CAT_POS',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL',
                                      ) || die $db->{'error'};

    $obj->{'TOTAL_FORUMS'} = $db->query(TABLE     => 'forum_info',
                                        SORT_KEY  => 'FORUM_POSITION',
                                        SORT_BY   => 'A-Z',
                                        MATCH     => 'ALL'
                                      ) || die $db->{'error'};


    $std->build_forumjump( DB     => $db,
                           CATS   => $obj->{'TOTAL_CATS'},
                           FORUMS => $obj->{'TOTAL_FORUMS'}
                         );

    $ADMIN->static_screen( URL   => "act=forum",
                           TITLE => "Forums Deleted",
                           TEXT  => "The changes were successful"
                         );
}


sub edit_rules {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'no_forum') unless defined $iB::IN{'f'};

    my $forum = $db->select( TABLE     => 'forum_info',
                             KEY       => $iB::IN{'f'},
                           );

    my $rules = $db->select( TABLE     => 'forum_rules',
                             KEY       => $iB::IN{'f'},
                           );

    $ADMIN->Error( DB => $db, STD => $std, MSG=>'no_forum') unless defined $forum->{'FORUM_ID'};


    my $html  = $SKIN->title( TITLE => "Forum Rules: $forum->{'FORUM_NAME'}", TEXT => 'You may edit the following board rules. iB Code, HTML and emoticons are allowed' );
    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( { act   => 'forum',
                                     f     => $forum->{'FORUM_ID'},
                                     CODE  => 'doedit_rules',
                                     SHOW_ALL => 0,
                                    } );

    $html .= $SKIN->td_select( TEXT     => 'Show Link to Forum Rules?',
                               NAME     => 'SHOW_RULES',
                               SIZE     => '',
                               REQ      => 1,
                               VALUES   => $forum->{'SHOW_RULES'},
                               DATA     => [ { VALUE => 2, NAME => 'Yes, show a link'  },
                                             { VALUE => 1, NAME => 'No, display the text above the topic list' },
                                             { VALUE => 0, NAME => 'Turn off (dont show either)' },
                                           ]
                             );


    $html .= $SKIN->section_header( TITLE => "Forum Rules Title" );

    $html .= $SKIN->td_input (   TEXT => 'Rules Title'      , NAME => 'RULES_TITLE', VALUE=> $rules->{'RULES_TITLE'}, REQ => 1 );

    $html .= $SKIN->section_header( TITLE => "Forum Rules Text" );

    $html .= $SKIN->td_textarea( TEXT => "Rules Text", NAME => 'RULES_TEXT', VALUE => $rules->{'RULES_TEXT'} );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply Changes' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    $ADMIN->Output( WHERE => 'FORUMS', NAV_ONE => qq[<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=forum' target='BODY'>Forum Control</a>], NAV_TWO => "Editing Rules for $forum->{'FORUM_NAME'}", PRINT => $html);


}


sub doedit_rules {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "No Forum ID selected, please try again") unless defined $iB::IN{'f'};

    $db->update( TABLE  => 'forum_info',
                 KEY    => $iB::IN{'f'},
                 VALUES => {  SHOW_RULES => $iB::IN{'SHOW_RULES'} }
              ) || $ADMIN->Error( DB => $db, STD => $std, MSG => $db->{'error'} );


    my $rules = $db->select( TABLE  => 'forum_rules',
                             KEY    => $iB::IN{'f'}
                           );

    if ($rules->{'RULES_TITLE'} && $rules->{'RULES_TEXT'} && defined $rules->{'ID'}) {
    
        $db->update( TABLE  => 'forum_rules',
                     KEY    => $iB::IN{'f'},
                     VALUES => { RULES_TITLE  => $iB::IN{'RULES_TITLE'},
                                 RULES_TEXT   => $iB::CGI->param('RULES_TEXT'),
                                 LAST_UPDATE  => time,
                                 SHOW_ALL     => $iB::IN{'SHOW_ALL'}
                               }
                   );

    } else {

        $db->insert( TABLE  => 'forum_rules',
                     VALUES => { ID           => $iB::IN{'f'},
                                 RULES_TITLE  => $iB::IN{'RULES_TITLE'},
                                 RULES_TEXT   => $iB::CGI->param('RULES_TEXT'),
                                 LAST_UPDATE  => time,
                                 SHOW_ALL     => $iB::IN{'SHOW_ALL'}
                               }
                   );
    }


    $ADMIN->write_log( TITLE => 'Forum Rules Changed', EXTRA => "Forum ID: $iB::IN{'f'}");


    $ADMIN->static_screen( URL   => "act=forum&CODE=list_rules&f=$iB::IN{'f'}",
                           TITLE => "Forum Rule changes applied",
                           TEXT  => "The changes were successful"
                         );
}







sub process {
    my ($obj, $db) = @_;

    my %Mode = ( 'view'      => \&do_view,
                 'edit'      => \&do_edit,
                 'add'       => \&add,
                 'do_add'    => \&do_add,

                 'del'       => \&delete,
                 'dodel'     => \&do_delete,
                 'fordel'    => \&really_I_mean_it_this_time,

                 'count'     => \&recount,
                 'dorecount' => \&dorecount,

                 'reorder'   => \&reorder,
                 'doreorder' => \&doreorder,

                 'list_rules'   => \&list_rules,
                 'edit_rules'   => \&edit_rules,
                 'doedit_rules' => \&doedit_rules,

               );

    $Mode{$iB::IN{'CODE'}} ? $Mode{$iB::IN{'CODE'}}->($obj,$db) : splash($obj,$db);
} 




1;
__END__
