package Admin::EmoticonControl;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;



    my $html  = $SKIN->title( TITLE => 'Emoticon Control');

    $html .= qq~<script language='JavaScript'>
                <!--
                function PopUp(url, name, width,height,center,resize,scroll,posleft,postop) {
                    if (posleft != 0) { x = posleft }
                    if (postop  != 0) { y = postop  }
                
                    if (!scroll) { scroll = 1 }
                    if (!resize) { resize = 1 }
                
                    if ((parseInt (navigator.appVersion) >= 4 ) && (center)) {
                      X = (screen.width  - width ) / 2;
                      Y = (screen.height - height) / 2;
                    }
                    if (scroll != 0) { scroll = 1 }
                
                    var Win = window.open( url, name, 'width='+width+',height='+height+',top='+Y+',left='+X+',resizable='+resize+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no');
                }
                //-->
                </script>
                ~;


       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'emoticon',
                                        CODE  => 'edit'
                                      } );

    #+-----------------------------------
    $html .= $SKIN->section_header( TITLE => "Please Edit the emoticons below",TEXT=> qq~Or leave both fields blank to remove<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:PopUp('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&AD=1&act=emoticon&CODE=viewall','HelpCard','200','400','0','1','1','1')">View All Emoticons</a>~ );
    $html .= qq~
    <tr>
    <td bgcolor='#EEEEEE' width='40%' align='left' valign='top'><font class='t'><b>Text</b></font></td>
    <td bgcolor='#EEEEEE' width='60%' align='left'><font class='t'><b>Insert into Clickable Table?      ::      Converted To</b></font></td>
    </tr>
    ~;

    my $cnt = 0;
    for my $e (split (/\|&\|/,$INFO->{'EMOTICONS'}) ) {
        my ($type, $image, $p_inc) = split (/\|/,$e);
        next unless $type and $image;

        my $click = "<select name='INC_$cnt' class='forminput' style='width:60px'>";
        $click .= $p_inc
                ? "<option value='1' selected>Yes</option><option value='0'>No</option>"
                : "<option value='1'>Yes</option><option value='0' selected>No</option>";

        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' width='40%' align='left'><input type='text' name="TEXT_$cnt" value='$type' class='forminput'></td>
            <td bgcolor='#FFFFFF' width='60%' align='left' valign='middle' nowrap>$click</select>&nbsp;&nbsp;<input type='text' name='IMG_$cnt' value='$image' class='forminput' style='width:350px'>&nbsp;&nbsp<img src="$iB::INFO->{'EMOTICONS_URL'}/$image" border="0" valign="absmiddle"></td>
            </tr>
        ~;
        $cnt++;

    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply these changes' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Emoticon Control', PRINT => $html);

}


sub doedit {
    my ($obj, $db) = @_;
    my $smilies;

    my $OLD = Boardinfo->new();

    my @emo_in = grep { /^TEXT_(\d+)$/ } $iB::CGI->param();

    for my $e (@emo_in) {
        $e    =~ m#^TEXT_(\d+)$#;
        my $n = $1;
        next unless defined $iB::IN{'TEXT_'.$n} and defined $iB::IN{'IMG_'.$n};
        $iB::IN{'INC_'.$n} ||= 0;
        $smilies .= $iB::IN{'TEXT_'.$n}.'|'.$iB::IN{'IMG_'.$n}.'|'.$iB::IN{'INC_'.$n}.'|&|';
    }

    $OLD->{'EMOTICONS'} = $smilies;

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $ADMIN->write_log( TITLE => 'Emoticons Changed');

    $ADMIN->static_screen( URL   => "act=emoticon",
                           TITLE => "Emoticons edited",
                           TEXT  => "The changes were successful"
                         );
}



##########################################################################################
#
# ADDING EMOTICONS
#
##########################################################################################



sub add {
    my ($obj, $db) = @_;


    my $html  = $SKIN->title( TITLE => 'Emoticon Control');
    $html .= qq~<script language='JavaScript'>
                <!--
                function PopUp(url, name, width,height,center,resize,scroll,posleft,postop) {
                    if (posleft != 0) { x = posleft }
                    if (postop  != 0) { y = postop  }
                
                    if (!scroll) { scroll = 1 }
                    if (!resize) { resize = 1 }
                
                    if ((parseInt (navigator.appVersion) >= 4 ) && (center)) {
                      X = (screen.width  - width ) / 2;
                      Y = (screen.height - height) / 2;
                    }
                    if (scroll != 0) { scroll = 1 }
                
                    var Win = window.open( url, name, 'width='+width+',height='+height+',top='+Y+',left='+X+',resizable='+resize+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no');
                }
                //-->
                </script>
                ~;
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'emoticon',
                                        CODE  => 'doadd'
                                      } );

    #+-----------------------------------

    $html .= $SKIN->section_header( TITLE => "Current Emoticons");

    my $all_emoticons = " ";
    for my $e (split (/\|&\|/,$INFO->{'EMOTICONS'}) ) {
        my ($type, $image, $p_inc) = split (/\|/,$e);
        next unless $type and $image;
        $all_emoticons .= qq![ $type &nbsp; <img src="$iB::INFO->{'EMOTICONS_URL'}/$image" border="0" valign="absmiddle"> ] !;
    }

    $html .= qq~
        <tr>
        <td bgcolor='#FFFFFF' colspan='2' align='middle'><font class='t'>$all_emoticons</font></td>
        </tr>
    ~;

    $html .= $SKIN->section_header( TITLE => "Please use the spaces to below to add emoticons",TEXT=> qq~You do not have to use all the fields.<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:PopUp('$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?s=$iB::SESSION&AD=1&act=emoticon&CODE=viewall','HelpCard','200','400','0','1','1','1')">View All Emoticons</a>~);

    $html .= qq~
    <tr>
    <td bgcolor='#EEEEEE' width='40%' align='left' valign='top'><font class='t'><b>Text</b></font></td>
    <td bgcolor='#EEEEEE' width='60%' align='left'><font class='t'><b>Insert into Clickable Table?      ::      Converted To</b></font></td>
    </tr>
    ~;

    foreach my $cnt (0 .. 10) {
        $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' width='40%' align='left'><input type='text' name="TEXT_$cnt" class='forminput'></td>
            <td bgcolor='#FFFFFF' width='60%' align='left' valign='middle' nowrap><select name='INC_$cnt' class='forminput' style='width:60px'><option value='1' selected>Yes</option><option value='0'>No</option></select>&nbsp;&nbsp;<input type='text' name='IMG_$cnt' class='forminput' style='width:350px'></td>
            </tr>
        ~;
        $cnt++;
    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Apply these Emoticons' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Emoticon Control', PRINT => $html);

}

sub viewall {
    my ($obj, $db) = @_;
    
    # View all smilies in the emoticons directory

    opendir BAGPUSS, $iB::INFO->{'HTML_DIR'} . 'emoticons' or die $!;
    my @stuffed_cat = grep  {    !/^\./  && !/\.html$/  } readdir BAGPUSS;
    closedir BAGPUSS;

    my $html  = qq~<html><head><title>All Emoticons</title></head>
                   <body>
                   <table cellspacing='1' cellpadding='5' border='1' style='border:1px solid black'>
                   <tr>
                    <td bgcolor='#666699' class='t' width='20%'><span style='color:white'>Image</span></td>
                    <td bgcolor='#666699' class='t' width='80%'><span style='color:white'>Filename</span></td>
                   </tr>
                 ~;                 

    for my $e (@stuffed_cat) {
        $html .= qq~<tr>
                    <td bgcolor='#FFFFFF' class='t' width='20%'><img src="$iB::INFO->{'EMOTICONS_URL'}/$e" border="0" valign="middle" alt=''></td>
                    <td bgcolor='#FFFFFF' class='t' width='80%'><input type='text' name='blah' value='$e' onMouseOver="this.focus()" onFocus="this.select()"></td>
                   </tr>
                 ~;
    }
       $html .= qq~</table>~;
       $ADMIN->Print( DB     => $db,
                      STD    => $std,
                      OUTPUT => $html,
                    );
}




sub doadd {
    my ($obj, $db) = @_;

    my $smilies;

    my $OLD = Boardinfo->new();

    my @emo_in = grep { /^TEXT_(\d+)$/ } $iB::CGI->param();

    for my $e (@emo_in) {
        $e    =~ m#^TEXT_(\d+)$#;
        my $n = $1;
        next unless defined $iB::IN{'TEXT_'.$n} and defined $iB::IN{'IMG_'.$n};
        $iB::IN{'INC_'.$n} ||= 0;
        $smilies .= $iB::IN{'TEXT_'.$n}.'|'.$iB::IN{'IMG_'.$n}.'|'.$iB::IN{'INC_'.$n}.'|&|';
    }

    $OLD->{'EMOTICONS'} .= $smilies;

    $ADMIN->make_module( FILE     => "Boardinfo.pm",
                         PKG_NAME => 'Boardinfo',
                         VALUES   => $OLD
                       );

    $ADMIN->write_log( TITLE => 'Emoticons Added');

    $ADMIN->static_screen( URL   => "act=emoticon",
                           TITLE => "Emoticons Add",
                           TEXT  => "The changes were successful"
                         );
}



sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'        => \&doedit,
                 'add'         => \&add,
                 'doadd'       => \&doadd,
                 'viewall'     => \&viewall,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 





1;
