package Admin::DBMclient;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matt Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $mem   = FUNC::Member->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my ($pkg, $args)  = @_;
    my $obj = { 'base_url' => "$iB::INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=dbmclient" };
    bless $obj, $pkg;
    return $obj;
}

#+---------------------------------------------------------------------------------------------------------

sub splash {
    my ($obj, $db) = @_;

    my $html = qq~

     <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
       <tr>
         <td><font class='large'>&gt;&gt; Re-index the member accounts</font><br>
         <font class='t'>This tool can be used periodically to re-index the member_profiles database when using DBM as your database driver.
         <br><br>It is also recommended that you re-index your member profiles after importing into your DBM database to ensure that it's fully
         up to date and carries no "dead" information.
         <br><br>
         <b><a href='$obj->{base_url}&CODE=doindex'>Re-index the member profiles table now</a></b>
         </font>
    </td>
  </tr>
</table>
    ~;

    $ADMIN->Output( WHERE => 'OPTIONS', NAV_ONE => 'DBM client backend toolbox', PRINT => $html);


}






sub doindex {
    my ($obj, $db) = @_;
    
    require iDatabase::SQL;

    my $create = $iB::INFO->{DB_DRIVER} eq 'DBM' ? 1 : 0;
    my $drop   = $iB::INFO->{DB_DRIVER} eq 'DBM' ? 1 : 0;
    
    my $db    = iDatabase::SQL->new( DATABASE  => $iB::INFO->{'DB_NAME'},
                                     DB_DIR    => $iB::INFO->{'DB_DIR'},
                                     IP        => $iB::INFO->{'DB_IP'},
                                     PORT      => $iB::INFO->{'DB_PORT'},
                                     USERNAME  => $iB::INFO->{'DB_USER'},
                                     PASSWORD  => $iB::INFO->{'DB_PASS'},
                                     DB_PREFIX => $iB::INFO->{'DB_PREFIX'},
                                     DB_DRIVER => "DBM",
                                     ATTR      => { allow_create => $create,
                                                    allow_drop   => $drop,
                                                  },
                                   ); 

    my $count = 0;
    
    $db->drop_index(   TABLE      => 'member_profiles',
                       INDEX_KEY  => 'MEMBER_EMAIL',
                   );

    $db->drop_index(   TABLE      => 'member_profiles',
                       INDEX_KEY  => 'MEMBER_NAME',
                   );

    $db->create_index( TABLE       => 'member_profiles',
                       INDEX_KEY   => 'MEMBER_EMAIL',
                       FOREIGN_KEY => 'MEMBER_ID',
                     );

    $db->create_index( TABLE       => 'member_profiles',
                       INDEX_KEY   => 'MEMBER_NAME',
                       FOREIGN_KEY => 'MEMBER_ID',
                     );

    my $members = $db->query( TABLE => 'member_profiles');

    my @delete;

    for my $m (@{$members}) {
        $m->{'MEMBER_EMAIL'} = lc($m->{'MEMBER_EMAIL'});
        $db->update_index( TABLE      => 'member_profiles',
                           INDEX_KEY  => 'MEMBER_EMAIL',
                           R_KEY      => $m->{'MEMBER_EMAIL'},
                           R_VALUE    => $m->{'MEMBER_ID'},
                         );

        $db->update_index( TABLE      => 'member_profiles',
                           INDEX_KEY  => 'MEMBER_NAME',
                           R_KEY      => $m->{'MEMBER_NAME'},
                           R_VALUE    => $m->{'MEMBER_ID'},
                         );

        ++$count;
    }

    $ADMIN->static_screen( URL   => "",
                           TITLE => "$count members re-indexed",
                           TEXT  => "The re-indexing was successful"
                         );

}



##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 
                 'doindex'      => \&doindex,
               );

    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
}





1;
__END__









