package Admin::BoardTemplates;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}


##############################################################################
#
# NEW TEMPLATE
#
##############################################################################

sub splash {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Board Template Control');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'board',
                                        CODE  => 'add'
                                      } );

my $it = qq~   <html>
    <head>
      <title>
        
        <% TITLE %>

      </title>

      <% GENERATOR %>

      <% IB CSS %>

      <% IB JAVASCRIPT %>
      
    </head>

<body bgcolor='#FFFFFF' leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" alink='#000000' vlink='#000000'>

<% BOARD HEADER %>

<% MEMBER BAR %>
<% NAVIGATION %>

<% IKONBOARD %>

<% STATS %>

<% COPYRIGHT %>

</body>

</html>
~;



    #XXX We use the ASCII values, so people can use &gt;, &lt; without it being converted when read back

    $it =~ s!<!&#60;!g;
    $it =~ s!>!&#62;!g;

    $html .= qq~<script language='javascript1.2'>
                <!--
                function Preview() {
                    Template = new String(document.TheForm.TEMPLATE.value);
                    Template.replace(/&#60;/g, "<");
                    Template.replace(/&#62;/g, ">");
                    Template.replace(/<% TITLE %>/g, "Ikonboard 3 Preview");
                    Template.replace(/<% IKONBOARD %>/g, "<table height='300' align='center' border='1'><tr><td align='center' valign='middle'>Ikonboard will be displayed here</td></tr></table>");
                    var newWin = window.open( '', 'PREVIEW', 'width=500,height=500,top=0,left=0,resizable=1,scrollbars=1,location=no,directories=no,status=no,menubar=no,toolbar=no');
                    newWin.document.write(Template);
                }
                //-->
                </script>
               ~;


    $html .= $SKIN->section_header( TITLE => "Global Template", TEXT => "Please do not remove, or edit the &lt;% TAG %&gt; tags. You may rearrange, or move them" );

    $html .= $SKIN->td_textarea( TEXT  => "Template",
                                 NAME  => 'TEMPLATE',
                                 VALUE => $it,
                                 SPAN  => 1,
                                 ROWS  => 30
                                );

    $html .= qq~<tr>
                <td colspan='2' bgcolor='#FFFFFF' align='center'><input type='button' value='PREVIEW' onClick='javascript:Preview();'></td>
                </tr>
                ~;

    $html .= $SKIN->td_input ( TEXT => 'Template Name',            NAME => 'NAME', VALUE=> "" ,   REQ => 1 );

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Add this Template' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Board Template Control', PRINT => $html);

}

sub add {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "I can't save an empty template!") unless length($iB::IN{'TEMPLATE'}) > 1;
    $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must enter a template name!") unless length($iB::IN{'NAME'}) > 1;

    #XXX Grab the raw TEMPLATE param, so we know it's not been regexed to death by CleanValue

    my $template = $iB::CGI->param('TEMPLATE');
    
    #XXX Gimmie back my HTML

    $template =~ s!&#62;!>!g;
    $template =~ s!&#60;!<!g;

    #XXX No doubt someone will remove the <% IKONBOARD %> tag...
    #XXX Then post on the support board that their board has gone 'missing'.

    unless ($template =~ m#<% IKONBOARD %>#) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "You need the &lt;% IKONBOARD %&gt; tag!");
    }
    unless ($template =~ m#<% COPYRIGHT %>#) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "You need the &lt;% COPYRIGHT %&gt; tag!");
    }

    # First, lets assign a new ID for this template.
    # We get this number by counting the total number of templates.
    
    my $templates = $db->query( TABLE  => 'templates' );

    my $new_id = 1; # As we already have 'global' stored.

    for (@{$templates}) {
        next if $_->{'ID'} eq 'global';
        next if $_->{'ID'} eq 'register';
        if ($_->{'ID'} > $new_id) {
            $new_id = $_->{'ID'};
        }
    }

    # One for luck..
    ++$new_id;

    #XXX Here goes nothing...

    $db->insert( TABLE  => 'templates',
                 VALUES => { 
                             TEMPLATE => $template,
                             ID       => $new_id,
                             NAME     => $iB::IN{'NAME'},
                           }
               );

    #XXX Print log and finish off

    $ADMIN->static_screen( URL   => "act=board&CODE=edit&ID=$new_id",
                           TITLE => "New Board Template Edited",
                           TEXT  => "The changes were successful"
                         );
}

##############################################################################
#
# EDIT TEMPLATE
#
##############################################################################

sub edit {
    my ($obj, $db) = @_;

    my $html  = $SKIN->title( TITLE => 'Template Control');
       $html .= $SKIN->begin_table();
       $html .= $SKIN->form_start();
       $html .= $SKIN->hidden_fields( { act   => 'board',
                                        CODE  => 'do_edit'
                                      } );

    #+-----------------------------------

    # Get the templates

    my $templates = $db->query( TABLE  => 'templates' );
    my @rtemplates;

    for (@{$templates}) {
        next if $_->{'ID'} eq 'register';
        if ($_->{'ID'} eq 'global') {
            $_->{'NAME'} = 'Original Board Template';
        }
        push @rtemplates, { NAME => $_->{'NAME'}, VALUE => $_->{'ID'} };
    }

    $html .= $SKIN->section_header( TITLE => "Please Choose a Board Template to Edit" );

    $html .= $SKIN->td_select( TEXT     => 'Editable Templates',
                               NAME     => 'ID',
                               VALUES   => '',
                               DATA     => \@rtemplates,
                             );


    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Edit this Template' );


    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Board Template Control', PRINT => $html);

}



sub do_edit {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "No template chosen!") unless $iB::IN{'ID'};

    my $template = $db->select( TABLE => 'templates',
                                KEY   => $iB::IN{'ID'},
                              );

    my $it = $template->{'TEMPLATE'};

    #XXX We use the ASCII values, so people can use &gt;, &lt; without it being converted when read back

    $it =~ s!<!&#60;!g;
    $it =~ s!>!&#62;!g;

    my $html  = $SKIN->title( TITLE => 'Board Template Control');

    $html .= qq~<script language='Javascript1.2'>
                <!--
                function Preview() {
                    Template = new String(document.TheForm.TEMPLATE.value);
                    Template.replace(/&#60;/g, "<");
                    Template.replace(/&#62;/g, ">");
                    Template.replace(/<% TITLE %>/g, "Ikonboard 3 Preview");
                    Template.replace(/<% IKONBOARD %>/g, "<table height='300' align='center' border='1'><tr><td align='center' valign='middle'>Ikonboard will be displayed here</td></tr></table>");
                    var newWin = window.open( '', 'PREVIEW', 'width=500,height=500,top=0,left=0,resizable=1,scrollbars=1,location=no,directories=no,status=no,menubar=no,toolbar=no');
                    newWin.document.write(Template);
                }
                //-->
                </script>
               ~;




    $html .= $SKIN->begin_table();
    $html .= $SKIN->form_start();
    $html .= $SKIN->hidden_fields( { act   => 'board',
                                     CODE  => 'save_template',
                                     ID    => $iB::IN{'ID'},
                                   } );

    $html .= $SKIN->section_header( TITLE => "Editing Board Template", TEXT => "Please do not remove, or edit the &lt;% TAG %&gt; tags. You may rearrange, or move them" );

    $html .= $SKIN->td_textarea( TEXT  => "Template",
                                 NAME  => 'TEMPLATE',
                                 VALUE => $it,
                                 SPAN  => 1,
                                 ROWS  => 30
                                );

    $html .= qq~<tr>
                <td colspan='2' bgcolor='#FFFFFF' align='center'><input type='button' value='PREVIEW' onClick='javascript:Preview();'></td>
                </tr>
                ~;

    if ($template->{'ID'} ne 'global') {
            $html .= $SKIN->td_input ( TEXT => 'Template Name',  NAME => 'NAME', VALUE=> $template->{'NAME'} ,   REQ => 1 );
    }

    $html .= $SKIN->td_submit(   NAME => '', VALUE => 'Edit this Template' );

    $html .= $SKIN->form_end();
    $html .= $SKIN->end_table();

    #+-----------------------------------

    $ADMIN->Output( WHERE => 'STYLES', NAV_ONE => 'Editing Global Template', PRINT => $html);

}

sub save_template {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB=>,"", STD=>"", MSG => "I can't save an empty template!") unless length($iB::IN{'TEMPLATE'}) > 1;
    $ADMIN->Error( DB=>,"", STD=>"", MSG => "No template chosen!") unless $iB::IN{'ID'};

    unless ($iB::IN{'ID'} eq 'global') {
            $ADMIN->Error( DB=>,"", STD=>"", MSG => "You must enter a template name!") unless length($iB::IN{'NAME'}) > 1;
    }

    #XXX Grab the raw TEMPLATE param, so we know it's not been regexed to death by CleanValue

    my $template = $iB::CGI->param('TEMPLATE');
    
    #XXX Gimmie back my HTML

    $template =~ s!&#62;!>!g;
    $template =~ s!&#60;!<!g;

    #XXX No doubt someone will remove the <% IKONBOARD %> tag...
    #XXX Then post on the support board that their board has gone 'missing'.

    unless ($template =~ m#<% IKONBOARD %>#) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "You need the &lt;% IKONBOARD %&gt; tag!");
    }
    unless ($template =~ m#<% COPYRIGHT %>#) {
        $ADMIN->Error( DB=>,"", STD=>"", MSG => "You need the &lt;% COPYRIGHT %&gt; tag!");
    }

    #XXX Here goes nothing...

    my $name = $iB::IN{'ID'} eq 'global' ? 'Original Board Template' : $iB::IN{'NAME'};

    $db->update( TABLE  => 'templates',
                 KEY    => $iB::IN{'ID'},
                 VALUES => { TEMPLATE => $template, NAME => $name }
               );

    #XXX Print log and finish off

    $ADMIN->write_log( TITLE => 'Global Template Edited');

    $ADMIN->static_screen( URL   => "act=board&CODE=edit",
                           TITLE => "Global Template Edited",
                           TEXT  => "The changes were successful"
                         );
}



##########################################################################################
#
# Process Sub
#
##########################################################################################


sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'edit'          => \&edit,
                 'do_edit'       => \&do_edit,
                 'save_template' => \&save_template,
                 'add'           => \&add,
               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
