package Admin::Adminlogs;
use strict;
#################################################################################
# Ikonboard v3 by Jarvis Entertainment Group, Inc.
#
# No part of this script can be used outside Ikonboard without prior consent.
#
# More information available from <ib-license@jarvisgroup.net>
# (c)2001 Jarvis Entertainment Group, Inc.
# 
# http://www.ikonboard.com | http://www.jarvisgroup.net
#
# Please read the license for more information
#
# 
# Script Author: Matthew Mecham <matt@ikonboard.com>
#
#################################################################################

BEGIN {
    require 'Lib/FUNC.pm';
    require 'Lib/ADMIN.pm';
    require 'Admin/SKIN.pm';
    require 'Boardinfo.pm' or die "Cannot load Module: $!";
}

my $SKIN  = Admin::SKIN->new();
my $std   = FUNC::STD->new();
my $ADMIN = FUNC::ADMIN->new();
my $INFO  = Boardinfo->new();

sub new {
    my $pkg = shift;
    my $obj = {};
    bless $obj, $pkg;
    return $obj;
}

sub splash {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'READ_AD_LOGS'};

    $obj->print_list( CODE   => 'view',
                      BUTTON => 'View Log Entry',
                      TYPE   => 'radio',
                      TEXT   => 'Please choose an administration log to view',
                      DB     => $db
                    );
}


sub delete {
    my ($obj, $db) = @_;
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'READ_AD_LOGS'};
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'DELETE_AD_LOGS'};
    $obj->print_list( CODE   => 'dodel',
                      BUTTON => 'Delete Selected Logs',
                      TYPE   => 'checkbox',
                      TEXT   => 'Choose which logs you wish to delete',
                      DB     => $db
                    );
}

sub print_list {
    my $obj = shift;

    my %IN = ( CODE    => "",
               BUTTON  => "",
               TYPE    => "",
               TEXT    => "",
               DB      => "",
               @_,
              );

    my $db = $IN{'DB'};

    # Get the admin logs

    my $logs = $db->query( TABLE    => 'moderator_logs',
                           SORT_KEY => 'TIME',
                           SORT_BY  => 'Z-A',
                         );

    # Get the forums..

    my $forums = $db->query( TABLE  => 'forum_info' );

    my %forum_data = map { $_->{'FORUM_ID'} => { FORUM_NAME => $_->{'FORUM_NAME'} } } @{$forums};

    my $nbsp = '&nbsp;';

    if ($IN{CODE} eq 'dodel') {
        $nbsp = qq~<input name="allbox" type="checkbox" value="Check All" onClick="CheckAll();">~;
    }

    my $html = qq~
    <script language='JavaScript'>
    <!--

    function CheckAll(cb) {
        var fmobj = document.theform;
        for (var i=0;i<fmobj.elements.length;i++) {
            var e = fmobj.elements[i];
            if ((e.name != 'allbox') && (e.type=='checkbox') && (!e.disabled)) {
                e.checked = fmobj.allbox.checked;
            }
        }
    }
    function CheckCheckAll(cb) {	
        var fmobj = document.theform;
        var TotalBoxes = 0;
        var TotalOn = 0;
        for (var i=0;i<fmobj.elements.length;i++) {
            var e = fmobj.elements[i];
            if ((e.name != 'allbox') && (e.type=='checkbox')) {
                TotalBoxes++;
                if (e.checked) {
                    TotalOn++;
                }
            }
        }
        if (TotalBoxes==TotalOn) {fmobj.allbox.checked=true;}
        else {fmobj.allbox.checked=false;}
    }
    //-->
    </script>

    <table cellspacing='0' cellpadding='5' border='0' width='100%' border='0'>
    <tr>
    <td>
    <font class='large'>&gt;&gt; Admin Logs</font><br>
    <font class='t'>&nbsp;&nbsp;$IN{'TEXT'}</font>
    
    <form action='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&CODE=view' method='post' name='theform'>
    <input type='hidden' name='AD' value='1'>
    <input type='hidden' name='act' value='logs'>
    <input type='hidden' name='s' value='$iB::SESSION'>
    <input type='hidden' name='CODE' value='$IN{'CODE'}'>

    <table cellspacing='1' cellpadding='0' width='100%' align='center' border='0' bgcolor='#333366'>
        <tr>
            <td>
            <table cellspacing='1' cellpadding='2' width='100%' align='center' border='0'>
            <tr>
            <td bgcolor='#8888AA' width='5%' align='center'>$nbsp</td>
            <td bgcolor='#8888AA' width='45%'><font class='t' style='color:white'><b>Time of Entry</b></font></td>
            <td bgcolor='#8888AA' width='50%'><font class='t' style='color:white'><b>Description</b></font></td>
            </tr>
    ~;


    for my $log (@{$logs}) {

            my $date = $std->get_date( TIME => $log->{'TIME'}, METHOD => 'LONG');

            $html .= qq~
            <tr>
            <td bgcolor='#FFFFFF' align='center'><input type='$IN{'TYPE'}' name='ID' value="$log->{'ID'}" style='border:none'></td>
            <td bgcolor='#FFFFFF'><font class='t'>$date</font></td>
            <td bgcolor='#FFFFFF'><font class='t'>$log->{'MEMBER_NAME'} $log->{'ACTION'} in forum $forum_data{ $log->{'FORUM_ID'} }->{'FORUM_NAME'}</font></td>
            </tr>
            ~;
        
      
    }

   
    $html .= qq~
            
            <tr>
            <td colspan='3' align='center' bgcolor='#FFFFFF'><br><input type='submit' value='$IN{'BUTTON'}'></td>
            </tr>
            </table>
         </td>
        </tr>
      </table>
     </form>
    </td>
    </tr>
    </table>
    ~;


    $ADMIN->Output( WHERE => 'MAINTAIN', NAV_ONE => 'Administration Logging Control', PRINT => $html);

}

sub view {
    my ($obj, $db) = @_;

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'READ_AD_LOGS'};
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must choose a valid Log ID to view")     unless $iB::IN{'ID'};

    # Get the log entry..

    my $log_entry = $db->select( TABLE => 'moderator_logs',
                                 KEY   => $iB::IN{'ID'},
                               );

    # Get the forum info..
    my $forum = $db->select( TABLE  => 'forum_info',
                             KEY    => $log_entry->{'FORUM_ID'},
                           );

    my $date = $std->get_date( TIME => $log_entry->{'TIME'}, METHOD => 'LONG' );

    my $html  = $SKIN->title( TITLE => 'Viewing administration logs' );
       $html .= $SKIN->begin_table();

    $html .= $SKIN->section_header( TITLE => "Log entry for <b>$date</b>" );

    $html .= qq~<tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Date</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t'>$date</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Member Name</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t' style='color:red'>$log_entry->{'MEMBER_NAME'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Action Taken</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t' style='color:red'>$log_entry->{'ACTION'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Member ID</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t'>$log_entry->{'MEMBER_ID'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Forum Name</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t' style='color:red'>$forum->{'FORUM_NAME'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Topic ID</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t'>$log_entry->{'TOPIC_ID'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Topic Title</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t' style='color:red'>$log_entry->{'TOPIC_TITLE'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>IP Address</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t'>$log_entry->{'REMOTE_ADDR'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Referrer</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t'>$log_entry->{'HTTP_REFERER'}</font></td>
                </tr>
                <tr>
                 <td bgcolor='#FFFFFF' width='40%'><font class='t'><b>Query string</b></font></td>
                 <td bgcolor='#FFFFFF' width='60%'><font class='t'>$log_entry->{'QUERY_STRING'}</font></td>
                </tr>
                ~;
    $html .= $SKIN->end_table();
    

    $ADMIN->Output( WHERE => 'MAINTAIN', NAV_ONE => qq[<a href='$INFO->{'BOARD_URL'}/ikonboard.$iB::INFO->{'CGI_EXT'}?AD=1&s=$iB::SESSION&act=logs' target='BODY'>Administration Logging Control</a>], NAV_TWO => "Viewing Log", PRINT => $html);

}



sub do_delete {
    my ($obj, $db) = @_;
    $ADMIN->Error( DB => $db, STD => $std, MSG => "You do not have permission for this action") unless $iB::MEMBER_GROUP->{'DELETE_AD_LOGS'};

    my $done = 0;

    my @to_delete = $iB::CGI->param('ID');

    $ADMIN->Error( DB => $db, STD => $std, MSG => "You must choose a valid Log ID to delete") unless scalar (@to_delete) > 0;

    $db->delete( TABLE => 'moderator_logs',
                 KEY   => \@to_delete,
               );

    $done = scalar (@to_delete);

    $ADMIN->static_screen( URL   => "act=logs",
                           TITLE => "Administration Logs Deleted",
                           TEXT  => "The changes were successful<br><br>$done files removed"
                         );

}





sub process {
    my ($obj, $db) = @_;

    my $CodeNo = $iB::IN{'CODE'};

    my %Mode = ( 'del'        => \&delete,
                 'view'       => \&view,
                 'dodel'      => \&do_delete,


               );
    $Mode{$CodeNo} ? $Mode{$CodeNo}->($obj,$db) : splash($obj,$db);
} 






sub DESTROY { }


1;
__END__
