#!/usr/local/bin/perl

#bnbform.cgi
#(c)1997 BigNoseBird.Com
#No warranties, etc.. Gratis for your learning and another
#experience you might need it for!


############## SPECIAL FORM VARIABLES ############################
#required:    comma delimited list of required entry fields
#data_order:  comma delimited list indicating what fields to actually
#             print and in what order.
#outputfile:  the name of the file to save the data in if using a file
#ok_url:      URL to go to if successful
#not_ok_url   URL to go to if unsuccessful
#submit_to:   email address of person to input receive data by mail
#submit_by:   email address of person completing form
#autorespond: if yes, then send confirmation to submitter
#automessage: text to print for autoconfirmation e-mail
#form_id:     name of form for e-mail subject
##################################################################


## MAIN ##########################################################

#This indicates the sendmail program. Should be okay for almost
#all unix systems.
$mail_program="/usr/lib/sendmail -t";
#

   &decode_vars;
   &valid_data;
   &write_data;
   if ($fields{'autorespond'} eq "yes")
    { &answer_back; }

   if ($fields{'ok_url'} ne "")
    { print "Location:$fields{'ok_url'}\n\n"; }
     else { &thank_you; }

##################################################################
sub write_data
{
   $the_date=localtime();
   if ($fields{'submit_to'} ne "")
    {
     &open_mail;
     print MAIL "To: $fields{'submit_to'}\n";
     print MAIL "From: $fields{'submit_by'}\n";
     print MAIL "Subject: $fields{'form_id'} RESPONSE\n";
     print MAIL "On $the_date,\n";
     print MAIL "The following information was submitted:\n";
    }
   if ($fields{'outputfile'} ne "")
    { open(OUT_FILE,">>$fields{'outputfile'}"); }
   foreach $to_print (@sortlist)
    {
      if ($fields{'outputfile'} ne "")
       { print OUT_FILE "$fields{$to_print}\|"; }
      if ($fields{'submit_to'} ne "")
       { print MAIL "$to_print = $fields{$to_print}\n"; }
    }
   if ($fields{'outputfile'} ne "")
    {
     print OUT_FILE "$the_date\|\n";
     close(OUT_FILE);
    }
   if ($fields{'submit_to'} ne "")
    { &close_mail; }
}

##################################################################
sub decode_vars
 {
  $i=0;
  read(STDIN,$temp,$ENV{'CONTENT_LENGTH'});
  @pairs=split(/&/,$temp);
  foreach $item(@pairs)
   {
    ($key,$content)=split(/=/,$item,2);
    $content=~tr/+/ /;
    $content=~s/%(..)/pack("c",hex($1))/ge;
    $content=~s/\012//gs;
    $content=~s/\015/ /gs;
    $fields{$key}=$content;
    if ($key eq "data_order")
      {
       $content=~s/ //gs;
       @sortlist=split(/,/,$content);
      }
    if ($key eq "required")
      {
       $content=~s/ //gs;
       @mandatory=split(/,/,$content);
      }
   }
}

##################################################################
sub valid_data
  {
   if ($fields{'data_order'} eq "")    #make sure we have work to do!
    {
      print "Content-type: text/html\n\n"; 
      print <<__W1__;

      <H1>NO data_order list SPECIFIED!</H1>

__W1__
      exit;
    }

   foreach $to_check (@mandatory) #test all required fields, bail on 1st bad
    {                             
      if ($fields{$to_check} eq "")
        {
          if ($fields{'not_ok_url'} ne "")
            { 
              print "Location:$fields{'not_ok_url'}\n\n";
            }
             else
              {
                &try_again;
              }
         }
    }

  }

##################################################################
sub thank_you
  {
      print "Content-type: text/html\n\n"; 
      print <<__W2__;

      <H1>Thank you!</H1>
      Your information has been sent and I will be in touch
      with you soon.

__W2__
      exit;
  }

##################################################################
sub try_again
  {
      print "Content-type: text/html\n\n"; 
      print <<__W3__;

      <H1>Missing Data!</H1>
      <B>Please press the back button and fill in
      all required fields!<P></B>

__W3__
      exit;
  }

##################################################################
sub open_mail
 {
       open (MAIL, "|$mail_program")
 }

##################################################################
sub close_mail
 {
  close(MAIL);
 }

##################################################################
sub answer_back
 {
  &open_mail;
  print MAIL "To: $fields{'submit_by'}\n";
  print MAIL "From: $fields{'submit_to'}\n";
  print MAIL "Subject: Thank you\n";
  if ($fields{'automessage'} ne "")
   {
    open (AM,$fields{'automessage'});
    while (<AM>)
     {
      chop $_;
      print MAIL "$_\n";
     } 
    close(AM);
   }
    else
    {
      print <<__W4__;

Thank you for your submission. I will be
MAIL "getting in touch with you soon.

__W4__
    }
  &close_mail;
 }

##################################################################
