#!/bin/perl

# WWWyear
#   - a WWW-log analyzing CGI-script (year report)
#
# See shared.pl for version information.
#
# Lars M. Garshol - larsga@ifi.uio.no - http://www.ifi.uio.no/~larsga/

# This program is freeware. Please let me know if you modify the code,
# and not just the configuration. 

# The GIF bars were stolen from http://weber.u.washington.edu/~reflux/

require "cgi.pl";
require "shared.pl";
require $VAR{"config"};

# ---------- Initialization     ------------------------

&InitDate; # $mon.$year is this month
                    
# Checking to see whether the user asked for a particular year

if ($VAR{"year"} ne "") {
    $year =$VAR{"year"};
}

# ---------- The program itself ------------------------

if (!$Redirect) { &printCType("text/html"); }

open(INN,$LogFile) ||
  error("Couldn't open logfile $LogFile: $!");

&PrintPageTop("Year access report $ForString");

$max=1; # To avoid division by zero errors if the log file is empty

while (<INN>)
{	
  if (!/\S/) { next; }          	#Bare whitespace: hopp over

  @felter=split(/ /,$_);      

  #Sjekk om vi skal ta med denne linjen
  if ($felter[5] eq '"HEAD')        { next; }
  if ($felter[8] != 200)            { next; }   # Hvis HTTP-kode ikke 200
  if (&SkipHost($felter[0]))        { next; }
  if (&SkipPage($felter[6]))        { next; }

  #Check that this is the right year
  @klokkeslett=split(/\//,$felter[3]);     #Dag/MM/AA:Time:Min:Sek
  if ($year!=$klokkeslett[2]) { next; }

  #Clean up the URL
  $_ = $felter[6]; 
  s/%7E/~/; 
  s/%7e/~/;
  s/\/$DefaultFile\Z/\//;
  $felter[6] = $_;

  $TotalHits += 1;
  $TotalByte += $felter[9];

  $MonthNo=$MonthNos{$klokkeslett[1]}; # Look up month number. Speed up this?
  $PageInMonth{$felter[6]}[$MonthNo]++;
  $PageTotal{$felter[6]}++;
  $mnd{$klokkeslett[1]} += 1;
  if ($mnd{$klokkeslett[1]}>$max) { $max=$mnd{$klokkeslett[1]}; }
}
close INN;

# ------ URL GROUPING -------

foreach $url (keys %PageInMonth) {
    if ($Aliases{$url}) {
	for ($ix=0; $ix<12; $ix++) {
	    $PageInMonth{$Aliases{$url}}[$ix]+=$PageInMonth{$url}[$ix];
	}
	delete $PageInMonth{$url}; # Removes the alias
	
	$PageTotal{$Aliases{$url}}       +=$PageTotal{$url};
	delete $PageTotal{$url};
    }
}

#------- OVERSKRIFT -------

print "<H3>Total statistics</H3>\n";

print "<TABLE>\n";
print "<TR><TD><STRONG>Year:</STRONG><TD>$year\n";
print "<TR><TD><STRONG>Number of accesses:</STRONG><TD>$TotalHits\n";
print "<TR><TD><STRONG>Bytes transferred:</STRONG><TD>$TotalByte\n";

if ($Redirect) {
    print "<TR><TD><STRONG>Report generated:</STRONG><TD> $LastRun\n";
}

print "</TABLE>\n";

#------- PR MONTH -------

print "<H3>Accesses per month</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>Month<TH>Number of hits\n";

for ($i=1; $i<=12; $i+=1) {
  $bredde=$Barwidth*$mnd{$months[$i-1]}/$max+1;
  print "<TR><TD>$months[$i-1]\n";
  print "<TD><IMG SRC=\"$BarImage\" WIDTH=$bredde HEIGHT=10>\n";
  print "$mnd{$months[$i-1]}\n";
} 

print "</TABLE>\n\n\n";

#------- PR PAGE -------

print "<H3>Accesses per page</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>Page<TH>Total";

for ($i=0; $i<12; $i++) {
    print "<TH>$months[$i]";
}
print "\n";

@sorted=sort {
    $SortDir*$PageTotal{$a} <=> $SortDir*$PageTotal{$b} }
        keys(%PageTotal);

#$count=0;
foreach $page (@sorted) {
  print "<TR><TD>$page <TD>$PageTotal{$page}\n";

  for ($ix=0; $ix<12; $ix++) {
      $_=$PageInMonth{$page}[$ix];
      if ($_==0) { $_=0; }
      print "    <TD>$_\n";
  }
  
  print "\n";

#  $count++;
#  if ($count==$NoOfWeekPs) { last; } # Don't print too many pages.
}

print "</TABLE>\n\n\n";

&PrintPageBot;
