#!/bin/perl

# WWWmonth
#   - a WWW-log analyzing CGI-script (monthly report)
#
# See shared.pl for version information.

# This program is freeware. Please let me know if you modify the code,
# and not just the configuration. 

# The GIF bars were stolen from http://weber.u.washington.edu/~reflux/

require "cgi.pl";
require "shared.pl";
require $VAR{"config"};

# ---------- Initialization     ------------------------

&InitDate; # $mon.$year gives current month

# Checking to see whether the user asked for a particular month

if ($VAR{"month"} ne "" && $VAR{"year"} ne "") {
    $mon  =$VAR{"month"}-1; # Count from zero...
    $year =$VAR{"year"};
}

# ---------- The program itself ------------------------

if (!$Redirect) { &printCType("text/html"); }

open(INN,$LogFile) ||
  error("Couldn't open logfile $LogFile: $!");

&PrintPageTop("Monthly access report $ForString");

# Search for start of month (to speed up report generation)

seek(INN,0,2);
$size=tell(INN);
$lastpos=0;

seek(INN,$pos,0);
<INN>; # Throwing a line away since we probably start in the middle of it
while(<INN>) {
    if (!/\S/) { next; }          	#Just whitespace: skip

    @felter=split(/ /,$_);      
    @klokkeslett=split(/\//,$felter[3]); #Dag/MM/AA:Time:Min:Sek

    #Have we reached this months data?
    if (!( $months[$mon] eq $klokkeslett[1] && $year==$klokkeslett[2])) {
	$lastpos=$pos;
	$pos=int(($pos+$size)/2);
	seek(INN,$pos,0);
	<INN>; # Skipping a line
    } else {
	seek(INN,$lastpos,0); # Found data for this week, using last position
	last; 
    }
}

# Make stats for this month
		       
while (<INN>)
{	
  if (!/\S/) { next; }          	#Bare whitespace: hopp over

  @felter=split(/ /,$_);      

  #Sjekk om vi skal ta med denne linjen
  if ($felter[5] eq '"HEAD')        { next; }
  if ($felter[8] != 200)            { next; }   # Hvis HTTP-kode ikke 200
  if (&SkipHost($felter[0]))        { next; }
  if (&SkipPage($felter[6]))        { next; }

  # Is this the right month?
  @klokkeslett=split(/\//,$felter[3]);     #Day/MM/YY:Time:Min:Sek
  if (!( $months[$mon] eq $klokkeslett[1] && $year==$klokkeslett[2])) 
  { next; }

  # Count accesses per page
  $_ = $felter[6]; 
  s/%7E/~/; 
  s/%7e/~/;
  s/\/$DefaultFile\Z/\//;
  $sider{$_}++;		     

  $TotalHits += 1;
  $TotalByte += $felter[9];

  $klokkeslett[0] =~ s/\[//;
  $dag[$klokkeslett[0]]++;
}
close INN;

# ------ URL GROUPING -------

foreach $url (keys %sider) {
    if ($Aliases{$url}) {
	$sider{$Aliases{$url}} += $sider{$url};
	delete $sider{$url}; # Removes the alias
    }
}

#------- OVERSKRIFT -------

print "<H3>Total statistics</H3>\n";

print "<TABLE>\n";
print "<TR><TD><STRONG>Month:</STRONG><TD>$months[$mon] $year\n";
print "<TR><TD><STRONG>Number of accesses:</STRONG><TD>$TotalHits\n";
print "<TR><TD><STRONG>Bytes transferred:</STRONG><TD>$TotalByte\n";

if ($Redirect) {
    print "<TR><TD><STRONG>Report generated:</STRONG><TD> $LastRun\n";
}

print "</TABLE>\n";

#------- PR DAY -------

print "<H3>Accesses per day</H3>\n\n";

print "<TABLE>\n";
print "<TR>\n";

$max=0;
for ($ix=1; $ix<=$#dag; $ix++) {
  print "<TH>$ix";
  if ($dag[$ix]>$max) { $max=$dag[$ix]; }
}

print "\n<TR>\n";

if ($max==0) { $max=1; }

for ($ix=1; $ix<=$#dag; $ix++) {
  $bredde=$Barwidth*$dag[$ix]/$max+1;
  print "<TD VALIGN=BOTTOM>$dag[$ix]<BR>\n";
  print "<IMG SRC=\"$BarImage\" HEIGHT=$bredde WIDTH=10 ALT=\"\">\n";
}

print "</TABLE>\n\n\n";

#------- PR PAGE -------

print "<H3>Accesses per page</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>Page<TH>Number of hits\n";

@sortert=sort { $SortDir*$sider{$a} <=> $SortDir*$sider{$b} }
         keys (%sider);

if ($SortDir<0) { $max=$sider{$sortert[0]}; }
else            { $max=$sider{$sortert[$#sortert]}; }

$count=0;
foreach $key (@sortert) {
  if ((($SortDir<0 && $count<$MaxNoFiles) ||
       ($SortDir>0 && $#sortert-$MaxNoFiles<$count)) &&
        $sider{$key}>=$MinHitFile) { 
     $bredde=$Barwidth*$sider{$key}/$max+1;
     print "<TR><TD>";
     if ($LinkToPages) { print "<A HREF=\"$key\">$key</A>"; }
     else              { print "$key";                      }
     print "<TD><IMG SRC=\"$BarImage\" WIDTH=$bredde HEIGHT=10 ALT=\"\">\n";
     print "$sider{$key}\n";
  }
  
  $count++;
} 

print "</TABLE>\n\n\n";

&PrintPageBot;


