#!/bin/perl

# WWWbrowser
#   - a WWW-log analyzing CGI-script (browser and OS report)  
#
# See shared.pl for version information.
#
# Lars M. Garshol - larsga@ifi.uio.no - http://www.ifi.uio.no/~larsga/

# This program is freeware. Please let me know if you modify the code,
# and not just the configuration. 

# The GIF bars were stolen from http://weber.u.washington.edu/~reflux/

# The OS and browser lists are highly incomplete. If anyone has info
# not in these lists, I'd be very glad to see it.

require "cgi.pl";
require "shared.pl";
require $VAR{"config"};

# ---------- The program itself ----------

if (!$Redirect) { &printCType("text/html"); }

open(INN,$LogFile) ||
  error("Couldn't open logfile $LogFile: $!");

&PrintPageTop("Browser and OS access report $ForString");

if ($Redirect) {
    print "<P>\nReport generated: $LastRun\n</P>\n\n";
}

while (<INN>)
{	
  if (!/\S/) { next; }          	#Whitespace, skip
  @felter=split(/ /,$_);      

  #Use this line?
  if ($felter[11] eq '-')           { next; }   # If no browser/OS reported
  if ($felter[5] ne '"GET')         { next; }
  if ($felter[8] != 200)            { next; }   # Hvis HTTP-kode ikke 200
  if (&SkipHost($felter[0]))        { next; }
  if (&SkipPage($felter[6]))        { next; }

  for ($ix=11+1; $ix<=$#felter; $ix++) {
    $felter[11] .= $felter[$ix];
  }

  $UserAgent=$felter[11];
  if (!$UserAgent =~ /\S/)          { next; } #No info, skip

  $skip=0;
  foreach $bot (@robotList) {
    if ($UserAgent =~ /$bot/)       { $skip=1; last; }
  }
  if ($skip)                        { next; } #Just a robot, skip it

  $total++;
  if ($UserAgent =~ /Mozilla/ && !($UserAgent =~ /compatible/i)) {
    #It's Netscape, let's check which version
    $browser{"Netscape"}++; 

    $UserAgent =~ /\/(\d)\./;  #$1 now contains major version no
    $nsver[$1]++;
  } else {
    $found=0;

    if ($UserAgent =~ /MSIE/ && !($UserAgent =~ /WebTV/)) {
	$browser{"MSIE"}++;
	$UserAgent =~ /MSIE(\d)\./;  #$1 now contains major version no
	$msiever[$1]++;
	$found=1;
    } else {
	foreach $key (@testBrowsers) {
	    if ($UserAgent =~ /$key/) { 
		$browser{$key}++;
		$found=1;
		last;
	    }
	}
    }

    if (!$found) {
	foreach $grabber (@siteGrabbers) {
	    if ($UserAgent =~ /$grabber/) {
		$browser{"SitGrab"}++;
		$found=1;
		last;
	    }
	}

	if (!$found) { $browser{"Unknown"}++; }
    }
  }

  $found=0;
  foreach $key (keys %OSName) {
    if ($UserAgent =~ /$key/) { 
      $OS{$key}++; 
      $found=1;
      last;
    }
  }
  
  if (!$found) { 
    foreach $key (keys %OSAlias) {
      if ($UserAgent =~ /$key/) {
	  $key=$OSAlias{$key};
	  $OS{$key}++;
        $found=1;
	  last;
      }
    }

    if (!$found) { $OS{"Unknown"} += 1; }
  }
}
close INN;

#------- BROWSER -------

print "<H3>Accesses per browser</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>Browser<TH>Number of hits<TH>Percent\n";

@sortert=sort {
	 	$SortDir*$browser{$a} <=> $SortDir*$browser{$b}
         } keys(%browser);
foreach $key (@sortert) {
  print "<TR><TD>$browserName{$key}";
  print "<TD>$browser{$key}\n";
  $p=int($browser{$key}/$total*100);
  print "<TD>$p %\n";
} 

print "</TABLE>\n\n\n";

#------- Netscape version ------

print "<H3>Accesses per Netscape version</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>Version<TH>Number of hits<TH>Percent\n";

for ($i=1; $i<=$#nsver; $i++) {
  print "<TR><TD>Mozilla/$i.xx";
  print "<TD>$nsver[$i]\n";
  $p=int($nsver[$i]/$browser{"Netscape"}*100);
  print "<TD>$p %\n";
} 

print "</TABLE>\n\n\n";

#------- MSIE version ------

print "<H3>Accesses per MSIE version</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>Version<TH>Number of hits<TH>Percent\n";

for ($i=1; $i<=$#msiever; $i++) {
  print "<TR><TD>MSIE/$i.xx";
  print "<TD>$msiever[$i]\n";
  $p=int($msiever[$i]/$browser{"MSIE"}*100);
  print "<TD>$p %\n";
} 

print "</TABLE>\n\n\n";

#------- OS'ES -------

print "<H3>Accesses per operating system</H3>\n\n";

print "<TABLE>\n";
print "<TR><TH>OS<TH>Number of hits<TH>Percent\n";

@sortert=sort {
	 	$SortDir*$OS{$a} <=> $SortDir*$OS{$b}
         } keys(%OS);
foreach $key (@sortert) {
  print "<TR><TD>$OSName{$key}";
  print "<TD>$OS{$key}";
  $p=int($OS{$key}/$total*100);
  print "<TD>$p %\n";
} 

print "</TABLE>\n\n\n";

&PrintPageBot;
