#!/bin/perl

# UAUnknown
#   - reports unknown user agents so that they can be added to the lists
#
# See shared.pl for version information.
#
# Lars M. Garshol - larsga@ifi.uio.no - http://www.ifi.uio.no/~larsga/

# This program is freeware. Please let me know if you modify the code,
# and not just the configuration. 

# The GIF bars were stolen from http://weber.u.washington.edu/~reflux/

require "cgi.pl";
require "config.pl";
require "shared.pl";

# ---------- The program itself ------------------------

&printCType("text/html");

open(INN,$LogFile) ||
  error("Couldn't open logfile $LogFile: $!");

&PrintPageTop("List of unknown user agents");

print "<TABLE>\n";
print "<TR><TH>Host <TH>File <TH>User-Agent\n";

while (<INN>)
{	
  if (!/\S/) { next; }          	#Whitespace, skip
  @felter=split(/ /,$_);      

  #Use this line?
  if ($felter[11] eq '-')           { next; }   # If no browser/OS reported
  if ($felter[5] ne '"GET')         { next; }
  if ($felter[8] != 200)            { next; }   # Hvis HTTP-kode ikke 200
  if (&SkipHost($felter[0]))        { next; }
  if (&SkipPage($felter[6]))        { next; }

  for ($ix=12; $ix<=$#felter; $ix++) {
    $felter[11] .= $felter[$ix];
  }

  $UserAgent=$felter[11];
  if (!$UserAgent =~ /\S/)          { next; } #No info, skip

  $skip=0;
  foreach $bot (@robotList) {
    if ($UserAgent =~ /$bot/)       { $skip=1; last; }
  }    
  if ($skip)                        { next; } #Just a robot, skip it

  #--- SITE GRABBER CHECK

  foreach $grabber (@siteGrabbers) {
      if ($UserAgent =~ /$grabber/) {
	  $skip=1;
	  last;
      }
  }
  if ($skip) { next; }
  
  #--- UA CHECK
  
  $total++;
  if ($UserAgent =~ /Mozilla/ && !($UserAgent =~ /compatible/i)) {
      1; # Dummy statement
  } else {
      $funnet=0;

      if ($UserAgent =~ /MSIE/) {
	  $funnet=1;
      } else {	  
	  foreach $key (@testBrowsers) {
	      if ($UserAgent =~ /$key/) { 
		  $funnet=1;
	      }
	  }
      }

      if (!$funnet && !($UserAgent =~ /-\s*/)) {
	  print "<TR><TD>$felter[0]  <TD>$felter[6]  <TD>$UserAgent\n";
      }
  }

  #--- OS CHECK
  $found=0;
  foreach $key (keys %OSName) {
    if ($UserAgent =~ /$key/) { 
      $found=1;
      last;
    }
  }
  
  if (!$found && !($UserAgent =~ /-\s*/)) { 
    foreach $key (keys %OSAlias) {
      if ($UserAgent =~ /$key/) {
	  $found=1;
	  last;
      }

      if ($UserAgent =~ /Lynx/) { $found=1; }
    }

    if (!$found) {
	push(@OSlist,"$felter[0] <TD>$felter[6] <TD>$UserAgent");
    }
  }
  
}
close INN;

print "</TABLE>\n\n\n";

print "<H2>Unknown OS-es</H2>\n";

print "<TABLE>\n";
foreach $UnknownOS (@OSlist) {
    print "<TR><TD>$UnknownOS\n";
}
print "</TABLE>\n";
  
&PrintPageBot;
