
# Shared library for the WWWstats package.

require "cgi.pl";

# ---------- Initialization -------------------

# ParseOptions is called at the bottom of the file

# ---------- Constants ------------------------

$Version = "1.55";

# ---------- Lists     ------------------------

# Unknown:
# MSProxy: Listed as unknown on purpose
# CrescentInternetToolPakHTTPOLEControl: http client library
# WebAuto
# contype
# CCrawler
# VCIWebViewer
# mcbot
# MicrosoftInternetExplorer/4.40.308(Windows95)
# Web21CustomCrawlbert@web21.com
# InosoftActiveFINDER
# LinkWalker

%browserName = ("Netscape","Netscape Navigator","MSIE","MS Internet Explorer",
		"Emacs\\-W3","GNUscape (Emacs-W3)","Lynx","Lynx",
                "Unknown","Uknown browser","IBrowse","IBrowse",
                "AOL\\-IWENG","AOL-IWENG","Opera","Opera","HotJava",
		"Sun HotJava","Cyberdog","Cyberdog","WebExplorer",
		"IBM-WebExplorer","AmigaVoyager","AmigaVoyager",
		"LineModeBrowser","W3C Line Mode Browser","Viking","Viking",
		"Lotus-Notes","Lotus Notes web client","WebTV","WebTV browser",
		"NCSA_Mosaic","NCSA Mosaic","MacWeb","MacWeb",
		"SitGrab","Site grabbers","InterGO","InterGO",
		"ANTFresco","ANT Fresco","MSPIE","MS Pocket Internet Explorer",
		"MSFrontPageExpress","MS FrontPage Express");

@siteGrabbers= ("GetRight","Wget","WebFetcher","22AciDownload","EmailSiphon",
		"WebZIP","WebMirror","WebVCR","TelePortPro","BPFTP",
		"TZGETURL");

@testBrowsers= ("WebTV","Lynx","Emacs\\-W3","IBrowse","AOL\\-IWENG",
		"Opera","HotJava","Cyberdog","WebExplorer","AmigaVoyager",
		"LineModeBrowser","Viking","Lotus-Notes","NCSA_Mosaic",
		"MacWeb","InterGO","ANTFresco","MSPIE","MSFrontPageExpress");

%OSName      = ("Win95","Windows 95","WinNT","Windows NT","SunOS","Sun Solaris"
		,"IRIX","IRIX","Macintosh","MacOS","Win16","Windows 3.xx",
                "unix","Unknown UNIX system","Linux","Linux","OS/2","OS/2",
		"OSF","Open Software Foundation UNIX","CrayOS","CrayOS",
		"AmigaOS","AmigaOS","HP-UX","Hewlett-Packard UNIX","Unknown",
		"Unknown OS","RISCOS","Acorn RISC OS","AIX","IBM UNIX (AIX)",
		"WindowsCE","Windows CE","Windows98","Windows 98",
		"NetBSD","NetBSD","WebTV","WebTV");

%OSAlias     = ("Windows95","Win95","Windows;I;16bit","Win16","WindowsNT",
		"WinNT","Windows3.1","Win16","Mac_PowerPC","Macintosh",
		"Win32","WinNT","Mac_PPC","Macintosh","Mac_68000","Macintosh",
		"MacWeb","Macintosh");

@robotList   = ("InfoSeek","Solbot","Slurp","Architext","Excite","OpenTextSite"
		,"Informant","Symantec WebFind","Scooter","Origobot","Gulliver"
		,"iSpi","KGValidator","MuscatFerret","WebCompass",
		"NetAttache","WiseWire","CSSCheck","w3index","Arachnoidea",
		"ia_archiver","WebCrawler","Lycos_Spider","W3C_Validator",
		"SummitSiteValidator","echO!","Lambda LinkCheck","EchO!",
		"AltaVistaIntranet","TestWinSpider","weblayers","Astra",
		"ExcaliburInternetSpider","HOMESITE","DigOut4U");

%Domain = ("ad","Andorra","ae","United Arab Emirates","af","Afghanistan","ag",
	   "Antigua and Barbuda","ai","Anguilla","al","Albania","am",
	   "Armenia","an","Netherlands Antilles","ao","Angola","aq",
	   "Antarctica","ar","Argentina","arpa","Old style Arpanet","as",
	   "American Samoa","at","Austria","au","Australia","aw","Aruba","az",
	   "Azerbaidjan","ba","Bosnia-Herzegovina","bb","Barbados","bd",
	   "Bangladesh","be","Belgium","bf","Burkina Faso","bg","Bulgaria",
	   "bh","Bahrain","bi","Burundi","bj","Benin","bm","Bermuda","bn",
	   "Brunei Darussalam","bo","Bolivia","br","Brazil","bs","Bahamas",
	   "bt","Bhutan","bv","Bouvet Island","bw","Botswana","by","Belarus",
	   "bz","Belize","ca","Canada","cc","Cocos (Keeling) Islands","cf",
	   "Central African Republic","cg","Congo","ch","Switzerland","ci",
           "Ivory Coast (Cote D'Ivoire)","ck","Cook Islands","cl","Chile","cm","Cameroon","cn","China","co","Colombia",
           "com","USA Commercial","cr","Costa Rica","cs","Former Czechoslovakia","cu","Cuba","cv","Cape Verde","cx",
           "Christmas Island","cy","Cyprus","cz","Czech Republic","de","Germany","dj","Djibouti","dk","Denmark","dm",
           "Dominica","do","Dominican Republic","dz","Algeria","ec","Ecuador","edu","USA Educational","ee","Estonia",
           "eg","Egypt","eh","Western Sahara","es","Spain","et","Ethiopia","fi","Finland","fj","Fiji","fk",
           "Falkland Islands","fm","Micronesia","fo","Faroe Islands","fr","France","fx","France (European Territory)","ga",
           "Gabon","gb","Great Britain","gd","Grenada","ge","Georgia","gf","French Guyana","gh","Ghana","gi","Gibraltar",
           "gl","Greenland","gm","Gambia","gn","Guinea","gov","USA Government","gp","Guadeloupe (French)","gq",
           "Equatorial Guinea","gr","Greece","gs","S. Georgia &amp; S. Sandwich Isls.","gt","Guatemala","gu","Guam (USA)",
           "gw","Guinea Bissau","gy","Guyana","hk","Hong Kong","hm","Heard and McDonald Islands","hn","Honduras","hr",
           "Croatia","ht","Haiti","hu","Hungary","id","Indonesia","ie","Ireland","il","Israel","in","India","int",
           "International","io","British Indian Ocean Territory","iq","Iraq","ir","Iran","is","Iceland","it","Italy","jm",
           "Jamaica","jo","Jordan","jp","Japan","ke","Kenya","kg","Kyrgyzstan","kh","Cambodia","ki","Kiribati","km",
           "Comoros","kn","Saint Kitts &amp; Nevis Anguilla","kp","North Korea","kr","South Korea","kw","Kuwait","ky",
           "Cayman Islands","kz","Kazakhstan","la","Laos","lb","Lebanon","lc","Saint Lucia","li","Liechtenstein","lk",
           "Sri Lanka","lr","Liberia","ls","Lesotho","lt","Lithuania","lu","Luxembourg","lv","Latvia","ly","Libya","ma",
           "Morocco","mc","Monaco","md","Moldavia","mg","Madagascar","mh","Marshall Islands","mil","USA Military","mk",
           "Macedonia","ml","Mali","mm","Myanmar","mn","Mongolia","mo","Macau","mp","Northern Mariana Islands","mq",
           "Martinique (French)","mr","Mauritania","ms","Montserrat","mt","Malta","mu","Mauritius","mv","Maldives","mw",
           "Malawi","mx","Mexico","my","Malaysia","mz","Mozambique","na","Namibia","nc","New Caledonia (French)","ne",
           "Niger","net","Network","nf","Norfolk Island","ng","Nigeria","ni","Nicaragua","nl","Netherlands","no","Norway",
           "np","Nepal","nr","Nauru","nt","Neutral Zone","nu","Niue","nz","New Zealand","om","Oman","org",
           "Non-Profit Organizations","pa","Panama","pe","Peru","pf","Polynesia (French)","pg","Papua New Guinea","ph",
           "Philippines","pk","Pakistan","pl","Poland","pm","Saint Pierre and Miquelon","pn","Pitcairn Island","pr",
           "Puerto Rico","pt","Portugal","pw","Palau","py","Paraguay","qa","Qatar","re","Reunion (French)","ro","Romania",
           "ru","Russian Federation","rw","Rwanda","sa","Saudi Arabia","sb","Solomon Islands","sc","Seychelles","sd",
           "Sudan","se","Sweden","sg","Singapore","sh","Saint Helena","si","Slovenia","sj","Svalbard and Jan Mayen Islands",
           "sk","Slovak Republic","sl","Sierra Leone","sm","San Marino","sn","Senegal","so","Somalia","sr","Suriname","st",
           "Saint Tome and Principe","su","Former USSR","sv","El Salvador","sy","Syria","sz","Swaziland","tc",
           "Turks and Caicos Islands","td","Chad","tf","French Southern Territories","tg","Togo","th","Thailand","tj",
           "Tadjikistan","tk","Tokelau","tm","Turkmenistan","tn","Tunisia","to","Tonga","tp","East Timor","tr","Turkey",
           "tt","Trinidad and Tobago","tv","Tuvalu","tw","Taiwan","tz","Tanzania","ua","Ukraine","ug","Uganda","uk",
           "United Kingdom","um","USA Minor Outlying Islands","us","United States","uy","Uruguay","uz","Uzbekistan","va",
           "Vatican City State","vc","Saint Vincent &amp; Grenadines","ve","Venezuela","vg","Virgin Islands (British)",
           "vi","Virgin Islands (USA)","vn","Vietnam","vu","Vanuatu","wf","Wallis and Futuna Islands","ws","Samoa","ye",
           "Yemen","yt","Mayotte","yu","Yugoslavia","za","South Africa","zm","Zambia","zr","Zaire","zw","Zimbabwe","IP","IP-address");

%MonthNos    = ("Jan",0,"Feb",1,"Mar",2,"Apr",3,"May",4,"Jun",5,"Jul",6,
		"Aug",7,"Sep",8,"Oct",9,"Nov",10,"Dec",11);

@months      = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct",
		"Nov","Dec");

# ---------- Functions ------------------------

sub SkipHost { 
  foreach $Skip (@SkipHosts) {
    if ($_[0] =~ m/$Skip/i) { 
	return 1;
    }
  }

  0; # Not in @SkipHosts
}

sub SkipPage {
  if (!($_[0] =~ /$RestrictTo/)) {
      return 1;
  }

  foreach $Skip (@SkipFiles) {
    if ($_[0] =~ m/$Skip/i) {
	return 1;
    }
  }

  0; # Not outside $RestrictTo and not inside @SkipFiles: OK
}

sub SkipRobot {
    foreach $Skip (@robotList) {
	if ($_[0] =~ /$Skip/i) {
	    return 1;
	}
    }

    0; # Not on robot list: OK
}

# Initializes date info.

sub InitDate {
    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
	localtime(time);
    if ($mon < 10) { $mon  = "0$mon"; }

    # Year 2000-handling. Will fail in 2090.
    if ($year<90) { $year += 2000; }
    else          { $year += 1900; }

    $day=$mday;
}

# Prints the top of the report page. First param: page title.

sub PrintPageTop {
    print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
    print "<!-- WWWstats $Version -->\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "  <TITLE>$_[0]</TITLE>\n";

    if ($StyleURL) {
	print "  <LINK HREF=\"$StyleURL\" TYPE=\"text/css\" MEDIA=screen REL=Stylesheet>\n";
    }
    
    print "</HEAD>\n\n";
    print "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\">\n";
    print "<H1>$_[0]</H1>\n\n";
}

# Prints the bottom of the report page.

sub PrintPageBot {
    print "<HR>\n";
    print "<FONT SIZE=-5>\n";
    print "This page produced by ";
    print "<A HREF=\"http://www.stud.ifi.uio.no/~larsga/download/WWWstats.html\">";
    print "WWWstats</A>.\n";
    print "</FONT>\n";

    print "</BODY>\n";
    print "</HTML>\n";
}

# Parses the command line and sets internal variables accordingly
# Sets %VAR hash to user-configured options.

sub ParseOptions {
    # Checks if we are in redirect mode
    if ($ENV{"REQUEST_METHOD"} eq "") {
	$Redirect=1;

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
	    localtime(time);

	# Year 2000-handling. Will fail in 2090.
	if ($year<90) { $year += 2000; }
	else          { $year += 1900; }

	if ($hour<10) { $hour="0".$hour; }
	if ($min<10)  { $min ="0".$min;  }
	$LastRun ="$mday.$months[$mon].$year $hour:$min local time";

	# Pretend first argument was really QUERY_STRING environment var
	$ENV{"QUERY_STRING"}=$ARGV[0];
    }
    
    &parseQRY_STR;

    # Using default if not set
    if (!$VAR{"config"}) {
	$VAR{"config"}="config.pl";
    }
}

&ParseOptions(); # Reading QUERY_STRING/cmd line. (Sets %VAR)

1; # Everything OK


