#!/usr/bin/perl
# Perl Location on your server 
##############################################################################
# If you encounter problems while trying to configure this script, help      #
# is available.  In order to get your problem solved:                        #
#       1) Read this file thoroughly                                         #
#       2) Consult the THANKS-CGI Frequently Asked Questions:                #
#               http://www.thanks-cgi.com/faq/                               #
#       3) If you are still having difficulty installing this script, send   #
#          e-mail to: support@thanks-cgi.com                                 #
#          Include any error messages you are receiving and as much detail   #
#          as you can so we can spot your problem.                           #
#                                                                            #
# Hopefully we will be able to help you solve your problems.  Thank you.     #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 THANKS-CGI All Rights Reserved.                             #
#  Not for re-sell or re-distribution.                                       #
##############################################################################
# Setup Begin
$filehead  = "/home/yourdomain/bitmapcounter/";             # The full filepath of all bitmapcounter's directory. If you are not sure what the path is, contact your server.
$usedfile  = "/home/yourdomain/bitmapcounter/usedfile.txt"; # The full filepath of database file. Extension must be "*.txt". If you are not sure what the path is, contact your server.
$resultpage= "/home/yourdomain/bitmapcounter/result.htm";   # The full filepath of page to show the result.  If you are not sure what the path is, contact your server.
$colortype = 0;   # 0=WHITE font in BLACK background. 1=BLACK font in WHITE background.
# End
#####################
if ("$ENV{'QUERY_STRING'}" =~ /result/) {
   open(RESULT,"$resultpage");
   @resultpage=<RESULT>;
   close(RESULT);

   print "Content-type: text/html\n\n";
   
   foreach (@resultpage) {
      if ($_ =~ /<!--resulthere-->/) {
         open(USEDFILE,"$usedfile");
         @usedfile=<USEDFILE>;
         close(USEDFILE);
        
         @usedfile=sort @usedfile;

         print "<table>\n";
         print "<tr><td>FROM:</td><td>HITS</td></tr>\n";
         foreach $temp (@usedfile) {
            ($a,$b,$c)=split(//,$temp);
            $counterfile= "$filehead$b";

            open(COUNTERFILE,"$counterfile");
            $counter=<COUNTERFILE>;
            close(COUNTERFILE);

            $counter=0 if ($counter eq "");
            
            print "<tr><td>$a</td><td align=right>$counter hits</td></tr>\n";
         }          
         print "</table>\n";
      }
      else {
         print "$_";
      }
   }
}
else {     
   if ($colortype==0) {
      @n0 = ("c3","99","99","99","99","99","99","99","99","c3");
      @n1 = ("cf","c7","cf","cf","cf","cf","cf","cf","cf","c7");
      @n2 = ("c3","99","9f","9f","cf","e7","f3","f9","f9","81");
      @n3 = ("c3","99","9f","9f","c7","9f","9f","9f","99","c3");
      @n4 = ("cf","cf","c7","c7","cb","cb","cd","81","cf","87");
      @n5 = ("81","f9","f9","f9","c1","9f","9f","9f","99","c3");
      @n6 = ("c7","f3","f9","f9","c1","99","99","99","99","c3");
      @n7 = ("81","99","9f","9f","cf","cf","e7","e7","f3","f3");
      @n8 = ("c3","99","99","99","c3","99","99","99","99","c3");
      @n9 = ("c3","99","99","99","99","83","9f","9f","cf","e3");
   }
   else {   
      @n0 = ("3c","66","66","66","66","66","66","66","66","3c");
      @n1 = ("30","38","30","30","30","30","30","30","30","30");
      @n2 = ("3c","66","60","60","30","18","0c","06","06","7e");
      @n3 = ("3c","66","60","60","38","60","60","60","66","3c");
      @n4 = ("30","30","38","38","34","34","32","7e","30","78");
      @n5 = ("7e","06","06","06","3e","60","60","60","66","3c");
      @n6 = ("38","0c","06","06","3e","66","66","66","66","3c");
      @n7 = ("7e","66","60","60","30","30","18","18","0c","0c");
      @n8 = ("3c","66","66","66","3c","66","66","66","66","3c");
      @n9 = ("3c","66","66","66","66","7c","60","60","30","1c");
   } 

   $counterfile =$ENV{"HTTP_REFERER"};
   
   open(USEDFILE,"$usedfile");
   @usedfile=<USEDFILE>;
   close(USEDFILE);

   $check=0;
   $b=0;
   foreach (@usedfile) {
      ($a,$b,$c)=split(//,$_);
      if ($a eq $counterfile) {
         $check=1;
         last;
      }
   }
   if ($check==0) {
      $b++;
      open(USEDFILE,">>$usedfile");
      print USEDFILE "$counterfile$b\n";
      close(USEDFILE);
   }
  
   $counterfile="$filehead$b";          

   open(COUNTERFILE,"$counterfile");
   $counter=<COUNTERFILE>;
   close(COUNTERFILE);

   $counter++;

   open(COUNTERFILE,">$counterfile");
   print COUNTERFILE "$counter";
   close(COUNTERFILE);

   $len=length($counter);
   
   @bitmap=();
   for($i=0;$i<10;$i++) {
      for($j=0;$j<$len;$j++) {
         $n=substr($counter,$j,1);
         $bytes=&takebitmap($n,$i); 
         push(@bitmap,$bytes);              
      }
   }

   for ($i=0;$i<$len*3;$i++) {
       if ($colortype==0) {
          unshift(@bitmap,"ff");    
          push(@bitmap,"ff");       
       }
       else {
          unshift(@bitmap,"00");
          push(@bitmap,"00");
       }
   }

   print "Content-type: image/x-xbitmap\n\n";
   printf ("#define count_width %d\n#define count_height 16\n",$len*8);
   printf STDOUT "static char count_bits[] = {\n";
   for($i = 0; $i < ($#bitmap+1); $i++) {
      print("0x$bitmap[$i]");
      if ($i != $#bitmap) {
         print(",");
         if (($i+1) % 7 == 0) {
            print("\n");
         }
      }
   }
   print("};\n");
}
exit 0;
########
sub takebitmap {
if ($_[0]==0) {return $n0[$_[1]];}   
elsif ($_[0]==1) {return $n1[$_[1]];}   
elsif ($_[0]==2) {return $n2[$_[1]];} 
elsif ($_[0]==3) {return $n3[$_[1]];} 
elsif ($_[0]==4) {return $n4[$_[1]];} 
elsif ($_[0]==5) {return $n5[$_[1]];} 
elsif ($_[0]==6) {return $n6[$_[1]];} 
elsif ($_[0]==7) {return $n7[$_[1]];} 
elsif ($_[0]==8) {return $n8[$_[1]];} 
elsif ($_[0]==9) {return $n9[$_[1]];} 
}