#!/usr/bin/perl
#####################################################################
# WebCounter Version 2.0
# Copyright 2001 LazyDog Concepts - all rights reserved.
# Created 29/08/2001.
#
# This is the server side of visitation counter scheme whose
# presentation is left to client side application.
#
# That version was dramatically reduced in size, it runs faster than
# previous script version since there aren't seconds recalculations.
# "Gap Time Criterion" to discard deceitful counting, is much more
# accurately applied.
#
# If migrating from previous version, don't worry with old data!
# A small modification doesn't to compromise scheme function.
#
# LazyDog Concepts can be reached at http://www.lazydog.hpg.com.br/.
#####################################################################

# initialize random number generator
srand;

# list of valid referrers
@referers = ("YourDomain.com");

# child directory for all used datafiles
$dataPath = "./data/";

# file where counter values are kept
$countFileName = $dataPath."webcount.dat";

# file where IP logs are to be recorded
$ipFileName = $dataPath."ipdata.dat";

# array with valid background filenames
@all_images = ("coral", "gold", "lemmon", "navy", "red", "silver", "skyblue", "violet");

# images preferred type and size are Gif/JPG 88  31 pixels wide
$fileExt = ".gif";

# performs a random choice, ie: for each visit a different background image
$backImg = $all_images[ rand @all_images ].$fileExt;

# gets the current server local time and adjusts to user time zone and format
# weekday_name dd/mm/yyyy (hh:MM:ss) --> usual Brazilian date format.
#
# Warning: Change $srvZone and $usrZone to proper GMT.
# 
sub get_date {
  # server timezone is PDT (GMT-08:00) :: Pacific Time (Canada USA and Tijuana)
  $srvZone = - 8;
  # guest timezone is GMT-04:00 :: Hora de Manaus = BDT-01:00
  $usrZone = - 4;
  # define array with short weekday names
  #@weekDay = ('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT');
  @weekDay = ('DOM', 'SEG', 'TER', 'QUA', 'QUI', 'SEX', 'SAB');
  # gets the server local time with Dayligth Savings Check
  $now = time;
  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = (localtime($now));
  # Warning: $isdst only works for servers located in places with daylight savings
  $timeDiff = ($usrZone - $srvZone - $isdst) * 3600;
  # adjusts server local time to user time zone also regarding to day light savings
  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = (localtime($now + $timeDiff));
  # add 1900 to the year to get the full 4 digit year.
  $year += 1900;
  $mask = "%02d/%02d/%04d (%02d:%02d:%02d)";
  $date = "$weekDay[$wday] ".sprintf($mask, $mday, $mon, $year, $hour, $min, $sec);
}

# discard if there isn't implementation
sub lock {
 flock(HANDLE, LOCK_EX);
}

# discard if there isn't implementation
sub unlock {
 flock(HANDLE, LOCK_UN);
}

# Update visitation counter, register access and finally send visitation
# counter number plus a random background image filename to client CGI
# caller as plain text.     Discard repeated visitations using "Gap Time
# Criterion" and always check files opening.
sub registration {

  # open counter datafile to read previous access data
  if (open HANDLE, "<$countFileName") {
    lock();
    $contents = <HANDLE>;
    unlock();
    close HANDLE;
  }
  else {
    $contents = "0::";
  }

  # split contents string to retrieve previous counter number and visitor's IP
  ($count, $prevIP, $prevTime) = split(':', $contents);

  # get visitor's IP
  $currIP = $ENV{'REMOTE_ADDR'};

  # prepare time&date variables to apply criterion and register access
  &get_date;

  # arbitrary minimum gap time between access
  $MIN_TIME = 60; # seconds

  # same IP access doesn't matter if difference between time access greater than MIN_TIME
  if ((($now - $prevTime) > $MIN_TIME) || ($currIP ne $prevIP)) {
    $count++;
    # open counter datafile to write visitor's access number, IP and time
    if (open HANDLE, ">$countFileName") {
      lock();
      print HANDLE "$count:$currIP:$now";
      unlock();
      close HANDLE;
    }
    # open IP datafile to append current access date and visitor's IP
    if (open HANDLE, ">>$ipFileName") {
      lock();
      print HANDLE "$date $currIP\n";
      unlock();
      close HANDLE;
    }
  }

  # send visit number and background image to client CGI caller
  print "Content-type: text/plain\n\n";
  print "$count:$backImg\n";
}

sub main {
  # localize the check_referer flag which determines if user is valid
  my $check_referer = 0;
  # check if referer is membership of valid referers list
  if ($ENV{'HTTP_REFERER'}) {
    foreach $referer (@referers) {
      if ($ENV{'HTTP_REFERER'} =~ m|https?://([^/]*)$referer|i) {
        $check_referer = 1;
        last;
      }
    }
  }
  else { # couldn't detect HTTP_REFERER, so validate permission.
    $check_referer = 1;
  }
  # If the HTTP_REFERER is valid, invoke registration procedure.
  if ($check_referer == 1) {
    &registration;
  }
}

&main;