/********************************************************************
  WebCounter Version 1.5
  Copyright 2001 LazyDog Concepts - all rights reserved.
  Created 29/08/2001.

  This is the client side of visitation counter scheme whose
  counter engine is left to server side script.

  This code is for free usage since you maintain all references about
  authorship and never sale the code, yet partially or modified.
  You can modify, freely distribute and make money with maintenance,
  or copy service.

  I sincerely hope this helps you to learn more about Perl/CGI/Java.

  LazyDog Concepts can be reached at http://www.lazydog.hpg.com.br/.
 ********************************************************************/
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.net.*;
//import java.text.SimpleDateFormat;
//import java.util.Calendar;

public class WebCounter extends Applet {

  final String
    appName = "WebCounter",
    version = "1.5";

  Graphics
    gb;         /* off screen graphics buffer */

  Image
    off,        /* off screen image for buffered painting */
    backImg,    /* background image */
    numbers[];  /* array with graphic image for each digit */

  Color
    backColor;  /* background color for transparent gif images */

  int
    Width,      /* applet width */
    Height,     /* applet height */
    ndigs;      /* number of displayable digits */

  MediaTracker
    md;         /* for images downloading management */

  /**
    * Constructor just create offscreen image/graphics buffer
    * and call data loading method.
   */
  public void init() {
    Width = getSize().width;
    Height = getSize().height;
    off = createImage(Width, Height);
    gb = off.getGraphics();
    loadData();
  }

  /**
    * Just paint offscreen image, fast and practical!
   */
  public void paint(Graphics g) {
    g.drawImage(off, 0, 0, this);
    System.gc();
  }

  /**
    * Get integer applet parameter, using "radix" to proper convert string to integer
    * with a "defaultValue" assignment on absence
   */
  private int getIntParam(String paramName, int radix, int defaultValue) {
    String param = getParameter(paramName);
    return (param != null) ? Integer.parseInt(param, radix) : defaultValue;
  }

  /**
    * Get string applet parameter with a "defaultValue" assignment on absence
   */
  private String getStringParam(String paramName, String defaultValue) {
    String param = getParameter(paramName);
    return (param != null) ? param : defaultValue;
  }

//  /* make a query string, useful for http GET */
//  private String getQuery() {
//    InetAddress localHost = null;
//    try {
//      localHost = InetAddress.getLocalHost();
//    } catch (UnknownHostException e) {}
//    Calendar connTime = Calendar.getInstance();
//    SimpleDateFormat df = new SimpleDateFormat("EEE dd.MMM.yyyy (HH:mm:ss z)");
//    return "?name=" + localHost.getHostName()
//      + "&address=" + localHost.getHostAddress()
//         + "&time=" + URLEncoder.encode(df.format(connTime.getTime()));
//  }

  /**
    * invoke CGI script to receive string containing visitation
    * counter number and background image filename
   */
  private String communique() {
    /* Warning: Do not expose URL string and/or child paths as applet parameter! */
    final String
      USER_URL = "http://Your_Domain/",
      SCRIPT_PATH = "WebCounter/",
      SCRIPT = "WebCounter.pl";
    StringBuffer
      buff = new StringBuffer(USER_URL).append(SCRIPT_PATH).append(SCRIPT);
      //buff.append(getQuery());
    String result = null;
    BufferedReader inp = null;
    try {
      URL url = new URL(buff.toString());
      URLConnection conn = url.openConnection();
      conn.setDoInput(true);
      conn.connect();
      inp = new BufferedReader(
              new InputStreamReader(conn.getInputStream()));
      result = inp.readLine();
      inp.close();
      inp = null;
    }
    catch (MalformedURLException ue) {}
    catch (Exception e) {}
    finally {
      try { if (inp != null) inp.close(); } catch(IOException e) {}
    }
    return result;
  }

  String
    countStr;   /* where server side script results are kept */

  boolean
    defaultDrawing; /* user choice flag for default drawing method */

  /**
    * Load data from server after invoking CGI script
    * and simultaneously prepare images download management
    * then call offscreen drawing method
   */
  private void loadData() {
    final String
      IMG_PATH = "img/",      /* child folder where image files are located */
      EXTENSION = "c.gif";    /* digits image files EXTENSION */

    countStr = communique();  /* invoke CGI to get visitation number and more */

    if (countStr == null)
      ndigs = 0;
    else { /* countStr expected format is INTEGER:STRING */
      ndigs = countStr.indexOf(':');
      if (ndigs > 0) {
        /* retrieve background filename from script response string */
        String filename = countStr.substring(ndigs+1);
        /* retrieve counter string from script response string */
        countStr = countStr.substring(0, ndigs);
        /* left pad counter string with zeroes (never less than 4 digits) */
        while ((ndigs = countStr.length()) < 4) { countStr = "0" + countStr; }
        /* check user choice to draw counter image using default method */
        defaultDrawing = getStringParam("defDrawing", "false").equals("true");
        if (!defaultDrawing) {
          md = new MediaTracker(this);
          /* request background image file from server */
          backImg = getImage(getCodeBase(), IMG_PATH + filename);
          md.addImage(backImg, 0);
          try {
            md.waitForID(0);
          }
          catch (InterruptedException e) {}
          /* request each digit image file from server */
          numbers = new Image[ndigs];
          for (int j=0; j < ndigs; j++) {
            numbers[j] = getImage(getCodeBase(), IMG_PATH + countStr.charAt(j) + EXTENSION);
            md.addImage(numbers[j], 1);
            try {
              md.waitForID(1);
            }
            catch (InterruptedException e) {}
          }
        }
      }
    }
    backColor = new Color(getIntParam("backColor", 16, 0xd2e9ff));

    drawOffscreenImage(); /* call draw offscreen image method (once a time) */
  }

  /**
    * draw text at offscreen image buffer with smooth 3D effect
   */
  private void draw3Dtext(String s, int x, int y) {
    gb.setColor(Color.white);
    gb.drawString(s, x+1, y+1);
    gb.setColor(
      new Color(
        getIntParam("fontColor", 16, backColor.darker().getRGB())));
    gb.drawString(s, x, y);
  }

  /**
    * Draw offscreen image as possible; primarily using your preferences
    * but if not possible self draw the image or warn about connection
    * fault without annoying gray box.
    * As you can see and check, self drawing still produces an interesting
    * image, is faster to draw since there are no images to download and
    * is partially parameter dependent (due to differences on each platform).
   */
  private void drawOffscreenImage() {
    if (ndigs > 0) {
      if (!defaultDrawing && (md.statusAll(false) & MediaTracker.ERRORED) == 0) {
        while (!md.checkAll());
        if ((md.statusAll(false) & MediaTracker.COMPLETE) != 0) {
          /* DRAW USER PREFERRED IMAGES */
          gb.setColor(backColor);
          gb.fillRect(0, 0, Width, Height);
          int dx = getIntParam("intraGap", 10, 2); /* distance between images */
          int vi = getIntParam("leftIndent", 10, 12); /* left indentation */
          /* assume homogeneous size for all digit images */
          int ww = numbers[0].getWidth(this);
          /* calculate horizontal drawing origin to center digits images */
          int ix = vi + ((Width - vi - ndigs * (ww + dx) + dx) >> 1);
          /* increment for each digit drawing */
          dx += ww;
          /* digits images are vertical centereds */
          int iy = (Height - numbers[0].getHeight(this)) >> 1;
          /* background image perfect fits applet panel */
          gb.drawImage(backImg, 0, 0, this);
          /* topmost foreground images: all digits */
          for (int j=0, x=ix; j < ndigs; j++) {
            gb.drawImage(numbers[j], x, iy, this);
            x += dx;
          }
          return; /* target drawing finished */
        }
      }
      /* must to use default drawing due to image download fault */
      countStr = "# " + countStr;
    }
    else {
      /* must to use default drawing due to CGI script/connection fault */
      countStr = "Conn Fault";
    }
    /* DRAW ALL DETAILS IF COULDN'T DOWNLOAD IMAGES, CONNECTION FAULT or USER CHOICE */
    /* draw background box like Swing does */
    gb.setColor(backColor);
    gb.fillRect(0, 0, Width, Height);
    gb.setColor(Color.white);
    gb.drawRect(1, 1, Width-2, Height-2);
    gb.setColor(backColor.darker());
    gb.drawRect(0, 0, Width-2, Height-2);
    /* draw applet name */
    Font ft = new Font(getStringParam("fontName", "Lucida Sans"), Font.BOLD, 9);
    FontMetrics fm = getFontMetrics(ft);
    gb.setFont(ft);
    draw3Dtext(appName, (Width - fm.stringWidth(appName)) >> 1, fm.getAscent() + 2);
    /* draw counter value */
    /* ft = ft.deriveFont(Font.BOLD, 11); /* JRE 1.2 or higher */
    ft = new Font(getStringParam("fontName", "Lucida Sans"), Font.BOLD, getIntParam("fontSize", 10, 11));
    fm = getFontMetrics(ft);
    gb.setFont(ft);
    draw3Dtext(countStr, (Width - fm.stringWidth(countStr)) >> 1, ((Height + fm.getAscent()) >> 1) + 2);
  }

}