#!/usr/local/bin/perl
####################################################### 
#postcard.pl 1.4					
#											
#by Command-O Software						
#http://www.command-o.com	
#				
#Programmer: Kendall Comey, kendall@command-o.com		 
#										
#Copyright, 1997, All Rights Reserved				
#
#By using this script Licensee agrees to all terms of the License 
#Agreement.								
#
#If you find this script useful, we would appreciate a 
#donation to keep this service active for the community.
#Command-O Software, P.O. Box 12200, Jackson WY 83002
#######################################################
# Client Customization Variables

#Set the correct paths, if cgi-lib.pl and postcard.setup are not in cgi-bin. 
require 'cgi-lib.pl';
require 'postcard.setup';

############################################################
# CHANGING ANYTHING BELOW THIS LINE WITHOUT THE EXPRESS PERMISSION	
#  OF COMMAND-O SOFTWARE IS A VIOLATION OF THE LICENSE AGREEMENT	 
############################################################

#Turn off Perl buffering
$| = 1;

#Read and parse the form data
&ReadParse(*input);

#Assign variables 

$date = `$date_command +"%D"`; 
$date =~ s/\n*$//;
$current_date = $date;
$test = 0;
$time = time;
$cardlist_temp = "$cardlist" . "_" . "temp";

if ($input{'send'} ne "") {
print "Location: $url_of_postcard_html", "\n\n";
}
elsif ($input{'pickup'} ne "") {
print "Location: $url_of_pickup_html", "\n\n";
}
elsif ($input{'preview'} ne "") {
	print &PrintHeader;
	&check_required;
	&select_card_number;
	&print_preview;
}
elsif ($input{'submit'} ne "")	{
	print &PrintHeader;
	&send_card;
	&delete_old_cards;

}
elsif ($ENV{'QUERY_STRING'} ne "")	{
	print &PrintHeader;
	&pickup_card;
}

#########################################################################
sub delete_old_cards	{
$current_time = time;

$delete_date = $current_time - ($days * 86400); 

open (TEMP, ">$cardlist_temp") || die ("Could not open $cardlist_temp");
flock (TEMP, 2);
open (CARD, "$cardlist") || die ("Could not open $cardlist");
flock (CARD, 2);
	while (<CARD>)	{
	($number, $from, $from_email, $message, $to, $notify, $image, $date_time, $date) = split(/\|/, $_);
		if ($delete_date < $date_time)	{
		print TEMP "$_";
		}
	}
flock (CARD, 8);
flock (TEMP, 8);
close (TEMP);
close (CARD);
rename ($cardlist_temp, $cardlist);
}

############################################################
sub check_required	{
if ($input{'address'} eq "")	{
print "You must specify the email address of the recipient in order for this ";
print "postcard to be sent. Please use the back button on your browser to ";
print "enter the email address and then submit the postcard again. Thank you.";
exit;
}
unless ($input{'address'} =~ /^[\w-.]+\@[\w-.]+$/)	{
print "Invalid email address. Please use the back button on your browser to ";
print "enter the correct email address and then submit the postcard again. ";
print "Thank you.";
exit;
}
if ($input{'name'} eq "")	{
print "You must specify a name for the recipient of this postcard in order for this ";
print "postcard to be sent. Please use the back button on your browser to ";
print "enter the name of the recipient and then submit the postcard again. Thank 
you.";
exit;
}
if ($input{'sender'} eq "") {
print "You must specify a name for the sender of this postcard in order for this ";
print "postcard to be sent. Please use the back button on your browser to ";
print "enter the name of the sender and then submit the postcard again. Thank you.";
exit;
}
if ($input{'notify'} ne "" && $input{'senderemail'} eq "")	{
print "You must enter your email address in order to be notified when your postcard ";
print "is picked up. Please use the back button on your browser to ";
print "enter your email address or deselect the notification checkbox and then ";
print "submit  the postcard again. Thank you.";
exit;
}
if ($input{'senderemail'} ne "")	{
unless ($input{'senderemail'} =~  /^[\w-.]+\@[\w-.]+$/) {
print "Invalid email address. Please use the back button on your browser to ";
print "enter the correct email address and then submit the postcard again. ";
print "Thank you.";
exit;
}
}
}

############################################################
#Preview postcard
sub print_preview	{
open (PAGE, "$preview_postcard") || die ("I am sorry, but I was unable to open the 
file $preview_postcard.");
	while (<PAGE>)		{
	s/%%date%%/$date/g;
	s/%%name%%/$input{'name'}/g;
	s/%%sender%%/$input{'sender'}/g;
	s/%%message%%/$input{'message'}/g;
	s/%%address%%/$input{'address'}/g;
	s/%%senderemail%%/$input{'senderemail'}/g;
	s/%%notify%%/$input{'notify'}/g;
	s/%%image%%/$image/g;
	print $_;
	}
	close (PAGE);
}

############################################################
#Put in the correct photograph
sub select_card_number {
$image = $input{'card_number'};
}

############################################################
sub send_card	{
#Assign a userid
srand (time|$$);
$userid = int (rand(1000));
$userid .= "$$";

#Print out thank you message
open (PAGE, "$thank_you") || die ("I am sorry, but I was unable to open the file 
$thank_you.");
while (<PAGE>)		{
	s/%%name%%/$input{'name'}/g;
	print $_;
}
close (PAGE);

#Write form data to file
open (DATABASE, ">>$cardlist") || die ("I am sorry, but I was unable to open the file.");

#Remove any pipe symbols from input
$input{'sender'} =~ s/\|//g;
$input{'message'} =~ s/\|//g;
$input{'name'} =~ s/\|//g; 
$input{'senderemail'} =~ s/\|//g;
$input{'message'} =~ s/\s+/ /g;

flock (DATABASE, 2);

print DATABASE "$userid\|$input{'sender'}\|$input{'senderemail'}\|$input{'message'}\|";
print DATABASE "$input{'name'}\|$input{'notify'}\|$input{'card_number'}\|$time\|$date\n";

flock (DATABASE, 8);
close (DATABASE);

#Send e-mail to recipient
open (MAIL, "|$mailprog $input{'address'}") || die "Can't open $mailprog!\n";
	print MAIL "Reply-to: $input{'senderemail'}\n";
	print MAIL "From: $input{'senderemail'}\n";
	print MAIL "To: $input{'address'}\n";
	print MAIL "Subject: $subject\n\n";
open (PAGE, "$mail_message") || die ("I am sorry, but I was unable to open the file 
$thank_you.");
	while (<PAGE>)		{
	s/%%sender%%/$input{'sender'}/g;
	s/%%userid%%/$userid/g;
	print MAIL $_;
	}
close (PAGE);
close (MAIL);
}

############################################################
sub pickup_card {
#Open card.list file
open (DATABASE, "$cardlist") || &CgiDie ("I am sorry, but I was not able to open the 
data file.");
flock (DATABASE, 2);
#Assign database to list array
	@list = <DATABASE>;
flock (DATABASE, 8);
close (DATABASE);

#Split array into scalar variables 
foreach $list (@list) {
($userid, $sender, $senderemail, $message, $name, $notify, $image, $date_time, $date) = split 
(/\|/, $list);

#Compare form input to $userid
if ($input{'id_num'} eq $userid && $input{'id_num'} ne "") {
$test = 1;
&print_html;
if ($notify eq "on") {
&notify;
}
last;
}
}

if ($test == 0) {
&invalid_id;
}
}
############################################################
sub print_html {
open (PAGE, "$show_postcard") || die ("I am sorry, but I was unable to open the file 
$thank_you.");
	while (<PAGE>)		{
	s/%%sender%%/$sender/g;
	s/%%date%%/$date/g;
	s/%%name%%/$name/g;
	s/%%message%%/$message/g;
	s/%%image%%/$image/g;
	print  $_;
			}
close (PAGE);
}

############################################################
#Send e-mail to sender
sub notify {
$date =~ s/\n*$//;
open (MAIL, "|$mailprog $senderemail") || die "Can't open $mailprog!\n";
print MAIL "Reply-to: $reply_to\n";
print MAIL "From: $reply_to\n";
   print MAIL "To: $senderemail\n";
   print MAIL "Subject: Postcard Picked-up\n\n";
   print MAIL "The postcard you sent to $name, from $company, was picked up on ";
print MAIL "$date. \nThank you.";
close (MAIL);
}

############################################################
#Invalid user message
sub invalid_id {
print <<EOT;
Sorry, but you have entered an invalid card ID number. Please use the back button 
on your browser to re-enter the correct card ID.
EOT
exit;
}

