#!/usr/bin/perl

##############################################################################
# If you encounter problems while trying to configure this script, help      #
# is available.  In order to get your problem solved:                        #
#       1) Read this file thoroughly                                         #
#       2) Consult the THANKS-CGI Frequently Asked Questions:                #
#               http://www.thanks-cgi.com/faq/                               #
#       3) If you are still having difficulty installing this script, send   #
#          e-mail to: support@thanks-cgi.com                                 #
#          Include any error messages you are receiving and as much detail   #
#          as you can so we can spot your problem.                           #
#                                                                            #
# Hopefully we will be able to help you solve your problems.  Thank you.     #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 THANKS-CGI All Rights Reserved.                             #
#  Not for re-sell or re-distribution.                                       #
##############################################################################

# Setup

$cgiurl    = "http://www.yourdomain.com/cgi-bin/card.cgi"; # The URL of "card.cgi".
$filehead  = "/home/yourdomain/card/"; # The full filepath of database and text files. If you don't know, you have to contact your server.

$samplepage   = "samplepage.htm"; # The page of CARD review.
$succpage     = "succpage.htm";   # The page of page after send out the card.
$errorpage    = "errorpage.htm";  # The page to show ERROR message.

$cardurl      = "http://www.thanks-cgi.com/card/store/";     # The URL of where card's information are stored.
$cardfilehead = "/home/yourdomain/card/store/"; # The full filepath of where cards are stored. If you don't know, you have to contact your server.

$mailendingfile ="mailending.txt"; # The footnote of E-mail.

$time_miss = +12; # TIME ZONE ADJUSTMENT
$keep_days = 30;  # Days to keep the record of card.

$allow_html=1; # Allows visitors to use HTML. 1=enable 0=disable

$deadletter   = "yourdomain.com";           # The server produce "dead.letter", usually is your own domain or the server you host with.
$masteremail  = "yourname\@yourdomain.com"; # Your E-mail.
$mailprg      = "/bin/sendmail -t";         # The path of E-mail system on your server. Contact your server if you don't know. DO NOT TAKE AWAY "-t"!

$sendtomaster = 1; # Auto notify webmaster when new registration. 1=ENABLE 0=DISABLE
# SetUp End
#############
&get_form;
&set_var;

print "Content-type: text/html\n\n";
if ($job eq "see") {
   &checkempty($fromname,"Sender's name can't be empty!");
   &checkempty($fromemail,"Sender's E-mail can't be empty!");
   &checkempty($toname,"Receiver's name can't be empty!");
   &checkempty($toemail,"Receiver's E-mail can't be empty!");
   &checkempty($card,"You have to select a card!");
   &checkempty($midi,"You have to select a MIDI music!");
   &checkempty($subject,"You have to make a title!");
   &checkempty($message,"You have to write some messages!");
   &checkempty($backcolor,"You forgot to select the background color!");
   &checkempty($wordcolor,"You forgot to select the text color!");

   if ($fromemail =~ /$deadletter/) {&error("Sender's E-mail is forbidden!");} 
   if ($toemail =~ /$deadletter/) {&error("Receiver's E-mail is forbidden!");} 

   @samplepage=&readtxtfile("$filehead$samplepage");
   foreach (@samplepage) {
      if ($_ =~ /<!--actionhere-->/) {
         print "<form action=$cgiurl method=post>\n";
         print "<input type=hidden name='job' value='makesend'>\n";
         print "<input type=hidden name='fromname' value='$fromname'>\n";
         print "<input type=hidden name='fromemail' value='$fromemail'>\n";
         print "<input type=hidden name='toname'  value='$toname'>\n";
         print "<input type=hidden name='toemail' value='$toemail'>\n";
         print "<input type=hidden name='card' value='$card'>\n";
         print "<input type=hidden name='midi' value='$midi'>\n";
         print "<input type=hidden name='subject' value='$subject'>\n";
         print "<input type=hidden name='message' value='$message'>\n";
         print "<input type=hidden name='backcolor' value='$backcolor'>\n"; 
         print "<input type=hidden name='wordcolor' value='$wordcolor'>\n"; 
         print "<input type=submit value='SURE! SENT IT OUT!'><input type=button value='MODIFY IT!' onclick='history.go(-1);'>\n";
      }
      else {
         $_ =~ s/\$fromname/$fromname/g;
         $_ =~ s/\$fromemail/$fromemail/g;
         $_ =~ s/\$toname/$toname/g;
         $_ =~ s/\$toemail/$toemail/g;
         $_ =~ s/\$card/$card/g;
         $_ =~ s/\$midi/$midi/g;
         $_ =~ s/\$subject/$subject/g;
         $_ =~ s/\$message/$message/g;
         $_ =~ s/\$backcolor/$backcolor/g;
         $_ =~ s/\$wordcolor/$wordcolor/g;
         print;
      }  
   }
}
elsif ($job eq "makesend") {
   &checkempty($fromname,"Sender's name can't be empty!");
   &checkempty($fromemail,"Sender's E-mail can't be empty!");
   &checkempty($toname,"Receiver's name can't be empty!");
   &checkempty($toemail,"Receiver's E-mail can't be empty!");
   &checkempty($card,"You have to select a card!");
   &checkempty($midi,"You have to select a MIDI music!");
   &checkempty($subject,"You have to make a title!");
   &checkempty($message,"You have to write some messages!");
   &checkempty($backcolor,"You forgot to select the background color!");
   &checkempty($wordcolor,"You forgot to select the text color!");

   if ($fromemail =~ /$deadletter/) {&error("Sender's E-mail is forbidden!");} 
   if ($toemail =~ /$deadletter/) {&error("Receiver's E-mail is forbidden!");} 

   $|=1;

   $newcardno="$newcardno\.htm";

   @samplepage=&readtxtfile("$filehead$samplepage");
   open(CARD,">$cardfilehead$newcardno");
   foreach (@samplepage) {
      if ($_ =~ /<!--actionhere-->/) {
         print CARD "<b>[</b><a href=http://www.thanks-cgi.com target='_top'>This E-CARD provide by THANKS-CGI</a><b>]</b>\n";
      }
      else { 
         $_ =~ s/\$fromname/$fromname/g;
         $_ =~ s/\$fromemail/$fromemail/g;
         $_ =~ s/\$toname/$toname/g;
         $_ =~ s/\$toemail/$toemail/g;
         $_ =~ s/\$card/$card/g;
         $_ =~ s/\$midi/$midi/g;
         $_ =~ s/\$subject/$subject/g;
         $_ =~ s/\$message/$message/g;
         $_ =~ s/\$backcolor/$backcolor/g;
         $_ =~ s/\$wordcolor/$wordcolor/g;
         print CARD "$_";
      }
   } 
   close(CARD);

   sleep 3;

   if ($sendtomaster==1) {
      open (TEMP,"| $mailprg") || die "Mail system error";
      print TEMP "To: $masteremail\n";
      print TEMP "Subject: E-CARD from the THANKS-CGI\n";
      print TEMP "From: $masteremail\n";
      print TEMP "======================================\n";
      print TEMP "URL: $cardurl$newcardno\n";
      print TEMP "From: $fromname E-mail: $fromemail\n";
      print TEMP "To: $toname E-mail: $toemail\n";
      print TEMP "Card: $card\n";
      print TEMP "MIDI: $midi\n";
      print TEMP "Title: $subject\n";
      print TEMP "Message: $message\n";
      print TEMP "BACKGROUND: $backcolor\n";
      print TEMP "TEXT COLOR: $wordcolor\n";
      print TEMP "======================================\n";
      print TEMP "IP=$userip AT $daten\n"; 
      print TEMP "$cgiurl\n";
      print TEMP "======================================\n";
      print TEMP "\n\n";
      close(TEMP); 
   }

   @mailending=&readtxtfile("$filehead$mailendingfile");

   open (TEMP,"| $mailprg") || die "Mail system error";
   print TEMP "To: $toemail\n";
   print TEMP "Cc: $fromemail\n";
   print TEMP "Subject: $subject\n";
   print TEMP "From: $fromemail\n";
   print TEMP "======================================\n";
   print TEMP "Hi! $toname,\n";   
   print TEMP "You have received a E-CARD from someone special......\n";   
   print TEMP "Please point to $cardurl$newcardno to get your own E-CARD!\n";
   foreach (@mailending) {print TEMP "$_";} 
   print TEMP "\n======================================\n";
   print TEMP "IP=$userip AT $daten\n"; 
   print TEMP "======================================\n";
   print TEMP "\n\n";
   close(TEMP);  

   &succ("Your E-CARD has been send out!");

#   while (glob("$cardfilehead/*")) {
#      $age=int((-C $_));
#      if ($age>$keep_days) {
#         unlink $_;
#      }
#   }
}
exit 0;
##########
sub set_var {
$job       =&get_var('job'      ,'\n|');
$fromname  =&get_var('fromname' ,'\n|');
$fromemail =&get_var('fromemail','\n|');
$toname    =&get_var('toname'   ,'\n|');
$toemail   =&get_var('toemail'  ,'\n|');
$card      =&get_var('card'     ,'\n|');
$midi      =&get_var('midi'     ,'\n|');
$backcolor =&get_var('backcolor','\n|');
$wordcolor =&get_var('wordcolor','\n|');
$subject   =&get_var('subject'  ,'\n|');
$message   =&get_var('message'  ,'');
$message   =~ s/\n/<br>/g;

$fromemail="" if (!($fromemail =~ /(.*)\@(.*)\.(.*)/));
$toemail="" if (!($toemail =~ /(.*)\@(.*)\.(.*)/));

$userip=$ENV{'REMOTE_ADDR'};

($secn,$minn,$hourn,$dayn,$monn,$yearn,$weekn,$yeardayn,$isdst)=localtime(time+(3600*$time_miss));
$monn=$monn+1;
if ($monn<10)  {$monn="0$monn";}
if ($dayn<10)  {$dayn="0$dayn";}
if ($hourn<10) {$hourn="0$hourn";}
if ($minn<10)  {$minn="0$minn";}
if ($secn<10)  {$secn="0$secn";}
$daten    ="$yearn/$monn/$dayn($hourn\:$minn\:$secn)";
$newcardno="$yearn$monn$dayn$hourn$minn$secn";
}
##########
sub get_form {
@querys = split(/&/, $ENV{'QUERY_STRING'});
foreach (@querys) {
  ($name,$value) = split(/=/, $_);
  &setvaluetoform($name, $value); 
}

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach (@pairs) {
  ($name, $value) = split(/=/, $_);
  &setvaluetoform($name, $value); 
}
}
##########
sub setvaluetoform {
$name=$_[0];
$value=$_[1];
$name=&decode($name);
$name=&filterhtml($name);
$value=&decode($value);
$value=&filterhtml($value);
if ($FORM{$_[0]}) {$FORM{$_[0]}="$FORM{$_[0]}$_[1]";}
else {$FORM{$_[0]}=$_[1];}
}
##########
sub decode {
local($return)=$_[0];
$return =~ tr/+/ /;
$return =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
return $return;
}
#########
sub filterhtml {
local($return)=$_[0];
$return =~ s/<!--(.|\n)*-->//g;
if ($allow_html != 1) {
   $return =~ s/<([^>]|\n)*>//g;
   $return =~ s/<//g;
}
return $return;
}
#########
sub get_var {
local($return)="";
$return="$FORM{$_[0]}" if ($FORM{$_[0]});
$return=~ s/$_[1]//g;
return $return;
}
#########
sub readtxtfile {
open(READTXTFILE,"$_[0]");
#flock(READTXTFILE,$_[1]) if ($_[1]); 
@readtxtfile=<READTXTFILE>;
#flock(READTXTFILE,8) if ($_[1]);
close(READTXTFILE);
return @readtxtfile;
}
#########
sub checkempty {
local($chkval)=$_[0];
$chkval =~ s/ |<br>|\n//g;
&error($_[1]) if ($chkval eq "");
}
#########
sub error {
@errorpage=&readtxtfile("$filehead$errorpage");
foreach (@errorpage) {
   $_ =~ s/\$errormessage/$_[0]/g;
   print;
}
exit 0;
}
#########
sub succ {
@succpage=&readtxtfile("$filehead$succpage");
foreach (@succpage) {
   $_ =~ s/\$succmessage/$_[0]/g;
   print;
}
exit 0;
}
