<% Option Explicit %>
<% 
'****************************************************************************************
'**  Copyright Notice    
'**
'**  Web Wiz Guide Site Search Engine
'**                                                              
'**  Copyright 2001-2002 Bruce Corkhill All Rights Reserved.                                
'**
'**  This program is free software; you can modify (at your own risk) any part of it 
'**  under the terms of the License that accompanies this software and use it both 
'**  privately and commercially.
'**
'**  All copyright notices must remain in tacked in the scripts and the 
'**  outputted HTML.
'**
'**  You may use parts of this program in your own private work, but you may NOT
'**  redistribute, repackage, or sell the whole or any part of this program even 
'**  if it is modified or reverse engineered in whole or in part without express 
'**  permission from the author.
'**
'**  You may not pass the whole or any part of this application off as your own work.
'**   
'**  All links to Web Wiz Guide and powered by logo's must remain unchanged and in place
'**  and must remain visible when the pages are viewed unless permission is first granted
'**  by the copyright holder.
'**
'**  This program is distributed in the hope that it will be useful,
'**  but WITHOUT ANY WARRANTY; without even the implied warranty of
'**  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR ANY OTHER 
'**  WARRANTIES WHETHER EXPRESSED OR IMPLIED.
'**
'**  You should have received a copy of the License along with this program; 
'**  if not, write to:- Web Wiz Guide, PO Box 4982, Bournemouth, BH8 8XP, United Kingdom.
'**    
'**
'**  No official support is available for this program but you may post support questions at: -
'**  http://www.webwizguide.info/forum
'**
'**  Support questions are NOT answered by e-mail ever!
'**
'**  For correspondence or non support questions contact: -
'**  info@webwizguide.com
'**
'**  or at: -
'**
'**  Web Wiz Guide, PO Box 4982, Bournemouth, BH8 8XP, United Kingdom
'**
'****************************************************************************************



'Set the response buffer to true
Response.Buffer = False

'Dimension global variables
Dim fsoObject			'File system object
Dim fldObject			'Folder object	
Dim sarySearchWord		'Array to hold the words to be searched for
Dim strSearchWords		'Holds the search words
Dim blnIsRoot			'Boolean set to true if it is the root dirctory
Dim strFileURL			'Holds the path to the file on the site
Dim strServerPath		'Holds the server path to this script
Dim intNumFilesShown		'Holds the number of files shown so far
Dim intTotalFilesSearched	'Holds the number of files searched
Dim intTotalFilesFound		'Holds the total matching files found
Dim intFileNum			'Holds the file number
Dim intPageLinkLoopCounter	'Loop counter to display links to the other result pages
Dim sarySearchResults(1000)	'Array holding the search results
Dim intDisplayResultsLoopCounter 'loop counter to diplay the results of the search
Dim intResultsArrayPosition	'Stores the array position of the array storing the results
Dim blnSearchResultsFound	'Set to true if search results are found
Dim strFilesTypesToSearch	'Holds the types of files to be searched
Dim strBarredFolders		'Holds the folders that you don't want searched
Dim strBarredFiles		'Holds the names of the files not to be searched
Dim blnEnglishLanguage		'Set to True if the user is using English




' -------------------------- Change the following line to the number of results you wish to have on each page ------------------------------------
Const intRecordsPerPage = 10 'change this to the number of results to show on each page

' --------------------- Place the names of the files types you want searching in the following line sepeararted by commas --------------------------
strFilesTypesToSearch = "htm,html,asp,shtml" 

' --------------------- Place the names of the folders you don't want searched in the following line spearated by commas --------------------------
strBarredFolders = "cgi_bin,_bin" 'cgi_bin and _bin have been put in here as examples, but you can put any folders in here

' ---------- Place the names of the files you don't want searched in the following line spearated by commas include the file extension -------------
strBarredFiles = "adminstation.htm,no_allowed.asp" 'adminstration.htm and not_allowed.asp have been put in as an examples

' -------------------- Set this boolean to False if you are not using an English language web site --------------------------------------------------
blnEnglishLanguage = True 'True = HTML Encode best for English sites \ False = no HTML Encoding best for non English sites

'-----------------------------------------------------------------------------------------------------------------------------------------------------


'Initalise variables
intTotalFilesSearched = 0

%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Search the Website</title>
<meta name="description" content="Search the web site for pages or information that you are after">

<!-- The Web Wiz Guide advanced site search engine is written and produced by Bruce Corkhill 2001
     	If you want your own site search engine then goto http://www.webwizguide.info --> 
       
       
<!-- Check the from is filled in correctly before submitting -->
<script  language="JavaScript">
<!-- Hide from older browsers...

//Preload search icon
var search_icon_off = new Image(); 
search_icon_off.src = "site_search_icon_off.gif";

//Check the form before submitting
function CheckForm () {

	//Check for a word to search
	if (document.frmSiteSearch.search.value==""){
		alert("Please enter at least one keyword to search");
		document.frmSiteSearch.search.focus();
		return false;
	}
	
	return true
}
// -->
</script>
       
</head>
<body bgcolor="#FFFFFF" text="#000000" link="#0000CC" vlink="#0000CC" alink="#FF0000">
<h1 align="center">Site Search Engine</h1>
  
<form method="get" name="frmSiteSearch" action="site_search.asp" onSubmit="return CheckForm();">
  <table cellpadding="0" cellspacing="0" width="90%" align="center">
    <tr> 
      
   <td height="66" width="165" align="right" rowspan="3" valign="middle"><img src="site_search_icon_on.gif" width="58" height="52" align="absmiddle" alt="Search the Web Site" name="searchIcon"> 
   </td>
      <td height="66" width="15" align="right" rowspan="3" valign="middle">&nbsp;</td>
      <td height="4" width="571"> Search the Web Site: </td>
    </tr>
    <tr> 
      <td height="2" width="571">
      <input type="TEXT" name="search" maxlength="50" size="36" value="<% =Request.QueryString("search") %>">
        <input type="submit" value="Search &gt;&gt;" name="submit">
        </td>
    </tr>
    <tr> 
      <td height="34" width="571" valign="top"> Search On : 
        <input type="radio" name="mode" value="allwords" CHECKED>
        All Words 
        <input type="radio" name="mode" value="anywords">
        Any Words 
        <input type="radio" name="mode" value="phrase">
        Phrase</td>
    </tr>
  </table>
</form>
<%

'Read in all the search words into one variable
strSearchWords = Trim(Request.QueryString("search"))

'If the site is in English then use the server HTML encode method
If blnEnglishLanguage = True Then
	'Replace any HTML tags with the HTML codes for the same characters (stops people entering HTML tags)
	strSearchWords = Server.HTMLEncode(strSearchWords)

'If the site is not english just change the script tags
Else
	'Just replace the script tag <> with HTML encoded &lt; and &gt;
	strSearchWords = Replace(strSearchWords, "<", "&lt;", 1, -1, 1)
	strSearchWords = Replace(strSearchWords, ">", "&gt;", 1, -1, 1)
End If

'Slit each word to be searched up and place in an array
sarySearchWord = Split(Trim(strSearchWords), " ")



'Read the file number to show from
intFileNum = CInt(Request.QueryString("FileNumPosition"))

'Set the number of files shown so far to the file number read in above
intNumFilesShown = intFileNum


'Create the file system object
Set fsoObject = Server.CreateObject("Scripting.FileSystemObject")


'If there is no words entered by the user to search for then dont carryout the file search routine
If NOT strSearchWords = "" Then


	'Get the path and the root folder to be searched
	Set fldObject = fsoObject.GetFolder(Server.MapPath("./"))
	
	'Read in the server path to this ASP script
	strServerPath = fldObject.Path & "\"
	
	'Set to true as this is searching the root directory
	blnIsRoot = True
		
	'Call the search sub prcedure
	Call SearchFile(fldObject)
			
	
	'Reset server variables
	Set fsoObject = Nothing
	Set fldObject = Nothing
	

	
	'Display the HTML table with the results status of the search or what type of search it is
	Response.Write vbCrLf & "	<table width=""98%"" border=""0"" cellspacing=""1"" cellpadding=""1"" align=""center"" bgcolor=""#CCCCCC"">"
	Response.Write vbCrLf & " 	  <tr>"
	
	'Display that there where no matching records found
	If blnSearchResultsFound = False Then 
		Response.Write vbCrLf & " 	    <td>&nbsp;Searched the site for <b>" & strSearchWords & "</b>. &nbsp;&nbsp;&nbsp;Sorry, no results found.</td>"   
	
	'Else Search went OK so display how many records found
	Else	
		Response.Write vbCrLf & " 	    <td>&nbsp;Searched the site for <b>" & strSearchWords & "</b>. &nbsp;&nbsp;&nbsp;Displaying Results " & intFileNum + 1 & " - " & intNumFilesShown & " of " & intTotalFilesFound & ".</td>"	    
	End If
	
	'Close the HTML table with the search status
	Response.Write vbCrLf & "	  </tr>"
	Response.Write vbCrLf & "	</table>"
	
	
	
	
	'HTML table to display the search results or an error if there are no results
	Response.Write vbCrLf & "	<table width=""95%"" border=""0"" cellspacing=""1"" cellpadding=""1"" align=""center"">"
	Response.Write vbCrLf & "	 <tr>" 
	Response.Write vbCrLf & "	  <td>"   
	
	'If no results are found then display an error message
	If blnSearchResultsFound = False Then 
	
		'Write HTML displaying the error
		Response.Write vbCrLf & "	  <br>"
		Response.Write vbCrLf & "	   Your Search - <b>" & strSearchWords & "</b> - did not match any files on this site."
	   	Response.Write vbCrLf & "	   <br><br>"
	   	Response.Write vbCrLf & "	   Suggestions:"
	   	Response.Write vbCrLf & "	   <br>"
	   	Response.Write vbCrLf & "	   <ul><li>Make sure all words are spelled correctly.<li>Try different keywords.<li>Try more general keywords.<li>Try fewer keywords.</ul>"
	
	'Else display the results
	Else
		
		'Loop round to display each result within the search results array
		For intDisplayResultsLoopCounter = 1 to (intNumFilesShown - intFileNum)
		
			Response.Write vbCrLf & "	<br>"
			Response.Write vbCrLf & "	    " & sarySearchResults(intDisplayResultsLoopCounter)
			Response.Write vbCrLf & "	<br>"
		Next
	End If
	
	'Close the HTML table displaying the results
	Response.Write vbCrLf & "	    </td>"
	Response.Write vbCrLf & "	  </tr>"
	Response.Write vbCrLf & "	</table>"

End If




 
'Display an HTML table with links to the other search results
If intTotalFilesFound > intRecordsPerPage then

	'Display an HTML table with links to the other search results
	Response.Write vbCrLf & "	<br>"
	Response.Write vbCrLf & "	<table width=""100%"" border=""0"" cellspacing=""0"" cellpadding=""0"" align=""center"">"
	Response.Write vbCrLf & " 	  <tr>"
	Response.Write vbCrLf & " 	    <td>"
	Response.Write vbCrLf & "		<table width=""100%"" border=""0"" cellpadding=""0"" cellspacing=""0"">"
	Response.Write vbCrLf & "		  <tr>"
	Response.Write vbCrLf & "		    <td width=""50%"" align=""center"">"
	
	Response.Write vbCrLf & "		Results Page:&nbsp;&nbsp;"
	
		
	'If the page number is higher than page 1 then display a back link    	
	If intNumFilesShown > intRecordsPerPage Then 
		Response.Write vbCrLf & "		 <a href=""site_search.asp?FileNumPosition=" &  intFileNum - intRecordsPerPage  & "&search=" & Replace(strSearchWords, " ", "+") & "&mode=" & Request.QueryString("mode") & """ target=""_self"">&lt;&lt;&nbsp;Prev</a> "   	     	
	End If     	
	
	
	'If there are more pages to display then display links to all the search results pages
	If intTotalFilesFound > intRecordsPerPage Then 
		
		'Loop to diplay a hyper-link to each page in the search results    	
		For intPageLinkLoopCounter = 1 to CInt((intTotalFilesFound / intRecordsPerPage) + 0.5)
			
			'If the page to be linked to is the page displayed then don't make it a hyper-link
			If intFileNum = (intPageLinkLoopCounter * intRecordsPerPage) - intRecordsPerPage Then
				Response.Write vbCrLf & "		     " & intPageLinkLoopCounter
			Else
			
				Response.Write vbCrLf & "		     &nbsp;<a href=""site_search.asp?FileNumPosition=" &  (intPageLinkLoopCounter * intRecordsPerPage) - intRecordsPerPage & "&search=" & Replace(strSearchWords, " ", "+") & "&mode=" & Request.QueryString("mode") & """ target=""_self"">" & intPageLinkLoopCounter & "</a>&nbsp; "			
			End If
		Next
	End If
	
	
	'If it is Not the last of the search results than display a next link     	
	If intTotalFilesFound > intNumFilesShown then   	
		Response.Write vbCrLf & "		&nbsp;<a href=""site_search.asp?FileNumPosition=" &  intNumFilesShown  & "&search=" & Replace(strSearchWords, " ", "+") & "&mode=" & Request.QueryString("mode") & """ target=""_self"">Next&nbsp;&gt;&gt;</a>"	   	
	End If      	
	
	
	'Finsh HTML the table      	
	Response.Write vbCrLf & "		    </td>"      	
	Response.Write vbCrLf & "		  </tr>"
	Response.Write vbCrLf & "		</table>"		
	Response.Write vbCrLf & "	    </td>"
	Response.Write vbCrLf & "	  </tr>"
	Response.Write vbCrLf & "	</table>"
	
 
End If 

%>
 <br>
 <div align="center">
    
  <table width="98%" border="0" cellspacing="1" cellpadding="1" bgcolor="#CCCCCC" align="center">
    <tr> 
        <td width="47%" height="18">&nbsp;Searched <% = intTotalFilesSearched  %> documents in total. </td>
        <td width="53%" align="right" height="18"><%				  
'***** START WARNING - REMOVAL OR MODIFICATION OF THIS CODE WILL VIOLATE THE LICENSE AGREEMENT ****** 
Response.Write("		Powered By - <a href=""http://www.webwizguide.info"" target=""_blank"">www.webwizguide.info</a>")
'***** END WARNING - REMOVAL OR MODIFICATION OF THIS CODE WILL VIOLATE THE LICENSE AGREEMENT ****** 
%></tr>
    </table>
     <!-- Swap animated search icon for still icon -->
    <script langauge="JavaScript">document.searchIcon.src = search_icon_off.src</script>
    <br>
  <a href="http://www.webwizguide.info" target="_blank"><img src="web_wiz_guide.gif" width="100" height="30" border="0" alt="Web Wiz Guide!"></a></div>
<br>
</body>
</html>
<%



'Sub procedure to do the search
Public Sub SearchFile(fldObject)

	'Dimension local variabales
	Dim filObject				'File object
	Dim tsObject				'Text stream object
	Dim subFldObject			'Sub folder object
	Dim RegExpObject			'RegExp Object
	Dim strFileContents			'Holds the contents of the file being searched	
	Dim strPageTitle			'Holds the title of the page
	Dim intTitleStartPositionInFile		'Holds the start postion in the file being searched of the title
	Dim intTitleEndPositionInFile		'Holds the end postion in the file being searched of the title
	Dim strPageDescription			'Holds the description of the page
	Dim intDescriptionStartPositionInFile	'Holds the start postion in the file being searched of the description
	Dim intDescriptionEndPositionInFile	'Holds the end postion in the file being searched of the description
	Dim intSearchLoopCounter		'Loop counter to search all the words in the array
	Dim blnSearchFound			'Set to true if the search words are found	
	
	'Error handler
	On Error Resume Next
	
	
	'Loop to search each file in the folder
	For Each filObject in fldObject.Files
		
				
		'Check the file extension to make sure the file is of the extension type to be searched
		If InStr(1, strFilesTypesToSearch, fsoObject.GetExtensionName(filObject.Name), vbTextCompare) > 0 Then
		
		  	'Check to make sure the file about to be searched is not a barred file if it is don't search the file
			If NOT InStr(1, strBarredFiles, filObject.Name, vbTextCompare) > 0 Then
		  	
		  	
			  	'Open the file for searching
			    	Set tsObject = filObject.OpenAsTextStream
			
				'Read in the contents of the file
			   	strFileContents = tsObject.ReadAll
			 		
			 	'Initalise the search found variable to flase
			 	blnSearchFound = False
			 	
			 	
			 	'If the user has choosen to search by phrase 
			 	If Request.QueryString("mode") = "phrase" Then
			 		
			 		'Search the file for the phrase
			 		If InStr(1, LCase(strFileContents), LCase(strSearchWords), 1) then
			 		
			 			'If the search is found then set the search found variable to true
			 			blnSearchFound = True
			 		End If
			 	
			 	
			 	'Else the search is either by all or any words
			 	Else
			 			 	
			 		'If the search is by all words then initialise the search found variable to true
				 	If Request.QueryString("mode") = "allwords" then blnSearchFound = True
				 	
				 	
				 	'Loop round to search for each word to be searched
				 	For intSearchLoopCounter = 0 to UBound(sarySearchWord)
				 		    	
					    	'Search the file for the search words
					    	If InStr(1, LCase(strFileContents), LCase(sarySearchWord(intSearchLoopCounter)), 1) Then
				    	
				    			'If the search word is found and the search is for any words then set the search found variable to true
				    			If Request.QueryString("mode") = "anywords" then blnSearchFound = True
				    			
				    		Else
				    			'If the search word is not found and the search is for all words then set the search found variable back to false as one of the words has not been found
				    			If Request.QueryString("mode") = "allwords" then blnSearchFound = False
				    			
				    		End If
				    	Next
			    	End If
			    	
			    	
			    	
			    	'Calculate the total files searched
			    	intTotalFilesSearched = intTotalFilesSearched + 1
			    		    	
			    			    	
			    	
			    	'If the search found variable is true then display the results
			    	If blnSearchFound = True Then
			    			    	
			    					    		    	
					'Calculate the total files found 
					intTotalFilesFound = intTotalFilesFound + 1
										
			    	
			    		
					'Check that the file shown is between the the files shown so far and the maximum files to show per page
					If  intNumFilesShown < (intRecordsPerPage + intFileNum) and intTotalFilesFound > intNumFilesShown Then
	
						'Calculate the number of results shown
						intNumFilesShown = intNumFilesShown + 1
						
		
					    	'Read in the title of the file
						strPageTitle = GetFileMetaTag("<title>", "</title>", strFileContents)
								
						'Read in the description meta tag of the file
						strPageDescription = GetFileMetaTag("<meta name=""description"" content=""", """>", strFileContents)
			 	
			 			'If the page contains no title then Page Title variable the appropriate message to display
					    	If strPageTitle = "" Then strPageTitle = "No Title"
					    	
					    	'If the page contains no title then Page Description variable the appropriate message to display
					    	If strPageDescription = "" Then strPageDescription = "There is no description available for this page"
				       		
				       		'Place the search results into the saerch results array
				       		'Calculate the array position of the results array
				       		intResultsArrayPosition = intResultsArrayPosition + 1
				       		
				       		
				       		'Set the search results found boolean to true
				       		blnSearchResultsFound = True
				       					       		
						'If the file is in the root directory then
						If blnIsRoot = True Then
						
							'Place the search results into the search results array
							sarySearchResults(intResultsArrayPosition) = "<a href=""./" &  filObject.Name & """ target=""_self"">" & strPageTitle & "</a><br>" & vbCrLf & "        " & strPageDescription
									    						       		
				       		'Else it is not in the root directiory
				       		Else
				       			'Place the search results into the search results array
				       			sarySearchResults(intResultsArrayPosition) = "<a href=""./" & strFileURL  & fldObject.Name & "/" & filObject.Name & """ target=""_self"">" & strPageTitle & "</a><br>" & vbCrLf & "	      " & strPageDescription			   			   								
						End If	
									
					End If	      		
		      		End If
							
				'Close the text stream object
		    		tsObject.Close
			End If
		End If
	Next



	'Loop to search through the sub folders within the site
	For Each subFldObject In FldObject.SubFolders
										
		'Check to make sure the folder about to be searched is not a barred folder if it is then don't search
		If NOT InStr(1, strBarredFolders, subFldObject.Name, vbTextCompare) > 0 Then
			
			'Set to false as we are searching sub directories
			blnIsRoot = False		
					
			'Get the server path to the file
			strFileURL = fldObject.Path & "\"
			
			'Turn the server path to the file into a URL path to the file
			strFileURL = Replace(strFileURL, strServerPath, "")
			
			'Replace the NT backslash with the internet forward slash in the URL to the file
			strFileURL = Replace(strFileURL, "\", "/")
			
			'Encode the file name and path into the URL code method
			strFileURL = Server.URLEncode(strFileURL)
			
			'Just incase it's encoded any backslashes
			strFileURL = Replace(strFileURL, "%2F", "/")
			
							
			'Call the search sub prcedure to search the web site
			Call SearchFile(subFldObject)
		End If
	Next



	'Reset server variables
	Set filObject = Nothing
	Set tsObject = Nothing
	Set subFldObject = Nothing


End Sub



'Function to read in the files meta tags
Private Function GetFileMetaTag(ByRef strStartValue, ByRef strEndValue, ByVal strFileContents)

	'Dimension Variables
	Dim intStartPositionInFile	'Holds the start position in the file
	Dim intEndPositionInFile	'Holds the end position in the file
	
	
	'Get the start position in the file of the meta tag
	intStartPositionInFile = InStr(1, LCase(strFileContents), strStartValue, 1)
	
	
	'If no description or keywords are found then you may be using http-equiv= instead of name= in your meta tags
	If intStartPositionInFile = 0 And InStr(strStartValue, "name=") Then
		
		'Swap name= for http-equiv= 
		strStartValue = Replace(strStartValue, "name=", "http-equiv=")
		
		'Check again for keywords or description
		intStartPositionInFile = InStr(1, LCase(strFileContents), strStartValue, 1)		
	End If
	
				    	
	'If there is a description then the position in file will be over 0
	If NOT intStartPositionInFile = 0 Then
					
		'Get the end position of the HTML meta tag
		intStartPositionInFile = intStartPositionInFile + Len(strStartValue)
						
		'Get the position in file of the closing tag for the meta tag
		intEndPositionInFile = InStr(intStartPositionInFile, LCase(strFileContents), strEndValue, 1)
	
		'Read in the meta tag from the file for the function to return
		GetFileMetaTag = Trim(Mid(strFileContents, intStartPositionInFile, (intEndPositionInFile - intStartPositionInFile)))
					
	'If the is no meta tag then the GetFileMetaTag function returns a null value
	Else
		GetFileMetaTag = ""
		       		
	End If

End Function
%>