<%@ Language=VBScript %>

<%

Option Explicit
Response.Buffer = true

%>

<!--#include file="includes/globals.asa"-->

<HTML>
<HEAD>
<link rel="stylesheet" type="text/css" href="includes/styles.css">

<TITLE></TITLE>
</HEAD>
<BODY>

<%
Dim objRpt 
Dim strHTML
Dim FormItem
Dim n
Dim strRptName
Dim strPrcName
Dim lngRetVal

strPrcName = Request.Cookies("webreport")("prcname")
strRptName = Request.Cookies("webreport")("rptname")

If instr(1,strPrcName," ") <> 0 Then
	strPrcName = "[" & strPrcName & "]"
End If

Response.Write "<H1>Report Name:  " & strRptName & "</H1><br>"

If Request.QueryString("Requery") = "" Then
	lngRetVal = Fetch(strPrcName, strHTML)
Else
	'	This is a ReSort 
	lngRetVal = Sort(strHTML)	
End If

If lngRetVal <> 0 Then
	If lngRetVal = (vbObjectError + 4000) or lngRetVal = (vbObjectError + 4001) or lngRetVal = (vbObjectError + 4002) Then
		'	This is a Value Added Error description formatted for the client
		'	so I want to process it as it.  
		Response.Write "&nbsp;&nbsp;" & objRpt.ErrDesc
	Else
		'	Unexpected Error
		Response.Redirect "Error.asp?ErrNum=" & lngRetVal & "&ErrDesc=" & objRpt.ErrDesc		
	End If
End If

Response.Write  strHTML 

%>
<P>&nbsp;</P>

</BODY>
</HTML>

<%

Public Function Fetch(ByVal strSQL, ByRef strHTML) 
                    
 Dim lngRetVal      
 Dim fld          
 Dim n                      
 Dim strParmName    
 Dim strCmdText     
 Dim intPageSize    
 Dim lngMaxRows     
 Dim strReqSQL   
 Dim strErrDesc
 
 Dim objCn   
 Dim objRs
 Dim objCmd  
 Dim objCmd2     
 
	'On Error Resume Next
 
 	Set objCn		= Server.CreateObject("ADODB.Connection")
	Set objRs		= Server.CreateObject("ADODB.Recordset")
	Set objCmd		= Server.CreateObject("ADODB.Command")  
	Set objCmd2		= Server.CreateObject("ADODB.Command")   
    
    '   Need to take [] out of CommandText but required for SQL string to work right
    strCmdText = Replace(strSQL, "[", "")
    strCmdText = Replace(strCmdText, "]", "")
    
    With objCmd
        .CommandType = adCmdStoredProc
        .CommandText = strCmdText		'   Get the Proc name
        .ActiveConnection = g_strConnect
        .Parameters.Refresh				'   Refresh the command object - this will populate parameters
    End With
    
    '   This will set the Cachesize
    intPageSize		= Request.Cookies("webreport")("pagesize")
    lngMaxRows		= Request.Cookies("webreport")("maxrows")
    
    '   Get a Recordset to determine which parameters are required and which aren't
    '   to speed select only the Required field
    strReqSQL = "asprep_sel_Report_Params @ReportID=" & Request.Cookies("webreport")("rptid")
   
    objCn.open g_strConnect
    
	With objCmd2
		.Commandtext = strReqSQL
		.Commandtype = adCmdText
		Set .ActiveConnection = objCn
	End With
	
	With objRs
		.CursorLocation = adUseClient
		.Open objCmd2, , adOpenDynamic, adLockReadOnly
		Set .ActiveConnection = Nothing
	End With
    
    For n = 0 To objCmd.Parameters.Count - 1
        strParmName = Replace(objCmd.Parameters(n).Name, "@", "")
    
        If Request.Form(strParmName) <> "" Then
            
            '   ------------------------------------------------
            '   Validate data for Dates, Numerics and length
            '   ------------------------------------------------
            
                '   Required validation
                If objRs("Required") = 1 Then   '   This is a required field
                    If Request.Form(strParmName) = "" Then
                        Err.Raise (vbObjectError + 4000), "Fetch", "Param Name: {" & strParmName & "} Missing entry for required field"
                    End If
                '   Date validation
                ElseIf objCmd.Parameters(n).Type = adDBTimeStamp Then
                    If Not IsDate(Request.Form(strParmName)) Then
                        Err.Raise (vbObjectError + 4000), "Fetch", "Param Name: {" & strParmName & "} Invalid data for DATE parameter"
                    End If
                '   Numeric validation
                ElseIf Quote(objCmd.Parameters(n).Type) = False Then
                    If Not IsNumeric(Request.Form(strParmName)) Then
                        Err.Raise (-2147217503), "Fetch", "Param Name: {" & strParmName & "} Invalid data for NUMERIC parameter"
                    End If
                '   Length validation
                ElseIf Len(Request.Form(strParmName)) > objCmd.Parameters(n).Size Then
                     Err.Raise (vbObjectError + 4002), "Fetch", "Param Name: {" & strParmName & "} Invalid data - parameter data length is too long<br>&nbsp;&nbsp;Max length is " & objCmd.Parameters(n).Size
                End If
                
            '   ------------------------------------------------
            '   Create the Dynamic SQL string
            '   ------------------------------------------------
            
                If Quote(objCmd.Parameters(n).Type) = True Then
                    strSQL = strSQL & " @" & strParmName & " = '" & Request.Form(strParmName) & "',"   ' This is a string so quote it
                Else
                    strSQL = strSQL & " @" & strParmName & " = " & Request.Form(strParmName) & ","     ' This isn't so don't
                End If
            
        Else
            If strParmName <> "RETURN_VALUE" Then
                '   User didn't fill out this field so we'll input a NULL
                strSQL = strSQL & " @" & strParmName & " = NULL, "
            End If
        End If
    Next

    If Right(RTrim(strSQL), 1) = "," Then
        strSQL = Left(strSQL, Len(Trim(strSQL)) - 1)    '   Take off trailing comma
    End If
    
    '   Write the SQLString to the cookie - this will be required if there is a requery
    Response.Buffer = True
    Response.Cookies("webreport")("SQLString") = strSQL
    
    '   Create the Recordset
    
    Set objCmd = Nothing
    Set objCmd = Server.CreateObject("ADODB.Command")
    objRs.Close
    
	lngRetVal = GetRecordSet(objRs, strSQL, strErrDesc)
	
	'	Handle Error
	If lngRetVal <> 0 Then
		Response.Redirect "Error.asp?ErrNum=" & lngRetVal & "&ErrDesc=" & strErrDesc
	ElseIf objRs.BOF And objRs.EOF Then
		Response.Write "No records returned"
		Exit Function
    End If
    
    '   Use the recordset to create the HTML table string
    '   This will be returned to the client
    '   Apparently if the recordset has no records an error occurrs when you try to pass it
    
    lngRetVal = CreateTable(objRs, strHTML, strErrDesc)
    
	'	Handle Error
	If Err.number <> 0 or lngRetVal <> 0 Then    
		   Response.Redirect "Error.asp?ErrNum=" & Err.Number & "&ErrDesc=" & Err.Description
	End If
End Function


Public Function Sort(ByRef strHTML) 
 Dim lngRetVal      
 Dim rs             
 Dim strSQL         
 Dim intPageSize    
 Dim lngMaxRows     
 Dim strSortOrder   
 Dim strFldName   
 Dim strErrDesc
 
 Dim objRs

 
	'On Error Resume Next
 
    
    '   This SQL was stored in the cookie from the preview Fetch operation
    '   rather than trying to recreate the SQL from user input, parameters etc. I've stored in
    '   in a cookie in case there is a ReSort.  In this case, I simply re-use it "As Is".
    strSQL = Request.Cookies("webreport")("SQLString")
    
    '   This will set the Cachesize
    intPageSize = Request.Cookies("webreport")("pagesize")
    lngMaxRows = Request.Cookies("webreport")("maxrows")
    
	lngRetVal = GetRecordset(objRs, strSQL, strErrDesc)
	If lngRetVal <> 0 Then 
		Response.Redirect "Error.asp?ErrNum=" & lngRetVal & "&ErrDesc=" & strErrDesc
	End If
	
    If lngRetVal <> 0 Then
        Exit Function
    ElseIf objRs.BOF And objRs.EOF Then
		Response.Write "No records returned"
		Exit Function
    End If
    
    '   ------------------------------------------------
    '   Process Sort by Field - if this came via a hyperlink
    '   ------------------------------------------------
        strFldName = Request.QueryString("fldname")
            
            '   ----------------------------------------------------------------
            '   Process Sort Order
            '   ----------------------------------------------------------------
            If strFldName <> "" Then
            
                If strFldName = Request.Cookies("webreport")("fldname") Then
                    '   Switch sort order if it's the same field
                    If Request.Cookies("webreport")("sortorder") = "ASC" Then
						strSortOrder = "DESC"
					Else
						strSortOrder = "ASC"
					End If	
                Else
                    '   otherwise go to default of Ascending
                    strSortOrder = "ASC"
                End If
            
                '   Store SortOrder and FieldName so we can check them on the next sort
                Response.Cookies("webreport")("sortorder") = strSortOrder
                Response.Cookies("webreport")("fldname") = strFldName
            
                '   sort based on the new Field sort and Order
                objRs.Sort = strFldName & " " & strSortOrder  '    i.e. "CustomerID DESC"
            Else
            
                strFldName = Request.Cookies("webreport")("fldname")
                strSortOrder = Request.Cookies("webreport")("sortorder")
            
                '   If there is a sort order for this TABLE then let's use it - even though this OPERATION
                '   may not have been a sort.  We want the sort to persist as long as the user is on the table
                If strFldName <> "" Then
                
                    '   Sort based on an old Field Sort and order
                    objRs.Sort = strFldName & " " & strSortOrder  '    i.e. "CustomerID DESC"
                Else
                    
                    '   Don't sort at all because there hasn't been a sort request for this table yet
                End If
            
            End If
        
    '   Use the recordset to create the HTML table string
    '   This will be returned to the client
    lngRetVal = CreateTable(objRs, strHTML, strErrDesc)
 
    If Err.number <> 0 Then
		CreateTable = Err.number
		strErrDesc = Err.description
	End If	 
End Function


Private Function CreateTable(objRs, ByRef strHTML, ByRef strErrDesc) 
 Dim bolPaint   
 Dim fld       
 Dim n         
 Dim intPage 
 Dim lngRetVal  
 Dim strShadeColor 
 
	'On Error Resume Next
 
    objRs.PageSize = Request.Cookies("webreport")("pagesize")
    
    '   If this action was trigger by the selection of another page - get this Page # from
    '   the query string
    If Request.QueryString("PageNum") <> "" Then
        intPage = Request.QueryString("PageNum")
    Else
        '   Otherwise use the default page number of 1
        intPage = 1
    End If
    
    strHTML = "&nbsp;&nbsp;Page Selector: "
    
    For n = 1 To objRs.PageCount
        If cint(n) = cint(intPage) Then
            '   If this is the current page we don't want to make it a hyperlink
            strHTML = strHTML & "[" & n & "]" & "&nbsp"
        Else
            strHTML = strHTML & "<a href=Template.asp?Requery=True&PageNum=" & n & ">" & n & "</a>&nbsp"
        End If
    Next
    
    If objRs.PageCount = 0 Then strHTML = strHTML & "No records were returned&nbsp"
    
    strHTML = strHTML & "<br><br>"
    
    strHTML = strHTML & "<table border=0 width=95% align=center cellspacing=0 cellpadding=2>"
    strHTML = strHTML & "<tr>"
    
    '   Show titles
    For Each fld In objRs.Fields
        '   Field may have spaces in it
        strHTML = strHTML & "<td><H3><a href=template.asp?Requery=True&fldname=" & fld.Name & ">" & fld.Name & "</a></H3></td>"
    Next
    
    If objRs.BOF And objRs.EOF Then
        Exit Function
    End If
    
    objRs.AbsolutePage = intPage
    
    If strShadeColor = "#C0C0C0" Then 
		strShadeColor = ""
	Else
		strShadeColor = "#C0C0C0"	'"#C0C0C0"
	End If
    
    For n = 1 To objRs.PageSize
        If objRs.EOF Then Exit For
    
        strHTML = strHTML & "<tr>"
        For Each fld In objRs.Fields
        
            '   Alternate the Paint effect
            If bolPaint Then
                strHTML = strHTML & "<td bgcolor=" & Chr(34) & strShadeColor & Chr(34) & ">" 
                If IsNull(fld.Value) Then
					strHTML = strHTML & "&nbsp;</td>"
				Else
					strHTML = strHTML & fld.Value & "</td>"
				End If	

            Else
                strHTML = strHTML & "<td>"
                If IsNull(fld.Value) Then 
					strHTML = strHTML & "&nbsp;" & "</td>"
				Else
					strHTML = strHTML & fld.Value & "</td>"
				End if
            End If
            
        Next
        
        '   Change Paint row
        If bolPaint = true then
			bolPaint = False
		Else
			bolPaint = True
		End If
        
        strHTML = strHTML & "</tr>"
        
        objRs.MoveNext
    Next
    
    Set objRs = Nothing
    
    strHTML = strHTML & "</table>"
    
    If Err.number <> 0 Then
		CreateTable = Err.number
		strErrDesc = Err.description
	End If	
End Function


Public Function Quote(intPrmType)
'   This function determines if a ADO Command Object Parameter should
'   be wrapped with quotes when it is converted to a SQL string or not

'   Input:  Parameter Type as integer
'   Output: Boolean, True - this is a string param and should be wrapped
'                           with quotes
'                    False - this is a numeric param and should not
 Dim bolVarQuote 
 
	bolVarQuote = False
 
    Select Case intPrmType
        Case adNumeric
        Case adVarBinary
        Case adUnsignedTinyInt
        Case adSmallInt
        Case adBoolean
        Case adSingle
        Case adCurrency
        Case adInteger
        Case adDouble
        Case adBinary
        Case adVarBinary
        Case adLongVarBinary
        
        Case adLongVarWChar
            bolVarQuote = True
        Case adVarChar
            bolVarQuote = True
        Case adWChar
            bolVarQuote = True
        Case adDBTimeStamp
            bolVarQuote = True
        Case Else
            bolVarQuote = True
    End Select
    
    Quote = bolVarQuote
End Function

%>

