<!-- #include file="i_utils.asp" -->
<%
	dim dtInserted
	dim accesslevel
	dim user_id
	dim user_name
	dim f_name
	dim l_name
	dim email
	dim password
	dim addr1
	dim addr2
	dim city
	dim state
	dim postalcode
	dim country
	dim phone
	dim notes
	dim mailing_list
	dim register_sql

sub request_register
''' request expected input parameters for this form
	dtInserted = request("dtInserted")
	accesslevel = request("accesslevel")
	user_id = request("user_id")
	user_name = request("user_name")
	f_name = request("f_name")
	l_name = request("l_name")
	email = request("email")
	password = request("password")
	addr1 = request("addr1")
	addr2 = request("addr2")
	city = request("city")
	state = request("state")
	postalcode = request("postalcode")
	country = request("country")
	phone = request("phone")
	notes = request("notes")
	mailing_list = request("mailing_list")
end sub

sub validate_register
''' request and validate data entered from this form
	dtInserted = trim(request("dtInserted"))
	if dtInserted <> "" AND (not isdate(dtInserted)) then
		error_list.add "564361date"," must be a valid date (MM/DD/YY)."
		b_error = true
	end if
	accesslevel = trim(request("accesslevel"))
	user_id = trim(request("user_id"))
	user_name = trim(request("user_name"))
	if user_name = "" then
		error_list.add "564348","desired username must be specified."
		b_error = true
	end if
	f_name = trim(request("f_name"))
	l_name = trim(request("l_name"))
	email = trim(request("email"))
	if email = "" then
		error_list.add "564351","email must be specified."
		b_error = true
	end if
	password = trim(request("password"))
	if password = "" then
		error_list.add "564352","password must be specified."
		b_error = true
	end if
	addr1 = trim(request("addr1"))
	addr2 = trim(request("addr2"))
	city = trim(request("city"))
	state = trim(request("state"))
	postalcode = trim(request("postalcode"))
	country = trim(request("country"))
	phone = trim(request("phone"))
	notes = trim(request("notes"))
	mailing_list = trim(request("mailing_list"))
end sub

sub get_defaults_register
''' set default values for this form
	accesslevel = 1
end sub

sub db_select_register
	sql = "SELECT " & _ 
	"dtInserted, " & _ 
	"accesslevel, " & _ 
	"user_id, " & _ 
	"user_name, " & _ 
	"f_name, " & _ 
	"l_name, " & _ 
	"email, " & _ 
	"password, " & _ 
	"addr1, " & _ 
	"addr2, " & _ 
	"city, " & _ 
	"state, " & _ 
	"postalcode, " & _ 
	"country, " & _ 
	"phone, " & _ 
	"notes, " & _ 
	"mailing_list FROM Users" & _ 
	" WHERE " & _ 
	"Users.user_id = " & to_sql(user_id,"number") & ""
	on error resume next
	set rs = cn.Execute(sql)
	if err.number <> 0 then
		b_error = true
		error_list.add "select_data_register", "The data selection failed. " & err.description
	elseif rs.EOF then
		b_results = false
		msg_list.add "select_data_register", "The record was removed from the database."
	else
		dtInserted = rs("dtInserted")
		accesslevel = rs("accesslevel")
		user_id = rs("user_id")
		user_name = rs("user_name")
		f_name = rs("f_name")
		l_name = rs("l_name")
		email = rs("email")
		password = rs("password")
		addr1 = rs("addr1")
		addr2 = rs("addr2")
		city = rs("city")
		state = rs("state")
		postalcode = rs("postalcode")
		country = rs("country")
		phone = rs("phone")
		notes = rs("notes")
		mailing_list = rs("mailing_list")
	end if
	rs.Close
	on error goto 0
end sub
sub db_insert_register
	sql = "INSERT INTO Users" & _ 
	"(" & _ 
	"user_name," & _ 
	"f_name," & _ 
	"l_name," & _ 
	"[email]," & _ 
	"[password]," & _ 
	"addr1," & _ 
	"addr2," & _ 
	"city," & _ 
	"[state]," & _ 
	"postalcode," & _ 
	"country," & _ 
	"phone," & _ 
	"[notes]," & _ 
	"dtInserted," & _ 
	"dtModified," & _ 
	"accesslevel," & _ 
	"mailing_list" & _ 
	") VALUES (" & _ 
	"" & to_sql(user_name,"text") & "," & _ 
	"" & to_sql(f_name,"text") & "," & _ 
	"" & to_sql(l_name,"text") & "," & _ 
	"" & to_sql(email,"text") & "," & _ 
	"" & to_sql(password,"text") & "," & _ 
	"" & to_sql(addr1,"text") & "," & _ 
	"" & to_sql(addr2,"text") & "," & _ 
	"" & to_sql(city,"text") & "," & _ 
	"" & to_sql(state,"text") & "," & _ 
	"" & to_sql(postalcode,"text") & "," & _ 
	"" & to_sql(country,"text") & "," & _ 
	"" & to_sql(phone,"text") & "," & _ 
	"" & to_sql(notes,"text") & "," & _ 
	"" & to_sql(now,"date") & "," & _ 
	"" & to_sql(now,"date") & "," & _ 
	"" & to_sql(accesslevel,"number") & "," & _ 
	"" & to_sql(mailing_list,"number") & ")"
	'response.write sql
	on error resume next
	cn.Execute(sql)
	if err.Number <> 0 then
		b_error = true
		error_list.add "db_insert_register" & err.Number ,"The database insert failed. " & err.Description
	else
		set rs = cn.Execute("SELECT @@IDENTITY")
		user_id = rs(0)
		rs.Close
		msg_list.add "db_insert_register","The database insert was successful."	end if
	on error goto 0
end sub
sub db_update_register
	sql = "UPDATE Users SET " & _ 
	"dtInserted = " & to_sql(dtInserted,"text") & ", " & _ 
	"accesslevel = " & to_sql(accesslevel,"number") & ", " & _ 
	"user_name = " & to_sql(user_name,"text") & ", " & _ 
	"f_name = " & to_sql(f_name,"text") & ", " & _ 
	"l_name = " & to_sql(l_name,"text") & ", " & _ 
	"email = " & to_sql(email,"text") & ", " & _ 
	"password = " & to_sql(password,"text") & ", " & _ 
	"addr1 = " & to_sql(addr1,"text") & ", " & _ 
	"addr2 = " & to_sql(addr2,"text") & ", " & _ 
	"city = " & to_sql(city,"text") & ", " & _ 
	"state = " & to_sql(state,"text") & ", " & _ 
	"postalcode = " & to_sql(postalcode,"text") & ", " & _ 
	"country = " & to_sql(country,"text") & ", " & _ 
	"phone = " & to_sql(phone,"text") & ", " & _ 
	"notes = " & to_sql(notes,"text") & ", " & _ 
	"mailing_list = " & to_sql(mailing_list,"number") & " WHERE " & _ 
	"user_id = " & to_sql(user_id,"number") & ""
	'response.write sql
	on error resume next
	cn.execute(sql)
	if err.number <> 0 then
		b_error = true
		error_list.add "db_update_register" & err.Number ,"The database update failed. " & err.Description
	else
		msg_list.add "db_update_register" & user_id,"The database update was successful."
	end if
	on error goto 0
end sub
sub db_delete_register
	sql = "DELETE FROM Users" & _ 
	" WHERE " & _ 
	"user_id = " & to_sql(user_id,"number") & ""
	'response.write sql
	on error resume next
	cn.Execute(sql)
	if err.number <> 0 then
		b_error = true
		error_list.add "db_delete_register" & err.Number ,"The database deletion failed. " & err.Description
	else
		msg_list.add "db_delete_register","The record was removed."
	end if
	on error goto 0
end sub

do_search = request("do_search")
''' request form keys
user_id = request("user_id")
''' request action
action = lcase(request("action"))
''' action case handler
select case action

case "select_register"
'  select the requested key record from database
if user_id <> "" then
	db_select_register
else
	b_error = true
	error_list.add "edit_register", "Specify record to select."
end if


case "insert_register"
'  request form data and insert a new record into database

validate_register
if not b_error then
	db_insert_register
end if



case "update_register"
'  request form data and update an existing database record
validate_register
if not b_error then
if user_id <> "" then
	db_update_register
else
	b_error = true
	error_list.add "update_register", "Specify record to update."
end if
end if


case "delete_register"
'  delete the requested key database record
if user_id <> "" then
	db_delete_register
	response.redirect request.servervariables("script_name") & "?msg=The+record+was+deleted."
else
	b_error = true
	error_list.add "delete_register", "Specify record to delete."
end if


end select
':: handle the default case(s) for each form (separate from action= parameter)
if user_id <> "" then
	db_select_register
end if


%>

<!-- #include file='i_header.asp' -->
<!-- #include file='i_menu.asp' -->


<%
display_errs
display_msg
%>

<table class='headerTable'>
<tr>
<td class='headerTD'>
Register
</td>
</tr>
</table>
<table  >
<form name="register" action="" method="get" >
		
		<input type=hidden name="dtInserted" value="<% =dtInserted %>">
		
		
		<input type=hidden name="accesslevel" value="<% =accesslevel %>">
		
		
		<input type=hidden name="user_id" value="<% =user_id %>">
		
<tr>
	<td class='labelTD'>desired username</td>
	<td class='dataTD' width='75%'>
		<input type=text  name="user_name" size="" maxlength="50" value="<% =user_name%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>first name</td>
	<td class='dataTD' >
		<input type=text  name="f_name" size="" maxlength="50" value="<% =f_name%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>last name</td>
	<td class='dataTD' >
		<input type=text  name="l_name" size="" maxlength="70" value="<% =l_name%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>email</td>
	<td class='dataTD' >
		<input type=text  name="email" size="" maxlength="60" value="<% =email%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>password</td>
	<td class='dataTD' >
		<input type=password name="password" size="" maxlength="50" value="<% =password %>">
	</td>
</tr>
<tr>
	<td class='labelTD'>address</td>
	<td class='dataTD' >
		<input type=text  name="addr1" size="" maxlength="100" value="<% =addr1%>">
	</td>
</tr>
<tr>
	<td class='labelTD'></td>
	<td class='dataTD' >
		<input type=text  name="addr2" size="" maxlength="50" value="<% =addr2%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>city</td>
	<td class='dataTD' >
		<input type=text  name="city" size="" maxlength="50" value="<% =city%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>state</td>
	<td class='dataTD' >
		
		<select name="state" >
		<option></option>
		<%
		 =get_options ("SELECT code FROM luStates ORDER BY code", state) 
		%>
		</select>
		
	</td>
</tr>
<tr>
	<td class='labelTD'>postal code</td>
	<td class='dataTD' >
		<input type=text  name="postalcode" size="" maxlength="50" value="<% =postalcode%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>country</td>
	<td class='dataTD' >
		<input type=text  name="country" size="" maxlength="50" value="<% =country%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>phone</td>
	<td class='dataTD' >
		<input type=text  name="phone" size="" maxlength="50" value="<% =phone%>">
	</td>
</tr>
<tr>
	<td class='labelTD'>comments</td>
	<td class='dataTD' >
		
		<textarea  name="notes" rows='10' cols='70'><% =notes%></textarea>
		
	</td>
</tr>
<tr>
	<td class='labelTD'>join newsletter?</td>
	<td class='dataTD' >
		<% if mailing_list = "" then mailing_list = false %>
		<input type=checkbox  <% if mailing_list then %>checked<% end if %> name="mailing_list" value="1">
	</td>
</tr>
<tr>
	<td class=labelTD align=right>&nbsp;
	<% if user_id <> "" then %><% end if %>
	</td>
	<td class=dataTD>
	<% if user_id = "" then %><input class=cmd type=submit value='REGISTER'><% end if %>
	</td>
<input type=hidden name="action" value="<% if user_id <> "" then %>update<% else %>insert<%end if %>_register"></tr>

</form>
</table>



<!-- #include file=i_footer.asp -->


<%
':: assure that any db resources are freed
on error resume next
rs.Close
set rs = NOTHING
cn.Close
set cn = NOTHING
user_cn.Close
set user_cn = NOTHING
on error goto 0
%>
