<!--#include file ="config.asp"-->
<!--#include file ="include.asp"-->

<!-- UPLOAD.ASP -->
<%

'========================================================================================
' strDefaultPath is what you consider to be the root/default destination for uploads
' It can be a virtual path such as "/www" or physical path such as "c:\inetpub\wwwroot\"
'========================================================================================
Dim strDefaultPath
strDefaultPath = RootFolder & "upload/"

'=====================================================
' The rest of the script shouldn't need to be changed!
'=====================================================

Dim scriptName
scriptName = Request.ServerVariables("SCRIPT_NAME")

Dim FSO
Set FSO = server.CreateObject ("Scripting.FileSystemObject")

Dim strDefaultPhysicalPath
strDefaultPhysicalPath = getPhysicalPath(strDefaultPath)

'===================================
' Create folder if it doesn't exist
'===================================
If FSO.FolderExists( strDefaultPhysicalPath ) = False Then 
  dim fa
  set fa=FSO.CreateFolder( strDefaultPhysicalPath )
  set fa=nothing
End If


'=================================
' Class with file upload functions
'=================================
Class CFileUploader
	Public isUploaded
	Public uploadedFile
	
	Public Default Sub Upload()
		Dim biData, sInputName
		Dim nPosBegin, nPosEnd, nPos, vDataBounds, nDataBoundPos
		Dim nPosFile, nPosBound

		biData = Request.BinaryRead(Request.TotalBytes)
		nPosBegin = 1
		nPosEnd = InstrB(nPosBegin, biData, StringToByteString(Chr(13)))
			
		If (nPosEnd-nPosBegin) <= 0 Then Exit Sub
			 
		vDataBounds = MidB(biData, nPosBegin, nPosEnd-nPosBegin)
		nDataBoundPos = InstrB(1, biData, vDataBounds)
			
		Do Until nDataBoundPos = InstrB(biData, vDataBounds & StringToByteString("--"))
			
			nPos = InstrB(nDataBoundPos, biData, StringToByteString("Content-Disposition"))
			nPos = InstrB(nPos, biData, StringToByteString("name="))
			nPosBegin = nPos + 6
			nPosEnd = InstrB(nPosBegin, biData, StringToByteString(Chr(34)))
			sInputName = ByteStringToString(MidB(biData, nPosBegin, nPosEnd-nPosBegin))
			nPosFile = InstrB(nDataBoundPos, biData, StringToByteString("filename="))
			nPosBound = InstrB(nPosEnd, biData, vDataBounds)
				
			If nPosFile <> 0 And  nPosFile < nPosBound Then
				Dim sFileName
				Set uploadedFile = New CUploadedFile
					
				nPosBegin = nPosFile + 10
				nPosEnd =  InstrB(nPosBegin, biData, StringToByteString(Chr(34)))
				sFileName = ByteStringToString(MidB(biData, nPosBegin, nPosEnd-nPosBegin))
				uploadedFile.FileName = Right(sFileName, Len(sFileName)-InStrRev(sFileName, "\"))
	
				nPos = InstrB(nPosEnd, biData, StringToByteString("Content-Type:"))
				nPosBegin = nPos + 14
				nPosEnd = InstrB(nPosBegin, biData, StringToByteString(Chr(13)))
					
				nPosBegin = nPosEnd+4
				nPosEnd = InstrB(nPosBegin, biData, vDataBounds) - 2
				uploadedFile.FileData = MidB(biData, nPosBegin, nPosEnd-nPosBegin)
					
				If uploadedFile.FileSize > 0 Then isUploaded = true Else isUploaded = false
			End If

			nDataBoundPos = InstrB(nDataBoundPos + LenB(vDataBounds), biData, vDataBounds)
		Loop
	End Sub

	Private Function StringToByteString(sString)
		Dim index
		For index = 1 to Len(sString)
			StringToByteString = StringToByteString & ChrB(AscB(Mid(sString,index,1)))
		Next
	End Function

	Private Function ByteStringToString(bsString)
		Dim index
		ByteStringToString =""
		For index = 1 to LenB(bsString)
			ByteStringToString = ByteStringToString & Chr(AscB(MidB(bsString,index,1))) 
		Next
	End Function
End Class

'==================================
' Class with file writing functions
'==================================
Class CUploadedFile
	Public FileName, FileData
		
	Public Property Get FileSize()
		FileSize = LenB(FileData)
	End Property
	
	Public Function Save(path)
		Dim file
		Dim index
		
		If path = "" Or FileName = "" Then 
			Save = false
			Exit Function
		End If
		path = addSlash(path, "\")
		
		If Not FSO.FolderExists(path) Then
			Save = false
			Exit Function
		End If
		
		on error resume next
		Set file = FSO.CreateTextFile(path & FileName, True)
			
		For index = 1 to LenB(FileData)
		    file.Write Chr(AscB(MidB(FileData,index,1)))
		Next
	
		file.Close
		If err.Number<>0 Then
			Save = false
		Else
			Save = true
		End If
	End Function
End Class
%>

<%
'================================
' Begin the whole upload process 
'================================
Dim sUploadPath

Dim sSessionAttachments
sSessionAttachments = Session("ATTACHMENTS")

If Request.QueryString("action")<>"" Then
	sUploadPath = strDefaultPhysicalPath
	sUploadPath = addSlash(sUploadPath, "\")
	If len(sUploadPath) < len(strDefaultPhysicalPath) Then Response.End 

	Dim fileUploader
	Set fileUploader = New CFileUploader
	
	Dim sUploadMsg, sUploadFile, sUploadSize
	sUploadMsg = ""
	sUploadFile = ""
	sUploadSize = ""
	
	fileUploader.Upload()
	
	If not fileUploader.isUploaded Then
		sUploadMsg = "Sorry, there was a problem. No file was uploaded!"
	Else
		If fileUploader.uploadedFile.FileName="" Then
			sUploadMsg = "Sorry, there was a problem. No file was uploaded!"
		Else
			If fileUploader.uploadedFile.Save(sUploadPath) Then
				sUploadFile = fileUploader.uploadedFile.FileName
				sUploadSize = strStatusMsg & formatBytes(fileUploader.uploadedFile.FileSize) & " (" & fileUploader.uploadedFile.FileSize & " bytes)"
			Else
				sUploadMsg = "Sorry! " & fileUploader.uploadedFile.FileName & " could not be written."
			End If
		End If
	End If

	'===================================================
	'Finished with uploading so go back original page...
	'===================================================
	
	If sUploadMsg = "" Then
	  If sSessionAttachments <> "" Then
	    sSessionAttachments = sSessionAttachments & "; " & sUploadFile
	  Else
	    sSessionAttachments = sUploadFile  	
	  End If  
	End If  
	
	Session("ATTACHMENTS") = sSessionAttachments
	
	Response.Write "<SCRIPT language=JavaScript>"
	If sUploadMsg <> "" Then
	  Response.Write "alert(""" & sUploadMsg & """);"
	Else
	  Response.Write "opener.document.forms.senderForm.attachments.value =""" & sSessionAttachments & """;"
	End If
	Response.Write "location.href=""uploadfile.asp?attachments=true"""
	Response.Write "</SCRIPT>"	
End If
%>