<%
Response.Expiresabsolute = Now() - 1
Response.AddHeader "pragma","no-cache"
Response.AddHeader "cache-control","private"
Response.CacheControl = "no-cache"
%>
<%
'===========================================================
' Put anything here that is used by two or more other files
'===========================================================
Dim usersDir
Dim usersPath
usersDir = getPhysicalPath(RootFolder) & "users"
usersPath = usersDir & "/"

Dim usersPhysicalPath
usersPhysicalPath = getPhysicalPath(usersPath)

Dim userFileName
userFileName = usersPhysicalPath & Session("USERNAME") & ".usr" 
Dim userTempFileName
userTempFileName = usersPhysicalPath & Session("USERNAME") & ".tmp" 

Const msgTOKEN = "::="
Const msgID = 0
Const msgFROM = 1
Const msgATTACHMENT = 2
Const msgUNIQUEURL = 3
Const msgSUBJECT = 4
Const msgDATE = 5
Const msgSTRREPLYFROM = 6

'==========================================
' Stops the app and prints a debug message
'==========================================
Sub DebugStr( strMsg )
  Response.Write strMsg
  Response.End
End Sub

'=====================
' Easily popup alerts
'=====================
Sub ShowMessage( strMsg )
  Response.Write "<SCRIPT>alert(""" & CStr(strMsg) & """)</SCRIPT>"
End Sub

'==============================================
' Easily insert comments in code for debugging
'==============================================
Sub Comment( strComment )
  Response.Write vbCrLf & vbCrLf & "<!-- " & strComment & " -->" & vbCrLf
End Sub

'===================================
' Adds slash to the end of the path
'===================================
Function addSlash(path, slash)
	If Right(path, 1) <> slash Then
        	addSlash = path & slash
	Else
		addSlash = path
	End If
End Function

'============================================
' Formats numBytes into  bytes, KB, MB or GB
'============================================
Function formatBytes (numBytes)
	If (numBytes < 1024) Then
		formatBytes = numBytes & " bytes"
	ElseIf (numBytes < 1024*1024) Then
		formatBytes = FormatNumber(numBytes/1024,2) & " Kb"
	ElseIf (numBytes < 1024*1024*1024) Then
		formatBytes = FormatNumber(numBytes/(1024*1024),2) & " Mb"
	Else
		formatBytes = FormatNumber(numBytes/(1024*1024*1024),2) & " Gb"
	End If
End Function

'==================================================
' Converts the given virtual path to physical path
'==================================================
Function getPhysicalPath(strPath)
	Dim path
	path = replace(strPath,"/","\")
	If Left(path,1) = "\" Then
		on error resume next
		getPhysicalPath = addSlash(server.MapPath(path),"\")
		If err.Number<>0 Then getPhysicalPath = strPath
	Else
		If InStr(1,path, ":", 1) <> 0 Then
			getPhysicalPath = addSlash(path,"\")
		Else
			getPhysicalPath = strPath & "?"
		End If
	End If
End Function	

'============================================
' Converts a textfile to an array of strings
'============================================

Function fileToArray( fName )
  If fName = "" Then Exit Function
  On Error Resume Next
  Dim objFSO, objFile
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  Set objFile = objFSO.OpenTextFile(fName, 1)  
'  Set objFile = objFSO.OpenTextFile(Server.MapPath(fName), 1)
  fileToArray = split(objFile.ReadAll, vbCrLf)
  objFile.close
  Set objFile = Nothing
  Set objFSO = Nothing
End Function

'======================
' Detect browser type.
'======================
user_agent = request.servervariables("HTTP_USER_AGENT")
browserID = "IE"
isOpera = false
If InStr( LCase(user_agent), "opera") <> 0 Then
  isOpera = true
  browserID = "OP"
ElseIf InStr( LCase(user_agent), "gecko") <> 0 Then
  browserID = "GE"
ElseIf InStr( LCase(user_agent), "msie") <> 0 Then  
  browserID = "IE"
Else
  browserID = "NS"  
End If  

'===========================================================
' Get the first valid FROM address from a list of addresses
'===========================================================
Function GetFromAddress( strEmail )
  arrayAddresses = split(MyAddresses, " ")
  For i=0 To ubound(arrayAddresses)
    If InStr(LCase(strEmail), LCase(arrayAddresses(i)) ) > 0 Then
      GetFromAddress = arrayAddresses(i)
      Exit Function
    End If
  Next
  GetFromAddress = ""
End function

Function DateToNumber( sDate )
  Dim sYear,sMonth,sDay,sTime,sHour,sMinute,sSecond
  sYear = Year(sDate)
  sMonth = Right("00" & Month(sDate), 2)
  sDay = Right("00" & Day(sDate), 2)
  sHour = Right("00" & Hour(sDate), 2)
  sMinute = Right("00" & Minute(sDate), 2)
  sSecond = Right("00" & Second(sDate), 2)
  DateToNumber = sYear & sMonth & sDay & sHour & sMinute & sSecond
End Function

Function GetDomainName( strEmail )
  GetDomainName = Right( strEmail, Len(strEmail) - Instr(strEmail, "@") )
End Function

Function stripTags( strTags )
  strTags = Replace(strTags, "<", "&lt;")
  strTags = Replace(strTags, ">", "&gt;")
  stripTags = strTags
End Function
%>


