<% @ Language = VBScript %>
<%
Option Explicit
With Response
	.Buffer = True
	.Expires = 0
	.Clear
End With
%>

<!-- #INCLUDE FILE = "./obj_FileUpload_beta_full.asp" -->

<%
 'declare some variables to facilitate working with the objects comprising fileupload.
Dim oFO, oProps, oFile, i, item, oMyName

 'create an instance of FileUpload. FileUpload is the only object that you will
 'directly set an instance of. The other classes are returned by various methods
 'of the object.
Set oFO = New FileUpload

 'print version
Response.Write("<H3>FileUpload Object v" & oFO.Version & "</H3>")

 'call the GetUploadSettings method to return an instance of the FO_Properties
 'object for this instance of FileUpload. FO_Properties contains all the 
 'property settings for uploads.
Set oProps = oFO.GetUploadSettings
with oProps

	 'the FO_Properties object contains 6 properties. Each property has a default
	 'so you only need to set the properties if the defaults do not meet
	 'your intended usage scheme.

	 'allowable file extensions
	.Extensions = Array("txt", "jpg", "zip")

	 'upload directory
	.UploadDirectory = Server.Mappath("../uploads/")

	 'file overwrite option
	.AllowOverWrite = true

	 'max file size for EACH file to upload (older versions of the class
	 'only check the entire post stream's length once at the beginning)
	.MaximumFileSize = 135000  ' give or take 135k for each file

	 'minimum file size for each file to upload (older versions of the class
	 'only check the entire post stream's length once at the beginning)
	.MininumFileSize = 10000 ' 10k

	 'disable uploading
	.UploadDisabled = false
End with

 'all the properties you set above are remembered by the FileUpload class as soon
 'as they are set so there's no reason not to destroy the FO_Properties object we
 'just used to modify the upload system properties to save memory.
set oProps = nothing

 'default method. Processupload must be called to set everything up. After 
 'ProcessUpload is called, the remaining properties, methods and objects 
 'exposed by fileupload become available and are populated with data.
oFO.ProcessUpload

 'the totalformcount property returns the total count of everything submitted 
 'to the fileupload object. this includes binary input from files and text form 
 'inputs posted from a form.
if oFO.TotalFormCount > 0 then

	 'the filecount property returns the count of all binary form inputs that 
	 'were read and loaded by the class after ProcessUpload was called. It is
	 'not an accurate count of acceptable files, it merely counts the number
	 'of binary form inputs parsed.
	if oFO.FileCount > 0 then

			'get a file by it's input name
			set oFile = oFO.File("blob")

			 'if an error has occurred when the FO_File object was
			 'being created or filled with data, it will be in the
			 'ErrorMessage property of the returned FO_File object.
			if oFile.ErrorMessage <> "" then
				response.write "&gt; An error occurred uploading a file: " & _
					oFile.ErrorMessage & "<BR>"
			else

				'rename file
				'oFile.FileName = "newfile.txt" & "." & oFile.FileExtension

				 'there are a couple of different options for
				 'saving files. in this case, i want a copy
				 'of the uploaded file on the server so I use
				 'the saveasfile method.
				oFile.SaveAsFile

				 'after saving an uploaded file using any of the
				 'various save methods available, you should check
				 'the upload successful property to ensure that
				 'the file was saved properly. In the event of an
				 'error during I/O, UploadSuccessful always returns 
				 'false.
				if oFile.UploadSuccessful then
					response.write "&gt; file uploaded successfully<BR>"

					 'if uploadsuccessful returns true, there 
					 'will be various information available
					 'depending on the method of saving called
					 'to store the file. If the file is saved
					 'to disk, these 6 properties of the
					 'FO_File object are filled with data about
					 'the saved file:

					 'absolutepath - returns the absolute path to 
					 'the file on the server.
					response.write(" - absolute path to file: " & _
						oFile.AbsolutePath & "<BR>")

					 'virtualpath - returns the virtual path (from 
					 'the root of the virtual web) to the uploaded
					 'file on the server.
					response.write(" - virtual path to file: " & _
						oFile.VirtualPath & "<BR>")

					 'urlpath - returns the fully qualified url
					 'path (including domain name) to the uploaded
					 'file.
					response.write(" - fully qualified URL path to file: " & _
						oFile.URLPath & "<BR>")

					 'contenttype - returns the content-type of the
					 'uploaded file.
					response.write(" - content-type: " & oFile.ContentType & "<BR>")

					 'filename - returns the filename of the uploaded
					 'file, including extension.
					response.write(" - file name: " & oFile.FileName & "<BR>")

					 'bytecount - returns the binary length of the saved file.
					 'this accurately represents the size of the file in bytes
					 'on the server.
					response.write(" - file size: " & _
						formatnumber(oFile.ByteCount, 0) & " bytes<BR>")
				else
					response.write "&gt; An error occurred saving file to disk: " & _
						oFile.ErrorMessage & "<BR>"
				end if
			end if

			 'release file object to save memory.
			set oFile = Nothing

	else

		 'if a form doesn't have any binary inputs on it, the filecount
		 'property will return 0 (no <input type=file> inputs)
		response.write "&gt; no binary file content submitted."
	end if

	 'formcount property of the FileUpload object returns an accurate count
	 'of all non-binary form inputs passed to the object.
	if oFO.FormCount > 0 then

		 'the inputs method returns an array representing the name of
		 'all non-binary form inputs passed.
		if isarray(oFO.Inputs) then

			 'you can use inputs method to set up a loop to gather
			 'all form inputs passed to the page, without knowing
			 'the names of each input.
			for each item in oFO.Inputs
				response.write "<HR><B>form input """ & item & """</B><HR>"

				 'the form method returns the value of a specified input.
				 'Form is CASE-SENSITIVE so make sure your case is
				 'correct or the method will return empty string.
				 'No room for sloppiness here, people.
				response.write " - value : " & oFO.Form(item) & "<BR>"

			'next form input
			next
		end if

		 'you can always grab a form input by it's properly-cased input name
		 'rather than using the collection method detailed above.
		'response.write oFO.Form("myName") & "<BR>"

		 'the FormEx method works just like the form method but allows you to
		 'specify a default value if the form input contains no valid data.
		'response.write oFO.FormEx("myName", "Anonymous") & "<BR>"
	end if

	 'print a handy upload again link back to the form.
	response.write "<BR><BR><A HREF=""" & _
		request.servervariables("SCRIPT_NAME") & """>upload again</A>"
else

	 'if the totalformcount property returns 0, no input was posted to the page
	 'so we might as well show the upload form and give them a chance to upload.
	oFO.ShowUploadForm request.servervariables("SCRIPT_NAME")
end if

'release FileUpload object to save memory.
set oFO = Nothing
%>