<%
'***********************************************************************
'** Copyright (C) 2001 - 2002 Max Yuan All Rights Reserved
'**
'** By using this program, you are agreeing to the terms of the
'** GNU General Public License.
'**
'** This program is free software; you can redistribute it and/or
'** modify it under the terms of the GNU General Public License
'** as published by the Free Software Foundation; either version 2
'** of the License, or any later version.
'**
'** All copyright notices regarding MaxWebPortal must remain intact
'** in the scripts and in the outputted HTML.
'** The "powered by" text/logo with a link back to 
'** http://www.maxwebportal.com in the footer of the pages MUST
'** remain visible when the pages are viewed on the internet or intranet.
'**
'** Support can be obtained from support forums at:
'** http://www.maxwebportal.com
'**
'** Email: maxwebportal@hotmail.com
'** ICQ: 148111300
'***********************************************************************
'** This Page Contains source code of Snitz Forums 2000
'***********************************************************************
'#################################################################################
'## Copyright (C) 2000  Michael Anderson and Pierre Gorissen
'## 
'## This program is free software; you can redistribute it and/or
'## modify it under the terms of the GNU General Public License
'## as published by the Free Software Foundation; either version 2
'## of the License, or any later version.
'##
'## All copyright notices regarding Snitz Forums 2000
'## must remain intact in the scripts and in the outputted HTML
'## The "powered by" text/logo with a link back to 
'## http://forum.snitz.com in the footer of the pages MUST
'## remain visible when the pages are viewed on the internet or intranet.
'## 
'## This program is distributed in the hope that it will be useful,
'## but WITHOUT ANY WARRANTY; without even the implied warranty of
'## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'## GNU General Public License for more details.
'## 
'## You should have received a copy of the GNU General Public License
'## along with this program; if not, write to the Free Software
'## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'## 
'## Support can be obtained from support forums at:
'## http://forum.snitz.com 
'##
'## Correspondence and Marketing Questions can be sent to:
'## reinhold@bigfoot.com
'## 
'## or
'## 
'## Snitz Communications 
'## C/O: Michael Anderson
'## PO Box 200
'## Harpswell, ME 04079
'#################################################################################
'##  Part of the SuperSearch Mod by Mark Findlay                                ##
'#################################################################################
CurPageType = "forums"
CurPageInfoChk = "1"
function CurPageInfo ()
	strOnlineQueryString = Request.QueryString
	if Request.QueryString("mode") = "news" then
	PageName = "News Search"
	else
	PageName = "Forum Search"
	end if
	PageAction = "Viewing<br>" 
	PageLocation = "search.asp?" & strOnlineQueryString & ""
	CurPageInfo = PageAction & " " & "<a href=" & PageLocation & ">" & PageName & "</a>"

end function
%>
<!--#INCLUDE FILE="config.asp" -->
<!--#INCLUDE FILE="inc_functions.asp" -->
<!--#INCLUDE FILE="inc_top.asp" -->
<% 
' do not alter an variables below this (in this group of variables)
dim strSearchStrings    ' contains all the users keywords
'	strSearchStrings = ChkString(Request.Form("Search"),"urlpath")
dim strSearchType     ' match all words, match any, exact phrase
	strSearchType = trim(Request.Form("andor"))
dim arrKeywords() ' array of keywords entered by the user. We will safety check them to a degree
dim arrTmp() ' temporary array used to hold only the unique keywords to avoid duplicate entry by user
dim bAtLeastOneKeywordValid
	bAtLeastOneKeywordValid=false
	

' StopPage
function StopPage()
	on error resume next
	rs.Close
	rs=nothing
	rsReplies.Close
	rsReplies=nothing
	rsOriginal.Close
	rsOriginal=nothing
	rsForumQry.Close
	rsForumQry=nothing
	Response.End
end function	
'---------------------------------------------
'GetMaxKeywordInputLength
' Returns the value set by the admin for max length of allowable keyword entry
'---------------------------------------------
function GetMaxKeywordInputLength()
	GetMaxKeywordInputLength = nMaxKeywordInputLength
end function
'---------------------------------------------
' BuildTmpArrayWithUniqueEntries
'---------------------------------------------
' This function transfers only the unique elements of the arrWords array
' into the global arrTmp array
function BuildTmpArrayWithUniqueEntries(arrWords)
	on error resume next
	
	' get size of current array
	nWordArrayTopIndex = ubound(arrWords)
	bFirstTime = true
	
	' for each word in current array, see if it exists in the new
	for each word in arrWords
	
		' word must be longer than 1 letter. Anyone searching for a single letter
		' needs some serious introspection:). Anyway, this is how we avoid the 
		' "corruption" of the text when inserting the keyword color coding.
		if Len(trim(word)) > 1 then
		
			bFound=false
		
			' what is the current size of the new array?
			if bFirstTime=true then
				bFirstTime=false
				nTmpTopIndex = -1
			else
				nTmpTopIndex = ubound(arrTmp)
			end if
		
			' compare each word in the new array with the word from the old
			if nTmpTopIndex >= 0 then
				for x = 0 to nTmpTopIndex
					if word = arrTmp(x) then
						bFound=true
						exit for
					end if
				next
			else
				' first time in, add the word to the first element of the new array
				ReDim Preserve arrTmp(1)
				arrTmp(0) = word
				bFound=true ' bypass check below
				bAtLeastOneKeywordValid=true
			end if
		
			' not found in new array, add it
			if bFound = false then
				ReDim Preserve arrTmp(nTmpTopIndex + 2)  ' redim takes 1-based number
				arrTmp(nTmpTopIndex+1) = word
				bAtLeastOneKeywordValid=true
			end if
			
		end if ' Len > 1
		
	next ' for each word in arrWords
	
end function	
%>
<script language="JavaScript">
<!-- hide from JavaScript-challenged browsers
function openWindow3(url) 
{
  	popupWin = window.open(url,'SearchHelp','width=500,height=450,scrollbars=yes')
}
function RefreshS() {
if (document.SearchForm.news.checked) {
	window.location ="search.asp?mode=news";
} else {
	window.location ="search.asp";
}
}
// done hiding -->
</script>
<%  ' This sets a variable that is inspected near the bottom to determine whether to display
    ' the query strings used in the search.
	dim bAdmin
   	
	' Only show the "Display Queries" option by default to administrators and moderators
	if (mlev = 4 or mlev = 3) then 
		bAdmin = true
   	else
    	bAdmin = false
	end if 
	
	' Handle condition where search results in not items and from 
	' the "no Items" page the user presses logout. This results 
	' in an endless loop between the logout screen and the search page.
	' This check checks for a hidden form field which will only 
	' be present when search is entered from another search.
	If Request.QueryString("mode") = "DoIt" then
		if (Request.Form("NavCheck") = "") then
			Response.Redirect("search.asp")
		end if
	end if


' START Protected Variables! (see from here to END protected variables)
' Do not change these, they are used to create the querystring passed to topic.asp when
' a user selects a search result

dim strReplyID 
strReplyID = "replyid="
dim sWhichPage
sWhichPage = "&whichpage="  ' used to tell the topic.asp page which page to show
Dim strAllReplyIDs    		' all reply IDs for a given topic whether they are a search hit or not (comma delimited)
Dim strReplyIDs		  		' all reply IDs that are a search hit (comma delimited)

dim arrAllReplyIDs	' array of ALL reply IDs for this topic
dim narrAllReplyIDsUpperBound ' upper bound index of ALL Reply IDs array for this topic

' small icon displayed next to search result line in the search results. 
dim strSearchFindIcon
strSearchFindIcon = "<br><img src=""icon_searchfind.gif"" border=""0"">"
' equivalent invisible icon so lines lineup ok in display results
dim strInvisibleIcon
strInvisibleIcon = "<br><img src=""icon_searchfind_invisible.gif"" border=""0"">"
' flag to indicate whether original search was found in the starting topic or one or more of the replies.
dim bOriginalMsgContainsHit
bOriginalMsgContainsHit = false
' END protected variables

'----------------------------------------
' START customizable variables
' You can change these to suit your taste


' -------SUPERSEARCH MOD BEGIN 2.1 ----------------------
dim nMaxKeywords
	nMaxKeywords = 5 ' to prevent malicious or unintentional mis-use. We will pass these values to topic.asp 
					 ' via the hyperlinks.
					 ' This value is the maximum number of keywords to allow to go into the query statement.
					 ' This is evaluated AFTER the edits on the keywords to strip out NULL values and duplicate
					 ' values.
					 
dim nMaxKeywordInputLength
	nMaxKeywordInputLength = 64  ' This is the max allowable length of entire keyword entry field. This to 
								 ' prevent malicious or at least unintentional supersized strings being sent
								 ' to the query.
' -------SUPERSEARCH MOD END 2.1 ----------------------


' Version 1.1 of SuperSearch allows the user to select multiple members to narrow
' the search on. The impact of this could be severe on a system with 1000 members and 999 of
' them selected. Besides, I don't know if there is a limit on 8479854231 a querystring and whether
' this could crash the query. So this limits the number of members the user can select 
' in the search form selection criteria. Current Default = 5. Zero = no limit.
' BE SURE TO: Set corresponding nMaxSelMemberCount variable in Javascript below
dim nMaxSelectMemberCount
nMaxSelectMemberCount = 5   ' BE SURE TO: Set corresponding nMaxSelMemberCount variable in Javascript below

'------------------------------------------------------------------------------------------
' GetMaxSelectForumLimitStr() - returns the string representation of the max forums allowed
' to be selected.
'------------------------------------------------------------------------------------------
function GetMaxSelectMemberLimitStr()

	if nMaxSelectMemberCount = 0 then
		GetMaxSelectMemberLimitStr = "no limit"
	else
		GetMaxSelectMemberLimitStr = CStr(nMaxSelectMemberCount)
	end if
	
end function

' Version 1.1 of SuperSearch allows the user to select multiple forums to narrow
' the search on. The impact of this could be severe on a system with 50 forums and 49 of
' them selected. Besides, I don't know if there is a limit on a querystring and whether
' this could crash the query. So this limits the number of forums the user can select 
' in the search form selection criteria. Current Default = 5. Zero = no limit
' BE SURE TO: Set corresponding nMaxSelForumCount variable in Javascript below
dim nMaxSelectForumCount
nMaxSelectForumCount = 5  ' BE SURE TO: Set corresponding nMaxSelForumCount variable in Javascript below

'-------------------------------------------------------------------------------------------
' GetMaxSelectForumLimitStr() - returns the string representation of the max forums allowed
' to be selected.
'-------------------------------------------------------------------------------------------
function GetMaxSelectForumLimitStr()

	if nMaxSelectForumCount = 0 then
		GetMaxSelectForumLimitStr = "no limit"
	else
		GetMaxSelectForumLimitStr = CStr(nMaxSelectForumCount)
	end if
	
end function

%>
<script  language="JavaScript">
<!-- 
function CheckForm () {
	
	var nForumCount=0;
	var nMemberCount=0;
	var bAllMembersSelected=false;
	var bAllForumsSelected=false;
	
	for (x = 0;x < document.SearchForm.reclimit.value.length ;x++)
	{
		if ((document.SearchForm.reclimit.value.charAt(x) < "0") || (document.SearchForm.reclimit.value.charAt(x) > "9"))
		{
			alert("Please enter only numbers in the record limit field.");
			return false;
		}
	}
	
	if (document.SearchForm.Search.value == "")
	{
		alert("Please enter at least 1 keyword to search for");
		return false;
	}
	
	// nMaxSelMemberCount is the max number of members we will let the user select.
	// If zero, there is no limit.
	if (nMaxSelMemberCount > 0)
	{
		// get a count of all SELECTED members
		for (x = 0;x < document.SearchForm.SearchMember.length ;x++)
		{
			// if the first item (ALL MEMBERS) was selected, turn off all other members since
			// we are searching for ALL
			if (bAllMembersSelected)
			{
				// set "selected" property to false
				document.SearchForm.SearchMember.options[x].selected=false;
				continue;
			}
			
			// if this member is selected...
			if (document.SearchForm.SearchMember.options[x].selected == true)
			{
				// if this is the first (ALL MEMBERS) option, set our flag
				if (x==0)
				{
					bAllMembersSelected=true;
				}
				
				nMemberCount++;
			}
		}
		
		
		// Did the user exceed the max allowable?
		if (nMemberCount > nMaxSelMemberCount)
		{
			alert("You have selected too many items from the Member list. Please limit the number of items selected to the limit count shown.");
			return false;
		}
	}
	
	
	// nMaxSelForumCount is the max number of forums we will let the user select.
	// If zero, there is no limit.
	if (nMaxSelForumCount > 0)
	{
		// get a count of all SELECTED forums
		for (x = 0;x < document.SearchForm.Forum.length ;x++)
		{
			// if the first item (ALL FORUMS) was selected, turn off all other forums since
			// we are searching for ALL
			if (bAllForumsSelected)
			{
				// set "selected" property to false
				document.SearchForm.Forum.options[x].selected=false;
				continue;
			}

			// if this forum is selected...
			if (document.SearchForm.Forum.options[x].selected == true)
			{
				// if this is the first (ALL FORUMS) option, set our flag
				if (x==0)
				{
					bAllForumsSelected=true;
				}
			
				nForumCount++;
			}
		}
		
		// Did the user exceed the max allowable?
		if (nForumCount > nMaxSelForumCount)
		{
			alert("You have selected too many items from the Forum list. Please limit the number of items selected to the limit count shown.");
			return false;
		}
	}
	
	// If the user selected every listbox item except the first (ALL FORUMS) then just de-select
	// all the other items and select the "ALL FORUMS" item. This will result in no qualifiers in 
	// the resulting query for FORUMS (which is what we want for ALL FORUMS)
	// Do the same for the members list
	if ((bAllForumsSelected==false) && (nForumCount >= document.SearchForm.Forum.length - 1))
	{
		document.SearchForm.Forum.options[0].selected=true;
		for (x = 1;x < document.SearchForm.Forum.length ;x++)
		{
			document.SearchForm.Forum.options[x].selected=false;
		}
	}
	
	// same as the forum check above, only for members.
	if ((bAllMembersSelected==false) && (nMemberCount >= document.SearchForm.SearchMember.length - 1))
	{
		document.SearchForm.SearchMember.options[0].selected=true;
		for (x = 1;x < document.SearchForm.SearchMember.length ;x++)
		{
			document.SearchForm.SearchMember.options[x].selected=false;
		}
	}
	
	// form passes. Ok to pass it on to the search mechanism
	return true
}
// -->
</script>
<%

' Set this to true to display all the queries used by the search, on the bottom of this page FOR ALL USERS.
' All users who use the search page will be able to set a checkbox item at search time that will display
' the queries performed by the search.
' The checkbox should be used for debugging purposes so you or the member can see what
' query might be causing a problem. When you set this to true, ALL USERS will have that 
' checkbox option on the SEARCH entry form.
' If you set this to false, only the ADMIN will see the checkbox. The Admin sees it regardless
' of whether this is true or false.
dim bSearchDebugMode
bSearchDebugMode = false    ' default is false. Set to true to enable all users to see the 'display queries' checkbox

' if the Display Quiery Strings checkbox is checked, set the debug mode to ON
if (Request.Form("chkShowQueries") = "chkShowQueries") then
	bSearchDebugMode=true
end if

' Max size of msg to display in first colunm of search results. Set this so that there is no line wrapping.
' Each found hit displayed should only take up 1 line so the other columns line up correctly. This is meant
' only as a quick reference anyway. 
' The DEFAULT string displayed is not the first x chars of the original message anyway since I could 
' not find a reasonable way to strip out the HTML codes from it and it was appearing in the display 
' as weird text. If you find a way let me know and I will incorporate into the mod.
dim nMaxMsgReferenceSize
nMaxMsgReferenceSize = 50

' max size of author's name to appear in search results. 
dim nMaxAuthorReference
nMaxAuthorReference = 35

' Custom msg to appear in place of msg content of msg found since there could be garbage in the string.
' This is the DEFAULT. See function DisplayReplyMessageCell() for its use.
' You can change this text to suit your own taste as well.
dim sLinkMsg
sLinkMsg = "View post with keyword highlighted..."

' boolean to indicate whether or not to use the custom msg above. Value are true or false.
' DEFAULT is true so user will see for each message found: "Click here to view post..."
dim bUseCustomMsg
bUseCustomMsg = true
' END customizable variables
'------------------------------------------


' Do not alter these
dim nMaxRecsToDisplay
nMaxRecsToDisplay = CInt(Request.Form("reclimit"))
dim bLimitDisplayRecs
if nMaxRecsToDisplay > 0 then
	bLimitDisplayRecs=true
else
	bLimitDisplayRecs=false
end if

dim nRecsDisplayedSoFar
nRecsDisplayedSoFar = 0
dim nRepliesDisplayedSoFar
nRepliesDisplayedSoFar = 0
dim nAuthorsDisplayedSoFar
nAuthorsDisplayedSoFar = 0

dim bNoHitsMsgDisplayed
bNoHitsMsgDisplayed=false
dim bLinesDisplayed
bLinesDisplayed=false
dim arrQueryForumIDs ' array of forum IDs containing search hits
dim nQueryForumIDsTopIndex ' top array index of arrQueryForumIDs
dim strProcessedForumIDs ' forum IDs already displayed to the user during the normal display

function ForumIDInProcessedHits(nID)
	arrProcessedIDs = split(strProcessedForumIDs,",")
	nProcessedIDsTopIndex = ubound(arrProcessedIDs)
	for x=0 to nProcessedIDsTopIndex
		if (nID = CInt(arrProcessedIDs(x))) then
			ForumIDInProcessedHits=true
			exit function
		end if
	next
	ForumIDInProcessedHits=false
end function

function ForumIDInSearchHits(nID)
	for x=0 to nQueryForumIDsTopIndex
		if (nID = CInt(arrQueryForumIDs(x))) then
			ForumIDInSearchHits=true
			if strProcessedForumIDs <> "" then strProcessedForumIDs = strProcessedForumIDs & ","
				strProcessedForumIDs = strProcessedForumIDs & CStr(nID)
			exit function
		end if
	next
	ForumIDInSearchHits=false
end function


	if Request.Form("Forum") <> "0" then
		' parse the individual forum IDs selected into an array 
		arrForumIDs = split(Request.Form("Forum"),",")
		' determine the top zero-based index of the array
		nForumIDTopIndex = ubound(arrForumIDs)
		bSearchByForums=true
	else
		bSearchByForums=false
	end if
	
	if Request.Form("SearchMessage") = 1 then
		bSubjectOnly=true
	else
		bSubjectOnly=false
	end if
	
	if Request.Form("SearchMember") <> "0" then
		bSearchByMember=true
		' parse the individual forum IDs selected into an array 
		arrMemberIDs = split(Request.Form("SearchMember"),",")
		' determine the top zero-based index of the array
		nMemberIDTopIndex = ubound(arrMemberIDs)
	else
		bSearchByMember=false
	end if

'-------------------------------
' BuildForumIDs
' Called by BuildWhereClause - adds qualifiers for the FORUMS if user selecting specific forums
'-------------------------------
function BuildForumIDs()

	BuildForumIDs=""
	
	if bSearchByForums=false then
		exit function
	end if
				
	BuildForumIDs = BuildForumIDs & " AND ("
	strTmp=""
			
	for nForumIndex = 0 to nForumIDTopIndex
		if strTmp <> "" then	
			strTmp = strTmp & " OR "
		end if
				
		' don't write FORUMID of 0 since there is no such forum. zero represents all forums.
		' It should never appear due to the edit check we have above but just to be safe....
		if arrForumIDs(nForumIndex) <> "0" then
			strTmp = strTmp & strTablePrefix & "FORUM.FORUM_ID = " & arrForumIDs(nForumIndex)
		end if
	next

	BuildForumIDs = BuildForumIDs & strTmp & ") "

end function


'-----------------------------------------------------------
' BuildForums
' This function builds the FORUM DESCRIPTION checking of each word. 
'-----------------------------------------------------------
function BuildForums(strWord)
	'BuildForums = ""
	'exit function
	
	' for single word
	if strWord <> "" then
		BuildForums = "(" & strTablePrefix & "FORUM.F_DESCRIPTION LIKE '%" & strWord & "%'"
		BuildForums = BuildForums & " OR "
		BuildForums = BuildForums & strTablePrefix & "FORUM.F_SUBJECT LIKE '%" & strWord & "%')"
		exit function
	end if
	
	' for multiple words to be AND'd since this is called when 'match all words' is selected
	strTmp=""
	BuildForums = "("
	
	' ---------------------SUPERSEARCH MOD BEGIN 2.1 -------------------------
	'For Each word in keywords
	For Each word in arrKeywords
	' ---------------------SUPERSEARCH MOD BEGIN 2.1 -------------------------
		SearchWord = ChkString(word, "SQLString")
						
		SearchWord = trim(SearchWord)
		if SearchWord <> "" then
				
			if strTmp <> "" then	
				strTmp = strTmp & " AND "
			end if  
						
			strTmp = strTmp & "(" & strTablePrefix & "FORUM.F_DESCRIPTION LIKE '%" & SearchWord & "%'"
			strTmp = strTmp & " OR "
			strTmp = strTmp & strTablePrefix & "FORUM.F_SUBJECT LIKE '%" & SearchWord & "%')"
			
		end if
	next
	
	BuildForums = BuildForums & strTmp & ")"
	
end function

'-----------------------------------------------------------
' BuildAuthors
' Called by BuildWhereClause - builds the "AND (T_AUTHOR=x OR T_AUTHOR=y)" portion of any where clause
' strTopicOrReply needs to be "T" or "R"
'-----------------------------------------------------------
function BuildAuthors(strTopicOrReply)
	BuildAuthors=""
	
	' not searching by author(s)
	if bSearchByMember=false then
		exit function
	end if
	
	if strTopicOrReply = "T" then 
		strField = "TOPICS.T_AUTHOR = "
	else
		strField = "REPLY.R_AUTHOR = "
	end if
	
	BuildAuthors = BuildAuthors & " AND ("
	strTmp=""
			
	for nMemberIndex = 0 to nMemberIDTopIndex
		if strTmp <> "" then	
			strTmp = strTmp & " OR "
		end if
				
		' don't write MEMBERID of 0 since there is no such member. zero represents all members.
		' It should never appear due to the edit check we have above but just to be safe....
		if arrMemberIDs(nMemberIndex) <> "0" then
			strTmp = strTmp & strTablePrefix & strField & arrMemberIDs(nMemberIndex) 
		end if
	next
			
	BuildAuthors = BuildAuthors & strTmp & ") "
	
end function


	if Request.Form("SearchDate") <> 0 then
		dt = cint(Request.Form("SearchDate"))
		bSearchByDate=true
	else
		bSearchByDate=false
	end if

'-----------------------------------------------------------
' BuildDateCriteria
' Called by BuildWhereClause - builds the "AND (R_DATE > xxxx)" portion of any where clause
' strFIELD needs to be either "R_DATE" or "T_DATE"
'-----------------------------------------------------------
function BuildDateCriteria(strFIELD)
	BuildDateCriteria=""
	
	' not searching by date
	if bSearchByDate=false then
		exit function
	end if
	
	BuildDateCriteria = BuildDateCriteria & " AND (" & strFIELD & " > '" & DateToStr(dateadd("d", -dt, strForumTimeAdjust)) & "')"
				
end function
'----------------------------------------------------------
' BuildReply
' Called by BuildWhereClause - builds the REPLY MESSAGE LIKE portion
'-----------------------------------------------------------
function BuildReply(strWord)
	
	' for single word
	if strWord <> "" then
		BuildReply = "(" & strTablePrefix & "REPLY.R_MESSAGE LIKE '%" & strWord & "%')"
		exit function
	end if
	
	' for multiple words to be AND'd since this is called when 'match all words' is selected
	strTmp=""
	BuildReply = "("
	
	' ---------------------SUPERSEARCH MOD BEGIN 2.1 -------------------------
	'For Each word in keywords
	For Each word in arrKeywords
	' ---------------------SUPERSEARCH MOD END 2.1 -------------------------
		SearchWord = ChkString(word, "SQLString")
						
		SearchWord = trim(SearchWord)
		if SearchWord <> "" then
				
			if strTmp <> "" then	
				strTmp = strTmp & " AND "
			end if  
						
			strTmp = strTmp & strTablePrefix & "REPLY.R_MESSAGE LIKE '%" & SearchWord & "%'"
		end if
	next

	BuildReply = BuildReply & strTmp & ")"
end function

'----------------------------------------------------------
' BuildMessage
' Called by BuildWhereClause - builds the (FORUM_TOPICS.T_SUBJECT LIKE '%what%' OR FORUM_TOPICS.T_MESSAGE LIKE '%what%')
' portion depending on whether bSubjectOnly is used
'-----------------------------------------------------------
function BuildMessage(strWord)

	BuildMessage="("

	' if building with a single word
	if strWord <> "" then
		BuildMessage = BuildMessage & strTablePrefix & "TOPICS.T_SUBJECT LIKE '%" & strWord & "%'"
		if bSubjectOnly=false then
			BuildMessage = BuildMessage & " OR " & strTablePrefix & "TOPICS.T_MESSAGE LIKE '%" & strWord & "%'"
		end if
	else
		' else building with 'match all words'
		strTmp=""
		BuildMessage = "("
	
		' ---------------------SUPERSEARCH MOD BEGIN 2.1 -------------------------
		'For Each word in keywords
		For Each word in arrKeywords
		' ---------------------SUPERSEARCH MOD END 2.1 -------------------------
			SearchWord = ChkString(word, "SQLString")
						
			SearchWord = trim(SearchWord)
			if SearchWord <> "" then
				
				if strTmp <> "" then	
					strTmp = strTmp & " AND "
				end if  
						
				strTmp = strTmp & strTablePrefix & "TOPICS.T_SUBJECT LIKE '%" & SearchWord & "%'"
			end if
		next

		BuildMessage = BuildMessage & strTmp & ")"
		
		' Now add the message part if appropriate
		if bSubjectOnly=false then
			BuildMessage = BuildMessage & " OR "
			strTmp=""
			BuildMessage = "("
	
			' ---------------------SUPERSEARCH MOD BEGIN 2.1 -------------------------
			'For Each word in keywords
			For Each word in arrKeywords
			' ---------------------SUPERSEARCH MOD END 2.1 -------------------------
				SearchWord = ChkString(word, "SQLString")
						
				SearchWord = trim(SearchWord)
				if SearchWord <> "" then
				
					if strTmp <> "" then	
						strTmp = strTmp & " AND "
					end if  
						
					strTmp = strTmp & strTablePrefix & "TOPICS.T_MESSAGE LIKE '%" & SearchWord & "%'"
				end if
			next

			BuildMessage = BuildMessage & strTmp & ")"
			
		end if
	
	end if
	
	BuildMessage = BuildMessage & ")"
	
end function

'----------------------------------------------------------------------
' BuildWhereClause
' Given a single word or phrase (treats both same), and an indicator
' as to whether to include the subject in the clause, build a 
' single where portion. 
' This function will be called once for each word, or only once
' with the exact phrase.
' It will return a string similar to: (depending on whether date and member options are in place)
'( 
'(FORUM_REPLY.R_MESSAGE LIKE '%what%' AND (FORUM_REPLY.R_AUTHOR = 1) AND (R_DATE > '2001060300000'))
'OR FORUM_FORUM.F_DESCRIPTION LIKE '%what%' 
'OR ((FORUM_TOPICS.T_SUBJECT LIKE '%what%' OR FORUM_TOPICS.T_MESSAGE LIKE '%what%') AND (FORUM_TOPICS.T_AUTHOR = 1)AND (T_DATE > '2001060300000'))
') 
function BuildWhereClause(strWord)
	BuildWhereClause = "("
	
	
	
	' ---- SUPERSEARCH MOD BEGIN 2.2 --------
	if (bSearchByForum=true) OR (bSearchByDate=true) OR (bSearchByMember=true) OR (bSubjectOnly=false) then
	' ---- SUPERSEARCH MOD END 2.2 --------
	
		' Check reply messages
		BuildWhereClause = BuildWhereClause & "("
		BuildWhereClause = BuildWhereClause & BuildReply(strWord)
		BuildWhereClause = BuildWhereClause & BuildAuthors("R")
		BuildWhereClause = BuildWhereClause & BuildDateCriteria("R_DATE")
		BuildWhereClause = BuildWhereClause & BuildForumIDs()
		BuildWhereClause = BuildWhereClause & ")"
	
	' Check topics (original messages)
	BuildWhereClause = BuildWhereClause & " OR "
	' ---- SUPERSEARCH MOD BEGIN 2.2 --------
	end if
	' ---- SUPERSEARCH MOD END 2.2 --------
	BuildWhereClause = BuildWhereClause & "(" 
	BuildWhereClause = BuildWhereClause & BuildMessage(strWord)
	BuildWhereClause = BuildWhereClause & BuildAuthors("T")
	BuildWhereClause = BuildWhereClause & BuildDateCriteria("T_DATE")
	BuildWhereClause = BuildWhereClause & BuildForumIDs()
	BuildWhereClause = BuildWhereClause & ")"

	if strWord <> "" then
		BuildWhereClause = BuildWhereClause & ")"
	end if
	
end function

'---------------------------------------------------------------
' BuildForumWhereClause
' Builds the where clause for the forum query
'---------------------------------------------------------------
function BuildForumWhereClause(strWord)
	BuildForumWhereClause = BuildForums(strWord)
	BuildForumWhereClause = BuildForumWhereClause & BuildForumIDs()
end function


'-----------------------------------------------------------------
' RemoveGarbageFromString
' 
' I tried to get this to work correctly 100% but just never could
' so if you know a way to strip ALL the html codes from a message
' prior to displaying it (See function DisplayReplyMessageCell() for its use)
' then I would be very happy to know. Please send the fix to me. 
' For now, it strips out most of the chars, but even then it does
' it by using a cludgy byte by byte inspection. InStr had all
' sorts of problems. That's why you see the 'exit function' call
' in the middle of this function. I wanted to leave the remaining
' code in place in case it helped anyone come up with a working 
' solution to this issue.
'
' This function will attempt to remove any leading tags from
' a string. It will only attempt to remove if the string begins
' with a '<' char. It will search for the matching '>' char and
' remove everying in the middle inclusive. It will then
' do it again until the leading char is no longer a '<'
' Then it will truncate the resulting string if need be
' to fit in the nResultingMaxLen.
'
' This function is called just before displaying a message
' line from a search as a hyper link. We don't want any
' of the <BLOCKQUOTE stuff in the display string.
' The caller will pass the opening  char to look for. If found,
' truncate the string to that length immediately and finish.
'-----------------------------------------------------------------
function RemoveGarbageFromString(strMsg, sStartChar, sEndChar, nResultingMaxLen)
	on error resume next

	
	nLen = Len(strMsg)
	for x = 1 to nLen
		sChar = Mid(strMsg,x,1)
		if  (sChar = ";")OR (sChar = " ") OR (sChar = ".") OR (sChar = ",") OR (sChar >= "a" AND sChar <= "z") OR (sChar >= "A" AND sChar <= "Z") OR (sChar >= "0" AND sChar <= "9") then
			sRes = sRes + sChar
		end if
	next
	
	'------------------------
	nStart = InStr(sRes,"lt") 
	
	'if nStart > 0 then
	while nStart > 0  
		' attempt to find the ending char
		nEnd = InStr(sRes,"gt;") 
		
		' if closing char found, remove everything inside inclusive
		if nEnd > 0 then 
			s1 = Mid(sRes,1,nStart-1)
			s2 = Mid(sRes,nEnd+3)
			sRes = s1 & s2
			' Call ourself again to search and clean any other occurrences of the chars
			nStart = InStr(sRes,"lt;") 
		else
			nStart = 0
		end if
	wend
	
	' catch any stragglers
	sRes = replace(sRes, "lt;", "")
	sRes = replace(sRes, "gt;", "")

	'------------------------
	
	
	nLen = Len(sRes)
	if nLen > nResultingMaxLen then
		sRes = Mid(sRes,1,nResultingMaxLen)
	end if
	
	RemoveGarbageFromString = sRes
	' exit function is intentional. See function comments above.
	exit function
	
	' IMPORTANT!!!! Convert the "&lt;" to a single "<" for searching and replacing!!!!
	' Wow - hard to know that "&lt;" was being stored in the database, since the access
	' view of the data showed it as a single char: "<" even in the table views!!!!!!
	'Response.Write("Pre string is " & strMsg)
	
	strMsg = replace(strMsg, "&lt;", "<<")
	'Response.Write("FIRST PASS string is " & strMsg)
	strMsg = replace(strMsg, "&gt;", ">>")
	
	
	' trim left and right of spaces
	strMsg = Trim(strMsg)

	nStart = InStr(strMsg,"<<") 
	
	'if nStart > 0 then
	if nStart > 0  then
		' attempt to find the ending char
		nEnd = InStr(strMsg,">>") 
		
		' if closing char found, remove everything inside inclusive
		if nEnd > 0 then 
			s1 = Mid(strMsg,1,nStart-1)
			s2 = Mid(strMsg,nEnd+2)
			strMsg = s1 & s2
			' Call ourself again to search and clean any other occurrences of the chars
			strMsg = RemoveGarbageFromString(strMsg, sStartChar, sEndChar, nResultingMaxLen)
		end if
	end if
	
	
	' with the resulting string, trim to size if necessary
	nLen = Len(strMsg)
	if nLen > nResultingMaxLen then
		strMsg = Mid(strMsg,1,nResultingMaxLen)
	end if
	
	RemoveGarbageFromString = strMsg
end function


'----------------------------------------------------------------------------------
' GetReplyIDs
' Given a recordset of repliesIDs, load a string delimited with commas of the IDs
' This function is only called if there ARE replies. If not, the strReplyIDs will have
' already been set to "0" representing the original message had the seach hit.
' ---------------------------------------------------------------------------------
Function GetReplyIDs(rsReplies, bOriginalMsgContainsHit)
	on error resume next
	
	' If the original message also contained a hit, include it in 
	' the list of 'replies' as ID of zero.
	if bOriginalMsgContainsHit then
		GetReplyIDs = "0"
	else
		GetReplyIDs = ""
	end if
	
	' start at top of recordset
	rsReplies.MoveFirst
	if err.number <> 0 then
		exit function
	end if
	
	' loop through record set
	while NOT (rsReplies.EOF or rsReplies.BOF) 
	
		' add a comma before the next entry if this is not the first time through the loop
		if GetReplyIDs <> "" then 
			GetReplyIDs = GetReplyIDs & ","
		end if
		
		' append to the reply IDs
		GetReplyIDs = GetReplyIDs & CStr(rsReplies("REPLY_ID"))
	
		' get next record from the recordset
		rsReplies.MoveNext
		
		if err.number <> 0 then
			exit function
		end if
	wend
	
	' if there are no results, then the only hit must have been on the original
	' message, which we are representing as zero.
	if GetReplyIDs = "" then
		GetReplyIDs = "0"
	end if	
	
end function

'--------------------------------------------------------------------------------------
' GetWhichPage(nIndex)
' formats a whichpage=x string for use in calling the topic.asp page
' and telling it the correct page to display the passed item.
' It is calculated by using the strPageSize setting.
' The passed value is the reply ID 
' OF THE REPLY FOR THIS TOPIC i.e. 1, 12, 33, 74, 95, etc.
' An nIndex of 0 means it is the original topic, not a reply, so it always page 1
' So essentially the nIndex should be considered a 1-based index. 
' Any other value and we find the INDEX of that value in the array of ALL REPLY IDs
' and calculate the whichpage based on that index.
'--------------------------------------------------------------------------------------
function GetWhichPage(nReplyID)

	if nReplyID < 0 then
		GetWhichPage = sWhichPage & CStr(1)
		exit function
	end if

	' init
	nIndex = -1
	
	' Get the index of the nReplyID 
	'arrAllReplyIDs = split(strAllReplyIDs, ",")
	'narrAllReplyIDsUpperBound = ubound(arrAllReplyIDs)
	' examine each array occurrence to try and match the passed replyID
	for x = 0 to narrAllReplyIDsUpperBound
		if nReplyID = CInt(arrAllReplyIDs(x)) then
			nIndex = x
			exit for
		end if
	next

	' Make nIndex 1-based for mathpurposes
	nIndex = nIndex + 1
	
	' If this will appear on the first page, just set the whichpage to 1
	if nIndex <= CInt(strPageSize) then
		GetWhichPage = sWhichPage & "1"
	else
		' how appropriate...MOD
		nMod = CInt(nIndex) MOD CInt(strPageSize)
		
		' determine which page this ID will appear based on the number of
		' replies allowed per page as set by the admin in the Features Configuration
		nPage = nIndex \ CInt(strPageSize)
		if nMod <> 0 then
			nPage = nPage + 1
		end if
	
		GetWhichPage = sWhichPage & CStr(nPage)
	end if
		
end function

'------------------------------------------------------------------------------
' DisplayReplyMessageCell
' Given an open recordset, display the contents of the first (TOPIC) column 
' with the beginning of the message. Do not close the recordset 
' when done since there will be other columns and records to display. 
' reReplies = Recordset containing the replies for the topic
' nReplyCount = number of replies for the topic
' rs = Recordset of parent query performing the search
' bOriginalMsgContainsHit = true/false indicating whether or not original topic contains search hits
' strReplyIDs = comma delimited string of all REPLY_IDs for the replies.
'--------------------------------------------------------------------------------
function DisplayReplyMessageCell(rsReplies,nReplyCount,rs, bOriginalMsgContainsHit, strReplyIDs)
	on error resume next
	
	' if max record count exceeded, stop showing
	if (bLimitDisplayRecs=true) and (nRecsDisplayedSoFar >= nMaxRecsToDisplay) then
		exit function
	end if
	' Build a link surrounding the search hit item. We will build a jumplink into the link
	' so that when the user selects that entry, they are placed not only on the right page
	' but are jumped directly to the right message. topic.asp will build the named anchor
	' for each hit item.
	
	' strPageSize = GLOBAL - number of replies to be listed per page. 
	' NOTE!!!!!! This does NOT include the initial topic posting. So if you have strPageSize set to 1
	'            meaning 1 reply per page, your first page will be the original message PLUS the 1st reply.
	'            All other pages will have Just the single reply.
	
	' Note that the hyperlinks are built in 2 places in this function. The first for the 
	' original message, which comes into the function first. Then the remaining a few lines
	' below where the replies processing loop is.
	
	' if no replies, just show the link to the original message containing the keyword hits
	' from the first query's recordset
	if bOriginalMsgContainsHit = true then
	
		sMsg=""
		' get the message from the record set
		sMsg = ChkString(left(rs("T_MESSAGE"),nMaxMsgReferenceSize),"display")
		
		' I GIVE UP! sMsg = RemoveGarbageFromString(sMsg, "&lt;", "&gt;", nMaxMsgReferenceSize)
		if bUseCustomMsg = true then
			sMsg = sLinkMsg
		end if
		
		
		' write the search hit icon
		Response.Write(strSearchFindIcon)
		' For the original message the SearchHit number will be zero.
		' -------------SUPERSEARCH MOD BEGIN 2.1 ---------------------------
		'Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & GetWhichPage(0) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit0" & """>" & sMsg & "</a>")
		Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & "&SearchStrings=" & strSearchStrings & "&SearchType=" & strSearchType & GetWhichPage(0) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit0" & """>" & sMsg & "</a>")
		' -------------SUPERSEARCH MOD END 2.1 ---------------------------
		nRecsDisplayedSoFar = nRecsDisplayedSoFar + 1
		
		' if no replies, exit after just showing the original message
		if nReplyCount < 1 then
			exit function
		end if
		
	end if 
	
	' Otherwise, there were replies, but we need to determine if the original message
	' also contained keywords. This is handled already and the bOriginalMsgContainsHit set to true
	' if so.
	
	' start at top of recordset
	rsReplies.MoveFirst
	if err.number <> 0 then
		exit function
	end if
	
	err.number=0
	while (NOT rsReplies.EOF) AND (NOT rsReplies.BOF) 
		
		' if max record count exceeded, stop showing
		if bLimitDisplayRecs=true and nRecsDisplayedSoFar >= nMaxRecsToDisplay then
			exit function
		end if

		
		sMsg=""
		' get the message
		sMsg = ChkString(left(rsReplies("R_MESSAGE"),nMaxMsgReferenceSize),"display")
		
		' I GIVE UP!!! sMsg = RemoveGarbageFromString(sMsg, "&lt;", "&gt;", nMaxMsgReferenceSize)
		if bUseCustomMsg = true then
			sMsg = sLinkMsg
		end if
		
		if err.number <> 0 then
			exit function
		end if

		' write the search hit icon
		Response.Write(strSearchFindIcon)
		' provide the reply link
		' -------------SUPERSEARCH MOD BEGIN 2.1 ---------------------------
		'Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & GetWhichPage(rsReplies("REPLY_ID")) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit" & CStr(rsReplies("REPLY_ID")) & """>" & sMsg & "</a>")
		Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & "&SearchStrings=" & strSearchStrings & "&SearchType=" & strSearchType & GetWhichPage(rsReplies("REPLY_ID")) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit" & CStr(rsReplies("REPLY_ID")) & """>" & sMsg & "</a>")
		' -------------SUPERSEARCH MOD END 2.1 ---------------------------
		
		nRecsDisplayedSoFar = nRecsDisplayedSoFar + 1
		
		rsReplies.MoveNext
		
	wend	
	
end function

'-------------------------------------------------------------------------------------
' DisplayReplyAuthorCell
' Given an open recordset, display the contents of the AUTHOR column 
' with the beginning of the message. Do not close the recordset 
' when done since there will be other columns and records to display. 
'-------------------------------------------------------------------------------------
function DisplayReplyAuthorCell(rsReplies,nReplyCount,rs, bOriginalMsgContainsHit)
	on error resume next
	
	' if max record count exceeded, stop showing
	if bLimitDisplayRecs=true and nAuthorsDisplayedSoFar >= nMaxRecsToDisplay then
		exit function
	end if

	' if no replies, just show the link to the original author containing the keyword hits
	' from the first query's recordset
	if bOriginalMsgContainsHit = true then
		sMsg = ChkString(left(rs("M_NAME"), nMaxAuthorReference),"display")
		Response.Write(strInvisibleIcon & sMsg)
		
		nAuthorsDisplayedSoFar = nAuthorsDisplayedSoFar + 1
		
		' if no replies, exit after just showing the original message
		if nReplyCount < 1 then
			exit function
		end if
		
	end if 

	' start at top of recordset
	rsReplies.MoveFirst
	if err.number <> 0 then
		exit function
	end if
	
	while NOT (rsReplies.EOF or rsReplies.BOF) 
	
		' if max record count exceeded, stop showing
		if bLimitDisplayRecs=true and nAuthorsDisplayedSoFar >= nMaxRecsToDisplay then
			exit function
		end if
	
	
		sMsg = ChkString(left(rsReplies("M_NAME"), nMaxAuthorReference),"display")
		
		if err.number <> 0 then
			exit function
		end if

		' write the invisible icon for alignment followed by the author
		Response.Write(strInvisibleIcon & sMsg)
		
		nAuthorsDisplayedSoFar = nAuthorsDisplayedSoFar + 1
		
		rsReplies.MoveNext
	wend	
	
end function

'---------------------------------------------------------------------------------------------
' DisplayReplyDateCell
' Given an open recordset, display the contents of the REPLY DATE column 
' with the beginning of the message. Do not close the recordset 
' when done since there will be other columns and records to display. 
'---------------------------------------------------------------------------------------------
function DisplayReplyDateCell(rsReplies,nReplyCount,rs, bOriginalMsgContainsHit, strReplyIDs)
	on error resume next
	
	' if max record count exceeded, stop showing
	if bLimitDisplayRecs=true and nRepliesDisplayedSoFar >= nMaxRecsToDisplay then
		exit function
	end if

	' if no replies, just show the link to the original author containing the keyword hits
	' from the first query's recordset
	if bOriginalMsgContainsHit = true then
		sMsg = ChkString(rs("T_DATE"),"display")
		
		' format the hyperlink to appear on the right hand side as well for each posting date
		sLinkString = ChkDate(sMsg) & "&nbsp;" & ChkTime(sMsg)

		' write the invisible icon for alignment followed by the hyperlink
		Response.Write(strInvisibleIcon)
		' -------------SUPERSEARCH MOD BEGIN 2.1 ---------------------------
		'Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & GetWhichPage(0) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit0" & """>" & sLinkString & "</a>")
		Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & "&SearchStrings=" & strSearchStrings & "&SearchType=" & strSearchType & GetWhichPage(0) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit0" & """>" & sLinkString & "</a>")
		' -------------SUPERSEARCH MOD END 2.1 ---------------------------
		nRepliesDisplayedSoFar = nRepliesDisplayedSoFar + 1
		
		' if no replies, exit after just showing the original message
		if nReplyCount < 1 then
			exit function
		end if
		
	end if 
	
	' start at top of recordset
	rsReplies.MoveFirst
	if err.number <> 0 then
		exit function
	end if
	
	while NOT (rsReplies.EOF or rsReplies.BOF) 
		
		' if max record count exceeded, stop showing
		if bLimitDisplayRecs=true and nRepliesDisplayedSoFar >= nMaxRecsToDisplay then
			exit function
		end if
	
		sMsg = ChkString(rsReplies("R_DATE"),"display")
		
		if err.number <> 0 then
			exit function
		end if
		
		' format the hyperlink to appear on the right hand side as well for each posting date
		sLinkString = ChkDate(sMsg) & "&nbsp;" & ChkTime(sMsg)

		' write the invisible icon for alignment followed by the hyperlink
		Response.Write(strInvisibleIcon)
		' -------------SUPERSEARCH MOD BEGIN 2.1 ---------------------------
		'Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & GetWhichPage(rsReplies("REPLY_ID")) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit" & CStr(rsReplies("REPLY_ID")) & """>" & sLinkString & "</a>")
		Response.Write("<a href=""topic.asp?TOPIC_ID=" & rs("TOPIC_ID") & "&SearchStrings=" & strSearchStrings & "&SearchType=" & strSearchType & GetWhichPage(rsReplies("REPLY_ID")) & "&ReplyIDs=" & strReplyIDs & "&AllReplyIDs=" & strAllReplyIDs & "&FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Topic_Title=" & ChkString(left(rs("T_SUBJECT"),50),"urlpath") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & "#SearchHit" & CStr(rsReplies("REPLY_ID")) & """>" & sLinkString & "</a>")
		' -------------SUPERSEARCH MOD END 2.1 ---------------------------
		nRepliesDisplayedSoFar = nRepliesDisplayedSoFar + 1

		rsReplies.MoveNext
	wend	
	
end function
%>
<% set rs = Server.CreateObject("ADODB.Recordset") %>
<% set rsReplies = Server.CreateObject("ADODB.Recordset") %>
<% set rsOriginal = Server.CreateObject("ADODB.Recordset") %>
<% set rsForumQry = Server.CreateObject("ADODB.Recordset") %>
<table width="100%" border="0">
    <tr> 
        <td align="left" valign="top"> <font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"> 
            <img src="icon_folder_open.gif" border="0">&nbsp;<a href="fhome.asp">All 
            Forums</a><br>
            <% If Request.QueryString("mode") = "DoIt" then %>
            <img src="icon_bar.gif" border="0"><img src="icon_folder_open.gif" border="0">&nbsp;<a href="search.asp?Search=<%=Request.Form("Search")%>">Search</a><br>
            <img src="icon_blank.gif" border="0"><img src="icon_bar.gif" border="0"><img src="icon_folder_open_topic.gif" border="0">&nbsp;Search 
			Results: <%=Request.Form("Search")%> 
            <% if bLimitDisplayRecs=true then %>
            &nbsp;&nbsp;(Return results limited to: <%=nMaxRecsToDisplay %> records). 
            <% end if %>
            <% else %>
            <img src="icon_bar.gif" border="0"><img src="icon_folder_open_topic.gif" border="0">&nbsp;Search 
            Form 
            <% end if %>
            </font> </td>
    </tr>
</table>
<%
If Request.QueryString("mode") = "DoIt" then

	' Do not allow a search string with only all spaces no matter what options chosen
	'if Request.Form("Search") <> "" then
	if trim(Request.Form("Search")) <> ""  then

		keywords = split(Request.Form("Search"), " ")
		keycnt = ubound(keywords)
		 
		'----------SUPERSEARCH MOD BEGIN 2.1 ----------------------
		on error resume next
		' build a temporary array of all the unique keywords. This will eliminate
		' duplicates
		BuildTmpArrayWithUniqueEntries(keywords)
		
		if bAtLeastOneKeywordValid=false then
		%>
		<p align="center"><font face="<% =strDefaultFontFace %>" size="<% =strHeaderFontSize %>"> 
			None of the keywords entered passed the qualifying edits.<br><br>Each keyword must be more
			than 1 character in length.</p>
			<p align="center"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"><a href="JavaScript:history.go(-1)">Back 
			To Search Page</a></p>
			
		<%
			StopPage() ' Close all objects and Response.End page
		end if
		
		keycnt = ubound(arrTmp)
		 
		' Make sure there is at least 1 keyword that passed the edits
		
		' Now examine the arrTmp array which contains only the unique keyword entries to make
		' sure the max keywords has not been exceeded.
		
		' Keyword count exceeds max. Copy only up to 'max' keywords into the final keyword array
		if keycnt >= nMaxKeywords then
			for nElements = 0 to (nMaxKeywords - 1)
				' do not pass spaces as a single element
				if trim(arrTmp(nElements)) <> "" then
					' increase the array size by 1 to hold the new element
					ReDim Preserve arrKeywords(nElements + 1)
					arrKeywords(nElements) = arrTmp(nElements)
				
					' add to parm to be passed to topic.asp
					if strSearchStrings <> "" then strSearchStrings = strSearchStrings & " "
					strSearchStrings = strSearchStrings & arrTmp(nElements)
				end if
			next
			keycnt = nMaxKeywords - 1
		else
			' allowable keyword count. Copy all keywords into the final keyword array
			for nElements = 0 to keycnt
				' do not pass spaces as a single element
				if trim(arrTmp(nElements)) <> "" then
					' increase the array size by 1 to hold the new element
					ReDim Preserve arrKeywords(nElements + 1)
					arrKeywords(nElements) = arrTmp(nElements)
				
					' add to parm to be passed to topic.asp
					if strSearchStrings <> "" then strSearchStrings = strSearchStrings & " "
					strSearchStrings = strSearchStrings & arrTmp(nElements)
				end if
			next
		end if 
		
		ChkString strSearchStrings,"urlpath"  ' encode search strings for use in href=
		' ---------------------SUPERSEARCH MOD END 2.1 -------------------------

		' Build a query for just the FORUMs. Check their SUBJECT and DESCRIPTION 
		' for the keywords
		bOptionalWordsProcessed=false
		
		strSql = "SELECT DISTINCTROW " & _ 
			strTablePrefix & "FORUM.FORUM_ID, " & _
			strTablePrefix & "FORUM.F_SUBJECT, " & _
			strTablePrefix & "FORUM.F_DESCRIPTION, " & _
			strTablePrefix & "FORUM.CAT_ID" & _
			" FROM " & _
			strTablePrefix & "FORUM" & _
			" WHERE ("
			
		if Request.Form("andor") = "phrase" then
			strSql = strSql & BuildForumWhereClause(ChkString(Request.Form("Search"), "SQLString"))
		else
			' if searching for any words, call BuildWhereClause separately with each word
			if Request.Form("andor") = " or " then
			'------------ SUPERSEARCH MOD BEGIN 2.1 ----------------------
				'For Each word in keywords
				For Each word in arrKeywords
			'------------ SUPERSEARCH MOD END 2.1 ----------------------
					SearchWord = ChkString(word, "SQLString")
						
					SearchWord = trim(SearchWord)
					if SearchWord <> "" then
				
						if bOptionalWordsProcessed=true then strSql = strSql & Request.Form("andor") 
						bOptionalWordsProcessed = true
						
						strSql = strSql & BuildForumWhereClause(SearchWord)
					end if
				next
			else
				' searching on all words, call BuildForumWhereClauseForAllWords
				strSql = strSql & BuildForumWhereClause("")
			end if
		end if
		
		strSql = strSql & " ) "
		strSql = strSql & " ORDER BY " & strTablePrefix & "FORUM.FORUM_ID"
		
		' Store the query string for debug display if the "show display string" checkbox is checked
		' on the search entry form
		if bSearchDebugMode then
			strSearchForumQuery = strSql
		end if
		
		on error resume next
		err.number=0
		
		' load the forum IDs of all the forums with search hits. This represents the
		' forums with the search hits, not the topics or replies
		rsForumQry.Open strSql, my_Conn, 3,1
		while NOT (rsForumQry.EOF or rsForumQry.BOF) 
			if strQueryForumIDs <> "" then
				strQueryForumIDs = strQueryForumIDs & ","
			end if
			
			strQueryForumIDs = strQueryForumIDs & CInt(rsForumQry("FORUM_ID"))
			
			rsForumQry.MoveNext
		wend
		
		arrQueryForumIDs = split(strQueryForumIDs,",")
		nQueryForumIDsTopIndex = ubound(arrQueryForumIDs)
		
		'## Forum_SQL - Find all records with the search criteria in them
		
		' replace the commented out line below with the one following it
		'strSql = "SELECT " & strTablePrefix & "FORUM.FORUM_ID, " & strTablePrefix & "FORUM.F_SUBJECT, " & strTablePrefix & "FORUM.CAT_ID, " & strTablePrefix & "TOPICS.TOPIC_ID, " & strTablePrefix & "TOPICS.T_SUBJECT, " & strTablePrefix & "TOPICS.T_MAIL, " & strTablePrefix & "TOPICS.T_STATUS, " & strTablePrefix & "TOPICS.T_LAST_POST, " & strTablePrefix & "TOPICS.T_REPLIES, " & strMemberTablePrefix & "MEMBERS.MEMBER_ID, " & strMemberTablePrefix & "MEMBERS.M_NAME "
		strSql = "SELECT DISTINCTROW " & _ 
			strTablePrefix & "FORUM.FORUM_ID, " & _
			strTablePrefix & "FORUM.F_SUBJECT, " & _
			strTablePrefix & "FORUM.F_DESCRIPTION, " & _
			strTablePrefix & "FORUM.CAT_ID, " & _
			strTablePrefix & "TOPICS.TOPIC_ID, " & _
			strTablePrefix & "TOPICS.T_SUBJECT, " & _
			strTablePrefix & "TOPICS.T_MAIL, " & _
			strTablePrefix & "TOPICS.T_STATUS, " & _
			strTablePrefix & "TOPICS.T_DATE, " & _
			strTablePrefix & "TOPICS.T_LAST_POST, " & _
			strTablePrefix & "TOPICS.T_REPLIES, " & _
			strTablePrefix & "TOPICS.T_NEWS, " & _
			strTablePrefix & "TOPICS.answer1, " & _
			strTablePrefix & "TOPICS.T_MESSAGE, " & _
			strMemberTablePrefix & "MEMBERS.MEMBER_ID, " _
			& strMemberTablePrefix & "MEMBERS.M_NAME "
		bOptionalWordsProcessed=false
		
		
		strSql = strSql & " FROM ((" & strTablePrefix & "FORUM LEFT JOIN " & strTablePrefix & "TOPICS "
		strSql = strSql & " ON " & strTablePrefix & "FORUM.FORUM_ID = " & strTablePrefix & "TOPICS.FORUM_ID) LEFT JOIN " & strTablePrefix & "REPLY "
		strSql = strSql & " ON " & strTablePrefix & "TOPICS.TOPIC_ID = " & strTablePrefix & "REPLY.TOPIC_ID) LEFT JOIN " & strMemberTablePrefix & "MEMBERS "
		strSql = strSql & " ON " & strTablePrefix & "TOPICS.T_AUTHOR = " & strMemberTablePrefix & "MEMBERS.MEMBER_ID "
		strSql = strSql & " WHERE ("
		

		' if searching on a phrase, call BuildWhereClause once passing the phrase
		if Request.Form("andor") = "phrase" then
			strSql = strSql & BuildWhereClause(ChkString(Request.Form("Search"), "SQLString"))
		else
			' if searching for any words, call BuildWhereClause separately with each word
			if Request.Form("andor") = " or " then
				'----------- SUPERSEARCH MOD BEGIN 2.1 ----------------
				'For Each word in keywords
				For Each word in arrKeywords
				'----------- SUPERSEARCH MOD END 2.1 ----------------
					SearchWord = ChkString(word, "SQLString")
						
					SearchWord = trim(SearchWord)
					if SearchWord <> "" then
				
						if bOptionalWordsProcessed=true then strSql = strSql & Request.Form("andor") 
						bOptionalWordsProcessed = true
						
						strSql = strSql & BuildWhereClause(SearchWord)
					end if
				next
			else
				' searching on all words, call BuildWhereClause with ""
				strSql = strSql & BuildWhereClause("")
			end if
		end if
		
		strSql = strSql & " ) "
		if Request.Form("news") = "news" then
			strSql = strSql & " AND " & strTablePrefix & "TOPICS.T_NEWS = " & 1
		end if
		strSql = strSql & " AND " & strTablePrefix & "FORUM.F_TYPE = " & 0 
		strSql = strSql & " ORDER BY " & strTablePrefix & "TOPICS.FORUM_ID DESC, "
		strSql = strSql & "          " & strTablePrefix & "TOPICS.T_LAST_POST DESC"

		mypage = request("whichpage")

		If mypage = "" then
			mypage = 1
		end if

		' Store the query string for debug display if the "show display string" checkbox is checked
		' on the search entry form
		if bSearchDebugMode then
			strSearchQuery = strSql
		end if
		
		rs.Open strSql, my_Conn, 3,1
%>
<table border="0" width="95%" cellspacing="0" cellpadding="0" align="center">
    <tr> 
        <td bgcolor="<% =strTableBorderColor %>"> 
            <table border="0" width="100%" cellspacing="1" cellpadding="4">
                <tr> 
                    <td align="center" bgcolor="<% =strHeadCellColor %>">&nbsp;</td>
                    <td align="center" bgcolor="<% =strHeadCellColor %>"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strHeadFontColor %>">Topic</font></b></td>
                    <td align="center" bgcolor="<% =strHeadCellColor %>"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strHeadFontColor %>">Author</font></b></td>
                    <td align="center" bgcolor="<% =strHeadCellColor %>"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strHeadFontColor %>">Posted</font></b></td>
                </tr>
                <%		if rs.EOF or rs.BOF then  '## No topic %>
                <tr> 
                    <td bgcolor="<% =strForumCellColor %>" colspan="5"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"><b> 
                        <% bNoHitsMsgDisplayed=true %>
                        No Topic or Reply Matches Found </b></font></td>
                </tr>
                <%
		else 
		
			rs.MoveFirst
			currForum = 0 
			currTopic = 0
			
			dim cStatus
			dim fStatus
			dim lastForunIDlastForumID 
				lastForunIDlastForumID = 1
			
			do until rs.EOF
				
				if ChkForumAccess(rs("FORUM_ID")) then 
					if lastForumID <> rs("FORUM_ID") then 

					'## Forum_SQL - Find out if the Category is Locked or Un-Locked and if it Exists
					strSql = "SELECT " & strTablePrefix & "CATEGORY.CAT_STATUS "
					strSql = strSql & ", " & strTablePrefix & "FORUM.F_STATUS "
					strSql = strSql & " FROM " & strTablePrefix & "CATEGORY "
					strSql = strSql & " , " & strTablePrefix & "FORUM "
					strSql = strSql & " WHERE " & strTablePrefix & "CATEGORY.CAT_ID = " & strTablePrefix & "FORUM.CAT_ID "
					strSql = strSql & " AND " & strTablePrefix & "FORUM.FORUM_ID = " & rs("FORUM_ID")
		
					if bSearchDebugMode then
						strCategoryQuery = strSql
					end if

					set rsCFStatus = my_Conn.Execute (StrSql)
					
						cStatus = rsCFStatus("CAT_STATUS")
						fStatus = rsCFStatus("F_STATUS")                 
						lastForumID = rs("FORUM_ID")                
						      
					end if

					if (currForum <> rs("FORUM_ID")) and (currTopic <> rs("TOPIC_ID")) then 
%>
                <% if (bLimitDisplayRecs=false) or (bLimitDisplayRecs=true and nRecsDisplayedSoFar < nMaxRecsToDisplay) then %>
                <tr> 
                    <td height="20" colspan="5" bgcolor="<% =strCategoryCellColor %>"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strCategoryFontColor %>"><b><% =ChkString(rs("F_SUBJECT"),"display") %>
                        <%    	if ForumIDInSearchHits(rs("FORUM_ID"))=true then
				bLinesDisplayed=true
				nRecsDisplayedSoFar = nRecsDisplayedSoFar + 1
				Response.Write("<a href=""forum.asp?FORUM_ID=" & rs("FORUM_ID") & "&CAT_ID=" & rs("CAT_ID") & "&Forum_Title=" & ChkString(rs("F_SUBJECT"),"urlpath") & """>") 
				end if
						%>
                        </b></font></td>
                </tr>
                <% end if %>
                <%					currForum = rs("FORUM_ID")
					end if %>
                <%					if currTopic <> rs("TOPIC_ID") then %>
                <% if (bLimitDisplayRecs=false) or (bLimitDisplayRecs=true and nRecsDisplayedSoFar < nMaxRecsToDisplay) then %>
                <tr> 
                    <%						if rsCFStatus("CAT_STATUS") <> 0 and rsCFstatus("F_STATUS") <> 0 and rs("T_STATUS") <> 0 then %>
                    <td bgcolor="<% =strForumCellColor %>" align="center"><a href="topic.asp?TOPIC_ID=<% =rs("TOPIC_ID") %>&FORUM_ID=<% =rs("FORUM_ID") %>&CAT_ID=<% =rs("CAT_ID") %>&Topic_Title=<% =ChkString(left(rs("T_SUBJECT"), 50),"urlpath") %>&Forum_Title=<% =ChkString(rs("F_SUBJECT"),"urlpath") %>"> 
                        <% =ChkIsNew(rs("T_LAST_POST")) %>
                        </a></td>
                    <%						else %>
                    <td bgcolor="<% =strForumCellColor %>" align="center"><a href="topic.asp?TOPIC_ID=<% =rs("TOPIC_ID") %>&FORUM_ID=<% =rs("FORUM_ID") %>&CAT_ID=<%=rs("CAT_ID") %>&Topic_Title=<% =ChkString(left(rs("T_SUBJECT"), 50),"urlpath") %>&Forum_Title=<%=ChkString(rs("F_SUBJECT"),"urlpath") %>"><img src="icon_folder_locked.gif"
<% 							if rsCFStatus("CAT_STATUS") = 0 then 
								Response.Write ("alt='Category Locked'")
							elseif rsCFStatus("F_STATUS") = 0 then 
								Response.Write ("alt='Forum Locked'")
							else
								Response.Write ("alt='Topic Locked'")
							end if %>
								border="0"></a> </td>
                    <%						end if %>
                    <% rsCFStatus.close %>
                    <% 
		' Only perform for messages that have replies
		on error resume next
		
		' See if the original message met the search criteria. This is the only way we can determine if JUST the original
		' message had a keyword hit if the above query returned replies with hits. Just the replies doesn't
		' tell us since we don't know if the hit was on the original message, the reply, the forum name, etc.
		cnt = 0
		strSql = "SELECT COUNT(*) AS MSGCOUNT FROM " & strTablePrefix & "TOPICS "
		'strSql = strSql & " WHERE " & strTablePrefix & "TOPICS.TOPIC_ID = " & rs("TOPIC_ID") & " AND ("
		strSql = strSql & " WHERE " & strTablePrefix & "TOPICS.TOPIC_ID = " & rs("TOPIC_ID") & " AND (("
		
		bOptionalWordsProcessed = false
		if Request.Form("andor") = "phrase" then
			strSql = strSql & BuildMessage(ChkString(Request.Form("Search"), "SQLString"))
		else
			'----------- SUPERSEARCH MOD BEGIN 2.1 ----------------
			'For Each word in keywords
			For Each word in arrKeywords
			'----------- SUPERSEARCH MOD END 2.1 ----------------
				SearchWord = ChkString(word, "SQLString")
						
				SearchWord = trim(SearchWord)
				if SearchWord <> "" then
				
					if bOptionalWordsProcessed=true then strSql = strSql & Request.Form("andor") 
					bOptionalWordsProcessed = true
						
					strSql = strSql & BuildMessage(SearchWord)
				end if
			next
		end if
			
		strSql = strSql & ") "
		strSql = strSql & BuildAuthors("T")
		strSql = strSql & BuildDateCriteria("T_DATE")
		strSql = strSql & " ) "
		
		if bSearchDebugMode then
			strOriginalTopicQuery = strSql
		end if
		
		set rsOriginal = my_Conn.Execute (StrSql)
		
		if err.number <> 0 then
			Response.Write("Error performing set rsOriginal = my_Conn.Execute: " & strSql & ". rc=" & CStr(err.number) & ". Reason: " & err.description)
			Response.End
		end if
		
		' set flag
		bOriginalMsgContainsHit = false
		
		if rsOriginal("MSGCOUNT") = 1 then
			bOriginalMsgContainsHit = true
		end if
		
		rsOriginal.Close
		
		
		' Now we need to load ALL of the replies for this topic, not JUST the replies that have hits in them.
		' We need to know ALL the reply IDs in order to properly create the jump links.
		strSql = "SELECT " & strTablePrefix & "REPLY.REPLY_ID FROM "
		strSql = strSql & strTablePrefix & "REPLY"
		strSql = strSql & " WHERE " & strTablePrefix & "REPLY.TOPIC_ID = " & CStr(rs("TOPIC_ID"))
		strSql = strSql & " ORDER BY " & strTablePrefix & "REPLY.REPLY_ID"
		
		err.number=0
		
		if bSearchDebugMode then
			strGetAllReplyIDsTopicQuery = strSql
		end if

		set rsAllReplies = my_Conn.Execute (StrSql)
			
		if err.number <> 0 then
			Response.Write("Error performing 'rsAllReplies = my_Conn.Execute' : " & strSql & ". rc=" & CStr(err.number) & ". Reason: " & err.description)
			Response.End
		end if
			
		' Fetch the Reply IDs. Tell the function if the original message had a hit
		
		' Use the GetReplyIDs function to return all the reply IDs separated by commas
		strALLReplyIDs = GetReplyIDs(rsAllReplies, bOriginalMsgContainsHit)
		rsAllReplies.Close
		
		' Load array of ALL reply IDs for this topic and determine index of upper bound of array
		arrAllReplyIDs = split(strAllReplyIDs, ",")
		narrAllReplyIDsUpperBound = ubound(arrAllReplyIDs)
		
		' set the ID of the original message if it had a hit. We will use zero for the original msg ID
		if bOriginalMsgContainsHit = true then
			strReplyIDs = "0" ' use this as a starting point
		else
			strReplyIDs = ""
		end if
		
		nReplyCount = (rs("T_REPLIES"))
		if nReplyCount > 0 then
			
			cnt = 0
			
			strSql = "SELECT " & strTablePrefix & "MEMBERS.M_NAME, "
			strSql = strSql & strTablePrefix & "REPLY.R_MESSAGE, "
			strSql = strSql & strTablePrefix & "REPLY.REPLY_ID, "
			strSql = strSql & strTablePrefix & "REPLY.R_DATE "
			strSql = strSql & " FROM " & strTablePrefix & "REPLY LEFT JOIN "
			strSql = strSql & strTablePrefix & "MEMBERS ON "
			strSql = strSql & strTablePrefix & "MEMBERS.MEMBER_ID = "
			strSql = strSql & strTablePrefix & "REPLY.R_AUTHOR"
			strSql = strSql & " WHERE " & strTablePrefix & "REPLY.TOPIC_ID = " & CStr(rs("TOPIC_ID")) & " AND ("
			
			' if searching on a phrase, call BuildWhereClause once passing the phrase
			bOptionalWordsProcessed=false
			if Request.Form("andor") = "phrase" then
				strSql = strSql & BuildReply(ChkString(Request.Form("Search"), "SQLString"))
			else
				' if searching for any words, call BuildWhereClause separately with each word
				if Request.Form("andor") = " or " then
					'----------- SUPERSEARCH MOD BEGIN 2.1 ----------------
					'For Each word in keywords
					For Each word in arrKeywords
					'----------- SUPERSEARCH MOD END 2.1 ----------------
						SearchWord = ChkString(word, "SQLString")
						
						SearchWord = trim(SearchWord)
						if SearchWord <> "" then
				
							if bOptionalWordsProcessed=true then strSql = strSql & Request.Form("andor") 
							bOptionalWordsProcessed = true
						
							strSql = strSql & BuildReply(SearchWord)
						end if
					next
				else
					' searching on all words, call BuildWhereClause with ""
					strSql = strSql & BuildReply("")
				end if
			end if
			
			strSql = strSql & BuildAuthors("R")
			strSql = strSql & BuildDateCriteria("R_DATE")
			strSql = strSql & ") ORDER BY " & strTablePrefix & "REPLY.R_DATE"
			
			' execute the query
			err.number=0
			
			if bSearchDebugMode then
				strGetHitReplyIDsTopicQuery = strSql
			end if
			
			set rsReplies = my_Conn.Execute (StrSql)
			
			if err.number <> 0 then
				Response.Write("Error performing 'rsReplies = my_Conn.Execute' : " & strSql & ". rc=" & CStr(err.number) & ". Reason: " & err.description)
				Response.End
			end if
			
			' Fetch the Reply IDs. Tell the function if the original message had a hit
			strReplyIDs = GetReplyIDs(rsReplies, bOriginalMsgContainsHit)
			
		end if ' if nReplyCount > 0
		
			' rsReplies now contains all the replies for the selected topic. We will pass that recordset to 
			' the function to display each cells contents
		%>
                    <% ' Only show the line if there is at least a message or reply hit
		if nReplyCount > 0 OR bOriginalMsgContainsHit=true then %>
                    <% 
						bLinesDisplayed=true
						' sync up
						nRepliesDisplayedSoFar = nRecsDisplayedSoFar
						nAuthorsDisplayedSoFar = nRecsDisplayedSoFar
					%>
                    <td bgcolor="<% =strForumCellColor %>" valign="top"> <font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">The 
                        topic <a href="topic.asp?TOPIC_ID=<% =rs("TOPIC_ID") %>&FORUM_ID=<% =rs("FORUM_ID") %>&CAT_ID=<% =rs("CAT_ID") %>&Topic_Title=<% =ChkString(left(rs("T_SUBJECT"), 50),"urlpath") %>&Forum_Title=<% =ChkString(rs("F_SUBJECT"),"urlpath") %>"> 
                        <% =ChkString(left(rs("T_SUBJECT"), 50),"display") %></a><% if trim(rs("answer1")) <> "" then %>&nbsp;<img src="icon_topic_poll.gif"><% end if %><% if rs("T_NEWS") = 1 then%>&nbsp;<img src="icon_topic_news.gif"><% end if %>
                        &nbsp;had these hits: <%=DisplayReplyMessageCell(rsReplies,nReplyCount,rs, bOriginalMsgContainsHit, strReplyIDs)%>
                        </font></td>
                    <td bgcolor="<% =strForumCellColor %>" valign="top" align="center"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strForumFontColor %>"> 
                        <% =ChkString(rs("M_NAME"),"display") %>
                        <%=DisplayReplyAuthorCell(rsReplies,nReplyCount,rs, bOriginalMsgContainsHit)%> 
                        </font></td>
					<!-- SUPERSEARCH MOD BEGIN 2.3 -->
					<!-- <td bgcolor="<% =strForumCellColor %>" valign="top" align="center" nowrap><font face="<% =strDefaultFontFace %>" color="<% =strForumFontColor %>" size="<% =strFooterFontSize %>"><b> -->
					<td bgcolor="<% =strForumCellColor %>" valign="top" align="center" nowrap><font face="<% =strDefaultFontFace %>" color="<% =strForumFontColor %>" size="<% =strDefaultFontSize %>"><b> 
					<!-- SUPERSEARCH MOD END 2.3 -->
					
                        <% =ChkDate(rs("T_DATE")) %>
                        </b>&nbsp; 
                        <% =ChkTime(rs("T_DATE")) %>
                        <%=DisplayReplyDateCell(rsReplies,nReplyCount,rs, bOriginalMsgContainsHit, strReplyIDs)%> 
                        </font></td>
                    <%else%>
                    <td bgcolor="<% =strForumCellColor %>"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">The 
                        topic <a href="topic.asp?TOPIC_ID=<% =rs("TOPIC_ID") %>&FORUM_ID=<% =rs("FORUM_ID") %>&CAT_ID=<% =rs("CAT_ID") %>&Topic_Title=<% =ChkString(left(rs("T_SUBJECT"), 50),"urlpath") %>&Forum_Title=<% =ChkString(rs("F_SUBJECT"),"urlpath") %>"> 
                        <% =ChkString(left(rs("T_SUBJECT"), 50),"display") %>
                        </a>&nbsp; had these hits: <br>
                        <img src="icon_searchfind_invisible.gif" border="0"> (The 
                        search result is the forum name / description, none of 
                        the messages) </font></td>
                    <td bgcolor="<% =strForumCellColor %>" valign="top" align="center"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strForumFontColor %>"> 
                        <% =ChkString(rs("M_NAME"),"display") %>
                        &nbsp; </font></td>
                    <td bgcolor="<% =strForumCellColor %>" valign="top" align="center"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strForumFontColor %>">&nbsp;</font></td>
                    <td bgcolor="<% =strForumCellColor %>" valign="top" align="center" nowrap><font face="<% =strDefaultFontFace %>" color="<% =strForumFontColor %>" size="<% =strFooterFontSize %>"><b> 
                        <% =ChkDate(rs("T_DATE")) %>
                        </b>&nbsp; 
                        <% =ChkTime(rs("T_DATE")) %>
                        &nbsp; </font></td>
                    <%end if%>
                </tr>
                <% end if 'record count check %>
                <%					currTopic = rs("TOPIC_ID")
					end if 
				end if
				on error resume next
				rsReplies.Close
				rs.MoveNext 
			loop 
			rs.Close
		end if 
%>
                <%
			' For all rsForumQry records, see which ones have not been displayed already (since they 
			' did not have any message or reply hits) and display them here
			rsForumQry.MoveFirst
			bFirstForumRow=true
		
			' if max record count exceeded, stop showing
			if bLimitDisplayRecs=true and nRecsDisplayedSoFar >= nMaxRecsToDisplay then
				rsForumQry.MoveLast
			end if
			
			
			while not (rsForumQry.EOF or rsForumQry.BOF)
				if (ChkForumAccess(rsForumQry("FORUM_ID"))) AND ForumIDInProcessedHits(rsForumQry("FORUM_ID"))=false then %>
                <% if bFirstForumRow=true then %>
                <tr> 
                    <td bgcolor="<% =strForumCellColor %>" colspan="5"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"><b> 
                        The following Forum Names or Descriptions contained the 
                        search word(s) </b></font></td>
                </tr>
                <%      bFirstForumRow=false
				   end if %>
                <tr> 
                    <td height="20" colspan="5" bgcolor="<% =strCategoryCellColor %>"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>" color="<% =strCategoryFontColor %>"><b><% =ChkString(rsForumQry("F_SUBJECT"),"display") %>
                        <% 
				bLinesDisplayed=true
				nRecsDisplayedSoFar = nRecsDisplayedSoFar + 1
				Response.Write("<a href=""forum.asp?FORUM_ID=" & rsForumQry("FORUM_ID") & "&CAT_ID=" & rsForumQry("CAT_ID") & "&Forum_Title=" & ChkString(rsForumQry("F_SUBJECT"),"urlpath") & """>") 
			%>
                        </b></font></td>
                </tr>
                <% 
				end if 
			
				' if max record count exceeded, stop showing
				if bLimitDisplayRecs=true and nRecsDisplayedSoFar >= nMaxRecsToDisplay then
					rsForumQry.MoveLast
				end if
				
				
				rsForumQry.MoveNext
			wend %>
                <% ' Show no hits it not already shown and there were no hits
			if bLinesDisplayed=false and bNoHitsMsgDisplayed=false then %>
                <tr> 
                    <td bgcolor="<% =strForumCellColor %>" colspan="5"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"><b> 
                        No Matches Found </b></font></td>
                </tr>
                <% end if %>
            </table>
        </td>
    </tr>
</table>
<% if (bSearchDebugMode = true OR bAdmin = true) AND (Request.Form("chkShowQueries") = "chkShowQueries") then %>
<table border="0" cellspacing="0" cellpadding="0" align=center width="50%">
    <tr> 
        <td><font face="<% =strDefaultFontFace %>" size=<% =strDefaultFontSize %>> 
            <% if bSearchDebugMode = true then %>
            Search Debug Mode <br>
            <br>
            <% end if %>
            Primary Search Query (Altered): <%= strSearchQuery %> <br>
            <br>
            Forum Category Query: <%= strCategoryQuery %> <br>
            <br>
            -------------- new queries ----------------<br>
            <br>
            Check Forums for hits Query: <%= strSearchForumQuery %> <br>
            <br>
            Check Original TOPIC Query: <%= strOriginalTopicQuery %> <br>
            <br>
            Get All Reply IDs Query: <%= strGetAllReplyIDsTopicQuery %> <br>
            <br>
            Get Only HIT Reply IDs Query: <%= strGetHitReplyIDsTopicQuery %><br>
            </font></td>
    </tr>
</table>
<% end if %>
<p align="center"><font face="<% =strDefaultFontFace %>" size=<% =strDefaultFontSize %>> 
    <a href="JavaScript:history.go(-1)">Back To Search Page</a> </font></p>
<%	Else %>
<p align="center"><font face="<% =strDefaultFontFace %>" size="<% =strHeaderFontSize %>">You 
    must enter keywords</p>
<p align="center"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"><a href="JavaScript:history.go(-1)">Back 
    To Search Page</a></p>
<meta http-equiv="Refresh" content="2; URL=JavaScript:history.go(-1)">
<%
	end if
Else
%>
<form action="search.asp?mode=DoIt" method="post" name="SearchForm" ONSUBMIT="return CheckForm();">
    <table border="0" cellspacing="0" cellpadding="0" align=center width="332">
        <tr> 
            <td bgcolor="<% =strPopUpBorderColor %>"> 
                <table border="0" cellspacing="1" cellpadding="1" width="450">
                    <tr> 
                        <td bgColor="<% =strPopUpTableColor %>" align="right" valign="top"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Search 
                            For:</font></b></td>
                        <td bgColor="<% =strPopUpTableColor %>" align="left" valign="top"> 
						<!---- SUPERSEARCH MOD BEGIN 2.1 ----------------------------------------------------------->
                        <!--    <input type="text" name="Search" size="40" value="<%=Request.QueryString("Search")%>">  -->
                            <input type="text" name="Search" size="40" value="<%=Request.QueryString("Search")%>" maxlength="<%=GetMaxKeywordInputLength()%>">
						<!---- SUPERSEARCH MOD END 2.1 ------------------------------------------------------>
                            <br>
                            <font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>"> 
                            <input type="radio" class="radio" name="andor" value="phrase">
                            Match exact phrase<br>
                            <!-- to fix looping problem when returning to the search page after logging out -->
                            <!-- immediately after getting no results on a search  -->
                            <input type="hidden" name="NavCheck" value="NavCheck">
                            <input type="radio" class="radio" name="andor" value=" and " checked>
                            Search for all Words<br>
                            <input type="radio" class="radio" name="andor" value=" or ">
                            Match any of the words </font></td>
                    </tr>
                    <tr> 
                        <td bgColor="<% =strPopUpTableColor %>" align="right" valign="top"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Search 
                            Forum:</font></b></td>
                        <td bgColor="<% =strPopUpTableColor %>" align="left" valign="top"> 
                            <b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Selection 
                            limit: <%= GetMaxSelectForumLimitStr() %></font></b><br>
                            <select name="Forum" size="6" multiple>
                                <option value="0" selected>All Forums</option>
                                <%
	'## Forum_SQL
	strSql = "SELECT " & strTablePrefix & "FORUM.FORUM_ID, " & strTablePrefix & "FORUM.F_SUBJECT "
	strSql = strSql & " FROM " & strTablePrefix & "FORUM"
	strSql = strSql & " ORDER BY " & strTablePrefix & "FORUM.F_SUBJECT ASC;"

	set rs = my_Conn.execute (strSql)

	On Error Resume Next

	do until rs.EOF
		if ChkForumAccess(rs("FORUM_ID")) then
			Response.Write "          <option value=""" & rs("FORUM_ID") & """>" & ChkString(left(rs("F_SUBJECT"), 50),"display") & "</option>" & vbCrLf
		end if
		rs.movenext
	loop
	rs.Close
%>
                            </select>
                        </td>
                    </tr>
                    <tr> 
                        <td bgColor="<% =strPopUpTableColor %>" align="right" valign="top"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Search 
                            In:</font></b></td>
                        <td bgColor="<% =strPopUpTableColor %>" align="left" valign="top"> 
                            <select NAME="SearchMessage">
                                <option value="0">Entire Message</option>
                                <option value="1">Subject Only</option>
                            </select>
                        </td>
                    </tr>
                    <tr> 
                        <td bgColor="<% =strPopUpTableColor %>" align="right" valign="top"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Search 
                            By Date:</font></b></td>
                        <td bgColor="<% =strPopUpTableColor %>" align="left" valign="top"> 
                            <select NAME="SearchDate">
                                <option value="0">Any Date</option>
                                <option VALUE="1">Since Yesterday</option>
                                <option VALUE="2">Since 2 Days Ago</option>
                                <option VALUE="5">Since 5 Days Ago</option>
                                <option VALUE="7">Since 7 Days Ago</option>
                                <option VALUE="14">Since 14 Days Ago</option>
                                <option VALUE="30">Since 30 Days Ago</option>
                                <option VALUE="60">Since 60 Days Ago</option>
                                <option VALUE="120">Since 120 Days Ago</option>
                                <option VALUE="365">In the Last Year</option>
                            </select>
                        </td>
                    </tr>
                    <tr> 
                        <td bgColor="<% =strPopUpTableColor %>" align="right" valign="top"><b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Search 
                            By Member:</font></b></td>
                        <td bgColor="<% =strPopUpTableColor %>" align="left" valign="top"> 
                            <b><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Selection 
                            limit: <%= GetMaxSelectMemberLimitStr() %></font></b><br>
                            <select name="SearchMember" size="6" multiple>
                                <option value="0" selected>All Members 
                                <%
	'## Forum_SQL
	strSql = "SELECT " & strMemberTablePrefix & "MEMBERS.MEMBER_ID, " & strMemberTablePrefix & "MEMBERS.M_NAME, " & strMemberTablePrefix & "MEMBERS.M_LEVEL "
	strSql = strSql & " FROM " & strMemberTablePrefix & "MEMBERS"
	strSql = strSql & " WHERE " & strMemberTablePrefix & "MEMBERS.M_STATUS = " & 1
	if Request.Querystring("mode") = "news" then
		strSql = strSql & " AND " & strMemberTablePrefix & "MEMBERS.M_LEVEL = " & 2
		strSql = strSql & " OR " & strMemberTablePrefix & "MEMBERS.M_LEVEL = " & 3
	end if
	strSql = strSql & " ORDER BY " & strMemberTablePrefix & "MEMBERS.M_NAME ASC;"
	
	set rs = my_Conn.execute (strSql)
	
	On Error Resume Next
	
	do until rs.EOF
		Response.Write "          <option value=""" & rs("MEMBER_ID") & """>" & ChkString(left(rs("M_NAME"), 50),"display") & "</option>" & vbCrLf
		rs.movenext
	loop
	rs.Close
%>
                            </select>
                        </td>
                    </tr>
                    <tr> 
                        <td bgColor="<% =strPopUpTableColor %>" align="center" valign="top"> 
                            <input type="submit" value="Search">
                        </td>
                        <td bgColor="<% =strPopUpTableColor %>" align="center" valign="top">
                            <% if (bSearchDebugMode = true) OR (bAdmin = true) then %>
                            <input type="checkbox" name="chkShowQueries" value="chkShowQueries">
                            <font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">Display 
                            queries used?</font> <br>
                            <% end if %>
                            &nbsp;<font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">
                            <input type="text" name="reclimit" maxlength="3" size="3" value="15">
                            results (0=no limit)</font>&nbsp;&nbsp;<a href="JavaScript:void(0)" onclick="openWindow3('pop_search.asp')"><img src="icon_smile_question.gif" alt="Help" border="0"></a>
                        <input type="checkbox" value="news" name="news" <% if Request.QueryString("mode") = "news" then%>checked<%end if%> onClick="RefreshS();"><font face="<% =strDefaultFontFace %>" size="<% =strDefaultFontSize %>">News only</font>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</form>
</font></font></font></font>
<% end if %>
<% on error resume next %>
<% rs.Close %>
<% set rs = nothing %>
<%
	rsCFStatus.close    
	rsCFStatus = nothing
	rsOriginal.Close
	rsOriginal = nothing
	rsForumQry.Close
	rsForumQry = nothing
%><!--#INCLUDE FILE="inc_footer.asp" -->