<HTML>
<BODY>
<%

'*************************************************************************************'
'* The mBaseDir variable is the base location of your web site - i.e. your home      *'
'*  directory. In this application, the News.mdb database is located in the home dir.*'
'*             This constant should ALWAYS end with a forward slash /                *'
'*************************************************************************************'

'*************************************************************************************'
'* The mNewsReaderPage is the location and filename of the .ASP document that        *'
'*  displays the news articles from the database. If a directory proceeds the .ASP   *'
'*  document, it should NOT begin with a forward slash /							 *'
'*  Examples --																		 *'
'*		NewsCode/NewsReader.asp														 *'
'*		News/NewsRead.asp															 *'
'*		NewsRead.asp																 *'
'*************************************************************************************'

'*************************************************************************************'
'* The mNewsAddArticle is the location and filename of the .ASP document that        *'
'*  allows users to add a new news article. If a directory proceeds the .ASP         *'
'*  document, it should NOT begin with a forward slash /							 *'
'*  Examples --																		 *'
'*		NewsCode/NewsAddArticle.asp													 *'
'*		News/NewsAdd.asp															 *'
'*		NewsAddArticle.asp					     									 *'
'*************************************************************************************'

  mBaseDir = "/"
  mNewsReaderPage = "NewsReader.asp"
  mAddArtPage = "NewsAddArticle.asp"
  
  '*****************************************************'
  '* Create DSNless ODBC Connection to Access Database *'
  '*****************************************************'
  
  set connNews = server.createobject("ADODB.Connection")
  connNews.open "DRIVER={Microsoft Access Driver (*.mdb)}; DBQ=" & server.mappath(mBaseDir & "News.mdb")
  set rsArticles = connNews.Execute("SELECT Article.Art_ID, Article.Art_Date, Article.Art_Title, Article.Art_Body, Article.Art_URL, Article.Art_Live, Article.Art_Expire FROM Article WHERE (((Article.Art_Live)=True) AND ((Article.Art_Expire)>=Date())) ORDER BY Article.Art_Date DESC;")

  '**********************************************************************************'
  '* Pull all news articles that exist in the database WHERE Art_Live = TRUE and    *'
  '*  Art_Expire >= Date() (current date). 											*'
  '**********************************************************************************'
    
  do while not rsArticles.EOF
    mURL = rsArticles("Art_URL")
	if left(mURL, 7) = "http://" then mURL = right(mURL, len(mURL)-7)	
    response.write "<P><TABLE><TR><TD><A HREF = http://" & mURL & "><B>" & rsArticles("Art_Title") & "</B></A> - (<I>" & rsArticles("Art_Date") & "</I>)</TD></TR>"
	response.write "<TR><TD>" & rsArticles("Art_Body") & "</TD></TR></TABLE>"
	rsArticles.MoveNext
  loop

  '*********************************************************'  
  '* Close recordset then connection to aviod memory leaks *'
  '*********************************************************'
    
  set rsArticle = nothing
  
  connNews.close
  set connNews = nothing
  
  '***************************************************************************'
  '* HTML to create [Add Article] button allowing users to submit an article *'
  '*  the mAddArtPage variable is used to point the form to the HTML document*'
  '*  that does the processing of adding an article							 *'
  '***************************************************************************'
  
    %>

  <FORM ACTION="<%= mAddArtPage %>" METHOD="POST">
    <INPUT TYPE=HIDDEN NAME="mNewsReaderPage" VALUE = "<%= mNewsReaderPage %>">
    <INPUT TYPE=HIDDEN NAME="mBaseDir" VALUE = "<%= mBaseDir %>">	
    <INPUT TYPE=SUBMIT NAME=<%= mAddArtPage %> VALUE="Add Article">
  </FORM>
  
</BODY>
</HTML>

  