<%
'*******************************************************
'*     ASP 101 Sample Code - http://www.asp101.com     *
'*                                                     *
'*   This code is made available as a service to our   *
'*      visitors and is provided strictly for the      *
'*               purpose of illustration.              *
'*                                                     *
'* Please direct all inquiries to webmaster@asp101.com *
'*******************************************************
%>

<H3>Tell a Friend:</H3>
<%
Dim objCDONTS                 ' Email object
Dim strFromName               ' From persons' real name
Dim strFromEmail, strToEmail  ' Email addresses
Dim strSubject, strBody       ' Message
Dim strThisPage               ' This page's URL
Dim strReferringPage          ' The referring page's URL
Dim bValidInput               ' A boolean indicating valid parameters

' Retrieve this page name and referring page name
strThisPage      = Request.ServerVariables("SCRIPT_NAME")
strReferringPage = Request.ServerVariables("HTTP_REFERER")

' Debugging lines:
'Response.Write strThisPage & "<BR>" & vbCrLf
'Response.Write strReferringPage & "<BR>" & vbCrLf

' Read in and set the initial values of our message parameters
strFromName  = Trim(Request.Form("txtFromName"))
strFromEmail = Trim(Request.Form("txtFromEmail"))
strToEmail   = Trim(Request.Form("txtToEmail"))
strSubject   = "Check out ASP 101!"
strBody      = Trim(Request.Form("txtMessage"))


' I set the body message to a message that referenced the page the
' user arrived from.  This makes it great if you place a link to it
' from your different articles, but can be weird if people link in
' from other web sites.
If strBody = "" Then
	If strReferringPage = "" Or InStr(1, strReferringPage, "www.asp101.com", 1) = 0 Then
		strBody = ""
		strBody = strBody & "I found a site I thought you'd like to see:" & vbCrLf
		strBody = strBody & vbCrLf
		strBody = strBody & "   http://www.asp101.com" & vbCrLf
	Else
		strBody = ""
		strBody = strBody & "I found an article I thought you'd like to see:" & vbCrLf
		strBody = strBody & vbCrLf
		strBody = strBody & "   " & strReferringPage & vbCrLf
	End If
End If
	
' Quick validation just to make sure our parameters are somewhat valid
bValidInput = True
bValidInput = bValidInput And strFromName <> ""
bValidInput = bValidInput And IsValidEmail(strFromEmail)
bValidInput = bValidInput And IsValidEmail(strToEmail)

' If valid send email and show thanks, o/w show form
If bValidInput Then
	' Set up our email object and send the message
	Set objCDONTS = Server.CreateObject("CDONTS.NewMail")
	objCDONTS.From    = strFromName & " <" & strFromEmail & ">"
	objCDONTS.To      = strToEmail
	objCDONTS.Subject = strSubject
	objCDONTS.Body    = strBody
	objCDONTS.Send
	Set objCDONTS = Nothing

	' Show our thank you message
	ShowThanksMsg
Else
	If "http://" & Request.ServerVariables("HTTP_HOST") & strThisPage = strReferringPage Then
		Response.Write "There's been an error.  Please check your entries:" & "<BR>" & vbCrLf
	End If
	' Show our information retrieval form
	ShowReferralForm strThisPage, strFromName, strFromEmail, strToEmail, strBody
End If
' End of page logic... subs and functions follow! 
%>


<%
' Subroutines and Functions that encapsulate some functionality
' and make the above code easier to write... and read.

' A quick email syntax checker.  It's not perfect,
' but it's quick and easy and will catch most of
' the bad addresses than people type in.
Function IsValidEmail(strEmail)
	Dim bIsValid
	bIsValid = True
	
	If Len(strEmail) < 5 Then
		bIsValid = False
	Else
		If Instr(1, strEmail, " ") <> 0 Then
			bIsValid = False
		Else
			If InStr(1, strEmail, "@", 1) < 2 Then
				bIsValid = False
			Else
				If InStrRev(strEmail, ".") < InStr(1, strEmail, "@", 1) + 2 Then
					bIsValid = False
				End If
			End If
		End If
	End If

	IsValidEmail = bIsValid
End Function

' I made this a function just to get it out of the
' logic and make it easier to read.  It just shows the
' form that asks for the input
Sub ShowReferralForm(strPageName, strFromName, strFromEmail, strToEmail, strBody)
	' I use script_name so users can rename this script witout having to change the code.
	%>
	<FORM ACTION="<%= strPageName %>" METHOD="post" name=frmReferral>
	<TABLE BORDER="0">
	<TR>
		<TD VALIGN="top" ALIGN="right"><STRONG>Your Name:</STRONG></TD>
		<TD><INPUT TYPE="text" NAME="txtFromName" VALUE="<%= strFromName %>" SIZE="30"></TD>
	</TR>
	<TR>
		<TD VALIGN="top" ALIGN="right"><STRONG>Your E-mail:</STRONG></TD>
		<TD><INPUT TYPE="text" NAME="txtFromEmail" VALUE="<%= strFromEmail %>" SIZE="30"></TD>
	</TR>
	<TR>
		<TD VALIGN="top" ALIGN="right"><STRONG>Friend's E-mail:</STRONG></TD>
		<TD><INPUT TYPE="text" NAME="txtToEmail" VALUE="<%= strToEmail %>" SIZE="30"></TD>
	</TR>
	<TR>
		<TD VALIGN="top" ALIGN="right"><STRONG>Message:</STRONG></TD>
		<TD><TEXTAREA NAME="txtMessage" COLS="50" ROWS="5" WRAP="virtual" READONLY><%= strBody %></TEXTAREA>
	</TR>
	<TR>
		<TD></TD>
		<TD><INPUT TYPE="reset" VALUE="Reset Form" name=rstReferral>&nbsp;&nbsp;<INPUT TYPE="submit" VALUE="Send E-mail" name=subReferral></TD>
	</TR>
	</TABLE>
	</FORM>
	<%
	'<P>The Message to be sent:</P>
	'<P><B>Subject:</B> < %= strSubject % ></P>
	'<P><B>Body:</B> < %= strBody % ></P>
End Sub

' This just shows our thank you message... probably didn't need to
' be a function, but since I made the form one I figured I'd do this
' for consistency.
Sub ShowThanksMsg()
	%>
	<P>Your message has been sent.  Thanks for helping us spread the word about ASP 101!</P>
	<%
End Sub
%>
