<%@ Language=VBScript EnableSessionState=False %><%
'
'
' Welcome to Andromeda!
' ------------------------------------------------------------
' Documentation is available here:
' http://www.turnstyle.com/andromeda/docs.asp
'
'
' Also, please check out these ways you can help:
' http://www.turnstyle.com/andromeda/contributions.asp
'
'
' enjoy,
' Scott
'
'
'
' NOTE 1
' ------------------------------------------------------------
' This is the compact version of the Andromeda script. If
' you want a copy of the developmental version, send an
' email to scott@turnstyle.com and let me know what you have
' in mind.
'
'
'
' NOTE 2
' ------------------------------------------------------------
' Configure Andromeda with a preference file. (Don't change
' the code in this file). See this page for details:
'
' http://www.turnstyle.com/andromeda/preferences.asp
'
' If you run multiple copies of Andromeda and want this copy
' to use a different prefs file, you can change the name
' below. Please note that this is the only modification
' permitted with this version of Andromeda.
'
' Any other changes to the code violate the terms of the
' license and will prevent it from working properly


andromedaPrefsFileName = "andromedaPrefs.asp"


' ------------------------------------------------------------
' license
' ------------------------------------------------------------
'
' This software is the copyrighted material of Scott Matthews,
' Turnstyle. This document is a license agreement. By running
' this software on your computer you agree to use it for
' personal, non-commercial use only. Information on commercial
' licensing is available from info@turnstyle.com. You agree
' not to copy or distribute this software or change the source
' code without prior written permission. Instead, please send
' questions, comments and suggestions to info@turnstyle.com.
' 
' Scott Matthews, Turnstyle takes no responsibility for any
' damage that this software might cause.
' 
' This software is designed to enable people to enjoy their
' media collection. By using it, you agree to comply with
' all federal and state laws applicable to such content, as
' well as the terms of this licence. Unauthorized copying,
' distribution, modification, public display, or public
' performance of copyrighted works is an infringement of the
' copyright holders' rights.
' 
' If you disagree with any of these terms, you are not
' authorized to use this software. If you do agree with these
' terms, please enjoy.
' 
' Copyright (c)1999-2002 Scott Matthews, Turnstyle
' http://www.turnstyle.com/andromeda
'
'
' ------------------------------------------------------------
Set local_fs = CreateObject("Scripting.FileSystemObject")
sub loadConstants
andromedaConst.add "andromedaVersion", "1.9.2 ASP"
andromedaConst.add "localUser", (request.servervariables("local_addr") = request.servervariables("remote_addr"))
andromedaConst.add "scriptFileName", local_fs.GetFileName(request.servervariables("path_info"))
andromedaConst.add "scriptPhysicalPath", local_fs.getparentfoldername(request.servervariables("path_translated"))
andromedaConst.add "appauth", "Scott Matthews"
andromedaConst.add "appcorp", "Turnstyle"
andromedaConst.add "appname", "Andromeda"
andromedaConst.add "approot", "http://www.turnstyle.com/andromeda"
end sub
sub loadDefaults
andromedaPrefs.add "siteName", "andromeda"
andromedaPrefs.add "useImageFiles", false
andromedaPrefs.add "imageFolderPath", ""
andromedaPrefs.add "displayNew", false
andromedaPrefs.add "displayAMG", true
andromedaPrefs.add "mediaWebPath", local_fs.getparentfoldername(request.servervariables("path_info"))
andromedaPrefs.add "mediaPhysicalPath", local_fs.getparentfoldername(request.servervariables("path_translated"))
andromedaPrefs.add "editMode", false
andromedaPrefs.add "ftpPath", ""
andromedaPrefs.add "email", ""
andromedaPrefs.add "permitSearch", true
andromedaPrefs.add "hostAddress", ""
andromedaPrefs.add "customHeader", ""
andromedaPrefs.add "customBlock", ""
andromedaPrefs.add "popupMaxWidth", 48
andromedaPrefs.add "folderAux1", ""
andromedaPrefs.add "requireLogon", false
andromedaPrefs.add "localFilePlayback", false
andromedaPrefs.add "cBlockSize", 3100
andromedaPrefs.add "cBlockCount", 8
andromedaPrefs.add "audioFileTypes", "mp3,wma,wav,aif,aiff,au,ogg,ra,mid,midi"
andromedaPrefs.add "videoFileTypes", "mpg,mpeg,mpe,asf,avi,wmv,vob,rv,rm,mov,qt"
andromedaPrefs.add "playlistFileTypes", "m3u,asx,ram"
andromedaPrefs.add "tkNumTrimCodes", "## - ,##_-_,##_,##."
andromedaPrefs.add "cssLinkHref", ""
andromedaPrefs.add "playlistMime", "audio/x-mpegurl"
andromedaPrefs.add "protocol", "http"
andromedaPrefs.add "fileLinks", true
andromedaPrefs.add "playLinks", true
andromedaPrefs.add "permitPlaylists", true
andromedaPrefs.add "getID3info", true
andromedaPrefs.add "skipID3v1", true
andromedaPrefs.add "absoluteHeader", ""
andromedaPrefs.add "absoluteFooter", ""
andromedaPrefs.add "disableHTMLheaders", false
andromedaPrefs.add "includeHeader", ""
andromedaPrefs.add "includeFooter", ""
andromedaPrefs.add "includeJavascript", ""
andromedaPrefs.add "folderListInfo", "_folderListInfo"
andromedaPrefs.add "folderOpenInfo", "_folderOpenInfo"
andromedaPrefs.add "folderListImage", "_folderListImage"
andromedaPrefs.add "folderOpenImage", "_folderOpenImage"
andromedaPrefs.add "folderListImageDims", ""
andromedaPrefs.add "folderOpenImageDims", ""
andromedaPrefs.add "skinFile", "andromedaSkin.txt"
andromedaPrefs.add "logonFile", "andromedaLogons.asp"
andromedaPrefs.add "includeEXTM3U", false
andromedaPrefs.add "defaultLanguage", "EN"
andromedaPrefs.add "globalAnnotations", true
andromedaPrefs.add "permitTranslation", true
andromedaPrefs.add "skipPrefix", ""
andromedaPrefs.add "folderSkipNames", "_private,_fpclass,_vti_cnf,_vti_pvt,_derived,_overlay,RECYCLER,Recycled,System Volume Information,Network Trash Folder"
andromedaPrefs.add "checkboxDefault", false
andromedaPrefs.add "coreInclude", ""
andromedaPrefs.add "iconSize", 1
andromedaPrefs.add "hideMenubar", false
andromedaPrefs.add "rootName", ""
andromedaPrefs.add "maxPlaylistTracks", 5000
andromedaPrefs.add "timeout", ""
andromedaPrefs.add "usePlaylistIcons", true
andromedaPrefs.add "vbrScanCount", 50
andromedaPrefs.add "vbrSkipCount", 50
andromedaPrefs.add "cbrCutoff", 5
andromedaPrefs.add "compactSearch", false
andromedaPrefs.add "logonMessage", ""
andromedaPrefs.add "pDimentions", "16,16"
andromedaPrefs.add "aDimentions", "26,16"
andromedaPrefs.add "vDimentions", "26,16"
andromedaPrefs.add "lDimentions", "26,16"
andromedaPrefs.add "hDimentions", "16,16"
andromedaPrefs.add "iDimentions", "16,16"
andromedaPrefs.add "rDimentions", "16,16"
andromedaPrefs.add "tDimentions", "16,16"
andromedaPrefs.add "oDimentions", "20,16"
andromedaPrefs.add "cDimentions", "26,16"
andromedaPrefs.add "gDimentions", "16,16"
andromedaPrefs.add "qDimentions", "16,16"
andromedaPrefs.add "saDimentions", "26,16"
andromedaPrefs.add "snDimentions", "25,16"
andromedaPrefs.add "psDimentions", "42,16"
andromedaPrefs.add "paDimentions", "42,16"
andromedaPrefs.add "prDimentions", "42,16"
andromedaPrefs.add "pvDimentions", "42,16"
andromedaPrefs.add "kDimentions", "16,16"
andromedaPrefs.add "siteWidth", "100%"
andromedaPrefs.add "bodyBgColor", "9999cc"
andromedaPrefs.add "bodyTextColor", "333333"
andromedaPrefs.add "bodyLinkColor", "666699"
andromedaPrefs.add "bodyVlinkColor", "996699"
andromedaPrefs.add "bodyAlinkColor", "999966"
andromedaPrefs.add "bodyMarginSize", "0"
andromedaPrefs.add "headDiv", ""
andromedaPrefs.add "menubarColor", "999999"
andromedaPrefs.add "siteNameColor", "ffff00"
andromedaPrefs.add "menubarDiv", "cccc99,1;9999cc,3;cccc99,1;999999,8;666666,1"
andromedaPrefs.add "bodyFgColor", "cccc99"
andromedaPrefs.add "formStyle", "font-size:9pt;color:000000;background-color:ffffff;"
andromedaPrefs.add "bodyFgDiv", "999966,1;efefcc,1"
andromedaPrefs.add "bodyFgToRowDiv", "ffffcc,1"
andromedaPrefs.add "rowColor1", "efefd0"
andromedaPrefs.add "rowColor2", "efefef"
andromedaPrefs.add "rowLinkColor", ""
andromedaPrefs.add "rowTextColor", "333333"
andromedaPrefs.add "newFileColor", "cc6666"
andromedaPrefs.add "rowDiv", "d0d0d0,1"
andromedaPrefs.add "rowToBodyFgDiv", "666666,1"
andromedaPrefs.add "footDiv", "ffffcc,1;999999,2;666666,1"
end sub
sub loadPrefs
if local_fs.fileexists(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefsFileName) then
Set MyFile = local_fs.OpenTextFile(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefsFileName)
do while not MyFile.AtEndOfStream
xxx = MyFile.ReadLine
if left(xxx,1) = "'" then
xxx = right(xxx,len(xxx)-1)
xxxa = split(xxx,vbtab)
if ubound(xxxa) >= 1 then
if andromedaPrefs.exists(xxxa(0)) then
andromedaPrefs(xxxa(0)) = xxxa(ubound(xxxa))
end if
end if
end if
loop
MyFile.Close
end if
end sub
sub loadSkin
if local_fs.fileexists(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefs("skinFile")) then
Set MyFile = local_fs.OpenTextFile(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefs("skinFile"))
do while not MyFile.AtEndOfStream
xxx = MyFile.ReadLine
xxxa = split(xxx,vbtab)
if ubound(xxxa) >= 1 then
if andromedaPrefs.exists(xxxa(0)) then
andromedaPrefs(xxxa(0)) = xxxa(ubound(xxxa))
end if
end if
loop
MyFile.Close
end if
end sub
sub loadLogons
if local_fs.fileexists(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefs("logonFile")) then
Set MyFile = local_fs.OpenTextFile(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefs("logonFile"))
do while not MyFile.AtEndOfStream
xxx = MyFile.ReadLine
if left(xxx,1) = "'" then
xxx = right(xxx,len(xxx)-1)
xxxa = split(xxx,vbtab)
if ubound(xxxa) >= 1 then
if not(andromedaLogons.exists(xxxa(0))) then
andromedaLogons.add xxxa(0), xxxa(ubound(xxxa))
end if
end if
end if
loop
MyFile.Close
end if
end sub
function vPath (x)
vpchk = true
if x <> "" then
vptmpa = split(replace(x,"\","/"),"/")
if vptmpa(0) <> "" then
vpchk = false
else
for vpi = 1 to ubound(vptmpa)
if vptmpa(vpi) = "" or vptmpa(vpi) = "." or vptmpa(vpi) = ".." then
vpchk = false
exit for
end if
next
end if
end if
vPath = vpchk
end function
sub andromedaHeader (x)
andromedaHeaderCore x,false
end sub
sub andromedaHeaderCore (x,y)
response.write("<!--" & string(12,vbcrlf) & vbtab & vbtab & andromedaPrefs("siteName") & vbcrlf & vbcrlf & vbcrlf & vbtab & vbtab & replace(replace(trans(27),"#a",andromedaConst("appname")),"##",andromedaConst("andromedaVersion")) & vbcrlf & vbtab & vbtab & "(c)" & year(date()) & " " & andromedaConst("appauth") & ", " & andromedaConst("appcorp") & vbcrlf & vbtab & vbtab & andromedaConst("approot") & vbcrlf & string(48,vbcrlf) & "-->")
if not andromedaPrefs("disableHTMLheaders") then
%><html><head><META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<% = clangCodes(1) %>"><title><% = minHTMLencode(andromedaPrefs("siteName") & ": " & x) %></title><%
if andromedaPrefs("cssLinkHref") <> "" then
%><link rel="stylesheet" type="text/css" href="<% = andromedaPrefs("cssLinkHref") %>"><%
end if
%><script<% if andromedaPrefs("includeJavascript") <> "" then %> src="<% = andromedaPrefs("includeJavascript") %>"<% end if %>></script></head><body bgcolor="<% = andromedaPrefs("bodyBgColor") %>" text="<% = andromedaPrefs("bodyTextColor") %>" link="<% = andromedaPrefs("bodyLinkColor") %>" vlink="<% = andromedaPrefs("bodyVlinkColor") %>" alink="<% = andromedaPrefs("bodyAlinkColor") %>" topmargin="<% = andromedaPrefs("bodyMarginSize") %>" leftmargin="<% = andromedaPrefs("bodyMarginSize") %>" marginheight="<% = andromedaPrefs("bodyMarginSize") %>" marginwidth="<% = andromedaPrefs("bodyMarginSize") %>"><%
end if
if y then
%><script language=javascript><!--
location.replace("<% = andrLink("","") %>");//--></script><%
end if
if ((andromedaPrefs("includeHeader") <> "") and (ScriptEngineMajorVersion >= 5)) then
server.execute(andromedaPrefs("includeHeader"))
end if
%><% = andromedaPrefs("absoluteHeader") %><%
%><center><%
colorbars andromedaPrefs("headDiv")
if not(andromedaPrefs("hideMenubar")) then
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("menubarColor") %>"><tr><td><table cellspacing=0 cellpadding=0 border=0><tr><td><a href=<% = andrLink("","") %>><% imagetag "h","i",trans(17) %></a></td><td><% ipad 4,1 %></td><td><font size="2" face="helvetica,arial" color="<% = andromedaPrefs("siteNameColor") %>"><b><i><% = minHTMLencode(andromedaPrefs("siteName")) %></i></b></font></td></tr></table></td><td align=right><table cellspacing=0 cellpadding=0 border=0><tr><%
if andromedaConst("localUser") then
%><td><a href=<% = andrLink("?q=r","") %>><% imagetag "r","i",trans(18) %></a></td><td><% ipad 4,1 %></td><%
end if
if andromedaPrefs("ftpPath") <> "" then
%><td><a href="<% = andromedaPrefs("ftpPath") %>" target=ftp><% imagetag "t","i",trans(20) %></a></td><td><% ipad 4,1 %></td><%
end if
%><td><a href="<% = andromedaConst("approot") %>" target=_top><% imagetag "i","i",andromedaConst("appname") & ": " & trans(17) %></a></td></tr></table><%
%></td></tr></table><%
colorbars andromedaPrefs("menubarDiv")
end if
if andromedaPrefs("customHeader") <> "" then
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><% = andromedaPrefs("customHeader") %></font></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
end if
response.flush
end sub
sub andromedaFooter
if andromedaPrefs("customBlock") <> "" then
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td align=center><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><% = andromedaPrefs("customBlock") %></font></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
end if
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td align=center><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 12
if andromedaPrefs("email") <> "" then
%><% = trans(26) %> &raquo; <% if andromedaPrefs("disableHTMLheaders") then %><a href="mailto:<% = andromedaPrefs("email") %>" style="color:<% = andromedaPrefs("bodyLinkColor") %>"><font color="<% = andromedaPrefs("bodyLinkColor") %>"><% = andromedaPrefs("email") %></font></a><% else %><a href="mailto:<% = andromedaPrefs("email") %>"><% = andromedaPrefs("email") %></a><% end if %><%
addvpad 12
end if
if andromedaPrefs("permitTranslation") then
%><table cellspacing=0 cellpadding=0 border=0><form method=get action="<% = andrLink("","") %>"><input type=hidden name=q value=t><tr><td><select name=t style="<% = andromedaPrefs("formStyle") %>" onChange="javascript:window.location.href = '<% = andrLink("?q=t&t=","") %>' + options[selectedIndex].value;"><%
for each x in rosetta.keys
clangCodesTmp = split(rosetta(x)(0),vbtab)
%><option value=<% = x %><% if x = currentLanguage then %> selected<% end if %>><%
if clangCodesTmp(1) = clangCodes(1) then
%><% = rosetta(x)(1) %><%
else
%><% = clangCodesTmp(2) %><%
end if
next
%></select></td><noscript><td><% ipad 4,1 %></td><td><% imagetag "g","f","" %></td></noscript></tr></form></table><%
addvpad 12
end if
ptag = trans(27)
if andromedaPrefs("disableHTMLheaders") then
ptag = replace(ptag,"#a","<a href=""" & andromedaConst("approot") & """ target=_top style=""color:" & andromedaPrefs("bodyLinkColor") & """><font color=""" & andromedaPrefs("bodyLinkColor") & """>" & andromedaConst("appname") & "</font></a>")
else
ptag = replace(ptag,"#a","<a href=""" & andromedaConst("approot") & """ target=_top>" & andromedaConst("appname") & "</a>")
end if
ptag = replace(ptag,"##",andromedaConst("andromedaVersion"))
%><nobr><% = ptag %>.</nobr> <nobr>&copy;<% = year(date()) & " " & andromedaConst("appauth") %>, <% if andromedaPrefs("disableHTMLheaders") then %><a href="http://www.turnstyle.com" target=_top style="color:<% = andromedaPrefs("bodyLinkColor") %>"><font color="<% = andromedaPrefs("bodyLinkColor") %>"><% = andromedaConst("appcorp") %></font></a><% else %><a href="http://www.turnstyle.com" target=_top><% = andromedaConst("appcorp") %></a><% end if %>.</nobr><%
addvpad 6
%></font></td></tr></table><%
colorbars andromedaPrefs("footDiv")
%></center><%
%><% = andromedaPrefs("absoluteFooter") %><%
if ((andromedaPrefs("includeFooter") <> "") and (ScriptEngineMajorVersion >= 5)) then
server.execute(andromedaPrefs("includeFooter"))
end if
if not andromedaPrefs("disableHTMLheaders") then
%></body></html><%
end if
end sub
sub showfolder (x)
if local_fs.folderExists(andromedaPrefs("mediaPhysicalPath") & x) then
folderName = displayName(x)
andromedaHeader folderName
folderOpenNote x & "/" & andromedaPrefs("folderOpenInfo") & ".txt"
navbar3 x,"browse"
if andromedaPrefs("permitPlaylists") then playlistFormHead true
colorbars andromedaPrefs("bodyFgToRowDiv")
xx2d = getSubfolders2d(x)
for fi = 0 to ubound(xx2d,1)
folderrow x & "/" & xx2d(fi,0),false,true
rowNote x & "/" & xx2d(fi,0) & "/" & andromedaPrefs("folderListInfo") & ".txt",x & "/" & xx2d(fi,0)
response.flush
next
xx2d = getFiles2d(x)
for fi = 0 to ubound(xx2d,1)
filerow x & "/" & xx2d(fi,0),false,true
rowNote x & "/" & local_fs.getbasename(xx2d(fi,0)) & ".txt",""
response.flush
next
colorbars andromedaPrefs("rowToBodyFgDiv")
if andromedaPrefs("permitPlaylists") then playlistFormFoot true
displayAMG folderName,isAlbum(x)
andromedaFooter
else
fourOfour
end if
end sub
sub fourOfour ()
andromedaHeader trans(40)
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>" height=220><tr><td align=center><% if andromedaPrefs("disableHTMLheaders") then %><font color=<% = andromedaPrefs("bodyTextColor") %>><% end if %><% = trans(40) & ". " & trans(43) & ", " %><% if andromedaPrefs("disableHTMLheaders") then %><a href=<% = andrLink("","") %> style="color:<% = andromedaPrefs("bodyLinkColor") %>"><font color="<% = andromedaPrefs("bodyLinkColor") %>"><% = trans(42) %></font></a><% else %><a href=<% = andrLink("","") %>><% = trans(42) %></a><% end if %>.<% if andromedaPrefs("disableHTMLheaders") then %></font><% end if %></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
andromedaFooter
end sub
sub navbar3 (x,y)
if andromedaPrefs("permitSearch") then
if y = "search" then
searchbar x
else
searchbar ""
end if
colorbars andromedaPrefs("bodyFgDiv")
end if
if not((x = "") and (y = "browse")) then
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><table cellspacing=0 cellpadding=0 border=0><tr><td><%
imagetag "o","i",""
%></td><td><%
drill2 local_fs.getparentfoldername(x),2
%></td></tr></table></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
end if
if y = "browse" then
if x = "" then
sidestep = false
else
sidestep = (subfolderCount(local_fs.getparentfoldername(x)) > 1)
end if
if andromedaPrefs("playLinks") then playalbum = playable(x)
end if
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><table cellspacing=0 cellpadding=0 border=0><tr><%
if ((x = "") and (y = "browse")) then
%><td><%
imagetag "o","i",""
%></td><%
end if
if sidestep then
%><form method=get action=<% = andrLink("","") %>><input type=hidden name=q value=f><%
end if
if ((x = "") and (y = "browse")) then
%><td><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b><% = andromedaPrefs("rootName") %></b></font></td><%
elseif y = "search" then
%><td><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b><% = "[" & x & "] " & trans(37) %></b></font></td><%
elseif y = "playlist" then
%><td><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b><% = x %></b></font></td><%
else
if sidestep then
%><td><font></font><select name=f style="<% = andromedaPrefs("formStyle") %>" onChange="javascript:window.location.href='<% = andrLink("?q=f&f=","") %>' + escape(options[selectedIndex].value);"><%
xx2d = getSubfolders2d(local_fs.getparentfoldername(x))
for fi = 0 to ubound(xx2d,1)
%><option value="<% = local_fs.getparentfoldername(x) & "/" & xx2d(fi,0) %>"<% if x = local_fs.getparentfoldername(x) & "/" & xx2d(fi,0) then %> selected<% end if %>><% = limitName(displayName(xx2d(fi,0))) %><%
next
%></select></td><noscript><td><% ipad 4,1 %></td><td><% imagetag "g","f","" %></td></noscript><%
else
%><td><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b><% = displayName(x) %></b></font></td><%
end if
end if
if sidestep then
%></form><%
end if
if andromedaPrefs("folderAux1") <> "" then
%><td><% ipad 4,1 %></td><td><a href="<% = andromedaPrefs("folderAux1") & server.urlencode(x) %>"><%
imagetag "q","i","discuss"
%></a></td><%
end if
if ((y = "playlist") and (ckplaylist <> "") and andromedaPrefs("playLinks")) then
%><td><% ipad 4,1 %></td><td><a href=<% = andrLink("?q=y&y=p","") %>><% imagetag "p","i",trans(11) %></a></td><%
end if
if playalbum then
%><td><% ipad 4,1 %></td><td><%
playFolderButton x
%></td><%
end if
if x = "" then
metadisplay = andromedaPrefs("mediaPhysicalPath")
else
metadisplay = x
end if
if y = "browse" then
metapath = "/" & andromedaPrefs("rootName") & x
else
metapath = "/" & andromedaPrefs("rootName") & "/" & x
end if
%><td><% ipad 4,1 %></td><td><a href="<% = andromedaConst("approot") %>/meta.asp?p=<% = server.urlencode(metapath) %>" target=_blank><%
imagetag "k","i",andromedaConst("appname") & ": " & displayname(metadisplay)
%></a></td><%
%></tr></table></td></tr></table><%
response.flush
end sub
sub folderOpenNote (x)
if (andromedaPrefs("globalAnnotations") or (andromedaPrefs("defaultLanguage") = currentLanguage)) then
if local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & local_fs.getparentfoldername(x) & "/" & andromedaPrefs("folderOpenImage") & ".jpg") then
folderImageExt = ".jpg"
elseif local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & local_fs.getparentfoldername(x) & "/" & andromedaPrefs("folderOpenImage") & ".gif") then
folderImageExt = ".gif"
end if
if local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & x) then
note = local_fs.OpenTextFile(andromedaPrefs("mediaPhysicalPath") & x).ReadAll
end if
if folderImageExt <> "" or note <> "" or (andromedaConst("localUser") and andromedaPrefs("editMode")) then
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><%
if note <> "" or (andromedaConst("localUser") and andromedaPrefs("editMode")) then
%><td align=center><table cellspacing=0 cellpadding=0 border=0><tr><td><%
if andromedaConst("localUser") and andromedaPrefs("editMode") then
if note = "" then
mode = "add"
else
mode = "edit"
end if
%><table cellspacing=0 cellpadding=0 border=0 align=left><tr><td><a href=<% = andrLink("?q=e&e=",x) %>><% imagetag "r","i",mode & " note" %></a></td></tr></table><%
end if
if note <> "" then
%><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><% = note & " " %></font><%
end if
%></td></tr></table></td><%
end if
if folderImageExt <> "" then
if andromedaPrefs("folderOpenImageDims") <> "" then
ittmpa = split(andromedaPrefs("folderOpenImageDims"),",")
imgdimtag = " width=" & ittmpa(0) & " height=" & ittmpa(1)
else
imgdimtag = ""
end if
%><td align=center><img src="<% = mkMediaWebPath(local_fs.getparentfoldername(x)) %>/<% = andromedaPrefs("folderOpenImage") & folderImageExt %>"<% = imgdimtag %>></td><%
end if
%></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
end if
end if
end sub
sub folderrow (x,d,m)
totalrowcount = totalrowcount + 1
mysubfolderCount = subfolderCount(x)
myfileCount = fileCount(x)
if totalrowcount <> 1 then colorBars andromedaPrefs("rowDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor=<% = switchrow(totalrowcount,andromedaPrefs("rowColor1"),andromedaPrefs("rowColor2")) %>><tr><td valign=top><%
if d then
drill2 local_fs.getparentfoldername(x),1
addvpad 8
end if
%><table cellspacing=0 cellpadding=0 border=0><tr><%
if andromedaPrefs("permitPlaylists") then
%><td valign=top><input type=checkbox name=f value="<% if m then %><% = "o" & x %><% else %><% = totalrowcount %><% end if %>"<% if andromedaPrefs("checkboxDefault") then %> checked<% end if %>></td><%
end if
%><td valign=top><a href=<% = folderLink(x) %>><% imagetag "c","i","" %></a></td><td valign=top><%
if ((andromedaPrefs("disableHTMLheaders") or (andromedaPrefs("rowLinkColor") <> andromedaPrefs("bodyLinkColor"))) and (andromedaPrefs("rowLinkColor") <> "")) then
%><a href=<% = folderLink(x) %> style="color:<% = andromedaPrefs("rowLinkColor") %>"><font size="2" color="<% = andromedaPrefs("rowLinkColor") %>"><% = displayName(x) %></font></a><%
else
%><a href=<% = folderLink(x) %>><font size="2"><% = displayName(x) %></font></a><%
end if
if andromedaPrefs("displayNew") then displaynew newestfile(x)
%></td></tr></table></td><td align=right><%
if mysubfolderCount = 0 and myfileCount = 0 then
desc2 = "&nbsp;"
end if
if mysubfolderCount > 1 and myfileCount = 0 then
desc2 = mysubfolderCount & "&nbsp;" & trans(5)
link2 = folderLink(x)
end if
if mysubfolderCount = 0 and myfileCount > 0 then
desc2 = myfileCount & "&nbsp;" & ifps2(myfileCount,trans(2),trans(3))
link2 = folderLink(x)
end if
if mysubfolderCount > 0 and myfileCount > 0 then
desc2 = mysubfolderCount & "&nbsp;" & ifps2(mysubfolderCount,trans(4),trans(5)) & ", " & myfileCount & "&nbsp;" & ifps2(myfileCount,trans(2),trans(3))
link2 = folderLink(x)
end if
if mysubfolderCount = 1 and myfileCount = 0 then
for each f22 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).subfolders
if legalFolder(f22.name) then
desc2 = displayName(f22.name)
link2 = folderLink(x & "/" & f22.name)
end if
next
end if
if link2 <> "" then
if ((andromedaPrefs("disableHTMLheaders") or (andromedaPrefs("rowLinkColor") <> andromedaPrefs("bodyLinkColor"))) and (andromedaPrefs("rowLinkColor") <> "")) <> "" then
desc2 = "<a href=" & link2 & " style=""color:" & andromedaPrefs("rowLinkColor") & """><font size=""1"" color=""" & andromedaPrefs("rowLinkColor") & """>" & desc2 & "</font></a>"
else
desc2 = "<a href=" & link2 & "><font size=""1"">" & desc2 & "</font></a>"
end if
else
desc2 = "<font size=""1"">" & desc2 & "</font>"
end if
if andromedaPrefs("playLinks") then
if playable(x) then
%><table cellspacing=0 cellpadding=0 border=0><tr><td align=right><% = desc2 %></td><td><% ipad 4,1 %></td><td><% playFolderButton x %></td></tr></table><%
else
%><% = desc2 %><%
end if
else
%><% = desc2 %><%
end if
%></td></tr></table><%
end sub
sub filerow (x,d,m)
thisfiletype = lcase(local_fs.getextensionname(x))
thisfilesize = local_fs.GetFile(andromedaPrefs("mediaPhysicalPath") & x).size
if (andromedaPrefs("getID3info") and (thisfiletype = "mp3") and (thisfilesize > 0)) then
Set fp = local_fs.OpenTextFile(andromedaPrefs("mediaPhysicalPath") & x, 1)
mp3Length = ""
mp3Album = ""
mp3Artist = ""
mp3TrackName = ""
mp3Quality = ""
fpp = 0
dim bb(9)
for i = 0 to 9
bb(i) = fixbin(fp.Read(1))
next
fpp = fpp + 10
validID3v2header = ((bb(0) = 73) and (bb(1) = 68) and (bb(2) = 51) and (bb(3) < 255) and (bb(4) < 255) and (bb(5) = (bb(5) and 240)) and (bb(6) = 0) and (bb(7) < 128) and (bb(8) < 128) and (bb(9) < 128))
if validID3v2header then
ID3size = bb(7) * 128 * 128 + bb(8) * 128 + bb(9)
extendedHeader = (bb(5) and 64) / 64
footerPresent = (bb(5) and 16) / 16
totalID3size = 10 + ID3size + footerPresent * 10
if extendedHeader = 1 then
for i = 0 to 5
bb(i) = fixbin(fp.Read(1))
next
fpp = fpp + 6
extendedHeaderSize = bb(1) * 128 * 128 + bb(2) * 128 + bb(3)
fp.skip(extendedHeaderSize - 6)
fpp = fpp + (extendedHeaderSize - 6)
end if
for i = 0 to 9
bb(i) = fixbin(fp.Read(1))
next
fpp = fpp + 10
do while ((((bb(0) >= 48) and (bb(0) <= 57)) or ((bb(0) >= 65) and (bb(0) <= 90))) and (((bb(1) >= 48) and (bb(1) <= 57)) or ((bb(1) >= 65) and (bb(1) <= 90))) and (((bb(2) >= 48) and (bb(2) <= 57)) or ((bb(2) >= 65) and (bb(2) <= 90))) and (((bb(3) >= 48) and (bb(3) <= 57)) or ((bb(3) >= 65) and (bb(3) <= 90))) and (bb(4) = 0) and (bb(5) < 128) and (bb(6) < 128) and (bb(7) < 128))
ID3frameID = chr(bb(0)) & chr(bb(1)) & chr(bb(2)) & chr(bb(3))
ID3frameSize = bb(5) * 128 * 128 + bb(6) * 128 + bb(7)
if ID3frameSize > 0 then
skipbyte = fp.Read(1)
ID3frameVal = bin2txt(fp.Read(ID3frameSize - 1))
fpp = fpp + ID3frameSize
else
ID3frameVal = ""
end if
if ID3frameID = "TLEN" then
mp3Length = ID3frameVal / 1000
'elseif ID3frameID = "TCON" then
'mp3Genre = ID3frameVal
'elseif ID3frameID = "TRCK" then
'mp3TrackNumber = ID3frameVal
elseif ID3frameID = "TALB" then
mp3Album = ID3frameVal
elseif ID3frameID = "TPE1" then
mp3Artist = ID3frameVal
elseif ID3frameID = "TIT2" then
mp3TrackName = ID3frameVal
end if
for i = 0 to 9
bb(i) = fixbin(fp.Read(1))
next
fpp = fpp + 10
loop
offset = totalID3size - fpp
if offset >= 0 then
if offset > 0 then
fp.skip(offset)
fpp = fpp + offset
end if
for i = 0 to 3
bb(i) = fixbin(fp.Read(1))
next
fpp = fpp + 4
else
for i = 1 to (-1 * offset)
bb(i-1) = bb(10 + offset + i - 1)
next
if 4 + offset > 0 then
for i = (-1 * offset) to 3
bb(i) = fixbin(fp.Read(1))
fpp = fpp + 1
next
end if
end if
end if
cbr = true
for xox = 1 to (andromedaPrefs("vbrScanCount") + andromedaPrefs("vbrSkipCount"))
mpegVersion = (bb(1) and 24) / 8
layer = (bb(1) and 6) / 2
protection = (bb(1) and 1)
bitrate = (bb(2) and 240) / 16
samplefrequency = (bb(2) and 12) / 4
padded = (bb(2) and 2) / 2
channelMode = (bb(3) and 192) / 64
validMP3frame = ((bb(0) = 255) and (bb(1) >= 224) and (mpegVersion <> 1) and (layer <> 0) and (bitrate <> 0) and (bitrate <> 15) and (samplefrequency <> 3))
if validMP3frame then
if mpegVersion = 3 then
if layer = 3 then
column = 1
elseif layer = 2 then
column = 2
elseif layer = 1 then
column = 3
end if
if samplefrequency = 0 then
samplefrequencyD = 44100
elseif samplefrequency = 1 then
samplefrequencyD = 48000
elseif samplefrequency = 2 then
samplefrequencyD = 32000
end if
elseif mpegVersion = 2 then
if layer = 3 then
column = 4
elseif layer = 2 then
column = 5
elseif layer = 1 then
column = 5
end if
if samplefrequency = 0 then
samplefrequencyD = 22050
elseif samplefrequency = 1 then
samplefrequencyD = 24000
elseif samplefrequency = 2 then
samplefrequencyD = 16000
end if
elseif mpegVersion = 0 then
if layer = 3 then
column = 4
elseif layer = 2 then
column = 5
elseif layer = 1 then
column = 5
end if
if samplefrequency = 0 then
samplefrequencyD = 11025
elseif samplefrequency = 1 then
samplefrequencyD = 12000
elseif samplefrequency = 2 then
samplefrequencyD = 8000
end if
end if
bitrateDataA = array(32,32,32,32,8,64,48,40,48,16,96,56,48,56,24,128,64,56,64,32,160,80,64,80,40,192,96,80,96,48,224,112,96,112,56,256,128,112,128,64,288,160,128,144,80,320,192,160,160,96,352,224,192,176,112,384,256,224,192,128,416,320,256,224,144,448,384,320,256,160)
bitrateD = bitrateDataA((bitrate - 1) * 5 + column - 1)
if ((bitrateD <> prevbitrateD) and (prevbitrateD <> "")) then
cbr = false
end if
prevbitrateD = bitrateD
if channelMode = 0 then
channelModeD = "Stereo"
elseif channelMode = 1 then
channelModeD = "Joint Stereo"
elseif channelMode = 2 then
channelModeD = "Dual Channel"
elseif channelMode = 3 then
channelModeD = "Single channel (Mono)"
end if
if ((layer = 1) or (layer = 2)) then
framesize = fix((144 * 1000 * bitrateD) / samplefrequencyD) + padded
elseif layer = 3 then
framesize = fix(12 * 1000 * bitrateD / samplefrequencyD + padded) * 4
end if
if xox > andromedaPrefs("vbrSkipCount") then avgbitrateD = avgbitrateD + bitrateD
if xox >= andromedaPrefs("cbrCutoff") and cbr then exit for
else
exit for
end if
if xox = 1 then
if validID3v2header then
cursor = framesize-4
else
cursor = framesize-10
end if
else
cursor = framesize-4
end if
if fpp + cursor < thisfilesize then
fp.Skip(cursor)
fpp = fpp + cursor
for i = 0 to 3
bb(i) = fixbin(fp.Read(1))
next
fpp = fpp + 4
else
exit for
end if
next
if bitrateD <> "" then
if cbr then
if mp3Length = "" then
mp3Length = round(thisfilesize / (bitrateD * 1000 / 8))
end if
mp3Quality = bitrateD & "&nbsp;kbit/s"
else
if mp3Length = "" then
mp3Length = round(thisfilesize / (avgbitrateD / (xox-1-andromedaPrefs("vbrSkipCount")) * 1000 / 8))
end if
mp3Quality = round(avgbitrateD / (xox-1-andromedaPrefs("vbrSkipCount"))) & "&nbsp;kbit/s&nbsp;VBR"
end if
end if
'mp3Quality = bitrateD & "&nbsp;kbit/s " & samplefrequencyD & "&nbsp;Hz " & channelModeD
if (not(andromedaPrefs("skipID3v1")) and (mp3TrackName = "")) then
fp.Skip(thisfilesize - fpp - 128)
id3v1tag = ucase(bin2txt(fp.Read(3)))
if ((id3v1tag = "ID3") or (id3v1tag = "TAG")) then
id3v1Title = trim(bin2txt(fp.Read(30)))
id3v1Artist = trim(bin2txt(fp.Read(30)))
id3v1Album = trim(bin2txt(fp.Read(30)))
id3v1Year = trim(bin2txt(fp.Read(4)))
id3v1Comment = trim(bin2txt(fp.Read(28)))
id3v12skip = ascb(fp.Read(1))
id3v12number = ascb(fp.Read(1))
id3v1Genre = ascb(fp.Read(1))
'if mp3Genre = "" then mp3Genre = id3v1Genre
'if mp3TrackNumber = "" then mp3TrackNumber = id3v12number
if mp3Album = "" then mp3Album = id3v1Album
if mp3Artist = "" then mp3Artist = id3v1Artist
if mp3TrackName = "" then mp3TrackName = id3v1Title
end if
end if
fp.close
end if
if fileTypes.exists(thisfiletype) then
select case fileTypes(thisfiletype)
case "audio"
fileicon = "a"
case "video"
fileicon = "v"
case "playlist"
fileicon = "l"
end select
end if
totalrowcount = totalrowcount + 1
if totalrowcount <> 1 then colorBars andromedaPrefs("rowDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor=<% = switchrow(totalrowcount,andromedaPrefs("rowColor1"),andromedaPrefs("rowColor2")) %>><tr><td><%
if d then
drill2 local_fs.getparentfoldername(x),1
addvpad 8
end if
%><table cellspacing=0 cellpadding=0 border=0><tr><%
if andromedaPrefs("permitPlaylists") then
%><td valign=top><input type=checkbox name=f value="<% if m then %><% = "i" & x %><% else %><% = totalrowcount %><% end if %>"<% if andromedaPrefs("checkboxDefault") then %> checked<% end if %>></td><%
end if
%><td valign=top><%
if andromedaPrefs("fileLinks") then
%><a href="<% if andromedaConst("localUser") and andromedaPrefs("localFilePlayback") then %><% = local_fs.GetFile(andromedaPrefs("mediaPhysicalPath") & x).path %><% else %><% = mkMediaWebPath(x) %><% end if %>"><% imagetag fileicon,"i","" %></a><%
else
imagetag fileicon,"i",""
end if
%></td><td valign=top><%
if andromedaPrefs("fileLinks") then
if ((andromedaPrefs("disableHTMLheaders") or (andromedaPrefs("rowLinkColor") <> andromedaPrefs("bodyLinkColor"))) and (andromedaPrefs("rowLinkColor") <> "")) <> "" then
%><a href="<% if andromedaConst("localUser") and andromedaPrefs("localFilePlayback") then %><% = local_fs.GetFile(andromedaPrefs("mediaPhysicalPath") & x).path %><% else %><% = mkMediaWebPath(x) %><% end if %>" style="color:<% = andromedaPrefs("rowLinkColor") %>"><font size="2" color="<% = andromedaPrefs("rowLinkColor") %>"><%
if mp3TrackName <> "" then
%><% = mp3TrackName %><%
else
%><% = displayName(x) %><%
end if
%></font></a><%
else
%><a href="<% if andromedaConst("localUser") and andromedaPrefs("localFilePlayback") then %><% = local_fs.GetFile(andromedaPrefs("mediaPhysicalPath") & x).path %><% else %><% = mkMediaWebPath(x) %><% end if %>"><font size="2"><%
if mp3TrackName <> "" then
%><% = mp3TrackName %><%
else
%><% = displayName(x) %><%
end if
%></font></a><%
end if
else
%><font size="2" color="<% = andromedaPrefs("rowTextColor") %>"><%
if mp3TrackName <> "" then
%><% = mp3TrackName %><%
else
%><% = displayName(x) %><%
end if
%></font><%
end if
if andromedaPrefs("displayNew") then displaynew local_fs.getfile(andromedaPrefs("mediaPhysicalPath") & x).datecreated
if ((mp3Artist <> "") or (mp3Album <> "")) then
%><br><font size="1" color="<% = andromedaPrefs("rowTextColor") %>"><%
if ((mp3Artist <> "") and (mp3Album <> "")) then
%><% = mp3Artist & " - " & mp3Album %><%
else
%><% = mp3Artist & mp3Album %><%
end if
%></font><%
end if
%></td></tr></table></td><td align=right><%
if andromedaPrefs("playLinks") then
%><table cellspacing=0 cellpadding=0 border=0><tr><td align=right><font size="1" color="<% = andromedaPrefs("rowTextColor") %>"><%
if ((mp3Length <> "") or (mp3Quality <> "")) then
if ((mp3Length <> "") and (mp3Quality <> "")) then
%><% = sec2time(mp3Length) & " &#183; " & mp3Quality %><%
else
if mp3Length <> "" then
%><% = sec2time(mp3Length) %><%
else
%><% = mp3Quality %><%
end if
end if
%><% = " &#183; " %><%
end if
%><% = bytecount(thisfilesize) & " &#183; " & ucase(thisfiletype) %></font></td><td><% ipad 4,1 %></td><td><a href=<% = andrLink("?q=m&m=",x) %>><% imagetag "p","i","" %></a></td></tr></table><%
else
%><font size="1" color="<% = andromedaPrefs("rowTextColor") %>"><%
if ((mp3Length <> "") or (mp3Quality <> "")) then
if ((mp3Length <> "") and (mp3Quality <> "")) then
%><% = sec2time(mp3Length) & " &#183; " & mp3Quality %><%
else
if mp3Length <> "" then
%><% = sec2time(mp3Length) %><%
else
%><% = mp3Quality %><%
end if
end if
%><% = " &#183; " %><%
end if
%><% = bytecount(thisfilesize) & " &#183; " & ucase(thisfiletype) %></font><%
end if
%></td></tr></table><%
end sub
sub rowNote (x,i)
if (andromedaPrefs("globalAnnotations") or (andromedaPrefs("defaultLanguage") = currentLanguage)) then
if i <> "" then
if local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & i & "/" & andromedaPrefs("folderListImage") & ".jpg") then
folderImageExt = ".jpg"
elseif local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & i & "/" & andromedaPrefs("folderListImage") & ".gif") then
folderImageExt = ".gif"
end if
end if
if local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & x) then
note = local_fs.OpenTextFile(andromedaPrefs("mediaPhysicalPath") & x).ReadAll
end if
if folderImageExt <> "" or note <> "" or (andromedaConst("localUser") and andromedaPrefs("editMode")) then
%><table cellspacing=0 cellpadding=0 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor=<% = switchrow(totalrowcount,andromedaPrefs("rowColor1"),andromedaPrefs("rowColor2")) %>><tr><%
if andromedaConst("localUser") and andromedaPrefs("editMode") then
if note = "" then
mode = "add"
else
mode = "edit"
end if
%><td valign=top><table cellspacing=0 cellpadding=0 border=0><tr><td><% ipad 10,1 %></td><td><a href=<% = andrLink("?q=e&e=",x) %>><% imagetag "r","i",mode & "note" %></a><td><% ipad 4,1 %></td></tr></table></td><%
else
%><td><% ipad 30,1 %></td><%
end if
%><td width=100%><%
if folderImageExt <> "" then
if andromedaPrefs("folderListImageDims") <> "" then
ittmpa = split(andromedaPrefs("folderListImageDims"),",")
imgdimtag = " width=" & ittmpa(0) & " height=" & ittmpa(1)
else
imgdimtag = ""
end if
%><table cellspacing=0 cellpadding=0 border=0 align=left><tr><td><a href=<% = folderLink(local_fs.getparentfoldername(x)) %>><img src="<% = mkMediaWebPath(local_fs.getparentfoldername(x) & "/" & andromedaPrefs("folderListImage") & folderImageExt) %>"<% = imgdimtag %> border=0></a></td></tr></table><%
end if
if note <> "" then
%><font size="2" color="<% = andromedaPrefs("rowTextColor") %>"><% = note & " " %></font><%
end if
%></td></tr></table><%
colorbar andromedaPrefs("siteWidth"),"6",switchrow(totalrowcount,andromedaPrefs("rowColor1"),andromedaPrefs("rowColor2"))
end if
end if
end sub
sub searchbar (s)
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td align=right><table cellspacing=0 cellpadding=0 border=0><form method=get action=<% = andrLink("","") %>><input type=hidden name=q value=s><% if andromedaPrefs("compactSearch") then %><input type=hidden name=sm value=ff><% end if %><tr><td align=right><font face="helvetica,arial" size="1"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><% = trans(13) & " " & andromedaPrefs("siteName") %></font></td><%
if not andromedaPrefs("compactSearch") then
%><td><% ipad 4,1 %></td><td><select name=sm style="<% = andromedaPrefs("formStyle") %>"><option value=fo<% if (request("sm") = "fo" or (request("sm") = "")) then %> selected<% end if %>><% = trans(5) %><option value=fi<% if request("sm") = "fi" then %> selected<% end if %>><% = trans(3) %><option value=ff<% if (request("sm") = "ff") then %> selected<% end if %>><% = trans(5) & " + " & trans(3) %></select></td><%
end if 
%><td><% ipad 4,1 %></td></td><td><input name=s size=20 value="<% = minHTMLencode(s) %>" style="<% = andromedaPrefs("formStyle") %>"></td><td><% ipad 4,1 %></td><td><% imagetag "g","f","" %></td></tr></form></table></td></tr></table><%
end sub
if ((abs(local_fs.GetFile(request.servervariables("path_translated")).size - len(andromedaPrefsFileName) - 122428 + 18) > 1) and (abs(local_fs.GetFile(request.servervariables("path_translated")).size - len(andromedaPrefsFileName) - 122428 + 2041 + 18) > 1)) then response.end
sub displayAMG (n,a)
if andromedaPrefs("displayAMG") then
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td align=right><table cellspacing=0 cellpadding=0 border=0><form action="http://www.allmusic.com/cg/amg.dll" method=post target=amg><input type=hidden name=P value=amg><tr><td align=right><font face="helvetica,arial" size="1"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><% = trans(13) & " allmusic.com" %></font></td><td><% ipad 4,1 %></td><td><select name=opt1 style="<% = andromedaPrefs("formStyle") %>"><option value=1><% = trans(21) %><option value=2<% if a then %> selected<% end if %>><% = trans(22) %><option value=3><% = trans(23) %><option value=5><% = trans(24) %><option value=4><% = trans(25) %></select></td><td><% ipad 4,1 %></td><td><input type=textfield name=sql size=20 maxlength=30 value="<% = minHTMLencode(n) %>" style="<% = andromedaPrefs("formStyle") %>"></td><td><% ipad 4,1 %></td><td><% imagetag "g","f","" %></td></tr></form></table></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
end if
end sub
sub search (s,sm)
andromedaHeader "[" & s & "] " & trans(37)
navbar3 s,"search"
if andromedaPrefs("permitPlaylists") then playlistFormHead true
colorbars andromedaPrefs("bodyFgToRowDiv")
if len(trim(s)) > 1 then
if sm = "fo" or sm = "ff" or sm = "" then searchFolders "",lcase(s)
if sm = "fi" or sm = "ff" or sm = "" then searchFiles "",lcase(s)
if totalrowcount = 0 then
%><table cellspacing=0 cellpadding=0 border=0 bgcolor="<% = andromedaPrefs("rowColor1") %>" width="<% = andromedaPrefs("siteWidth") %>"><tr><td align=center><% addvpad 48 %><font face="helvetica,arial" size="2" color="<% = andromedaPrefs("rowTextColor") %>"><b><% = trans(39) %></b></font><% addvpad 48 %></td></tr></table><%
end if
colorbars andromedaPrefs("rowToBodyFgDiv")
if andromedaPrefs("permitPlaylists") then playlistFormFoot true
else
%><table cellspacing=0 cellpadding=0 border=0 bgcolor="<% = andromedaPrefs("rowColor1") %>" width="<% = andromedaPrefs("siteWidth") %>"><tr><td align=center><% addvpad 48 %><font face="helvetica,arial" size="2" color="<% = andromedaPrefs("rowTextColor") %>"><b><% = trans(38) %></b></font><% addvpad 48 %></td></tr></table><%
colorbars andromedaPrefs("rowToBodyFgDiv")
if andromedaPrefs("permitPlaylists") then playlistFormFoot true
end if
displayAMG s,false
andromedaFooter
end sub
sub searchFolders (x,s)
xx2d = getSubfolders2d(x)
for fi = 0 to ubound(xx2d,1)
if instr(lcase(replace(xx2d(fi,0),"_"," ")),s) <> 0 then
folderrow x & "/" & xx2d(fi,0),true,true
response.flush
end if
searchFolders x & "/" & xx2d(fi,0),s
next
end sub
sub searchFiles (x,s)
for each i in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).files
if legalFile(i.name) then
if instr(lcase(replace(i.name,"_"," ")),s) <> 0 then
filerow x & "/" & i.name,true,true
response.flush
end if
end if
next
xx2d = getSubfolders2d(x)
for fi = 0 to ubound(xx2d,1)
searchFiles x & "/" & xx2d(fi,0),s
next
end sub
sub playlistFormHead (x)
if x then
m = 1
else
m = 0
end if
%><script language=JavaScript><!--
function ca(x){for(i=0;i<document.forms["l"].elements.length;i++){var j=document.forms["l"].elements[i];if(j.type=="checkbox"){j.checked=x;}}}function ac(){var x=false;for(i=0;i<document.forms["l"].elements.length;i++){var j=document.forms["l"].elements[i];if(j.type=="checkbox"){x=x||j.checked;};if(x){break}}return x;}<%
if andromedaPrefs("usePlaylistIcons") then
%>function pf(x,y){if(!y){y=ac()}if(y){document.forms["l"]["y"].value=x;document.forms["l"].submit();}}<%
end if
%>//--></script><%
%><table cellspacing=0 cellpadding=0 border=0 bgcolor="<% = andromedaPrefs("bodyFgColor") %>" width="<% = andromedaPrefs("siteWidth") %>"><tr><td><table cellspacing=0 cellpadding=0 border=0><form method=post action=<% = andrLink("?q=y&m=" & m,"") %> name=l><%
if andromedaPrefs("usePlaylistIcons") then
%><script language=JavaScript><!--
document.write("<input type=hidden name=y value=\"\">");//--></script><%
end if
%><tr><td></td></tr></table></td></tr></table><%
end sub
sub playlistFormFoot (x)
if ((totalrowcount > 0) or (ckplaylist <> "")) then
plb = andromedaPrefs("usePlaylistIcons")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><%
%><table cellspacing=0 cellpadding=0 border=0><tr><%
if totalrowcount > 0 then
%><script language=JavaScript><!--
<%
if plb then
%>document.write("<td valign=top><a href=# onclick=\"ca(true);return false\"><% imagetagE "sa","i",trans(6) %></a></td><td valign=top><a href=# onclick=\"ca(false);return false\"><% imagetagE "sn","i",trans(7) %></a></td><%
else
%>document.write("<td valign=top><input type=submit value=\"<% = trans(6) %>\" style=\"<% = andromedaPrefs("formStyle") %>\" onclick=\"ca(true);return false;\"></td><td valign=top><input type=submit value=\"<% = trans(7) %>\" style=\"<% = andromedaPrefs("formStyle") %>\" onclick=\"ca(false);return false;\"></td><%
end if
%><td><% ipad 8,1 %></td>");//--></script><%
end if
if totalrowcount > 0 and andromedaPrefs("playLinks") then
%><td valign=top><%
if plb then
%><script language=JavaScript><!--
document.write("<a href=# onclick=\"pf('<% = trans(10) %>',false);return false\"><% imagetagE "ps","i",trans(10) %></a>");//--></script><%
%><noscript><%
end if
%><input type=submit name=y value="<% = trans(10) %>" style="<% = andromedaPrefs("formStyle") %>" onclick="return ac()"><%
if plb then response.write("</noscript>")
%></td><%
%><td><% ipad 8,1 %></td><%
end if
if x and totalrowcount > 0 then
%><td valign=top><%
if plb then
%><script language=JavaScript><!--
document.write("<a href=# onclick=\"pf('<% = trans(8) %>',false);return false\"><% imagetagE "pa","i",trans(8) %></a>");//--></script><%
%><noscript><%
end if
%><input type=submit name=y value="<% = trans(8) %>" style="<% = andromedaPrefs("formStyle") %>" onclick="return ac()"><%
if plb then response.write("</noscript>")
%></td><%
%><td><% ipad 8,1 %></td><%
end if
if ((x = false) and (totalrowcount > 0)) then
%><td valign=top><%
if plb then
%><script language=JavaScript><!--
document.write("<a href=# onclick=\"pf('<% = trans(9) %>',false);return false\"><% imagetagE "pr","i",trans(9) %></a>");//--></script><%
%><noscript><%
end if
%><input type=submit name=y value="<% = trans(9) %>" style="<% = andromedaPrefs("formStyle") %>" onclick="return ac()"><%
if plb then response.write("</noscript>")
%></td><%
%><td><% ipad 8,1 %></td><%
end if
if (x and (ckplaylist <> "")) then
%><td valign=top><%
if plb then
%><script language=JavaScript><!--
document.write("<a href=# onclick=\"pf('<% = trans(45) %>',true);return false\"><% imagetagE "pv","i",trans(45) %></a>");//--></script><%
%><noscript><%
end if
%><input type=submit name=y value="<% = trans(45) %>" style="<% = andromedaPrefs("formStyle") %>"><%
if plb then response.write("</noscript>")
%></td><%
%><td><% ipad 8,1 %></td><%
end if
if ((totalrowcount > 0) and (ckplaylist <> "")) then
plbnote = trans(12)
plbnote = replace (plbnote,"##",round((len(ckplaylist)/(andromedaPrefs("cBlockCount")*andromedaPrefs("cBlockSize")))*100))
%><td><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><% = plbnote %></font></td><%
end if
%></tr></table><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
end if
%><table cellspacing=0 cellpadding=0 border=0 bgcolor="<% = andromedaPrefs("bodyFgColor") %>" width="<% = andromedaPrefs("siteWidth") %>"><tr><td><table cellspacing=0 cellpadding=0 border=0><tr><td></td></tr></form></table></td></tr></table><%
end sub
sub displayPlaylist (x)
andromedaHeader trans(44)
navbar3 trans(44),"playlist"
playlistFormHead false
colorbars andromedaPrefs("bodyFgToRowDiv")
xtmpa = split(ckplaylist,vbcrlf)
for xi = 0 to ubound(xtmpa) -1
if left(xtmpa(xi),1) = "o" then folderrow mid(xtmpa(xi),2),true,false
if left(xtmpa(xi),1) = "i" then filerow mid(xtmpa(xi),2),true,false
next
colorbars andromedaPrefs("rowToBodyFgDiv")
playlistFormFoot false
displayAMG "",false
andromedaFooter
end sub
function readPlaylist (x)
rtmp = ""
for rpi = 1 to andromedaPrefs("cBlockCount")
rtmp = rtmp & request.cookies(x & rpi)
next
readPlaylist = rtmp
end function
sub writePlaylist (x)
for rpi = 1 to andromedaPrefs("cBlockCount")
rpitmp = mid(ckplaylist,(((rpi-1)*andromedaPrefs("cBlockSize"))+1),andromedaPrefs("cBlockSize"))
if rpi = andromedaPrefs("cBlockCount") then
rpitmp = left(rpitmp,instrrev(rpitmp, vbcrlf)+1)
end if
response.cookies(x & rpi) = rpitmp
next
end sub
sub playFolder (x)
if local_fs.folderExists(andromedaPrefs("mediaPhysicalPath") & x) then
playFolder2 x
if totalrowcount = 0 then
response.redirect(andrlink("?q=f&f=",x))
end if
else
fourOfour
end if
end sub
function playable (x)
pinme = false
for each f1 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).files
if legalFile(f1.name) then
pinme = true
exit for
end if
next
if not pinme then
for each f1 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).subfolders
if legalFolder(f1.name) then
if playable (x & "/" & f1.name) then
pinme = true
exit for
end if
end if
next
end if
playable = pinme
end function
sub playFolder2 (x)
xx2d = getSubfolders2d(x)
for fi = 0 to ubound(xx2d,1)
playFolder2 x & "/" & xx2d(fi,0)
if (totalrowcount = andromedaPrefs("maxPlaylistTracks")) then exit for
next
xx2d = getFiles2d(x)
for fi = 0 to ubound(xx2d,1)
playlistRow x & "/" & xx2d(fi,0)
if (totalrowcount = andromedaPrefs("maxPlaylistTracks")) then exit for
next
if ubound(xx2d,1) >= 0 then response.flush
end sub
sub playlistHeader ()
response.contenttype = andromedaPrefs("playlistMime")
select case lcase(andromedaPrefs("playlistMime"))
case "audio/x-mpegurl"
fext = "m3u"
case "audio/x-pn-realaudio"
fext = "ram"
case else
fext = ""
end select
if fext <> "" then
response.AddHeader "Content-Disposition", "inline; filename=playlist." & fext
end if
if andromedaPrefs("includeEXTM3U") then
response.write("#EXTM3U" & vbcrlf)
end if
if not (andromedaConst("localUser") and andromedaPrefs("localFilePlayback")) then
if andromedaPrefs("hostAddress") <> "" then
plrpre = andromedaPrefs("protocol") & "://" & andromedaPrefs("hostAddress")
else
if request.servervariables("SERVER_NAME") <> "" then
ckServerName = request.servervariables("SERVER_NAME")
else
ckServerName = request.servervariables("LOCAL_ADDR")
end if
if ((request.servervariables("SERVER_PORT") <> "80") and (request.servervariables("SERVER_PORT") <> "")) then
ckServerName = ckServerName & ":" & request.servervariables("SERVER_PORT")
end if
plrpre = andromedaPrefs("protocol") & "://" & ckServerName
end if
end if
end sub
sub playlistRow (x)
if totalrowcount = 0 then playlistHeader
totalrowcount = totalrowcount + 1
if andromedaPrefs("includeEXTM3U") then
response.write("#EXTINF:-1," & displayName(x) & vbcrlf)
end if
if (andromedaConst("localUser") and andromedaPrefs("localFilePlayback")) then
response.write(local_fs.GetFile(andromedaPrefs("mediaPhysicalPath") & x).path & vbcrlf)
else
response.write(plrpre & mkMediaWebPath(x) & vbcrlf)
end if
end sub
sub playPrepList (x)
xtmpa = split(x,vbcrlf)
for xi = 0 to ubound(xtmpa) -1
if left(xtmpa(xi),1) = "o" then playFolder2 mid(xtmpa(xi),2)
if left(xtmpa(xi),1) = "i" then playlistRow mid(xtmpa(xi),2)
if (totalrowcount = andromedaPrefs("maxPlaylistTracks")) then exit for
next
end sub
sub imagetag (x,m,t)
ittmpa = split(andromedaPrefs(x & "Dimentions"),",")
imagetag2 x,ittmpa(0),ittmpa(1),t,true,m,""
end sub
sub imagetagE (x,m,t)
ittmpa = split(andromedaPrefs(x & "Dimentions"),",")
imagetag2 x,ittmpa(0),ittmpa(1),t,true,m,"\"
end sub
sub imagetag2 (x,a,b,t,c,m,e)
select case m
case "i"
%><img src=<%
case "f"
%><input type=image src=<%
end select
if andromedaPrefs("useImageFiles") then
%><% = andromedaPrefs("imageFolderPath") %><% = x %>.gif<%
else
%><% = andrLink("?i=" & x,"") %><%
end if
%> width=<% = a * andromedaPrefs("iconSize") %> height=<% = b * andromedaPrefs("iconSize") %><%
if c then
%> border=0<%
end if
if t <> "" then
%> alt=<% = e %>"<% = minHTMLencode(t) %><% = e %>"<%
end if
%>><%
end sub
sub displayImage (dix)
select case dix
case "p" ' playButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,51,153,0,102,204,0,51,102,0,255,255,255,0,0,0,255,255,255,0,0,0,0,0,0,33,249,4,1,0,0,5,0,44,0,0,0,0,16,0,16,0,0,3,76,88,170,212,190,176,180,64,107,139,132,10,1,186,39,75,22,0,194,192,121,29,40,141,228,96,162,0,40,118,165,123,210,147,87,219,122,78,187,192,147,192,215,2,14,88,195,140,206,200,34,17,119,205,141,108,121,68,13,25,203,38,233,138,37,69,165,24,194,102,156,140,132,28,23,72,2,0,59)
case "i"' infoButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,51,51,51,255,255,255,0,0,0,0,0,0,33,249,4,1,0,0,5,0,44,0,0,0,0,16,0,16,0,0,3,64,88,186,220,94,35,142,215,70,8,147,80,53,0,38,129,70,117,24,224,137,14,105,134,140,36,121,151,203,5,166,41,88,53,54,95,177,192,199,156,23,207,21,97,16,86,158,201,3,148,76,110,64,4,146,146,162,177,232,54,193,34,118,155,0,0,59)
case "h"' homeButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,102,102,153,153,153,204,204,204,255,255,255,255,204,204,204,102,102,102,0,0,0,255,255,255,33,249,4,1,0,0,7,0,44,0,0,0,0,16,0,16,0,0,3,85,120,170,214,190,240,52,65,43,48,209,212,80,74,248,1,198,80,95,65,16,30,40,106,37,49,12,168,42,145,230,208,193,233,197,214,197,219,199,58,1,239,229,195,5,123,53,34,202,118,236,184,148,157,66,176,69,196,5,0,23,73,235,196,245,100,181,156,168,24,43,2,131,62,216,239,162,145,78,55,34,107,199,27,146,0,0,59)
case "r"' prefsButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,102,102,153,153,153,204,204,204,255,255,255,255,102,102,102,0,0,0,255,255,255,0,0,0,33,249,4,1,0,0,6,0,44,0,0,0,0,16,0,16,0,0,3,80,104,170,213,190,208,52,65,107,139,165,134,205,67,89,153,64,140,99,231,49,66,64,12,108,201,125,161,202,14,43,193,1,211,86,211,228,134,103,186,217,204,22,248,165,100,164,154,47,39,19,210,150,64,36,233,9,192,73,130,78,155,245,170,74,146,170,31,134,201,7,198,20,170,232,95,4,228,184,64,18,0,59)
case "t"' ftpButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,102,102,153,153,153,204,204,204,255,255,255,255,0,0,0,255,255,255,0,0,0,0,0,0,33,249,4,1,0,0,5,0,44,0,0,0,0,16,0,16,0,0,3,78,88,170,212,190,176,52,65,107,139,164,134,205,3,89,153,176,1,36,208,125,146,56,14,131,186,125,33,7,176,110,0,76,118,73,151,54,62,179,64,90,47,99,11,6,69,55,34,128,242,171,32,113,50,225,232,38,233,52,101,40,130,85,147,67,85,59,83,42,164,81,42,93,34,12,199,121,145,0,0,59)
case "g"' goButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,102,102,153,153,153,204,204,204,255,255,255,255,0,0,0,255,255,255,0,0,0,0,0,0,33,249,4,1,0,0,5,0,44,0,0,0,0,16,0,16,0,0,3,72,88,170,212,190,176,52,65,107,139,164,134,205,3,89,153,208,141,30,35,146,221,151,1,67,187,177,110,0,76,114,59,188,182,76,215,49,60,204,25,92,207,6,20,249,132,183,226,145,151,156,73,80,29,231,19,42,147,78,71,128,236,7,210,200,122,129,17,144,227,2,73,0,0,59)
case "q"' discussButton
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,102,102,153,153,153,204,204,204,255,255,255,255,0,0,0,255,255,255,0,0,0,0,0,0,33,249,4,1,0,0,5,0,44,0,0,0,0,16,0,16,0,0,3,71,88,170,212,190,176,52,65,107,139,164,134,205,3,89,153,208,141,30,35,110,67,151,150,33,186,6,195,10,76,46,23,115,115,86,239,65,126,198,43,224,198,231,10,222,122,52,216,81,8,152,73,72,35,231,19,58,148,78,163,205,15,164,209,236,230,34,32,199,5,146,0,0,59)
case "a" ' audioFile
imageDataLookup = array(71,73,70,56,57,97,26,0,16,0,162,0,0,102,102,51,153,153,102,204,204,153,255,255,204,255,255,255,102,102,102,51,51,51,255,255,255,33,249,4,1,0,0,7,0,44,0,0,0,0,26,0,16,0,0,3,93,120,186,92,254,144,201,121,10,185,152,216,66,187,189,6,246,113,157,244,25,225,21,149,13,97,12,105,70,178,40,58,8,113,16,104,172,242,14,55,28,65,39,234,29,12,186,128,64,152,225,245,144,186,101,40,185,155,149,12,128,172,50,86,124,214,0,129,233,78,101,84,88,176,185,106,185,2,226,146,203,31,87,211,105,140,207,233,61,136,254,193,72,0,0,59)
case "v" ' videoFile
imageDataLookup = array(71,73,70,56,57,97,26,0,16,0,162,0,0,255,255,255,239,239,239,102,102,102,51,51,51,255,255,255,0,0,0,0,0,0,0,0,0,33,249,4,1,0,0,4,0,44,0,0,0,0,26,0,16,0,0,3,78,72,186,44,254,144,201,73,4,184,24,88,65,231,248,32,168,93,92,183,124,65,154,126,218,99,158,131,186,14,89,249,162,50,139,217,102,232,215,47,5,78,165,35,5,9,195,25,48,152,12,20,53,71,95,104,121,139,229,104,187,168,149,136,53,50,165,79,222,203,146,41,139,77,144,180,107,145,0,0,59)
case "l" ' playlistFile
imageDataLookup = array(71,73,70,56,57,97,26,0,16,0,162,0,0,255,255,255,204,204,204,102,102,102,51,51,51,255,255,255,0,0,0,0,0,0,0,0,0,33,249,4,1,0,0,4,0,44,0,0,0,0,26,0,16,0,0,3,74,72,186,44,254,144,201,73,4,184,24,88,65,231,248,32,168,93,92,183,12,25,134,70,166,130,166,192,75,182,110,0,89,178,70,19,185,154,149,173,222,37,7,52,13,108,144,216,111,39,84,98,138,157,38,145,137,124,56,103,52,233,50,27,10,109,119,22,216,115,167,184,153,139,9,0,59)
case "o" ' folderOpen
imageDataLookup = array(71,73,70,56,57,97,20,0,16,0,162,0,0,255,255,153,153,153,102,224,224,153,204,204,153,255,255,255,102,102,102,255,255,255,0,0,0,33,249,4,1,0,0,6,0,44,0,0,0,0,20,0,16,0,0,3,60,104,186,220,174,37,198,247,138,184,183,80,102,49,150,146,83,12,100,89,126,13,168,74,89,74,188,112,60,10,26,7,220,120,62,215,118,238,143,188,69,193,247,11,4,33,68,157,177,146,196,77,68,171,213,102,74,173,90,167,9,0,59)
case "c" ' folderClosed
imageDataLookup = array(71,73,70,56,57,97,26,0,16,0,162,0,0,255,255,153,224,224,153,255,255,255,102,102,102,255,255,255,0,0,0,0,0,0,0,0,0,33,249,4,1,0,0,4,0,44,0,0,0,0,26,0,16,0,0,3,61,72,186,220,254,111,72,9,235,26,33,231,97,33,214,218,52,117,196,7,158,1,215,13,66,235,190,173,106,13,64,109,223,181,92,209,120,175,123,61,31,137,23,180,253,34,197,219,209,65,76,46,27,162,104,148,68,173,90,175,212,4,0,59)
case "x" ' invisiblePixel
imageDataLookup = array(71,73,70,56,57,97,1,0,1,0,128,0,0,255,255,255,0,0,0,33,249,4,1,0,0,0,0,44,0,0,0,0,1,0,1,0,0,2,2,68,1,0,59)
case "sa"
imageDataLookup = array(71,73,70,56,57,97,26,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,26,0,16,0,0,3,80,72,186,220,238,33,202,73,107,28,130,4,193,187,255,160,128,105,97,56,96,223,184,149,222,0,172,109,6,179,238,11,170,55,42,2,252,204,225,41,0,166,102,187,201,110,60,162,175,3,108,241,158,75,230,17,20,128,178,68,83,106,145,150,165,94,127,221,175,73,118,42,155,207,232,114,230,193,110,19,18,0,59)
case "sn"
imageDataLookup = array(71,73,70,56,57,97,25,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,25,0,16,0,0,3,65,72,186,220,206,33,202,73,107,28,36,136,205,187,255,2,166,129,228,39,150,40,119,166,232,218,13,112,44,155,153,9,220,248,61,190,181,55,228,185,157,170,247,178,68,104,66,22,82,89,114,49,125,196,39,47,32,171,90,175,152,135,118,75,72,0,0,59)
case "ps"
imageDataLookup = array(71,73,70,56,57,97,42,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,42,0,16,0,0,3,91,72,186,220,254,240,133,73,171,189,56,211,161,130,248,96,40,10,195,48,158,39,71,120,104,10,152,109,171,178,113,56,0,111,157,118,186,141,231,61,208,44,248,185,253,96,193,33,209,120,92,242,150,63,28,77,167,76,70,167,212,167,85,74,44,106,123,70,44,248,75,5,136,199,171,238,224,140,14,148,222,240,184,124,78,135,71,238,248,60,33,1,0,59)
case "pa"
imageDataLookup = array(71,73,70,56,57,97,42,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,42,0,16,0,0,3,102,72,186,220,254,240,133,73,171,189,56,211,161,130,248,32,168,105,97,249,113,132,103,126,217,224,14,215,26,162,170,188,14,0,48,216,50,205,11,23,156,46,99,243,241,54,175,220,11,86,41,118,126,155,156,84,202,164,56,83,208,137,112,170,180,92,107,191,165,242,245,3,25,87,173,174,151,119,54,165,135,235,175,173,245,138,177,159,229,124,153,182,236,251,255,128,129,17,131,132,133,4,9,0,59)
case "pr"
imageDataLookup = array(71,73,70,56,57,97,42,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,42,0,16,0,0,3,91,72,186,220,254,240,133,73,171,189,56,211,161,130,248,32,168,105,97,249,113,132,103,126,99,182,134,168,250,206,244,28,215,45,102,119,248,52,252,192,160,101,151,234,5,6,128,164,50,57,24,190,110,180,205,114,217,172,16,101,181,160,118,80,3,65,87,185,75,150,247,10,59,175,51,179,149,246,237,186,217,157,173,124,78,167,71,238,248,60,33,1,0,59)
case "pv"
imageDataLookup = array(71,73,70,56,57,97,42,0,16,0,162,0,0,255,255,255,204,204,204,153,153,153,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,42,0,16,0,0,3,108,72,186,220,254,240,133,73,171,189,56,211,161,130,248,32,168,105,97,249,113,132,103,126,217,224,98,107,136,170,113,233,2,184,91,175,243,46,84,3,156,112,0,139,245,118,27,161,146,104,169,29,107,73,101,238,226,236,248,162,82,102,165,154,242,201,178,94,153,53,118,185,225,8,47,138,239,105,106,189,208,218,245,120,53,162,192,39,242,46,185,62,185,231,3,46,129,130,131,132,133,134,130,17,137,138,139,4,9,0,59)
case "k"
imageDataLookup = array(71,73,70,56,57,97,16,0,16,0,162,0,0,0,0,0,255,255,255,102,102,153,153,153,204,204,204,255,255,255,255,0,0,0,0,0,0,33,249,4,1,0,0,5,0,44,0,0,0,0,16,0,16,0,0,3,70,88,170,208,190,176,52,66,107,139,160,142,205,7,88,25,209,141,30,35,110,65,26,116,95,136,170,41,39,76,92,60,216,195,156,145,170,76,119,61,223,14,184,234,232,78,36,217,76,50,194,229,62,76,162,18,26,29,9,174,84,6,224,202,213,69,64,142,11,36,1,0,59)
end select
for ix = 0 to ubound(imageDataLookup)
binstr = binstr & chrb(imageDataLookup(ix))
next
response.contenttype = "image/gif"
response.binarywrite(binstr)
end sub
function trans(y)
if rosetta(currentLanguage)(y) <> "" then
trans = rosetta(currentLanguage)(y)
else
trans = rosetta("EN")(y)
end if
end function
function sec2time (x)
minutes = fix(x / 60)
seconds = round(x - (minutes * 60))
if seconds < 10 then seconds = "0" & seconds
sec2time = minutes & ":" & seconds
end function
function andromedaEncode (x)
tmp = server.urlencode(x)
tmp = replace(tmp,"+","%20")
tmp = replace(tmp,"%2F","/")
tmp = replace(tmp,"%2E",".")
tmp = replace(tmp,"%2D","-")
tmp = replace(tmp,"%5F","_")
andromedaEncode = tmp
end function
function legalFolder (x)
lftmp = true
if andromedaPrefs("skipPrefix") <> "" then
if left(x,len(andromedaPrefs("skipPrefix"))) = andromedaPrefs("skipPrefix") then
lftmp = false
end if
end if
if lftmp then
if folderSkipNames.exists(x) then
lftmp = false
end if
end if
legalFolder = lftmp
end function
function legalFile (x)
lftmp = true
if andromedaPrefs("skipPrefix") <> "" then
if left(x,len(andromedaPrefs("skipPrefix"))) = andromedaPrefs("skipPrefix") then
lftmp = false
end if
end if
if lftmp then
if fileTypes.exists(lcase(local_fs.getextensionname(x))) then
isaftmp = fileTypes(lcase(local_fs.getextensionname(x)))
lftmp = ((isaftmp = "audio") or (isaftmp = "video") or (isaftmp = "playlist"))
else
lftmp = false
end if
end if
legalFile = lftmp
end function
function subfolderCount (x)
sdctotal = 0
for each f1 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).subfolders
if legalFolder(f1.name) then sdctotal = sdctotal + 1
next
subfolderCount = sdctotal
end function
function fileCount (x)
tfileCount = 0
for each f1 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).files
if legalFile(f1.name) then tfileCount = tfileCount + 1
next
fileCount = tfileCount
end function
function getSubfolders2d(x)
lc = -1
lastVal = ""
sorted = true
redim subfolderList(subfolderCount(x) - 1,0)
for each f1 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).subfolders
if legalFolder(f1.name) then
lc = lc + 1
subfolderList(lc,0) = f1.name
sorted = sorted and strGreaterThan(f1.name,lastVal)
lastVal = f1.name
end if
next
if ((lc > 0) and not(sorted)) then quickSort2d subfolderList,0,lc,0
getSubfolders2d = subfolderList
end function
function getFiles2d(x)
lc = -1
lastVal = ""
sorted = true
redim fileList(fileCount(x) - 1,1)
for each f1 in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).files
if legalFile(f1.name) then
lc = lc + 1
fileList(lc,0) = f1.name
fileList(lc,1) = f1.size
sorted = sorted and strGreaterThan(f1.name,lastVal)
lastVal = f1.name
end if
next
if ((lc > 0) and not(sorted)) then quickSort2d fileList,0,lc,0
getFiles2d = fileList
end function
sub drill2 (x,z)
if z = 1 then
lcolor = andromedaPrefs("rowLinkColor")
tcolor = andromedaPrefs("rowTextColor")
elseif andromedaPrefs("disableHTMLheaders") then
lcolor = andromedaPrefs("bodyLinkColor")
tcolor = andromedaPrefs("bodyTextColor")
end if
%><font size="<% = z %>"<% if tcolor <> "" then %> color=<% = tcolor %><% end if %>><%
if lcolor <> "" then
%><nobr><a href=<% = andrLink("","") %> style="color:<% = lcolor %>"><font color=<% = lcolor %>><% = andromedaPrefs("rootName") %></font></a> /</nobr> <%
else
%><nobr><a href=<% = andrLink("","") %>><% = andromedaPrefs("rootName") %></a> /</nobr> <%
end if
tmpaa = split(x,"/")
tlp = ""
for i = 1 to ubound(tmpaa)
tlp = tlp & "/" & tmpaa(i)
if lcolor <> "" then
%><nobr><a href=<% = folderLink(tlp) %> style="color:<% = lcolor %>"><font color=<% = lcolor %>><% = displayName(tmpaa(i)) %></font></a> /</nobr> <%
else
%><nobr><a href=<% = folderLink(tlp) %>><% = displayName(tmpaa(i)) %></a> /</nobr> <%
end if
next
%></font><%
end sub
sub playFolderButton (plx)
%><a href=<% = andrLink("?q=p&p=",plx) %>><% imagetag "p","i",trans(11) %></a><%
end sub
function andrLink (x,y)
andrLink = andromedaConst("scriptFileName") & x & server.urlencode(y)
end function
function mkMediaWebPath (x)
mkMediaWebPath = andromedaEncode(andromedaPrefs("mediaWebPath") & x)
end function
function folderLink (x)
folderLink = andrLink("?q=f&f=",x)
end function
function isAlbum (x)
isAlbum = (subfolderCount(x) = 0) and (fileCount(x) > 0)
end function
function byteCount (x)
if x >= 1024 * 1000 then
byteCount = round(x/(1024*1024),2) & "&nbsp;Mb"
elseif x >= 1000 then
byteCount = round(x/1024) & "&nbsp;Kb"
else
byteCount = x & "&nbsp;byte"
end if
end function
sub addvpad (height)
response.write("<table cellspacing=0 cellpadding=0 border=0 height=" & height & "><tr><td></td></tr></table>")
end sub
sub ipad (width,height)
imagetag2 "x",width,height,"",false,"i",""
end sub
sub colorbar (cbw, cbh, cbc)
%><table cellspacing=0 cellpadding=0 border=0 width=<% = cbw %> height=<% = cbh %> bgcolor=<% = cbc %>><tr><td><% ipad 1,1 %></td></tr></table><%
end sub
sub colorBars (cbs)
cbtmp1a = split(cbs,";")
%><table cellspacing=0 cellpadding=0 border=0 width="<% = andromedaPrefs("siteWidth") %>"><%
for i = 0 to ubound(cbtmp1a)
cbtmp2a = split(cbtmp1a(i),",")
%><tr bgcolor="<% = cbtmp2a(0) %>"><td><% ipad 1,cbtmp2a(1) %></td></tr><%
next
%></table><%
end sub
function switchRow(swx,swcolor1,swcolor2)
if swx mod 2 = 0 then
switchRow = swcolor1
else
switchRow = swcolor2
end if
end function
function ifps2(x,y,z)
if x = 1 then
ifps2 = y
else
ifps2 = z
end if
end function
function displayName (x)
if legalFile(x) then
cfntmp2 = local_fs.getbasename(x)
else
cfntmp2 = local_fs.getfilename(x)
end if
tknumtrimcodea = split(andromedaPrefs("tkNumTrimCodes"),",")
for i = 0 to ubound(tknumtrimcodea)
trimme = true
for j = 1 to len(tknumtrimcodea(i))
if mid(tknumtrimcodea(i),j,1) = "#" then
trimme = (trimme and isnumeric(mid(cfntmp2,j,1)))
else
trimme = (trimme and (mid(tknumtrimcodea(i),j,1) = mid(cfntmp2,j,1)))
end if
if trimme = false then exit for
next
if trimme then
cfntmp2 = mid(cfntmp2,len(tknumtrimcodea(i))+1)
exit for
end if
next
cfntmp2 = replace(cfntmp2,"_"," ")
cfntmp2 = trim(cfntmp2)
if right(lcase(cfntmp2),5) = ", the" then
cfntmp2 = right(cfntmp2,3) & " " & left(cfntmp2,len(cfntmp2) - 5)
end if
cftmpa = split(cfntmp2," ")
if ubound(cftmpa) = 1 then
if right(cftmpa(0),1) = "," then
cfntmp2 = cftmpa(1) & " " & left(cftmpa(0),len(cftmpa(0)) - 1)
end if
end if
displayName = cfntmp2
end function
function limitName (x)
if len(x) < andromedaPrefs("popupMaxWidth") then
limitname = x
else
limitname = (trim(left(x, andromedaPrefs("popupMaxWidth") - 2)) & "...")
end if
end function
function ca2s (x)
for i = 0 to ubound(x)
tmp = tmp & chr(x(i))
next
ca2s = tmp
end function
function newestfile (x)
for each i in local_fs.GetFolder(andromedaPrefs("mediaPhysicalPath") & x).files
if legalFile(i.name) then
if i.datecreated > maxdate then maxdate = i.datecreated
end if
next
xx2d = getSubfolders2d(x)
for fi = 0 to ubound(xx2d,1)
maxsubfiledate = newestfile(x & "/" & xx2d(fi,0))
if maxsubfiledate > maxdate then maxdate = maxsubfiledate
next
newestfile = maxdate
end function
sub displaynew (x)
if isdate(x) then
daydiff = DateDiff("d", x, date())
if daydiff = 0 then
%><font size="1" color="<% = andromedaPrefs("newFileColor") %>"><b><i> <% = replace(trans(28)," ","&nbsp;") %></i></b></font><%
elseif daydiff = 1 then
%><font size="1" color="<% = andromedaPrefs("newFileColor") %>"><b><i> <% = replace(trans(29)," ","&nbsp;") %></i></b></font><%
elseif daydiff > 1 and daydiff < 7 then
%><font size="1" color="<% = andromedaPrefs("newFileColor") %>"><b><i> <% = replace(trans(29 + weekday(x,1))," ","&nbsp;") %></i></b></font><%
end if
end if
end sub
function minHTMLencode(x)
mhetmp = replace(x,"<","&lt;")
mhetmp = replace(mhetmp,">","&gt;")
mhetmp = replace(mhetmp,"""","&quot;")
minHTMLencode = mhetmp
end function
function bin2txt(Binary)
for i = 1 to LenB(Binary)
plo = ascb(midb(Binary,i,1))
if plo <> 0 then strChar = strChar & chr(plo)
next
bin2txt = strChar
end function
function fixbin (x)
if lenb(x) = 1 then
fixbin = ascb(x)
elseif lenb(x) = 2 then
fbyte1 = ascb(midb(x,1,1))
fbyte2 = ascb(midb(x,2,1))
if (((fbyte1 < 128) or (fbyte1 = 129) or (fbyte1 = 141) or (fbyte1 = 143) or (fbyte1 = 144) or (fbyte1 = 157) or (fbyte1 > 159)) and (fbyte2 = 0)) then
fixbin = fbyte1
else
select case fbyte1 & "-" & fbyte2
case "172-32"
fixbin = 128
case "26-32"
fixbin = 130
case "25-1"
fixbin = 131
case "30-32"
fixbin = 132
case "38-32"
fixbin = 133
case "32-32"
fixbin = 134
case "33-32"
fixbin = 135
case "198-2"
fixbin = 136
case "48-32"
fixbin = 137
case "96-1"
fixbin = 138
case "57-32"
fixbin = 139
case "82-1"
fixbin = 140
case "125-1"
fixbin = 142
case "24-32"
fixbin = 145
case "25-32"
fixbin = 146
case "28-32"
fixbin = 147
case "29-32"
fixbin = 148
case "34-32"
fixbin = 149
case "19-32"
fixbin = 150
case "20-32"
fixbin = 151
case "220-2"
fixbin = 152
case "34-33"
fixbin = 153
case "97-1"
fixbin = 154
case "58-32"
fixbin = 155
case "83-1"
fixbin = 156
case "126-1"
fixbin = 158
case "120-1"
fixbin = 159
case else
fixbin = fbyte1
end select
end if
end if
end function
function strGreaterThan(slt1,slt2)
strGreaterThan = (strcomp(slt1,slt2,1) = 1)
end function
sub quickSort2d(sortTable,startRow,endRow,sortColumn)
sortTableWidth = ubound(sortTable,2)
if endRow = (startRow + 1) then
if strGreaterThan(sortTable(startRow,sortColumn),sortTable(endRow,sortColumn)) then
for swi = 0 to sortTableWidth
tempvar = sortTable(startRow,swi)
sortTable(startRow,swi) = sortTable(endRow,swi)
sortTable(endRow,swi) = tempvar
next
end if
else
redim pivot(sortTableWidth)
for swi = 0 to sortTableWidth
pivot(swi) = sortTable(int((startRow + endRow) / 2),swi)
sortTable(int((startRow + endRow) / 2),swi) = sortTable(startRow,swi)
sortTable(startRow,swi) = pivot(swi)
next
loSwap = startRow + 1
hiSwap = endRow
do while loSwap < hiSwap
do while loSwap < hiSwap and strGreaterThan(pivot(sortColumn),sortTable(loSwap,sortColumn))
loSwap = loSwap + 1
loop
do while strGreaterThan(sortTable(hiSwap,sortColumn),pivot(sortColumn))
hiSwap = hiSwap - 1
loop
if loSwap < hiSwap then
for swi = 0 to sortTableWidth
tempvar = sortTable(loSwap,swi)
sortTable(loSwap,swi) = sortTable(hiSwap,swi)
sortTable(hiSwap,swi) = tempvar
next
end if
loop
for swi = 0 to sortTableWidth
sortTable(startRow,swi) = sortTable(hiSwap,swi)
sortTable(hiSwap,swi) = pivot(swi)
next
if startRow < (hiSwap - 1) then quickSort2d sortTable,startRow,hiSwap-1,sortColumn
if hiSwap + 1 < endRow then quickSort2d sortTable,hiSwap+1,endRow,sortColumn
end if
end Sub
sub editNote (x)
if local_fs.fileexists(andromedaPrefs("mediaPhysicalPath") & x) then
mode = "update"
else
mode = "create"
end if
andromedaHeader "edit note"
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><form method=post action=<% = andrLink("","") %>><input type=hidden name=q value=v><input type=hidden name=v value="<% = minHTMLencode(x) %>"><tr><td><ul><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 24
%><b>enter your annotation here</b><br><textarea name=n cols=34 rows=8 style="<% = andromedaPrefs("formStyle") %>"><% if local_fs.fileExists(andromedaPrefs("mediaPhysicalPath") & x) then %><% = local_fs.OpenTextFile(andromedaPrefs("mediaPhysicalPath") & x).ReadAll %><% end if %></textarea><%
if mode = "update" then
addvpad 12
%>to delete the note (and the file), clear the box and click save<%
end if
%></font></ul></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><br><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>note:</b> clicking the save button will <% = mode & " " & local_fs.getfilename(x) & " in " & replace(local_fs.getparentfoldername(andromedaPrefs("mediaPhysicalPath") & x),"/","\") %></font><%
%><br><br><input type=submit value=save><%
%></ul></td></tr></form></table><%
colorbars andromedaPrefs("bodyFgDiv")
andromedaFooter
end sub
sub saveNote (x,n)
if replace(replace(n," ",""),vbcrlf,"") = "" then
if local_fs.fileexists(andromedaPrefs("mediaPhysicalPath") & x) then
local_fs.DeleteFile(andromedaPrefs("mediaPhysicalPath") & x) '[, force]
end if
else
Set f = local_fs.OpenTextFile(andromedaPrefs("mediaPhysicalPath") & x, 2, True)
f.Write n
f.Close
end if
select case local_fs.getbasename(x)
case andromedaPrefs("folderListInfo")
response.redirect(folderLink(local_fs.getparentfoldername(local_fs.getparentfoldername(x))))
case andromedaPrefs("folderOpenInfo")
response.redirect(folderLink(local_fs.getparentfoldername(x)))
case else
response.redirect(folderLink(local_fs.getparentfoldername(x)))
end select
end sub
sub editPrefs
if local_fs.fileexists(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefsFileName) then
mode = "update"
else
mode = "create"
end if
andromedaHeader "edit preferences"
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><form method=post action=<% = andrLink("","") %>><input type=hidden name=q value=b><tr><td><%
addvpad 24
%><b>Note:</b> I suggest that you edit your prefs file manually with a text editor rather than use this page. Andromeda is highly configurable, but not all preferences are listed here. Please see the manual at my site for details.<%
addvpad 24
%><font size="3" face="helvetica,arial"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>please contribute</b></font><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 6
%><b>please remember to pay for andromeda if you're still using it after two weeks.</b> you can give whatever you think reasonable, and even a small contribution will help. <% if andromedaPrefs("disableHTMLheaders") then %><a href="http://www.turnstyle.com/andromeda/contributions.asp" target=_top style="color:<% = andromedaPrefs("bodyLinkColor") %>"><font color="<% = andromedaPrefs("bodyLinkColor") %>"><b>get more info</b></font></a><% else %><a href="http://www.turnstyle.com/andromeda/contributions.asp" target=_top><b>get more info</b></a><% end if %>.<%
addvpad 12
%></font></ul><%
%><font size="3" face="helvetica,arial"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>general preferences</b></font><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 6
%><b>siteName</b><br><input name=siteName size=40 value="<% = minHTMLencode(andromedaPrefs("siteName")) %>" style="<% = andromedaPrefs("formStyle") %>"><br>change the name of your site<%
addvpad 8
%><b>email</b><br><input name=email size=40 value="<% = minHTMLencode(andromedaPrefs("email")) %>" style="<% = andromedaPrefs("formStyle") %>"><br>if you want your email address displayed, enter it here.<%
addvpad 8
%><input name=requireLogon type=checkbox <% if andromedaPrefs("requireLogon") then %> checked<% end if %>> <b>requireLogon</b><br>implements rudimentary security. you'll have to create & edit the andromedaLogons file<%
addvpad 8
%><input name=editMode type=checkbox <% if andromedaPrefs("editMode") then %> checked<% end if %>> <b>editMode</b><br>makes it easy for you to annotate your collection<%
addvpad 8
%><input name=localFilePlayback type=checkbox <% if andromedaPrefs("localFilePlayback") then %> checked<% end if %>> <b>localFilePlayback</b><br>this is a good feature which is off by default because of a bug with some versions of Internet Explorer. if you play mp3s on the same computer running andromeda, turn this on to prevent them from being copied to your web cache. if playback fails, turn it back off.<%
addvpad 8
%><input name=displayNew type=checkbox <% if andromedaPrefs("displayNew") then %> checked<% end if %>> <b>displayNew</b><br>automatically highlights recent additions; turn off to improve performance, especially with big collections<%
addvpad 8
%><input name=permitSearch type=checkbox <% if andromedaPrefs("permitSearch") then %> checked<% end if %>> <b>permitSearch</b><br>uncheck to disable the search feature<%
addvpad 8
%><input name=displayAMG type=checkbox <% if andromedaPrefs("displayAMG") then %> checked<% end if %>> <b>displayAMG</b><br>displays the allmusic.com search box. don't be so quick to turn it off - it's not an advertisement, but a handy feature.<%
addvpad 12
%></font></ul><%
%><font size="3" face="helvetica,arial"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>image handling</b></font><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 6
%><input name=useImageFiles type = checkbox<% if andromedaPrefs("useImageFiles") then %> checked<% end if %>> <b>useImageFiles</b><br>turn on to improve performance by using gif files instead of internal binary data. you can <% if andromedaPrefs("disableHTMLheaders") then %><a href="http://www.turnstyle.com/andromeda/download.asp" target=_top style="color:<% = andromedaPrefs("bodyLinkColor") %>"><font color="<% = andromedaPrefs("bodyLinkColor") %>"><b>download the icon files</b></font></a><% else %><a href="http://www.turnstyle.com/andromeda/download.asp" target=_top><b>download the icon files</b></a><% end if %> from my site.<%
addvpad 8
%><b>imageFolderPath</b><br><input name=imageFolderPath size=40 value="<% = minHTMLencode(andromedaPrefs("imageFolderPath")) %>" style="<% = andromedaPrefs("formStyle") %>"><br>if you set useImageFiles (above), the default location for the gif files is in the same folder as the Andromeda asp (<% = andrLink("","") %>). use this to specify another location (ie /images/). must end with a forward slash (/).<%
addvpad 12
%></font></ul><%
%><font size="3" face="helvetica,arial"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>network settings</b></font><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 6
%><b>ftpPath</b><br><input name=ftpPath size=40 value="<% = minHTMLencode(andromedaPrefs("ftpPath")) %>" style="<% = andromedaPrefs("formStyle") %>"><br>if you include a ftpPath, users will see a link the ftp site entered here.<%
addvpad 8
%><b>hostAddress</b><br><input name=hostAddress size=40 value="<% = minHTMLencode(andromedaPrefs("hostAddress")) %>" style="<% = andromedaPrefs("formStyle") %>"><br>if your comupter's ip address cannot be seen (ie mapped through nat), or if you need to include a port you can enter an alternate ip address or host name here; no leading 'http://' or trailing '/'<%
addvpad 8
%><b>mediaWebPath</b><br><input name=mediaWebPath size=40 value="<% = minHTMLencode(andromedaPrefs("mediaWebPath")) %>" style="<% = andromedaPrefs("formStyle") %>"><br><b>mediaPhysicalPath</b><br><input name=mediaPhysicalPath size=40 value="<% = minHTMLencode(andromedaPrefs("mediaPhysicalPath")) %>" style="<% = andromedaPrefs("formStyle") %>"><br>by default andromeda looks in its folder for your mp3s. if you want andromeda to look elsewhere, edit <b>mediaWebPath</b> and <b>mediaPhysicalPath</b> to point to the preferred folder. this is an advanced feature; clear them both to revert to the default behavior.<%
addvpad 12
%></font></ul><%
%><font size="3" face="helvetica,arial"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>integration</b></font><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><%
addvpad 6
%><b>customHeader</b><br><textarea name=customHeader cols=34 rows=8 style="<% = andromedaPrefs("formStyle") %>"><% = minHTMLencode(andromedaPrefs("customHeader")) %></textarea><br>this puts whatever you want up in the menubar; use html to make it look nice; carriage returns will be removed.<%
addvpad 8
%><b>customBlock</b><br><textarea name=customBlock cols=34 rows=8 style="<% = andromedaPrefs("formStyle") %>"><% = minHTMLencode(andromedaPrefs("customBlock")) %></textarea><br>this puts whatever you want at the bottom of every folder/file list; use html to make it look nice; carriage returns will be removed.<%
addvpad 12
%></ul></font><%
%></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>"><tr><td><ul><br><font size="2"<% if andromedaPrefs("disableHTMLheaders") then %> color=<% = andromedaPrefs("bodyTextColor") %><% end if %>><b>note:</b> clicking the save button will <% = mode & " " & andromedaPrefsFileName & " in " & andromedaConst("scriptPhysicalPath") %></font><%
%><br><br><input type=submit value=save><%
%></ul></td></tr></form></table><%
colorbars andromedaPrefs("bodyFgDiv")
andromedaFooter
end sub
sub savePrefs
Set f = local_fs.OpenTextFile(andromedaConst("scriptPhysicalPath") & "/" & andromedaPrefsFileName, 2, True)
f.WriteLine("<" & "%")
if trim(request("siteName")) <> "" then f.WriteLine("'siteName" & vbtab & trim(request("siteName")))
if trim(request("email")) <> "" then f.WriteLine("'email" & vbtab & trim(request("email")))
if request("requireLogon") = "on" then f.WriteLine("'requireLogon" & vbtab & "true")
if request("editMode") = "on" then f.WriteLine("'editMode" & vbtab & "true")
if request("localFilePlayback") = "on" then f.WriteLine("'localFilePlayback" & vbtab & "true")
if request("displayNew") = "on" then f.WriteLine("'displayNew" & vbtab & "true")
if request("permitSearch") <> "on" then f.WriteLine("'permitSearch" & vbtab & "false")
if request("displayAMG") <> "on" then f.WriteLine("'displayAMG" & vbtab & "false")
if request("useImageFiles") = "on" then f.WriteLine("'useImageFiles" & vbtab & "true")
if trim(request("imageFolderPath")) <> "" then f.WriteLine("'imageFolderPath" & vbtab & trim(request("imageFolderPath")))
if trim(request("ftpPath")) <> "" then f.WriteLine("'ftpPath" & vbtab & trim(request("ftpPath")))
if trim(request("hostAddress")) <> "" then f.WriteLine("'hostAddress" & vbtab & trim(request("hostAddress")))
if trim(replace(request("customHeader"),vbcrlf," ")) <> "" then f.WriteLine("'customHeader" & vbtab & trim(replace(request("customHeader"),vbcrlf," ")))
if trim(replace(request("customBlock"),vbcrlf," ")) <> "" then f.WriteLine("'customBlock" & vbtab & trim(replace(request("customBlock"),vbcrlf," ")))
if ((trim(request("mediaWebPath")) <> "") and (trim(request("mediaWebPath")) <> local_fs.getparentfoldername(request.servervariables("path_info")))) then f.WriteLine("'mediaWebPath" & vbtab & trim(request("mediaWebPath")))
if ((trim(request("mediaPhysicalPath")) <> "") and (trim(request("mediaPhysicalPath")) <> local_fs.getparentfoldername(request.servervariables("path_translated")))) then f.WriteLine("'mediaPhysicalPath" & vbtab & trim(request("mediaPhysicalPath")))
f.WriteLine("%" & ">")
f.Close
response.redirect(andrLink("",""))
end sub
if request("i") <> "" then
displayImage request("i")
else
response.buffer = true
Set andromedaConst = CreateObject("Scripting.Dictionary")
Set andromedaPrefs = CreateObject("Scripting.Dictionary")
Set fileTypes = CreateObject("Scripting.Dictionary")
Set folderSkipNames = CreateObject("Scripting.Dictionary")
Set andromedaLogons = CreateObject("Scripting.Dictionary")
Set rosetta = CreateObject("Scripting.Dictionary")
'
' PLEASE DO NOT MODIFY THE TRANSLATION DICTIONARIES. IF YOU THINK
' SOMETHING COULD BE PHRASED BETTER, PLEASE LET ME KNOW SO I CAN
' FIX IT FOR EVERYBODY.
'
' THANKS
'
rosetta.add "AR", array("Arabic" & vbtab & "windows-1256" & vbtab & "Arabic","","","","",""," ","","    ","    "," "," ","  %## ",""," "," "," "," ",""," #a","   ","","","",""," ","  ","    #a  ##"," "," "," "," "," "," "," "," "," "," ","     ","   ","  ","  "," "," ","  ","   ")
rosetta.add "BG", array("Bulgarian" & vbtab & "Windows-1251" & vbtab & "Bulgarian","","","","",""," "," ","  ","  "," "," ","    ##%"," "," ","",""," ",""," #a","ftp ","","","","","","  ","  #a  ##"," "," ","  ","  ","  ","  ","  ","  ","  ","  ","     -   ","   ","  ","    "," "," ",""," ")
rosetta.add "CA", array("Catalan" & vbtab & "iso-8859-1" & vbtab & "Catal&agrave;","Catal","arxiu","arxius","carpeta","carpetes","seleccionar tot","res","afegir a la llista","treure de la llista","reproduir selecci","reproduir tot","la llista est ##% plena","buscar a","identifica't si-us-plau","nom","clau","pgina inicial","preferencies","sobre #a","lloc ftp","artistes","lbums","canons","gneres","segells","preguntes o comentaris","funciona amb #a versi ##","nou avui","nou d ahir","nou del diumenge","nou del dilluns","nou del dimarts","nou del dimecres","nou del dijous","nou del divendres","nou del dissabte","resultats de la bsqueda","cal introduir com a mnim 2 lletres","no s'han trobat coincidncies","Arxiu no trobat","Hauries de ser redirigit cap aquest lloc","apreta aqui","Per continuar","llista","veure llista")
rosetta.add "CS", array("Czech" & vbtab & "iso-8859-2" & vbtab & "Cesky","esky","soubor","soubory","sloka","sloky","vybrat ve","nic","pidat do playlistu","odstranit z playlistu","pehrt vybran","pehrt ve","playlist je z ##% pln","hledat v","prihlate se prosm","jmno","heslo","tituln strana","nastaven","o #a","ftp server","umlci","alba","psn","nry","labely","otzky nebo komente","pouv #a verze ##","novinka dnes","novinka vera","novinka Nedle","novinka Pondl","novinka ter","novinka Stedy","novinka tvrtka","novinka Pteku","novinka Soboty","vsledky vyhledvn","zadejte alespo 2 znaky","nic nenalezeno","Soubor nenalezen","Budete pesmrovn na","klikni zde","Pokraovat","playlist","prohldnout playlist")
rosetta.add "ZH-cn", array("Chinese Simplified" & vbtab & "GB2312" & vbtab & "Chinese Simplified","","","","ϼ","ϼ","ȫѡ","","嵥","Ӳ嵥Ƴ","嵥","ȫ","嵥ʹ##%","Ѱ","","","","ҳ","趨"," #a","ftp վ̨","ݳ/","ר","","","Ƭ˾",""," #a  - 汾 ##"," - "," - "," - "," - һ"," - ڶ"," - ","- "," - "," - ","Ѱ","ѰԪ","ҲҪĿ","Ҳ","㽫ᱻվ̨","밴","","嵥","Ӳ嵥")
rosetta.add "ZH-tw", array("Chinese Traditional" & vbtab & "BIG5" & vbtab & "Chinese Traditional","c餤","ɮ","ɮ","ӸƧ","ӸƧ","","M","sWܼM","qM椤","M","","MwϥΤF##%","jM","еnJ","nJW","KX","","]w"," #a","ftp x","tX/t","M","q","O","ۤq","DηN"," #a }o -  ##","sW - ","sW - Q","sW - P","sW - P@","sW - PG","sW - PT","sW- P|","sW - P","sW - P","jMG","jM󥲶Ѧܤ֨ӦrҲզ","䤣ŦXnD","䤣ɮ","AN|QaiJx","Ыo","~","M","˵M")
rosetta.add "DA", array("Danish" & vbtab & "iso-8859-1" & vbtab & "Dansk","Dansk","fil","filer","mappe","mapper","vlg alle","ingen","tilfj til liste","fjern fra liste","afspil valgte","afspil alle","listen er ##% fuld","sg","vr venlig at logge ind","brugernavn","kodeord","hjemmeside","indstillinger","om #a","ftp site","kunstnere","albums","sange","genrer","titler","sprgsml eller kommentarer","genereret af #a version ##","nye i dag","nye i gr","nye sndag","nye mandag","nye tirsdag","nye onsdag","nyt torsdag","nye fredag","nye lrdag","sgeresultater","sgeordet skal minimum indeholde 2 karakterer","din sgning gav intet resultat","siden blev ikke fundet","du burde blive viderestillet til sitet","tryk her","for at fortstte","listen","vis listen")
rosetta.add "DE", array("German" & vbtab & "iso-8859-1" & vbtab & "Deutsch","Deutsch","Datei","Dateien","Ordner","Ordner","alles auswhlen","aufheben","zur Playlist hinzufgen","aus der Playlist entfernen","Auswahl abspielen","alles Abspielen","die Playlist ist zu ##% voll","durchsuche","Bitte anmelden","Benutzername","Passwort","Homepage","Einstellungen","ber #a","FTP Server","Knstler","Alben","Titel","Genres","Labels","Fragen oder Kommentare","powered by #a version ##","Neu, seit Heute","Neu, seit Gestern","Neu, seit Sonntag","Neu, seit Montag","Neu, seit Dienstag","Neu, seit Mittwoch","Neu, seit Donnerstag","Neu, seit Freitag","Neu, seit Samstag","Suchergebnisse","Der Suchbegriff mu mindestens 2 Zeichen enthalten","Keine Ergebnisse gefunden","Datei nicht gefunden","Sie sollten jetzt auf die Seite weitergeleitet werden","hier klicken","Um fortzufahren","Playlist","Playlist anzeigen")
rosetta.add "EL", array("Greek" & vbtab & "iso-8859-7" & vbtab & "Ellinika","","","","",""," ","","  ","   ","  "," ","   ##% ","",""," ",""," ","","   #a","ftp site","","","","","","  ","  #a  ##"," "," "," "," "," "," "," "," "," "," ","        2 ","  ","   ","   site"," click ","  "," ","   ")
rosetta.add "EN", array("English" & vbtab & "iso-8859-1" & vbtab & "English","English","file","files","folder","folders","select all","none","add to playlist","remove from playlist","play selection","play all","the playlist is ##% full","search","please logon","logon","password","home page","preferences","about #a","ftp site","artists","albums","songs","genres","labels","questions or comments","powered by #a version ##","new today","new yesterday","new Sunday","new Monday","new Tuesday","new Wednesday","new Thursday","new Friday","new Saturday","search results","the search term must be at least 2 characters","no matches found","File not found","You should be redirected into the site","click here","To continue","playlist","view playlist")
rosetta.add "ES", array("Spanish" & vbtab & "iso-8859-1" & vbtab & "Espa&ntilde;ol","Espaol","archivo","archivos","carpeta","carpetas","seleccionar todo","ninguno","aadir a la lista"," quitar de la lista","reproducir seleccin","reproducir todas","la lista esta ##% llena","buscar en","autentifcate por favor","nombre","contrasea","web inicial","preferencias","acerca de #a","sitio de ftp","artistas","discos","canciones","gneros","disqueras","preguntas o comentarios","soportado por #a versin ##","nueva hoy","nueva ayer","nueva domingo","nueva lunes","nueva martes","nueva mircoles","nueva jueves","nueva viernes","nueva sbado","resultados de la bsqueda","la bsqueda debe tener al menos 2 letras","no se encontraron coincidencias","Archivo no encontrado","Deberas ser redirigido al sitio","pulsa aqu","Para continuar","lista","ver lista")
rosetta.add "FR", array("French" & vbtab & "iso-8859-1" & vbtab & "Fran&ccedil;ais","Franais","fichier","fichiers","dossier","dossiers","slectionner tout","aucun","ajouter  la liste","enlever de la liste","jouer la slection","jouer tout","la liste est pleine  ##%","rechercher","enregistrez-vous, svp","usager","mot de passe","acceuil","prfrences"," propos d'#a","site ftp","artistes","albums","chansons","genres","maisons d'ditions","questions ou commentaires","gnr par #a version ##","ajout aujourd'hui","ajout hier","ajout dimanche","ajout lundi","ajout mardi","ajout mercredi","ajout jeudi","ajout vendredi","ajout samedi","rsultats","le mot-cl recherch doit avoir au moins 2 caractres","aucuns rsultats pour cette recherche","Le fichier n'a pas t trouv","Vous devriez tre redirig vers le site","cliquez ici","Pour continuer","liste","voir la liste")
rosetta.add "IS", array("Icelandic" & vbtab & "iso-8859-1" & vbtab & "&Iacute;slenska","slenska","skr","skrr","mappa","mppur","velja allt","ekkert","bta vi lagalista","fjarlgja af lagalista","spila val","spila allt","lagalistinn er ##% fullur","leita ","skru ig inn","notendanafn","lykilor","heimasa","stillingar","um #a","ftp svi","listamenn","pltur","lg","tegund","tgfur","spurningar ea bendingar","kni af #a tgfa ##","ntt  dag","ntt  gr","ntt  sunnudag","ntt  mnudag","ntt  rijudag","ntt  mivikudag","ntt  fimmtudag","ntt  fstudag","ntt  laugardag","niurstur leitar","leitin verur a innihalda a minnsta kosti 2 stafi","ekkert fannst","Skrin finnst ekki"," ttir a vera fluttur  suna","smelltu hr","Til a halda fram","agalisti","skoa lagalista")
rosetta.add "IT", array("Italian" & vbtab & "iso-8859-1" & vbtab & "Italiano","Italiano","file","files","cartella","cartelle","seleziona tutto","cancella","aggiungi alla playlist","rimuovi dalla playlist","play selezione","play tutto","la playlist e' piena al ##%","cerca","inserisci utente e password","utente","password","home page","preferenze","informazioni su #a","sito FTP ","artisti","albums","canzoni","generi","etichette","domande o commenti","creato con #a versione ##","aggiunto oggi","aggiunto ieri","aggiunto domenica","aggiunto lunedi","aggiunto martedi","aggiunto mercoledi","aggiunto giovedi","aggiunto venerdi","aggiunto sabato","risultati della ricerca","la parola da cercare deve esse di 2 lettere almeno","nessun risultato per questa ricerca","File non trovato","Sarete rediretti al sito","clicca qui","Per continuare","playlist","guarda la playlist")
rosetta.add "JA", array("Japanese" & vbtab & "Shift_JIS" & vbtab & "Japanese","{","t@C","t@C","tH_","tH_","SI","Ȃ","Xgɒǉ","Xg폜","IȂĐ","ׂčĐ","Xg##%t","T[`","OIĂ","OI","pX[h","z[y[W","IvV","#aɂ","ftp TCg","A[eBXg","Ao","","W","[x","܂̓Rg","powered by #a version ##","fڍ","fڍ","fړj","fڌj","fډΗj","fڐj","fږؗj","fڋj","fړyj","","L[[h2ȏɂĂ","݂܂ł","t@C͌܂ł","IɃTCgֈړ܂","NbNĂ","","ĐXg","ĐXg")
rosetta.add "KO", array("Korean" & vbtab & "euc-kr" & vbtab & "Korean","ѱ","","","",""," "," "," Ͽ ߰"," Ͽ "," "," ","̿   Ͽ ##%   Դϴ","˻","α ϼ","α","н","ó","","#a Ͽ","FTP Ʈ","ƼƮ","ٹ","","","̺","ǰ õ ǻ ּ","powered by #a version ##","(߰)","(߰)","(߰)Ͽ","(߰)","(߰)ȭ","(߰)","(߰)","(߰)ݿ","(߰)","˻ ","˻ ּ 2 ̻ ̾ մϴ","ġϴ ڷᰡ ϴ"," ã  ϴ","ٽ õ  ּ","Ŭϼ","⸦"," ","  ")
rosetta.add "HU", array("Hungarian" & vbtab & "iso-8859-2" & vbtab & "Magyar","Magyar","fjl","fjl","knyvtr","knyvtr","mind kivlaszt","semmi","hozzads a listhoz","trls a listbl","kivlasztottak lejtszsa","minden lejtszsa","a lista ##%-ig tele","Keress:","Krem lpj be","Felhasznlnv","Jelsz","Kezdoldal","Belltsok","Az #a-rl","FTP trhely","Eladk","Albumok","Dalok","Stlusok","Feliratok","Krdsek vagy megjegyzsek","Az oldal az #a ## verzival kszlt","Mai jdonsgok","Tegnapi jdonsgok","Vasrnapi jdonsgok","Htfi jdonsgok","Keddi jdonsgok","Szerdai jdonsgok","Cstrtki jdonsgok","Pnteki jdonsgok","Szombati jdonsgok","A keress eredmnye","A keresend sznak legalbb 2 betbl kell llni","Nincs tallat","A fjl nem tallhat","Mindjrt tirnytunk az oldalunkra","kattints ide","A folytatshoz","Dalok listja","Lista megtekintse")
rosetta.add "NL", array("Dutch" & vbtab & "iso-8859-1" & vbtab & "Nederlands","Nederlands","bestand","bestanden","map","mappen","alles selecteren","niets","aan playlist toevoegen","van playlist verwijderen","selectie afspelen","speel alles","de playlist is voor ##% vol","zoek in","Inloggen a.u.b.","gebruikersnaam","wachtwoord","home pagina","instellingen","over #a","ftp site","artiesten","albums","nummers","genres","labels","vragen of opmerkingen","powered by #a versie ##","nieuw vandaag","nieuw gisteren","nieuw zondag","nieuw maandag","nieuw dinsdag","nieuw woensdag","nieuw donderdag","nieuw vrijdag","nieuw zaterdag","zoekresultaten","de zoekterm moet uit minimaal 2 tekens bestaan","geen zoekresultaten gevonden","Bestand niet gevonden","U wordt naar de site doorgestuurd","klik hier","Om door te gaan","playlist","playlist bekijken")
rosetta.add "NO", array("Norwegian" & vbtab & "iso-8859-1" & vbtab & "Norsk","Norsk","fil","filer","mappe","mapper","velg alle","ingen","legg til i spillelisten","fjern fra spillelisten","spill valgte","spill alle","spillelisten er ##% full","Sk","Vennligst logg inn","Brukernavn","Passord","hjem","innstillinger","om #a","ftp side","artister","album","sanger","sjangere","plateselskaper","sprsml eller kommentarer","Drevet av #a versjon ##","ny i dag","ny i gr","ny p sndag","ny p mandag","ny p tirsdag","ny p onsdag","ny p torsdag","ny p fredag","ny p lrdag","skeresultater","skestrengen m vre p minst 2 tegn","ingen treff","Finner ikke filen","Du burde bli videresendt til siden","klikk her","For  fortsette","spillelisten","se p spillelisten")
rosetta.add "PL", array("Polish" & vbtab & "iso-8859-2" & vbtab & "Polski","Polski","plik","plikw","folder","folderw","zaznacz wszystko","nic","dodaj do listy","usu z listy","odtwrz zaznaczone","odtwrz wszystko","wypenienie listy ##%","szukaj","zaloguj si","uytkownik","haso","strona gwna","preferencje","o #a","serwer FTP","wykonawca","albumy","utwory","gatunek","tytu","pytania lub komentarze","powered by #a version ##","dzisiejsze nowoci","wczorajsze nowoci","nowo z niedzieli","nowo z poniedziaku","nowo z wtorku","nowo ze rody","nowo z czwartku","nowo z pitku","nowo z soboty","wyniki szukania","szukana fraza musi skada si z min. 2 liter","nie znaleziono","Brak pliku","Musisz by przekierowany do strony","kliknij tutaj","Kontynuacja","lista odtwarzania","widok listy odtwarzania")
rosetta.add "PT", array("Portuguese" & vbtab & "iso-8859-1" & vbtab & "Portugu&ecirc;s","Portugus","ficheiro","ficheiros","pasta","pastas","seleccionar todos","nenhum","juntar  playlist","remover da playlist","tocar seleco","tocar todos","a playlist est ##% cheia","procure no","por favor identifique-se","utilizador","palavra-passe","homepage","preferncias","acerca do #a","site ftp","artistas","lbums","canes","gneros","editoras","questes ou comentrios","powered by #a verso ##","novo hoje","novo ontem","novo domingo","novo segunda-feira","novo tera-feira","novo quarta-feira","novo quinta-feira","novo sexta-feira","novo sbado","resultados da pesquisa","o termo da pesquisa deve ter pelo menos 2 caracteres","nenhum resultado encontrado","Ficheiro no encontrado","Dever ser redirigido para este site","clique aqui","Para continuar","playlist","ver playlist")
rosetta.add "PT-br", array("Portuguese (Brazil)" & vbtab & "iso-8859-1" & vbtab & "Portugu&ecirc;s (Brasil)","Portugus (Brasil)","arquivo","arquivos","pasta","pastas","selecionar todos","nenhum","adicionar ao playlist","remover do playlist","tocar seleo","tocar todas","o playlist est ##% cheio","procure no","por favor identifique-se","usurio","senha","homepage","preferncias","sobre o #a","site ftp","artistas","lbums","msicas","estilos","selos","perguntas ou comentrios","powered by #a verso ##","novo hoje","novo ontem","novo domingo","novo segunda-feira","novo tera-feira","novo quarta-feira","novo quinta-feira","novo sexta-feira","novo sbado","resultados da pesquisa","o termo da pesquisa deve ter pelo menos 2 caracteres","nenhum resultado encontrado","Arquivo no encontrado","Dever ser redirecionado para este site","clique aqui","Para continuar","playlist","ver o playlist")
rosetta.add "RU", array("Russian" & vbtab & "Windows-1251" & vbtab & "Pycckuu","","","","",""," ","","  ","  "," "," ","   ##%"," ","  ","",""," ",""," #a"," ftp","","","","","","  ","  #a  ##"," "," ","  ","  ","  ","  ","  ","  ","  "," ","      2   ","  ","  ","   "," "," ",""," ")
rosetta.add "RO", array("Romanian" & vbtab & "iso-8859-2" & vbtab & "Rom&acirc;na","Romn","fiier","fiiere","director","directoare","selecteaz toate","nici unul","adaug la list","terge din list","red selecia","red toate","lista de piese este ##% plin","caut pe","v rog conectai-v","utilizator","parola","pagina principal","preferine","despre #a","locaie ftp","artiti","albume","piese","stiluri","etichete","ntrebri sau comentarii","creat de #a versiunea ##","adugat astzi","adugat ieri","adugat Duminic","adugat Luni","adugat Mari","adugat Miercuri","adugat Joi","adugat Vineri","adugat Smbt","rezultatul cutrii","cuvntul de cutare trebuie sa aib cel puin 2 caractere","nu am gsit nimic","Fiierul nu exist","Trebuie s reintri n site","apas aici","Pentru a continua","lista","vizualizeaz lista")
rosetta.add "SL", array("Slovenian" & vbtab & "iso-8859-2" & vbtab & "Slovenscina","Slovenina","datoteka","datotek","mapa","map","izberi vse","ni","dodaj na seznam","zbrii s seznama","predvajaj izbrano","predvajaj vse","seznam je ##% poln","ii","prosim prijavi se","prijava","geslo","domaa stran","preference","o #a","ftp server","izvajalci","albumi","skladbe","anr","zalobe","vpraanja ali pripombe","powered by #a version ##","novo danes","novo od veraj","novo od nedelje","novo od ponedeljka","novo od torka","novo od srede","novo od etrtka","novo od petka","novo od sobote","ii po zadetkih","iskani termin naj vsebuje vsaj 2 znaka","ni zadetkov","Datoteka ni najdena","Preusmerjeni bi morali biti na stran","klikni tukaj","Za nadaljevanje","seznam","poglej seznam")
rosetta.add "SK", array("Slovak" & vbtab & "iso-8859-2" & vbtab & "Slovensky","Slovensky","sbor","sbory","zloka","zloky","vybra vetko","zma vber","prida do playlistu","odstrni z playlistu","prehra vybran","prehra vetko","playlist je z ##% pln","hada v","prihlste sa prosm","meno","heslo","tituln strana","nastavenie","o Andromede","ftp server","umelci","albumi","piesne","nre","labely","otzky alebo komentre","pouva Andromedu verzie ##","novinka dnes","novinka vera","novinka Nedele","novinka Pondelka","novinka Utorka","novinka Stredy","novinka tvrtka","novinka Piatku","novinka Soboty","vsledky vyhadvania","zadejte aspo 2 znaky","ni nenjden","Sbor nenjden","Budete presmerovn na","kliknite tu","Pokraova","playlist","prohliadnu playlist")
rosetta.add "SR", array("Serbian" & vbtab & "iso-8859-2" & vbtab & "Srpski","Srpski","fajl","fajla","direktorijum","direktorijuma","selektuj sve","nita","dodaj u listu","izbrii iz liste","sluaj selektovano","sluaj sve","lista je ##% puna","pretraga","molimo da se ulogujete","logovanje","ifra","glavna strana","podeavanja","#a","ftp strana","umetnici","albumi","pesme","anrovi","labele","pitanja ili komentari","powered by #a version ##","novi danas","novi jue","novi Nedelja","novi Ponedeljak","novi Utorak","novi Sreda","novi etvrtak","novi Petak","novi Subota","rezultati pretrage","morate uneti najmanje 2 slova za pretragu","nita nije pronaeno","Fajl nije pronaen","Trebalo bi da budete poslani na sajt","kliknite ovde","Da nastavite","lista","pogledaj listu")
rosetta.add "FI", array("Finnish" & vbtab & "iso-8859-1" & vbtab & "Suomi","Suomi","tiedosto","tiedostoa","kansio","kansiota","valitse kaikki","poista valinnat","lis soittolistaan","poista soittolistasta","soita valitut","soita kaikki","soittolistan tilasta on kytss ##%","etsi palvelimelta","kirjaudu jrjestelmn","kyttjtunnus","salasana","kotisivu","asetukset","tietoja #a:sta","ftp-palvelin","artistit","albumit","kappaleet","musiikkityylit","levy-yhtit","kysymykset tai kommentit","jrjestelm on toteutettu #a versiolla ##","uusi tnn","uusi eilen","uusi sunnuntai","uusi maanantai","uusi tiistai","uusi keskiviikko","uusi torstai","uusi perjantai","uusi lauantai","haun tulokset","hakusanan tulee olla vhintn 2 kirjaimen pituinen","hakusanalla ei lytynyt tiedostoja","Tiedostoa ei lydy","Selaimesi pitisi ohjautua uudelle sivulle","paina tst","Jatkaaksesi","soittolista","nyt soittolista")
rosetta.add "SV", array("Swedish" & vbtab & "iso-8859-1" & vbtab & "Svenska","Svenska","fil","filer","mapp","mappar","vlj alla","inga","lgg till spellistan","radera frn spellistan","spela urvalet","spela alla","spellistan r till ##% full","sk i","Logga in tack","loggin","lsenord","hemsida","instllningar","om #a","ftp adress","artist","album","snger","kategori","skivmrke","frgor och kommentarer","skapad av #a version ##","ny idag","ny igr","ny Sndag","ny Mndag","ny Tisdag","ny Onsdag","ny Torsdag","ny Fredag","ny Lrdag","sk resultat","skordet mste vara minst 2 tecken","inga trffar funna","inga filer funna","du blir vidarbefodrad till sidan","tryck hr","fortstt","spellistan","visa spellista")
rosetta.add "TR", array("Turkish" & vbtab & "iso-8859-9" & vbtab & "T&uuml;rk&ccedil;e","Trke","dosya","dosya","dizin","dizin","hepsini se","hibiri","listeye ekle","listeden kar","seimi al","hepsini al","liste ##% dolu","ara","ltfen giri yapn","kullanc","ifre","ana sayfa","ayarlar","#a hakknda","ftp site","artistler","albmler","arklar","trler","etiketler","sorular veya neriler","destekleyen; #a versiyon ##","yeni bugn","yeni dn","yeni Pazar","yeni Pazartesi","yeni Sal","yeni aramba","yeni Perembe","yeni Cuma","yeni Cumartesi","arama sonular","arama kriteri en az 2 karakterli olmal","aranan kayt bulunamad","Dosya bulunamad","Siteye gnderilebilirsiniz","buraya tklayn","Devam iin","liste","listeye gzat")
loadConstants
loadDefaults
loadPrefs
if andromedaPrefs("timeout") <> "" then
Server.ScriptTimeout = andromedaPrefs("timeout")
end if
if andromedaPrefs("rootName") = "" then
andromedaPrefs("rootName") = displayName(andromedaPrefs("mediaPhysicalPath"))
end if
if andromedaPrefs("rootName") = "" then andromedaPrefs("rootName") = "root"
if ((andromedaPrefs("coreInclude") <> "") and (ScriptEngineMajorVersion >= 5)) then
server.execute(andromedaPrefs("coreInclude"))
end if
fttmpa = split(lcase(andromedaPrefs("audioFileTypes")),",")
for fti = 0 to ubound(fttmpa)
fileTypes.add fttmpa(fti), "audio"
next
fttmpa = split(lcase(andromedaPrefs("videoFileTypes")),",")
for fti = 0 to ubound(fttmpa)
fileTypes.add fttmpa(fti), "video"
next
fttmpa = split(lcase(andromedaPrefs("playlistFileTypes")),",")
for fti = 0 to ubound(fttmpa)
fileTypes.add fttmpa(fti), "playlist"
next
fttmpa = split(andromedaPrefs("folderSkipNames"),",")
for fti = 0 to ubound(fttmpa)
folderSkipNames.add fttmpa(fti), true
next
loadSkin
loadLogons
totalrowcount = 0
plrpre = ""
if andromedaPrefs("permitTranslation") then
if request("t") <> "" then
currentLanguage = request("t")
else
if request.cookies("clang") <> "" then
currentLanguage = request.cookies("clang")
else
currentLanguage = andromedaPrefs("defaultLanguage")
end if
end if
else
currentLanguage = andromedaPrefs("defaultLanguage")
end if
clangCodes = split(rosetta(currentLanguage)(0),vbtab)
if not(andromedaPrefs("requireLogon")) or andromedaConst("localUser") then
permitAccess = true
else
cklogon = request.cookies("logon")
ckpassword = request.cookies("password")
if andromedaLogons.exists(cklogon) then
permitAccess = ((andromedaLogons(cklogon) = ckpassword) and (request("q") <> "l"))
else
permitAccess = false
end if
end if
if ((andromedaConst(ca2s(array(97,112,112,97,117,116,104))) <> ca2s(array(83,99,111,116,116,32,77,97,116,116,104,101,119,115))) or (andromedaConst(ca2s(array(97,112,112,99,111,114,112))) <> ca2s(array(84,117,114,110,115,116,121,108,101))) or (andromedaConst(ca2s(array(97,112,112,110,97,109,101))) <> ca2s(array(65,110,100,114,111,109,101,100,97))) or (andromedaConst(ca2s(array(97,112,112,114,111,111,116))) <> ca2s(array(104,116,116,112,58,47,47,119,119,119,46,116,117,114,110,115,116,121,108,101,46,99,111,109,47,97,110,100,114,111,109,101,100,97)))) then response.end
if not(permitAccess) then
if request("q") = "l" then
cklogon = request("flogon")
ckpassword = request("fpassword")
if andromedaLogons.exists(cklogon) then
permitAccess2 = (andromedaLogons(cklogon) = ckpassword)
else
permitAccess2 = false
end if
if not(permitAccess2) then
if ((request("t") <> "") and andromedaPrefs("permitTranslation")) then response.cookies("clang") = currentLanguage
andromedaHeader(trans(14))
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>" height=220><tr><td align=center><%
if andromedaPrefs("logonMessage") <> "" then
%><font size="2"><% = andromedaPrefs("logonMessage") %></font><%
addvpad 12
end if
%><table cellspacing=0 cellpadding=1 border=0 bgcolor="<% = andromedaPrefs("menubarColor") %>"><form method=post action=<% = andrLink("","") %>><input type=hidden name=q value=l><tr><td><table cellspacing=0 cellpadding=2 border=0 bgcolor="<% = andromedaPrefs("rowColor1") %>" width=100%><tr><td><font face="helvetica,arial" size="1" color="<% = andromedaPrefs("rowTextColor") %>"><% = trans(14) %></font></td></tr></table><% colorbar "100%","1",andromedaPrefs("menubarColor") %><table cellspacing=0 cellpadding=0 border=0 bgcolor="<% = andromedaPrefs("rowColor2") %>" width=100%><tr><td><table cellspacing=0 cellpadding=2 border=0 width=100%><tr><td align=right><font size="1" face="helvetica,arial" color="<% = andromedaPrefs("rowTextColor") %>"><% = trans(15) %>:</font></td><td><input name=flogon size=16 value="<% = minHTMLencode(request("flogon")) %>" style="font-size:9pt;"></td></tr><tr><td align=right><font size="1" face="helvetica,arial" color="<% = andromedaPrefs("rowTextColor") %>"><% = trans(16) %>:</font></td><td><input name=fpassword type=password size=16 style="font-size:9pt;"></td></tr></table></td><td><% ipad 4,1 %></td><td><% imagetag "g","f","" %></td><td><% ipad 2,1 %></td></tr></table></td></tr></form></table></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
andromedaFooter
else
response.cookies("logon") = request("flogon")
response.cookies("password") = request("fpassword")
andromedaHeaderCore trans(41), true
%><table cellspacing=0 cellpadding=4 border=0 width="<% = andromedaPrefs("siteWidth") %>" bgcolor="<% = andromedaPrefs("bodyFgColor") %>" height=220><tr><td align=center><% if andromedaPrefs("disableHTMLheaders") then %><font color=<% = andromedaPrefs("bodyTextColor") %>><% end if %><% = trans(41) & ". " & trans(43) & ", " %><% if andromedaPrefs("disableHTMLheaders") then %><a href=<% = andrLink("","") %> style="color:<% = andromedaPrefs("bodyLinkColor") %>"><font color="<% = andromedaPrefs("bodyLinkColor") %>"><% = trans(42) %></font></a><% else %><a href=<% = andrLink("","") %>><% = trans(42) %></a><% end if %>.<% if andromedaPrefs("disableHTMLheaders") then %></font><% end if %></td></tr></table><%
colorbars andromedaPrefs("bodyFgDiv")
andromedaFooter
end if
else
if ((request("t") <> "") and andromedaPrefs("permitTranslation")) then
response.redirect(andrlink("?q=l&t=" & request("t"),""))
else
response.redirect(andrlink("?q=l",""))
end if
end if
else
if ((request("t") <> "") and andromedaPrefs("permitTranslation")) then response.cookies("clang") = currentLanguage
ckplaylist = readPlaylist("playlist")
if request("q") = "f" and vpath(request("f")) then
showfolder request("f")
elseif request("q") = "p" and vpath(request("p")) and andromedaPrefs("playLinks") then playFolder request("p")
elseif request("q") = "m" and vpath(request("m")) and andromedaPrefs("playLinks") then playPrepList "i" & request("m") & vbcrlf
elseif request("q") = "e" and andromedaConst("localUser") and vpath(request("e")) then editNote request("e")
elseif request("q") = "v" and andromedaConst("localUser") and vpath(request("v")) then saveNote request("v"), request("n")
elseif request("q") = "r" and andromedaConst("localUser") then editPrefs
elseif request("q") = "b" and andromedaConst("localUser") then savePrefs
elseif request("q") = "s" and andromedaPrefs("permitSearch") then search request("s"),request("sm")
elseif request("q") = "y" and andromedaPrefs("permitPlaylists") then
select case request("y")
case "p"
if andromedaPrefs("playLinks") then playPrepList ckplaylist
case trans(10)
if andromedaPrefs("playLinks") then
if request("m") = 1 then
for each xx in request("f")
pftmp = pftmp & xx & vbcrlf
next
playPrepList pftmp
else
selectlist = ""
for each x in request("f")
selectlist = selectlist & "[" & x & "]"
next
xtmpa = split(ckplaylist,vbcrlf)
for xi = 0 to ubound(xtmpa) -1
if instr(selectlist,"[" & xi + 1 & "]") <> 0 then
xtmp = xtmp & xtmpa(xi) & vbcrlf
end if
next
playPrepList xtmp
end if
end if
case trans(8)
xtmp = ckplaylist
for each xx in request("f")
if vpath(mid(xx,2)) then xtmp = xtmp & xx & vbcrlf
next
xtmp = left(xtmp,andromedaPrefs("cBlockSize") * andromedaPrefs("cBlockCount"))
xtmp = left(xtmp,instrrev(xtmp, vbcrlf)+1)
ckplaylist = xtmp
writePlaylist "playlist"
displayPlaylist "playlist"
case trans(45)
displayPlaylist "playlist"
case trans(9)
removelist = ""
for each x in request("f")
removelist = removelist & "[" & x & "]"
next
xtmpa = split(ckplaylist,vbcrlf)
for xi = 0 to ubound(xtmpa) -1
if instr(removelist,"[" & xi + 1 & "]") = 0 then
xtmp = xtmp & xtmpa(xi) & vbcrlf
end if
next
ckplaylist = xtmp
writePlaylist "playlist"
displayPlaylist "playlist"
end select
else
showfolder ""
end if
end if
set rosetta = nothing
set andromedaLogons = nothing
set folderSkipNames = nothing
set fileTypes = nothing
set andromedaPrefs = nothing
set andromedaConst = nothing
end if
set local_fs = nothing
%>
