<% Option Explicit %>
<!--#include file="common.asp" -->
<%
'****************************************************************************************
'**  Copyright Notice    
'**
'**  Web Wiz Guide Guestbook
'**                                                              
'**  Copyright 2001-2003 Bruce Corkhill All Rights Reserved.                                
'**
'**  This program is free software; you can modify (at your own risk) any part of it 
'**  under the terms of the License that accompanies this software and use it both 
'**  privately and commercially.
'**
'**  All copyright notices must remain in tacked in the scripts and the 
'**  outputted HTML.
'**
'**  You may use parts of this program in your own private work, but you may NOT
'**  redistribute, repackage, or sell the whole or any part of this program even 
'**  if it is modified or reverse engineered in whole or in part without express 
'**  permission from the author.
'**
'**  You may not pass the whole or any part of this application off as your own work.
'**   
'**  All links to Web Wiz Guide and powered by logo's must remain unchanged and in place
'**  and must remain visible when the pages are viewed unless permission is first granted
'**  by the copyright holder.
'**
'**  This program is distributed in the hope that it will be useful,
'**  but WITHOUT ANY WARRANTY; without even the implied warranty of
'**  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR ANY OTHER 
'**  WARRANTIES WHETHER EXPRESSED OR IMPLIED.
'**
'**  You should have received a copy of the License along with this program; 
'**  if not, write to:- Web Wiz Guide, PO Box 4982, Bournemouth, BH8 8XP, United Kingdom.
'**    
'**
'**  No official support is available for this program but you may post support questions at: -
'**  http://www.webwizguide.info/forum
'**
'**  Support questions are NOT answered by e-mail ever!
'**
'**  For correspondence or non support questions contact: -
'**  info@webwizguide.com
'**
'**  or at: -
'**
'**  Web Wiz Guide, PO Box 4982, Bournemouth, BH8 8XP, United Kingdom
'**
'****************************************************************************************



'Buffer the response
Response.Buffer = True

'Dimension variables
Dim strName 			'Holds the Users name
Dim strEmailAddress 		'Holds the Users e-mail address
Dim strCountry 			'Holds the users country
Dim strHomepage 		'Holds the Users homepage
Dim strComments 		'Holds the Users comments
Dim dtmEntryDate 		'Holds the date the commnets where made
Dim intRecordPositionPageNum 	'Holds the record position
Dim intRecordLoopCounter 	'Loop counter for displaying the guestbook records
Dim intTotalNumGuestbookEntries 'Holds the total number of records in the database
Dim intTotalNumGuestbookPages 	'Holds the total number of pages in the database
Dim intLinkPageNum 		'Holds the page number to be linked to



'If this is the first time the page is displayed then the guestbook record position is set to page 1
If Request.QueryString("PagePosition") = "" Then
	intRecordPositionPageNum = 1

'Else the page has been displayed before so the guestbook record postion is set to the Record Position number
Else
	intRecordPositionPageNum = CInt(Request.QueryString("PagePosition"))
End If	

		

'Initalise the strSQL variable with an SQL statement to query the database by selecting all tables ordered by the decending date
strSQL = "SELECT " & strDbTable & "Comments.* FROM " & strDbTable & "Comments ORDER BY Date_stamp DESC;"

'Set the cursor type property of the record set to dynamic so we can naviagate through the record set
rsCommon.CursorType = 3
	
'Query the database
rsCommon.Open strSQL, adoCon

'Set the number of records to display on each page by the constant set at the top of the script
rsCommon.PageSize = intRecordsPerPage
	
'Get the guestbook record poistion to display from
If NOT rsCommon.EOF Then rsCommon.AbsolutePage = intRecordPositionPageNum
%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Guest Book</title>

<!-- The Web Wiz Guestbook v. <% = strVersion %> is written by Bruce Corkhill 2001-2003
    	 If you want your Guestbook then goto http://www.webwizguide.info --> 
    	 
<!--#include file="includes/header.asp" -->
<table width="90%" border="0" align="center" cellpadding="0" cellspacing="0" height="8">
 <tr valign="middle"> 
  <td height="14"> <table width="98%" border="0" cellspacing="0" cellpadding="0" align="center">
    <tr> 
     <td width="70%"align="center" class="text">Welcome to the guestbook. If you would like to sign the guest book then click on the link below.<br> <br> <a href="http://www.webwizguide.info"></a> <a href="sign.asp?PagePosition=<% = intRecordPositionPageNum %>" target="_self">Sign the guest book</a></td>
    </tr>
   </table></td>
 </tr>
</table>
<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
 <tr> 
  <td align="center" class="text"> <%
'If there are no rcords in the database display an error message
If rsCommon.EOF Then
	'Tell the user there are no records to show
	Response.Write "<br>There are no records in the guestbook database"
	Response.Write "<br>Please check back later"
	Response.End
	


'Display the guestbook
Else	
	
	'Count the number of enties in the guestbook database
	intTotalNumGuestbookEntries = rsCommon.RecordCount	
	
	'Count the number of pages there are in the guestbook database calculated by the PageSize attribute set above
	intTotalNumGuestbookPages = rsCommon.PageCount


	'Display the HTML number number the total number of pages and total number of records in the guestbook database
	%> <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
    <tr> 
     <td align="center" class="text"><br>There are <% = intTotalNumGuestbookEntries %> guestbook entries in <% = intTotalNumGuestbookPages %> pages and you are on page number <% = intRecordPositionPageNum %></td>
    </tr>
   </table>
   <br> <%

	'For....Next Loop to display records from the guestbook database
	For intRecordLoopCounter = 1 to intRecordsPerPage
	
		'If there are no guestbook records left to display then exit loop
		If rsCommon.EOF Then Exit For
	      		
	      	'Read in the values form the database	
	      	strName = rsCommon("Name")
      		strCountry = rsCommon("Country")
	      	strEmailAddress = rsCommon("EMail")
	      	dtmEntryDate = CDate(rsCommon("Date_stamp"))
	      	strHomepage = rsCommon("Homepage")
	      	strComments = rsCommon("Comments")
	      
	      		      	
	      	'If there is no homepage entry to display the display no URL given	
	     	If strHomepage = "http://" then 
	     		strHomepage = "no URL given"
	     	
	     	'Else turn the URL stored in the strHomepage variable into a hyperlink
	     	Else 
	     		strHomepage = "<a href=""" & strHomepage & """ target=""_blank"">" & strHomepage & "</a>"
	     	End If
	      	
	      	
	      	'Write the HTML to the web browser to display the guestbook entries
	      	%> <table width="100%" border="0" cellspacing="0" cellpadding="1" align="center" bgcolor="<% = strTableBorderColour %>">
    <tr> 
     <td> <table width="100%" border="0" cellpadding="2" cellspacing="0">
       <tr bgcolor="<% = strTableTitleColour %>"> 
        <td colspan="2" class="text"> <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
           <td width="93%" class="text">Comments by 
            <%
           
           	'Display the email address if there is one
           	If strEmailAddress <> "" Then Response.Write("<a href=""mailto:" & strEmailAddress & """>" & strName & "</a>") Else Response.Write(strName)
            
            %> on <% = FormatDateTime(dtmEntryDate, VbLongDate) %> at <% = FormatDateTime(dtmEntryDate, VbShortTime) %> </td>
           <td width="7%" align="right" class="text">IP&nbsp;Logged</td>
          </tr>
         </table></td>
       </tr>
       <tr> 
        <td colspan="2" bgcolor="<% = strTableColour %>" class="text"><% = strComments %> </td>
       </tr>
       <tr bgcolor="<% = strTableTitleColour %>"> 
        <td width="50%" align="left" class="text"><% = strCountry %></td>
        <td width="50%" align="right" class="text"><% = strHomepage %></td>
       </tr>
      </table></td>
    </tr>
   </table>
   <br> <%      
	      		
      		'Move to the next record in the database
	   	rsCommon.MoveNext
	
	'Loop back round   	
	Next
End If



'Display an HTML table with links to the other entries in the guestbook
%> <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
    <tr> 
     <td> <table width="100%" border="0" cellpadding="0" cellspacing="0">
       <tr>
        <td width="50%" align="center" class="text"> <%
'If there are more pages to display then add a title to the other pages
If intRecordPositionPageNum > 1 or NOT rsCommon.EOF Then
	Response.Write vbCrLf & "		Page:&nbsp;&nbsp;"
End If

'If the guestbook page number is higher than page 1 then display a back link    	
If intRecordPositionPageNum > 1 Then 
	Response.Write vbCrLf & ("<a href=""default.asp?PagePosition=" &  intRecordPositionPageNum - 1  & """ target=""_self"">&lt;&lt;&nbsp;Prev</a>")	     	
End If     	

'If there are more pages to display then display links to all the pages
If intRecordPositionPageNum > 1 or NOT rsCommon.EOF Then 
	
	'Display a link for each page in the guestbook     	
	For intLinkPageNum = 1 to intTotalNumGuestbookPages	
	
		'If there is more than 7 pages display ... last page and exit the loop
		 If intLinkPageNum > 15 Then 
		 	If intTotalNumGuestbookPages = intRecordPositionPageNum Then Response.Write(" ..." & intTotalNumGuestbookPages) Else Response.Write(" ...<a href=""default.asp?PagePosition=" &  intTotalNumGuestbookPages  & """ target=""_self"">" & intTotalNumGuestbookPages & "</a>")
		 		
		 	'Exit Loop
		 	Exit For
		 'Else display the normal link code
		 Else
			 'If the page to be linked to is the page displayed then don't make it a hyper-link
			If intLinkPageNum = intRecordPositionPageNum Then Response.Write(" " & intLinkPageNum) Else Response.Write("&nbsp;<a href=""default.asp?PagePosition=" &  intLinkPageNum  & """ target=""_self"">" & intLinkPageNum & "</a>")	
		 End If
	Next
End If

'If it is Not the End of the guestbook entries then display a next link for the next guestbook page      	
If NOT rsCommon.EOF then   	
	Response.Write ("&nbsp;<a href=""default.asp?PagePosition=" &  intRecordPositionPageNum + 1  & """ target=""_self"">Next&nbsp;&gt;&gt;</a>")   	
End If      	


'Finsh HTML the table 
%> </td>
       </tr>
      </table></td>
    </tr>
   </table>
   <% 

'Reset Server Variables
rsCommon.Close
Set rsCommon = Nothing	
adoCon.Close
Set adoCon = Nothing


%> </td>
 </tr>
</table>
<div align="center"><br>
 <% 
'***** START WARNING - REMOVAL OR MODIFICATION OF THIS CODE WILL VIOLATE THE LICENSE AGREEMENT ******
If blnLCode = True Then
	Response.Write("<span class=""smText"">Powered by <a href=""http://www.webwizguide.info"" target=""_blank"" class=""smLink"">Web Wiz Guestbook</a> version " & strVersion & "</span>")
	Response.Write("<br><span class=""smText"">Copyright &copy;2001-2003 Web Wiz Guide</span>")
End If 
'***** END WARNING - REMOVAL OR MODIFICATION OF THIS CODE WILL VIOLATE THE LICENSE AGREEMENT ******
%>
 <br>
</div>
<!--#include file="includes/footer.asp" -->