<!-- #INCLUDE FILE="includes/common.asp" -->
<%
ProcessForumPage True
%>

<%
'== BEGIN MAIN =================================================================
Sub Main()
	' Message parameters
	Dim iForumId, iThreadId, iThreadParent, iThreadLevel
	Dim sSubject, sMessage, bNotify
	
	Dim sName, sEmail ' User Info from Cookies

	Dim iNewMessageId ' Id of the message we're adding

	Select Case Request.QueryString("action")
		Case "save"
			' Retrieve parameters
			iForumId = Request.Form("forum_id")
			iThreadId = Request.Form("thread_id")
			iThreadParent = Request.Form("thread_parent")
			iThreadLevel = Request.Form("thread_level")
			sName = Request.Form("name")
			sEmail = Request.Form("email")
			sSubject = Request.Form("subject")
			sMessage = Request.Form("message")
			bNotify = Request.Form("notify")

			If bNotify = "yes" Then
				bNotify = True
			Else
				bNotify = False
			End If

			 ' Validate Input
			If InputIsValid("save", iForumId, iThreadId, iThreadParent, iThreadLevel, sName, sSubject, sMessage) Then
				' Insert the New Message
				iNewMessageId = InsertRecord(iForumId, iThreadId, iThreadParent, iThreadLevel, sName, sEmail, bNotify, sSubject, sMessage)
				
				' Show The Thanks Page
				ShowThanks iNewMessageId, iThreadParent, iForumId, sName, sEmail
				
				' Send Email Notification
				SendEmailNotification iNewMessageId, iThreadId, sEmail
			Else
				ShowForm iForumId, iThreadId, iThreadParent, iThreadLevel, sName, sEmail, sSubject, sMessage
			End If
		Case Else
			' Retrieve Parameters
			iForumId = Request.QueryString("fid")
			iThreadId = Request.QueryString("tid")
			iThreadParent = Request.QueryString("pid")
			iThreadLevel = Request.QueryString("level")
			sName = Request.Cookies("name")
			sEmail = Request.Cookies("email")
			sSubject = Request.QueryString("subject")
			'sMessage = Request.Form("message")
			If Len(sSubject) <> 0 And Left(sSubject, 3) <> "Re:" Then
				If Len(sSubject) > 46 Then ' If Re: won't fit!
					sSubject = "Re: " & Left(sSubject, 43) & "..."
				Else
					sSubject = "Re: " & sSubject
				End If			
			End If

			If InputIsValid("post", iForumId, iThreadId, iThreadParent, iThreadLevel, sName, sSubject, sMessage) Then
				ShowForm iForumId, iThreadId, iThreadParent, iThreadLevel, sName, sEmail, sSubject, sMessage
			Else
				' A message should have been displayed by the validation routine so we do nothing!
			End If
	End Select
End Sub 'Main
'== END MAIN ===================================================================
%>

<%
'== BEGIN SUBS & FUNCTIONS =====================================================
Function InputIsValid(strSituation, iForumId, iThreadId, iThreadParent, iThreadLevel, sName, sSubject, sMessage)
	Dim bEverythingIsCool
	bEverythingIsCool = True
	
	'Validate info
	If IsNumeric(iForumId) Then
		If iForumId <> 0 Then
			iForumId = CLng(iForumId)
		Else
			WriteLine "You aren't in an active forum!<BR>"
			bEverythingIsCool = False
		End If
	Else
		WriteLine "You aren't in an active forum!<BR>"
		bEverythingIsCool = False
	End If

	If IsNumeric(iThreadId) And IsNumeric(iThreadParent) And IsNumeric(iThreadLevel) Then 
		iThreadId = CLng(iThreadId)
		iThreadParent = CLng(iThreadParent)
		If iThreadLevel = 0 Then iThreadLevel = 1
		iThreadLevel = CLng(iThreadLevel)
	Else
		WriteLine "Invalid thread information!<BR>"
		bEverythingIsCool = False
	End If

	' Do our additional checks if we're about to save!
	If strSituation = "save" Then
		If Len(sName) = 0 Then 
			WriteLine "Name can't be empty!<BR>"
			bEverythingIsCool = False
		End If

		If Len(sSubject) = 0 Then 
			WriteLine "Subject can't be empty!<BR>"
			bEverythingIsCool = False
		End If

		If Len(sMessage) = 0 Then 
			WriteLine "Message can't be empty!<BR>"
			bEverythingIsCool = False
		End If
	End If

	InputIsValid = bEverythingIsCool
End Function ' InputIsValid

Sub ShowForm(forum_id, thread_id, thread_parent, thread_level, name, email, subject, message)
	%>
	<FORM NAME="NewMessage" ACTION="post_message.asp?action=save" METHOD="post">
	<INPUT TYPE="hidden" NAME="forum_id" VALUE="<%= forum_id %>">
	<INPUT TYPE="hidden" NAME="thread_id" VALUE="<%= thread_id %>">
	<INPUT TYPE="hidden" NAME="thread_parent" VALUE="<%= thread_parent %>">
	<INPUT TYPE="hidden" NAME="thread_level" VALUE="<%= thread_level %>">

	<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0">
		<TR>
			<TD VALIGN="top" ALIGN="right"><FONT SIZE="-1" COLOR="#0000FF"><I>Name:&nbsp;</I></FONT></TD>
			<TD><INPUT TYPE="text" NAME="name" MAXLENGTH="50" VALUE="<%= name %>"></INPUT></TD>
		</TR>
		<TR>
			<TD VALIGN="top" ALIGN="right"><FONT SIZE="-1" COLOR="#0000FF"><I>E-mail:&nbsp;</I></FONT></TD>
			<TD><INPUT TYPE="text" NAME="email" MAXLENGTH="50" VALUE="<%= email %>"></INPUT> (optional)</TD>
		</TR>
		<TR>
			<TD VALIGN="top" ALIGN="right"><FONT SIZE="-1" COLOR="#0000FF"><I>Subject:&nbsp;</I></FONT></TD>
			<TD><INPUT TYPE="text" NAME="subject" MAXLENGTH="50" VALUE="<%= subject %>"></INPUT></TD>
		</TR>
		<TR>
			<TD VALIGN="top" ALIGN="right"><FONT SIZE="-1" COLOR="#0000FF"><I>Message:&nbsp;</I></FONT></TD>
			<TD><TEXTAREA COLS="50" ROWS="10" NAME="message" WRAP="virtual"><%= message %></TEXTAREA></TD>
		</TR>
		<% If SEND_EMAIL Then %>
		<TR>
			<TD VALIGN="top" ALIGN="right"><INPUT TYPE="checkbox" NAME="notify" VALUE="yes"></TD>
			<TD COLSPAN="2"><FONT SIZE="-1" COLOR="#0000FF"><I>E-mail me when someone posts a new message in this thread.</I></FONT></TD>
		</TR>
		<% End If %>
		<TR>
			<TD COLSPAN="2" ALIGN="right"><INPUT TYPE="reset" VALUE="Reset Form" id=reset1 name=reset1>&nbsp;&nbsp;<INPUT TYPE="submit" VALUE="Post Message" id=submit1 name=submit1></TD>
		</TR>
	</TABLE>
	</FORM>
		
	<% If thread_parent <> 0 Then %>
		<A HREF="display_message.asp?mid=<%= thread_parent %>"><FONT SIZE="-1"><I>Back to the Message</I></FONT></A><BR>
	<% End If %>
	<A HREF="display_forum.asp?fid=<%= forum_id %>"><FONT SIZE="-1"><I>Back to the Folder</I></FONT></A><BR>

	<%
End Sub ' ShowForm

Function InsertRecord(forum_id, thread_id, thread_parent, thread_level, author, email, notify, subject, body)
	Dim objRSInsert
	Dim dTimeStamp
	Dim iNewMessageId
	
	dTimeStamp = Now()

	Set objRSInsert = Server.CreateObject("ADODB.RecordSet")

	' Access likes #'s, SQL doesn't
	objRSInsert.Open "SELECT * FROM messages WHERE message_timestamp=" & DB_DATE_DELIMITER & FormatTimestampDB(dTimeStamp) & DB_DATE_DELIMITER & ";", cnnForumDC, adOpenDynamic, adLockPessimistic
	
	objRSInsert.AddNew
	objRSInsert.Fields("message_timestamp") = dTimeStamp

	objRSInsert.Fields("forum_id") = forum_id
	objRSInsert.Fields("thread_id") = thread_id
	objRSInsert.Fields("thread_parent") = thread_parent
	objRSInsert.Fields("thread_level") = thread_level
	objRSInsert.Fields("message_author") = author
	If email <> "" Then objRSInsert.Fields("message_author_email") = email
	objRSInsert.Fields("message_author_notify") = notify
	objRSInsert.Fields("message_subject") = subject
	objRSInsert.Fields("message_body") = body
	
	objRSInsert.Update

	' Doesn't work with Access!
	'objRSInsert.Fields("thread_id") = objRSInsert.Fields("message_id")
	'objRSInsert.Update
	
	objRSInsert.Requery ' To be sure we have the message_id back from the DB.

	objRSInsert.MoveFirst

	iNewMessageId = objRSInsert.Fields("message_id")
	If thread_id = 0 Then
		objRSInsert.Fields("thread_id") = iNewMessageId
		objRSInsert.Update
	End If

	objRSInsert.Close
	Set objRSInsert = Nothing
	
	InsertRecord = iNewMessageId
End Function 'InsertRecord

Sub SendEmailNotification(iNewMessageId, iThreadId, sPostersEmail)
	' DB object var for email notification
	Dim objNotifyRS
	Dim strSQL

	' Make sure emailing is enabled
	If SEND_EMAIL Then
		' Send Email notify if author has requested it
		' thread_id = 0 -> this is the first post in thread -> no one to notify
		If iThreadId <> 0 Then
			strSQL = "SELECT DISTINCT message_author_email FROM messages WHERE "
			strSQL = strSQL & "message_id <> " & iNewMessageId & " AND "
			strSQL = strSQL & "thread_id = " & iThreadId & " AND "
			strSQL = strSQL & "message_author_notify <> 0 AND "
			strSQL = strSQL & "message_author_email <> '' AND "
			strSQL = strSQL & "message_author_email <> '" & sPostersEmail & "';"

			Set objNotifyRS = GetRecordset(strSQL)
			If Not objNotifyRS.EOF Then
				objNotifyRS.MoveFirst

				Do While Not objNotifyRS.EOF
					SendEmail _
						"ASP 101 Webmaster <webmaster@asp101.com>", _
						objNotifyRS.Fields("message_author_email").Value, _
						"A new message has been posted!", _
						"A new message has been posted in a thread you asked us watch for you on ASP 101's " & _
						"discussion forum.  You can find the forum at http://www.asp101.com/forum.  For " & _
						"your convenience, the address of the new message is " & _
						"http://www.asp101.com/forum/display_message.asp?mid=" & iNewMessageId & "."

					objNotifyRS.MoveNext
				Loop
			End If
			objNotifyRS.Close
			Set objNotifyRS = Nothing
		End If
	End If
End Sub 'SendEmailNotification

Sub ShowThanks(iNewMessageId, iThreadParent, iForumId, sName, sEmail)
	Response.Write "<B>Thank you for your post!</B><BR>" & vbCrLf
	Response.Write "<BR>" & vbCrLf
	If IsNull(Request.Cookies("name")) Or Len(Request.Cookies("name")) = 0 Then
		Response.Write "For your convenience, we can save your name and e-mail to a cookie on your "
		Response.Write "machine so you won't need to enter them the next time you post a message.  Click "
		Response.Write "<A HREF=""./save_cookie.asp"
		Response.Write "?fid=" & iForumId
		Response.Write "&mid=" & iNewMessageId
		Response.Write "&name=" & Server.URLEncode(sName)
		Response.Write "&email=" & Server.URLEncode(sEmail)
		Response.Write """>here</A> to save this information now.<BR><BR>" & vbCrLf
	End If
	Response.Write "<A HREF=""./display_message.asp?mid=" & iNewMessageId & """><FONT SIZE=""-1""><I>View Your Message</I></FONT></A><BR>" & vbCrLf
	If iThreadParent <> 0 Then
		Response.Write "<A HREF=""./display_message.asp?mid=" & iThreadParent & """><FONT SIZE=""-1""><I>Back to the Message</I></FONT></A><BR>" & vbCrLf
	End If
	Response.Write "<A HREF=""./display_forum.asp?fid=" & iForumId & """><FONT SIZE=""-1""><I>Back to the Folder</I></FONT></A><BR>" & vbCrLf
End Sub 'ShowThanks
'== END SUBS & FUNCTIONS =======================================================
%>