<%
'*******************************************************
'*     ASP 101 Sample Code - http://www.asp101.com     *
'*                                                     *
'*   This code is made available as a service to our   *
'*      visitors and is provided strictly for the      *
'*               purpose of illustration.              *
'*                                                     *
'* Please direct all inquiries to webmaster@asp101.com *
'*******************************************************
%>

<% ' ***** Begin the functions to be called by the runtime script *****
' To find the actual runtime code scroll WAY DOWN....

' This function is written to enable the adding of multiples of an item
' but this sample always just adds one.  If you wish to add different
' quantities simply replace the value of the Querystring parameter count.
' We didn't do this because we wanted to keep the whole thing simple and
' not get into using forms so it stayed relatively readable.
Sub AddItemToCart(iItemID, iItemCount)
 	If dictCart.Exists(iItemID) Then
		dictCart(iItemID) = dictCart(iItemID) + iItemCount
	Else
		dictCart.Add iItemID, iItemCount
	End If
	Response.Write iItemCount & " of item # " & iItemID & " have been added to your cart.<BR><BR>" & vbCrLf
End Sub

Sub RemoveItemFromCart(iItemID, iItemCount)
 	If dictCart.Exists(iItemID) Then
		If dictCart(iItemID) <= iItemCount Then
			dictCart.Remove iItemID
		Else
			dictCart(iItemID) = dictCart(iItemID) - iItemCount
		End If
		Response.Write iItemCount & " of item # " & iItemID & " have been removed from your cart.<BR><BR>" & vbCrLf
	Else
		Response.Write "Couldn't find any of that item your cart.<BR><BR>" & vbCrLf
	End If
End Sub

Sub ShowItemsInCart()
Dim Key
Dim aParameters ' as Variant (Array)
Dim sTotal, sShipping
	
	%>
	<TABLE Border=1 CellPadding=3 CellSpacing=1>
	    <TR>
			<TD>Item #</TD>
			<TD>Description</TD>
			<TD>Quantity</TD>
			<TD>Remove Item From Cart</TD>
			<TD>Price</TD>
			<TD>Totals</TD>
	    </TR>
	<%
	sTotal = 0
	For Each Key in dictCart
		aParameters = GetItemParameters(Key)
		%>
		<TR>
			<TD ALIGN="Center"><%= Key %></TD>
			<TD ALIGN="Left"><%= aParameters(1) %></TD>
			<TD ALIGN="Center"><%= dictCart(Key) %></TD>
			<TD ALIGN="Left"><A HREF="./shopping.asp?action=del&item=<%= Key %>&count=1">Remove One</A>&nbsp;&nbsp;<A HREF="./shopping.asp?action=del&item=<%= Key %>&count=<%= dictCart(Key) %>">Remove All</A></TD>
			<TD ALIGN="Right">$<%= aParameters(2) %></TD>
			<TD ALIGN="Right">$<%= FormatNumber(dictCart(Key) * CSng(aParameters(2)),2) %></TD>
		</TR>
		<%
		sTotal = sTotal + (dictCart(Key) * CSng(aParameters(2)))
	Next
	
	'Calculate shipping - you might want to pull this out into a function if your shipping 
	' calculations are more complicated then ours.  ;)
	If sTotal <> 0 Then
		sShipping = 7.5
	Else
		sShipping = 0
	End If
	sTotal = sTotal + sShipping
	%>
	<TR><TD COLSPAN=5 ALIGN="Right"><B>S+H:</B></TD><TD ALIGN="Right">$<%= FormatNumber(sShipping,2) %></TD></TR>
	<TR><TD COLSPAN=5 ALIGN="Right"><B>Total:</B></TD><TD ALIGN="Right">$<%= FormatNumber(sTotal,2) %></TD></TR>
	</TABLE>
	<%
End Sub

Sub ShowFullCatalog()
Dim aParameters ' as Variant (Array)
Dim I
Dim iItemCount ' Number of items we sell
	' If you are really going to use this sample this should probably be pulled from a DB
	iItemCount = 3
	%>
	<TABLE Border=1 CellPadding=3 CellSpacing=1>
	    <TR>
	        <TD>Image</TD>
	        <TD>Description</TD>
	        <TD>Price</TD>
	        <TD>Add Item To Cart</TD>
	    </TR>
	<%
	For I = 1 to iItemCount
		aParameters = GetItemParameters(I)
		%>
	    <TR>
	        <TD><IMG SRC="<%= aParameters(0) %>"></TD>
	        <TD><%= aParameters(1) %></TD>
	        <TD>$<%= aParameters(2) %></TD>
	        <TD><A HREF="./shopping.asp?action=add&item=<%= I %>&count=1">Add this to my cart!</A></TD>
	    </TR>
		<%
	Next 'I
	%>
	</TABLE>
	<%
End Sub

Sub PlaceOrder()
Dim Key
Dim aParameters ' as Variant (Array)
Dim sTotal, sShipping
	
	%>
	<TABLE Border=1 CellPadding=3 CellSpacing=1>
	    <TR>
	        <TD>Item #</TD>
	        <TD>Description</TD>
			<TD>Quantity</TD>
	        <TD>Price</TD>
			<TD>Totals</TD>
	    </TR>
	<%
	sTotal = 0
	For Each Key in dictCart
		aParameters = GetItemParameters(Key)
		%>
		<TR>
			<TD ALIGN="Center"><%= Key %></TD>
			<TD ALIGN="Left"><%= aParameters(1) %></TD>
			<TD ALIGN="Center"><%= dictCart(Key) %></TD>
			<TD ALIGN="Right">$<%= aParameters(2) %></TD>
			<TD ALIGN="Right">$<%= FormatNumber(dictCart(Key) * CSng(aParameters(2)),2) %></TD>
		</TR>
		<%
		sTotal = sTotal + (dictCart(Key) * CSng(aParameters(2)))
	Next
	
	'Calculate shipping - you might want to pull this out into a function if your shipping 
	' calculations are more complicated then ours.  ;)
	If sTotal <> 0 Then
		sShipping = 7.5
	Else
		sShipping = 0
	End If
	sTotal = sTotal + sShipping
	%>
	<TR><TD COLSPAN=4 ALIGN="Right"><B>S+H:</B></TD><TD ALIGN="Right">$<%= FormatNumber(sShipping,2) %></TD></TR>
	<TR><TD COLSPAN=4 ALIGN="Right"><B>Total:</B></TD><TD ALIGN="Right">$<%= FormatNumber(sTotal,2) %></TD></TR>
	</TABLE>
	<%
End Sub

' We implemented this this way so if you attach it to a database you'd only need one call per item
Function GetItemParameters(iItemID)
Dim aParameters ' Will contain 3 string values : image path, description, price
				' However we need to keep price so it can be converted to a
				' single for computation hence no currency symbol.  This array
				' can also be expanded to contain any other information about the
				' product that you might want to pull from the DB.
	Select Case iItemID
		Case 1
			aParameters = Array("./images/shop_shirt.gif", "ASP 101 T-Shirt", "15.00")
		Case 2
			aParameters = Array("./images/shop_kite.gif", "ASP 101 Kite", "17.50")
		Case 3
			aParameters = Array("./images/shop_watch.gif", "ASP 101 Watch", "35.00")
		Case 4 ' Not in use because we couldn't draw a pen in a few seconds!
			aParameters = Array("./images/shop_pen.gif", "ASP 101 Pen", "5.00")
	End Select
' Return array containing product info.
GetItemParameters = aParameters
End Function
%>




<% ' ***** Begin the infamous runtime script *****
' Declare our Vars
Dim dictCart ' as dictionary
Dim sAction ' as string
Dim iItemID ' as integer
Dim iItemCount ' as integer

' Get a reference to the cart if it exists otherwise create it
If IsObject(Session("cart")) Then
	Set dictCart = Session("cart")
Else
	' We use a dictionary so we can name our keys to correspond to our
	' item numbers and then use their value to hold the quantity.  An
	' array would also work, but would be a little more complex and
	' probably not as easy for readers to follow.
	Set dictCart = Server.CreateObject("Scripting.Dictionary")
End If

' Get all the parameters passed to the script
sAction = CStr(Request.QueryString("action"))
iItemID = CInt(Request.QueryString("item"))
iItemCount = CInt(Request.QueryString("count"))
%>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
<TR><TD>
<%
' Select action based on user input
Select Case sAction
	Case "add"
		AddItemToCart iItemID, iItemCount
		ShowItemsInCart
		%>
		</TD></TR>
		<TR><TD ALIGN="right">
		<A HREF="./shopping.asp?action="><IMG SRC="./images/shop_look.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="Continue Looking"></A>
		<A HREF="./shopping.asp?action=checkout"><IMG SRC="./images/shop_checkout.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="Checkout"></A><BR>
		<%
	Case "del"
		RemoveItemFromCart iItemID, iItemCount
		ShowItemsInCart
		%>
		</TD></TR>
		<TR><TD ALIGN="right">
		<A HREF="./shopping.asp?action="><IMG SRC="./images/shop_look.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="Continue Looking"></A>
		<A HREF="./shopping.asp?action=checkout"><IMG SRC="./images/shop_checkout.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="Checkout"></A><BR>
		<%
	Case "viewcart"
		ShowItemsInCart
		%>
		</TD></TR>
		<TR><TD ALIGN="right">
		<A HREF="./shopping.asp?action="><IMG SRC="./images/shop_look.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="Continue Looking"></A>
		<A HREF="./shopping.asp?action=checkout"><IMG SRC="./images/shop_checkout.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="Checkout"></A><BR>
		<%
	Case "checkout"
		PlaceOrder
		%>
		</TD></TR>
		<TR><TD ALIGN="left">
		<BR>
		<H2>Thank you for your order!</H2>
		If this had been an actual shopping cart, this is where you would have had them enter
		their personal information and payment method and then taken care of any backend
		processing before finalizing their order.  However as this is a shopping cart sample
		and this is where security becomes a problem, we'll leave it for a future sample.
		<%
	Case Else ' Shop
		ShowFullCatalog
		%>
		</TD></TR>
		<TR><TD ALIGN="right">
		<A HREF="./shopping.asp?action=viewcart"><IMG SRC="./images/shop_cart.gif" BORDER=0 WIDTH=46 HEIGHT=46 ALT="View Cart Contents"></A>
		<%
End Select

' Return cart to Session for storage
Set Session("cart") = dictCart
%>
</TD></TR>
</TABLE>
