<%
' ------------------------------------
' DON'T CHANGE ANY OF THESE CONSTANTS!
' ------------------------------------

' Security levels
' Users with securityLvl set lower to this value will be consider as standard users
' Users with securityLvl equal or higher then this value will be consider as administrators
Const ADMIN_SECURITY_LVL = 2
Const NORMAL_USER = 1

' ALL is use by talkTo to specify talking to all
Const ALL = -1

' Action for ignore list management
Const IGNORE_HIM = 1
Const DO_NOT_IGNORE_HIM = 0
Const LIST_SEP = "!"
Const LARGE = "2"
Const SMALL = "1"

' Memo text numbers
Const LOGIN_MSG = 1
Const LOST_PWD = 2
Const LOST_PWD_MSG = 3
Const NEW_USER = 4
Const NEW_USER_MSG = 5
Const SROOM_MSG = 6
Const WELCOME_MSG = 7

' Image numbers
Const QUIT_CHAT_BUTTON = 1
Const HELP_BUTTON = 2
Const MANAGER_BUTTON = 3
Const SEND_BUTTON = 4
Const BROADCAST_BUTTON = 5
Const ENTER_BUTTON = 6
Const QUIT_BUTTON = 7
Const LOGIN_LOGO = 8
Const NEW_USER_LOGO = 9
Const SROOM_LOGO = 10
Const SMALL_LOGO = 11

' Stat type
Const NBR_POST = 1
Const TIME_IN_CHAT = 2
Const NBR_LOGIN = 3
Const LAST_LOGIN = 4
Const LAST_LOGOUT = 5


' Functions and subs
' ------------------
Sub processMessage(ByRef msgLine)
	'
	' This sub is used to analyse the message string and do any modification if required
	' If you want to implement a blocking profanity feature, this would be the place to put it
	'
	If (Application("useSmiley")="True") then
		msgLine = Replace(msgLine,"O:-)",  "<img src='images/angel.gif'>")
		msgLine = Replace(msgLine,"xx(",  "<img src='images/dead.gif'>")
		msgLine = Replace(msgLine,":-)",  "<img src='images/smile.gif'>")
		msgLine = Replace(msgLine,":o)",  "<img src='images/clown.gif'>")
		msgLine = Replace(msgLine,":-(",  "<img src='images/frown.gif'>")
		msgLine = Replace(msgLine,":o(",  "<img src='images/frown.gif'>")
		msgLine = Replace(msgLine,";-)",  "<img src='images/wink.gif'>")
		msgLine = Replace(msgLine,";o)",  "<img src='images/wink.gif'>")
		msgLine = Replace(msgLine,":-[",  "<img src='images/angry.gif'>")
		msgLine = Replace(msgLine,":o[",  "<img src='images/angry.gif'>")
		msgLine = Replace(msgLine,":-]",  "<img src='images/devil.gif'>")
		msgLine = Replace(msgLine,":o]",  "<img src='images/devil.gif'>")
		msgLine = Replace(msgLine,":)",  "<img src='images/smile.gif'>")
		msgLine = Replace(msgLine,":(",  "<img src='images/frown.gif'>")
		msgLine = Replace(msgLine,";)",  "<img src='images/wink.gif'>")
		msgLine = Replace(msgLine,":]",  "<img src='images/devil.gif'>")
		msgLine = Replace(msgLine,":[",  "<img src='images/angry.gif'>")
		msgLine = Replace(msgLine,":D",  "<img src='images/biggrin.gif'>")
		msgLine = Replace(msgLine,":O",  "<img src='images/oh.gif'>")
		msgLine = Replace(msgLine,":P",  "<img src='images/tongue.gif'>")
	End If
End Sub



Sub postUserDate(userKey, newDate, statType)
	'
	' Post last login/logout
	'
	Dim objConn1, objRS1, strSQL1

	Set objConn1 = Server.CreateObject("ADODB.Connection")
	objConn1.ConnectionString = Application("DBString")
	objConn1.Open
	Set objRS1 = Server.CreateObject("ADODB.Recordset")
	strSQL1 = "SELECT * FROM users WHERE key = " & userKey & ";"
	objRS1.Open strSQL1, objConn1, adOpenStatic, adLockOptimistic

	Select Case statType
		Case LAST_LOGIN objRS1("lastLogin") = newDate
		Case LAST_LOGOUT objRS1("lastLogout") = newDate
	End Select

	objRS1.Update

	objRS1.Close
	Set objRS1 = Nothing
	objConn1.Close
	Set objConn1 = Nothing
End Sub

Sub increaseUserStat(userKey, statType, byHowMuch)
	'
	' Increase stat of one user by one
	'
	Dim objConn1, objRS1, strSQL1, statCounter

	Set objConn1 = Server.CreateObject("ADODB.Connection")
	objConn1.ConnectionString = Application("DBString")
	objConn1.Open
	Set objRS1 = Server.CreateObject("ADODB.Recordset")
	strSQL1 = "SELECT * FROM users WHERE key = " & userKey & ";"
	objRS1.Open strSQL1, objConn1, adOpenStatic, adLockOptimistic

	Select Case statType
		Case NBR_POST
			statCounter = objRS1("nbrPost")
			objRS1("nbrPost") = statCounter + byHowMuch
		Case TIME_IN_CHAT
			statCounter = objRS1("timeInChat")
			objRS1("timeInChat") = statCounter + byHowMuch
		Case NBR_LOGIN
			statCounter = objRS1("nbrLogin")
			objRS1("nbrLogin") = statCounter + byHowMuch
	End Select

	objRS1.Update

	objRS1.Close
	Set objRS1 = Nothing
	objConn1.Close
	Set objConn1 = Nothing
End Sub


Function addNewUser(nickname, email, password, sexe, picture, securityLvl, confirmed, language)
	'
	' Add a new user to the database
	' Return 0 if ok, msg number if not
	'	106: nickname already taken
	'	108: trying to create a new nickname using an email adress already registered
	' You can call this function directly from your site to add a new user and bypass the new user screen
	
	Dim objConn1, objRS1, strSQL1
	
	addNewUser = 0
	Set objConn1 = Server.CreateObject("ADODB.Connection")
	objConn1.ConnectionString = Application("DBString")
	objConn1.Open
	Set objRS1 = Server.CreateObject("ADODB.Recordset")
	strSQL1 = "SELECT * FROM users WHERE nickname = '" & nickname & "';"
	objRS1.Open strSQL1, objConn1, adOpenStatic, adLockOptimistic
		
	' Is this nickname already taken?
	If not objRS1.BOF Then
		addNewUser = 106
	Else
		objRS1.Close
		strSQL1 = "SELECT * FROM users WHERE email = '" & email & "';"
		objRS1.Open strSQL1, objConn1, adOpenStatic, adLockOptimistic
	
		' We can only have one user per email account
		If not objRS1.BOF Then
			addNewUser = 108
		Else
			' We have a new user! YES!
			' Create his account
			objRS1.AddNew
			objRS1("nickname") = nickname
			objRS1("email") = email
			objRS1("password") = password
			objRS1("sexe") = sexe
			objRS1("picture") = picture
			objRS1("securityLvl") = securityLvl
			objRS1("confirmed") = confirmed
			objRS1("language") = language
			objRS1("creationDate") = localTime()
			objRS1("refreshRate") = getDefaultRefresh()
			objRS1("scrollUP")= Application("scrollUp")
			objRS1("nameColor") = "Navy"
			objRS1("nbrPost") = 0
			objRS1("timeInChat") = 0
			objRS1("nbrLogin") = 0
			objRS1("signalInOut") = 1
			objRS1.Update
		End If
	End If
	objRS1.Close
	Set objRS1 = Nothing
	objConn1.Close
	Set objConn1 = Nothing
End Function


Function displayImage(number, langage)
	'
	' Display an image based on its number and the user langage
	'
	Dim imageSRC
	Dim fs

	imageSRC = "images/"
	Select Case number
		Case QUIT_CHAT_BUTTON imageSRC = imageSRC & "quitchat"
		Case HELP_BUTTON imageSRC = imageSRC & "help"
		Case MANAGER_BUTTON imageSRC = imageSRC & "manager"
		Case SEND_BUTTON imageSRC = imageSRC & "send"
		Case BROADCAST_BUTTON imageSRC = imageSRC & "broadcast"
		Case ENTER_BUTTON imageSRC = imageSRC & "enter"
		Case QUIT_BUTTON imageSRC = imageSRC & "quit"
		Case LOGIN_LOGO imageSRC = imageSRC & "loginLogo"
		Case NEW_USER_LOGO imageSRC = imageSRC & "newUserLogo"
		Case SROOM_LOGO imageSRC = imageSRC & "sRoomLogo"
		Case SMALL_LOGO imageSRC = imageSRC & "smallLogo"
	End Select
	imageSRC = imageSRC & langage & ".gif"

	Set fs = CreateObject("Scripting.FileSystemObject")
	If fs.FileExists(server.mappath(imageSRC)) Then
		displayImage = imageSRC
		Set fs=nothing
	Else
		Set fs=nothing
		displayImage = displayImage(number,"English")
	End If
End Function

Sub displayMemo(number, langage)
	'
	' Display a memo text based on number and langage
	'
	Dim objConn, objRS, strSQL

	Set objConn = Server.CreateObject("ADODB.Connection")
	objConn.ConnectionString = Application("DBString")
	objConn.Open
	Set objRS = Server.CreateObject("ADODB.Recordset")
	strSQL = "SELECT * FROM memo" & langage & " WHERE memoNumber=" & number & ";"
	objRS.Open strSQL, objConn, adOpenStatic, adLockReadOnly
	If Not objRS.BOF Then
		Response.Write objRS("memoText")
	End If
	objRS.Close
	Set objRS = Nothing
	objConn.Close
	Set objConn = Nothing
End Sub


Sub initializeLanguage()
	'
	' Dynamically modify the messages
	'
	Dim objConn, objRS, strSQL, objRS1

	Set objConn = Server.CreateObject("ADODB.Connection")
	objConn.ConnectionString = Application("DBString")
	objConn.Open
	Set objRS = Server.CreateObject("ADODB.Recordset")
	Set objRS1 = Server.CreateObject("ADODB.Recordset")
	strSQL = "SELECT * FROM languages;"
	objRS.Open strSQL, objConn, 3, 1

	Application.Lock
	Do Until objRS.EOF
		strSQL = "SELECT * FROM " & objRS("language") & ";"
		objRS1.Open strSQL, objConn, 3, 1
		
		Do Until objRS1.EOF
			Application("msg" & objRS1("msgNumber") & objRS("language")) = objRS1("message")
			objRS1.MoveNext
		Loop
		objRS1.Close
		objRS.MoveNext
	Loop
	Application.Unlock
	objRS.Close
	Set objRS = Nothing
	Set objRS1 = Nothing
	objConn.Close
	Set objConn = Nothing
End Sub


Function localTime()
	'
	' Ajust site local time by adding timeOffset to server local time
	'
	localTime = DateAdd("h",Application("timeOffset"),now())
End Function


Sub clearRoom(roomID)
	'
	' Clear room when last user as leave, if required
	'
	Dim k

	If Application("clearOnEmpty")="True" And lclRoomData(roomID,2) = 0 Then
		Application.Lock
		For k = 1 To Application("msgSize")
			Application("conversation" & roomID & k) = ""
			Application("conversation" & roomID & "id" & k) = -1
			Application("conversation" & roomID & "to" & k) = -1
		Next
		Application.UnLock
	End If
End Sub

Sub initSession(securityLvl, key, nickname, picture, language, refreshRate, scroll, beep, nameColor, signalInOut)
	'
	' Initialize a new user session
	'
	Session("userSecurityLvl") = securityLvl			' User security level
	Session("userKey") = key					' User key (number unique to each user)
	Session("userName") = nickname					' User nickname
	Session("userPicture") = picture				' User picture
	Session("userLanguage") = language				' User langage preference
	Session("refreshRate") = refreshRate				' User refresh rate
	Session("scrollUP") = scroll					' Set default scroll direction
	Session("screenSize") = LARGE					' Initialize screen size
	Session("adminMsgNumber") = Application("adminMsgNumber")-1	' Set to current admin message number-1
	Session("ignore") = ""						' Ignore user list
	Session("talkTo") = ALL						' TalkTo will specify to who the user is talking to. At start, set to all
	Session("beep") = beep						' Signal new arrival
	Session("nameColor") = nameColor				' Color use for the user name
	Session("textColor") = "x000000"				' Initialize text color to black
	Session("signalInOut") = signalInOut				' Show In/Out messages?
End Sub


Function initUserSession(nickname, password)
	'
	' Validate user and init session
	' Returns 1 if valid nickname/password, 0 if not
	' nickname : user nickname
	' password : user password
	'
	Dim objConn, objRS, strSQL

	' Open DB and create Recordset object
	Set objConn = Server.CreateObject("ADODB.Connection")
	objConn.ConnectionString = Application("DBString")
	objConn.Open
	Set objRS = Server.CreateObject("ADODB.Recordset")
			
	' Validate userid and password	
	strSQL = "SELECT * FROM users WHERE nickname='" & nickname & "' AND password='" & password &"';"
	objRS.Open strSQL, objConn, adOpenStatic, adLockReadOnly
	If objRS.BOF Then
		' userid/password invalid
		initUserSession = 0
	Else
		initUserSession = 1
		' initialize session variables	
		Call initSession(objRS("securityLvl"), objRS("key"), nickname, objRS("picture"), objRS("language"), objRS("refreshRate"), objRS("scrollUP"), objRS("beep"), objRS("nameColor"), objRS("signalInOut"))
	End If

	' No longer need the connection. Close it
	objRS.Close
	Set objRS = Nothing
	objConn.Close
	Set objConn = Nothing
End Function


Sub selectLanguage(currentLanguage)
	'
	' Create a selection box with available languages.
	' Must be called within a form that can process mode="changeLangage"
	' currentLanguage : current selected language
	'
	Dim msg
	Dim DBObj, RSObj, strSQL

	' Get access to database and languages table
	Set DBObj = Server.CreateObject("ADODB.Connection")
	DBObj.ConnectionString = Application("DBString")
	DBObj.Open
	Set RSObj = Server.CreateObject("ADODB.Recordset")
	strSQL = "SELECT * FROM languages WHERE active=1;"
	RSObj.Open strSQL, DBObj, adOpenStatic, adLockReadOnly

	msg = "<select name='langSelection' class='menuText' onChange='onChange(this.form," & chr(34) & "changeLangage" & chr(34) & "); return true'>"
	
	Do Until RSObj.EOF
		msg = msg & "<option value='" & RSObj("language") & "' "
		If currentLanguage = RSObj("language") Then
			msg = msg & "Selected"
		End if
		msg = msg & ">" & RSObj("language") & "</option>"
		RSObj.MoveNext
	Loop
	msg = msg & "</select>"
	Response.Write msg
	RSObj.Close
	Set RSObj = Nothing
	DBObj.Close
	Set DBObj = Nothing
End Sub

Sub selectRefreshRate(currentRate)
	'
	' Create a selection box with available refresh rates.
	' Must be called within a form that can process mode="newRefresh"
	' currentRate : current refresh rate
	'
	Dim msg
	Dim DBObj, RSObj, strSQL

	' Get access to database and refreshRates table
	Set DBObj = Server.CreateObject("ADODB.Connection")
	DBObj.ConnectionString = Application("DBString")
	DBObj.Open
	Set RSObj = Server.CreateObject("ADODB.Recordset")
	strSQL = "SELECT * FROM refreshRates;"
	RSObj.Open strSQL, DBObj, adOpenStatic, adLockReadOnly

	msg = "<select name='newRefreshRate' class='menuText' onChange='onChange(this.form," & chr(34) & "newRefresh" & chr(34) & "); return true'>"
	
	Do Until RSObj.EOF
		msg = msg & "<option value='" & RSObj("rate") & "' "
		If CSng(currentRate) = RSObj("rate") Then
			msg = msg & "Selected"
		End if
		msg = msg & ">" & RSObj("rate") & "</option>"
		RSObj.MoveNext
	Loop
	msg = msg & "</select>"
	Response.Write msg
	RSObj.Close
	Set RSObj = Nothing
	DBObj.Close
	Set DBObj = Nothing
End Sub

Function getDefaultLang()
	'
	' Returns the default language for this site
	'
	Dim DBObj, RSObj, strSQL

	' Get access to database and languages table where default = 1
	Set DBObj = Server.CreateObject("ADODB.Connection")
	DBObj.ConnectionString = Application("DBString")
	DBObj.Open
	Set RSObj = Server.CreateObject("ADODB.Recordset")
	strSQL = "SELECT * FROM languages WHERE default=1;"
	RSObj.Open strSQL, DBObj, adOpenStatic, adLockReadOnly

	getDefaultLang = RSObj("language")
	RSObj.Close
	Set RSObj = Nothing
	DBObj.Close
	Set DBObj = Nothing
End Function


Function getDefaultRefresh()
	'
	' Returns the default refresh rate for this site
	'
	Dim DBObj, RSObj, strSQL

	' Get access to database and languages table where default = 1
	Set DBObj = Server.CreateObject("ADODB.Connection")
	DBObj.ConnectionString = Application("DBString")
	DBObj.Open
	Set RSObj = Server.CreateObject("ADODB.Recordset")
	strSQL = "SELECT * FROM refreshRates WHERE default=1;"
	RSObj.Open strSQL, DBObj, adOpenStatic, adLockReadOnly

	getDefaultRefresh = RSObj("rate")
	RSObj.Close
	Set RSObj = Nothing
	DBObj.Close
	Set DBObj = Nothing
End Function

Sub CheckQuit(pos, pageName)
	' If pos is greater then 0 then we close the window.
	If ( pos > 0) Then
		Response.Redirect pageName
		Response.End
	End If
End Sub

Sub ReadDisplayFile(fileToRead)
	'
	' Insert a txt file in html code
	' fileToRead : text file to read
	'
	Dim whichFile		' full path to fileToRead
	Dim fs
	Dim thisFile
	Dim tempSTR

	whichFile=server.mappath(fileToRead)
	Set fs = CreateObject("Scripting.FileSystemObject")
	Set thisFile = fs.OpenTextFile(whichFile, 1, False)
	tempSTR=thisFile.readall
	response.write tempSTR
	thisFile.Close
	set thisFile=nothing
	set fs=nothing
End Sub

Sub CheckSecurity(level)
	'
	' If the user security level is lower then level then kick out this user
	' level: the minimum security level required to stay alive
	'
	If CSng(Session("userSecurityLvl")) < level Then
		' Check if user has been kicked, if yes remove him from room
		If Csng(Session("userSecurityLvl")) = -1 Then
			Session("userSecurityLvl") = 0
			Call removeUser(Session("roomID"), Session("userKey"), Session("userName"), "msg15")
			Session("roomID") = -1
		Else
			' Someone is trying to get in without login. Dont let him!
			Response.Redirect "security.asp"
			Response.End
		End If
	End If
End Sub

Function getRoomIndex(roomName)
	'
	' Return the index of a room in the roomData array
	' Assumes that a local copy of the array already exist in lclRoomData
	'
	Dim i

	getRoomIndex = -1
	For i=1 to Application("numRoom")
		If lclRoomData(i,1) = roomName Then
			getRoomIndex = i
			Exit For
		End If
	Next
End Function

Sub userExist(userKey, ByRef roomID, ByRef index)
	' 
	' Find user in userData array
	' userKey : user key to find
	' roomID : will return -1 if user not found or room index in userData
	' index : will return -1 if user not found or user index in userData
	'
	Dim i
	Dim j
	
	roomID = -1
	index = -1
	For i=1 to UBound(lclUserData,1)
		For j=1 to UBound(lclUserData,3)
			If lclUserData(i,4,j) = userKey Then
				roomID = i
				index = j
				Exit For
			End If
		Next
	Next
End Sub

Sub outInRoom(room1, room2, userKey, userName, timeStamp, picture, securityLvl)
	'
	' Remove user from one room and enter him in another room
	' room1 : take him out of room1
	' room2 : enter him in room2
	' userKey, userName, timeStamp, picture, securityLvl : information required to enter a user in a room
	'
	Call removeUser(room1, userKey, userName, "msg31")
	Call initializeNewUser(room2, userName, timeStamp, picture, userKey, securityLvl)
End Sub

Sub removeUser(roomID, userKey, userName, message)
	'
	' Remove a user from a room. Must be call from a page that has a local copy of userData.
	' roomID : remove him from this room
	' userKey, userName : the user to take out
	' message : what mesage number to use to signal that this user is out
	'
	Dim i

	Call userExist(userKey, roomID, i)

	If roomID <> -1 Then
		' add a leaving message to chatroom
		If lclUserData(roomID,5,i)<ADMIN_SECURITY_LVL Or Application("invAdmin")="False" Then
			Call postMessage(roomID, formatSystemMessage(message,"images/bp.gif",userName), -2, -1)
		End If
		lclUserData(roomID, 4, i) = -1
		lclUserData(roomID, 5, i) = 0
		Application.lock
			lclRoomData = Application("roomData")
			lclRoomData(roomID, 2) = lclRoomData(roomID,2) - 1
			Application("roomData") = lclRoomData
			Application("userData") = lclUserData
		Application.UnLock
	
		' Log departure
		Call logMessage(roomID, "OUT ", Session("userName"))

		' Keep dat in user stat
		Call postUserDate(Session("userKey"), localTime() ,LAST_LOGOUT)

		' Clear room if required
		Call clearRoom(roomID)
	End If
End Sub

Sub logMessage(roomID, message, userName)
	'
	' log a message to the log file if logToFile is set to True
	' roomID : post to log file for this room
	' message : message to log
	' userName : who sent that message
	'
	Const ForAppending=8
	Dim logRecords
	Dim fso
	Dim logFile
	Dim timeStamp
	
	If Application("logToFile") = "True" Then
		logRecords = server.mappath(Application("logDirectory") & "/logRecord" & roomID & ".txt") 
		Set fso = createObject("scripting.FileSystemObject")
	
		If fso.fileExists(logRecords) Then
			Set logFile=fso.openTextFile(logRecords,ForAppending)
		Else
			Set logFile=fso.createTextFile(logRecords)
		End If

		timeStamp = FormatDateTime(localTime())
		logFile.writeLine (timeStamp &  " " & userName & " " & message)
		logFile.close
		Set fso = Nothing
		Set logFile = Nothing
	End If
End Sub

Function initializeNewUser(roomID, name, timeStamp, picture, userKey, securityLvl)
	'
	' Initialize a new user in a room. Must be call from a page that has a local copy of userData.
	' roomID : in what room
	' name, timeStamp, picture, userKey, securityLvl: information required to enter a new user
	'

	Dim i

	' increase number of user in room
	Application.lock
	
	lclRoomData = Application("roomData")

	' First check that we still have some place in room
	If lclRoomData(roomID,2) < UBound(lclUserData,3) Then
		initializeNewUser = True
		lclRoomData(roomID, 2) = lclRoomData(roomID,2) + 1
		Application("roomData") = lclRoomData

		For i=1 to UBound(lclUserData, 3)
			If lclUserData(roomID,4,i) = -1 Then
				lclUserData(roomID,1,i) = name
				lclUserData(roomID,2,i) = timeStamp
				lclUserData(roomID,3,i) = picture
				lclUserData(roomID,4,i) = userKey
				lcluserData(roomID,5,i) = securityLvl
				Exit For
			End if
		Next
	Else
		initializeNewUser = False
	End If
	Application.UnLock


End Function

' ----------

Sub SelectRoom()
	Dim msg, i, lclRoomData
	
	lclRoomData = Application("roomData")
	msg = "<select name='chatRoom' class='loginText' onChange='onChange(this.form," & chr(34) & "selected" & chr(34) & "); return true'>"
	For i=1 to Application("numRoom")
		If lclRoomData(i,3) = "" Then
			msg = msg & "<option value=" & i 
			If Session("roomID") = i Then
				msg = msg & " Selected"
			End if
			msg = msg & ">" & lclRoomData(i,1) & "</option>"
		End If
	Next	
	msg = msg & "</select>"
	Response.Write msg
End Sub

Sub OpenConnection(ByRef DBObj, ByRef RSObj)
	' We open a connection to the database.
	' Application("DBString") must be set to your database string in Global.asa
	Set DBObj = Server.CreateObject("ADODB.Connection")
	DBObj.ConnectionString = Application("DBString")
	DBObj.Open
	Set RSObj = Server.CreateObject("ADODB.Recordset")
End Sub


Sub CheckExpired()
	if Session("roomID") = -1 then
		Response.Redirect "expired.asp"
		Response.End
	End If
End Sub

Sub modTimeStamp(roomID, userKey, timeStamp)
	Dim i
	For i=1 to UBound(lclUserData,3)
		If lclUserData(roomID, 4, i) = userKey Then
			lclUserData(roomID, 2, i) = timeStamp
			Application.lock
			Application("userData") = lclUserData
			Application.UnLock
			Exit For
		End If
	Next
End Sub

Sub postMessage(roomID, msg, fromWho, toWho)
	Dim roomConversation
	Dim i

	roomConversation = "conversation" & roomID
	Application.Lock

	' Move down messages 1 line
	For i = Application("msgSize") To 2 Step -1
		Application(roomConversation & i) = Application(roomConversation & i-1)
		Application(roomConversation & "id" & i) = Application(roomConversation & "id" & i-1)
		Application(roomConversation & "to" & i) = Application(roomConversation & "to" & i-1)
	Next

	' Send messsage
	Application(roomConversation & "1") = msg
	Application(roomConversation & "id1") = fromWho
	Application(roomConversation & "to1") = toWho

	Application.Unlock
End Sub
	
Function formatMessage(message, fromWhoName, nameColor)
	formatMessage = "<table border='0' cellpadding='2' cellspacing='1' width='100%'>" & _
		"<tr>" & _
		" <td nowrap valign='top' align='left'><span class='Name'><font color=" & nameColor & ">" & fromWhoName & ":" &_
		"</font></span></td>" & _
		" <td align='justify' width='100%'><div class='Message' align='justify'>" & message & "</span></td>" & _
		"</tr>" & _
		"</table>" & vbCrLf
End Function

Function formatSystemMessage(message,picture, userName)
	formatSystemMessage = "<span class='loggedIn'>" & userName & " " & message & " " &  localTime() & "</span><br>"
	' formatSystemMessage = "<span class='loggedIn'><img src='" & picture & "' height=9 width=9>" & userName & " " & message & " " &  localTime() & "</span><br>"
End Function


%>