<%	Option Explicit %>
<!-- #include file="constants.inc" -->
<%
	' 
	' :@users.asp
	' 
	' Shows a list of all active chat users in the current users room. The 
	' current user will be bolded in the list in order to separate him from
	' other users.
	' 
	' @author	Peter Theill	peter@theill.com
	' 
	
	Response.Buffer = True
	
	Dim userId, roomId
	userId = CStr(Request("chatId"))
	roomId = CStr(Request("roomId"))
	
	If (NOT isLoggedIn(userId)) Then
'		Response.Redirect PAGE_EXPIRED
		Response.Write("Please Wait...")
		Response.End
	End If
	
	' this is the case when the user logs in the first time
	If (roomId = "") Then
		Dim u
		Set u = getUser(userId)
		roomId = u.roomId
	End If
	
	Dim needToRefreshRooms
	needToRefreshRooms = False
	If (Request("action") = "switch") Then
		
		' switch to new room
		Call enterRoom(userId, roomId)
		needToRefreshRooms = True
		
	End If
	
%>
<html>
<head>
	<meta http-equiv='Refresh' content='15; URL=users.asp?chatId=<%= userId %>&roomId=<%= roomId %>'>
	<title><%= APPLICATION_NAME %> - Users</title>
	<link rel="stylesheet" type="text/css" href="chat.css">
</head>

<body bgcolor="#FFFFFF" text="#000000" link="#FF8040" vlink="#FF8040" alink="#354FC6" topmargin="0" leftmargin="0" marginwidth="0" marginheight="0">
<table border="0" width="100%" cellspacing="0" cellpadding="2">
  <tr>
    <td colspan=2 width="100%" bgcolor="#D0D0D0">
     <table border=0 cellspacing=0 cellpadding=0>
     <tr>
      <td width=100%><nobr><b>Users</b></nobr></td>
      <td><a href="users.asp?chatId=<%= userId%>&roomId=<%= roomId %>"><img src="images/ico.refresh.gif" width=16 height=16 border=0 alt="Refresh"></a></td>
     </tr>
     </table>
    </td>
  </tr>
<%
	
	' we need to show all users available in this room
	
	Dim user, userId_, rowIdx
	For Each userId_ In conquerChatUsers
		Set user = getUser(userId_)
		If (user.roomId = roomId) Then
			If (rowIdx MOD 2) Then
				Response.Write "<tr bgcolor='#F8F8F8'>"
			Else
				Response.Write "<tr>"
			End If
			
			Response.Write " <td><img src='images/ico.user.gif' width=16 height=16 border=0></td>"
			
			If (user.id = userId_) Then
				Response.Write " <td width=100% class='infoText'><b>" & user.name & "</b>&nbsp;</td>"
			Else
				Response.Write " <td width=100% class='infoText'>" & user.name & "&nbsp;</td>"
			End If
			
			Response.Write "</tr>"
			rowIdx = rowIdx + 1
		End If
	Next
	
%>
</table>

<% If (needToRefreshRooms) Then %>
<script language="JavaScript">
<!--

	// update rooms and messages windows
	parent.rooms.location.href = 'rooms.asp?chatId=<%= userId %>';
	parent.messages.location.href = 'window.asp?chatId=<%= userId %>';
	
	// update roomId variable in message control. This is needed in order to 
	// send the correct one when a user adds a message to the chat.
	parent.message.frmControl.roomId.value = '<%= roomId %>';
	
	// bring focus to message edit field since a user probably wants to type
	// a message in this new chatroom he just entered
	parent.message.frmControl.message.focus();
	
// -->
</script>
<% End If %>
</body>
</html>