<%
	
	' 
	' --------------------- C H A T   A P P L I C A T I O N   S E T T I N G S
	'
	
	'
	' Name of this Chat application. If you want to use it on your own site,
	' you probably wants to give it a different name, e.g. 'Lucky Chat'. By
	' changing this value, all text strings in chat will be changed.
	' 
	' Default Value: ConquerChat OnLine 3.0
	'
	Const APPLICATION_NAME = "ConquerChat OnLine 3.0"
	
	'
	' Contains the e-mail address for the web administrator for this web site.
	' If an error occurs or a user wants to send an email to the webmaster,
	' this email will be shown.
	' 
	' Default Value: webmaster@mydomain.com
	'
	Const WEBMASTER_EMAIL = "webmaster@mydomain.com"
	
	'
	' The maximum number of shown messages on the screen. You may want to 
	' limit this number in order to have all messages written on one page
	' without the user having to scroll his/hers chat window. The value is
	' on a 'per room' basis.
	'
	' Default Value: 25
	'
	Const MESSAGES = 25
	
	' 
	' This specifies the number of users allowed to log into this chat. If
	' you have a large site you may want to increase this number to allow
	' more users.
	'
	' Default Value: 30
	' 
	Const USERS = 30
	
	'
	' No more than X rooms are allowed to be created for any chat. This value
	' will limit the number of rooms for the entire chat -- not just for one
	' user.
	'
	' Default Value: 10
	'
	Const NUMBER_OF_ROOMS = 10
	
	' 
	' Timeout in seconds - a session times out after 5 minutes (5*60=300) thus
	' if a logged in user hasn't entered anything in the window he will be
	' logged out in order to avoid taking up a space in the chat.
	' 
	' Default Value: 300
	' 
	Const TIMEOUT = 300
	
	' 
	' Specify is all messages should be wiped, when last user leaves the 
	' chatroom. This feature is also called the 'whiteboard cleaner'.
	' 
	' Default Value: True
	' 
	Const CLEAR_ON_EMPTY = True

	Const CLEAR_MESSAGE = True
	
	' 
	' If True, a typed smiley (e.g. :-) will be replaced by a small image
	' representation.
	' 
	' Default Value: True
	' 
	Const USE_IMAGE_SMILEY = True
	
	'
	' List of default rooms available for all users. Rooms are separated
	' using a simicolon (;) and first room is _always_ the default room,
	' i.e. where all new users are placed
	'
	' Default Value: Entrance;Music;Sport
	'
	Const DEFAULT_ROOMS = "Entrance;Music;Sport"
	
	'
	' Indicates if all chat messages should print from top-to-bottom or from
	' bottom-to-top. If TOP_MESSAGE_ORDER is set to True new messages will
	' be printed in the top of the chat area otherwise a new message appear
	' in the bottom.
	'
	' Default Value: True
	'
	Const TOP_MESSAGE_ORDER = True
	
	'
	' This value indicates the maximum length of a username. If a user enters
	' a username larger than this value, he will be prompted to enter another
	' name.
	' 
	' Default Value: 20
	'
	Const MAX_USERNAME_LENGTH = 20
	
	' 
	' --------------------------------------------------------- C L A S S E S
	'
	
	Class Person
		
		Private id_
		Private name_
		Private roomId_
		Private lastAction_
		
		Private Sub Class_Initialize()
			id_ = -1
			name_ = "Guest"
			roomId_ = -1
			action()
		End Sub
		
		Public Property Get id
			id = id_
		End Property
		
		Public Property Get name
			name = name_
		End Property
		
		Public Property Get roomId
			roomId = roomId_
		End Property
		
		Public Property Get lastAction
			lastAction = lastAction_
		End Property
		
		
		Public Property Let id(v)
			id_ = v
		End Property
		
		Public Property Let name(v)
			name_ = v
		End Property
		
		Public Property Let roomId(v)
			roomId_ = v
		End Property
		
		Public Sub action()
			lastAction_ = CStr(Now())
		End Sub
		
		Public Property Get data
			data = id_ & Chr(1) & name_ & Chr(1) & roomId_ & Chr(1) & lastAction_
		End Property
		
		Public Property Let data(v)
			Dim dataArray
			dataArray = Split(v, Chr(1))
			If (IsArray(dataArray) AND (UBound(dataArray) >= 3)) Then
'			If (IsArray(dataArray)) Then
				id_ = dataArray(0)
				name_ = dataArray(1)
				roomId_ = dataArray(2)
				lastAction_ = dataArray(3)
			End If
		End Property
		
		Private Sub debug()
			Response.Write "<table><tr><td colspan=4>User</td></tr><tr><td>" & id_ & "</td><td>" & name_ & "</td><td>" & roomId_ & "</td><td>" & lastAction_ & "</td></tr></table>"
		End Sub
		
	End Class
	
	
	Class Room
		
		Private id_
		Private name_		
		Private createdBy_
		
		Private Sub Class_Initialize()
			id_ = -1
			name_ = "Guest"
			createdBy_ = -1
		End Sub
		
		
		Public Property Get id
			id = id_
		End Property
		
		Public Property Get name
			name = name_
		End Property
		
		Public Property Get createdBy
			createdBy = createdBy_
		End Property
		
		
		Public Property Let id(v)
			id_ = v
		End Property
		
		Public Property Let name(v)
			name_ = v
		End Property
		
		Public Property Let createdBy(v)
			createdBy_ = v
		End Property
		
		
		Public Property Get data
			data = id_ & ";" & name_ & ";" & createdBy_
		End Property
		
		Public Property Let data(v)
			Dim dataArray
			dataArray = Split(v, ";")
			If (IsArray(dataArray) AND (UBound(dataArray) >= 2)) Then
'			If (IsArray(dataArray)) Then
				id_ = dataArray(0)
				name_ = dataArray(1)
				createdBy_ = dataArray(2)
			End If
		End Property
		
	End Class
	
	' [>] moved to release 3.1
	Class Message
		
		Private roomId_
		Private position_
		Private userId_
		Private receiverId_
		Private text_
		
		Public Property Get roomId
			roomId = roomId_
		End Property

		Public Property Get position
			position = position_
		End Property

		Public Property Get userId
			userId = userId_
		End Property

		Public Property Get receiverId
			receiverId = receiverId_
		End Property

		Public Property Get text
			text = text_
		End Property
		
		
		Public Property Let roomId(v)
			roomId_ = v
		End Property

		Public Property Let position(v)
			position_ = v
		End Property
		
		Public Property Let userId(v)
			userId_ = v
		End Property
		
		Public Property Let receiverId(v)
			receiverId_ = v
		End Property
		
		Public Property Let text(v)
			text_ = v
		End Property
		
		
		Public Property Get data
			data = roomId_ & ";" & position & ";" & userId_ & ";" & receiverId_ & ";" & text_
		End Property
		
		Public Property Let data(v)
			Dim dataArray
			dataArray = Split(v, ";")
			If (IsArray(dataArray) AND (UBound(dataArray) >= 5)) Then
				roomId_ = dataArray(0)
				position_ = dataArray(1)
				userId_ = dataArray(2)
				receiverId_ = dataArray(3)
				text_ = dataArray(4)
			End If
		End Property
		
	End Class
	
	
	' Internal constants used within ConquerChat -- warning: please do not 
	' modify these values unless you know what you are doing!
	Const USER_UNAVAILABLE = "-1"
	Const PAGE_EXPIRED = "expired.asp"
	
	
	'
	' ------------------------------------- U T I L I T Y   F U N C T I O N S
	'
	
	'
	' The UserExists(username) function is able to find a specific logged in
	' user using his or hers username (aka chatname).
	' 
	' Function returns True if user was found, False otherwise.
	'
	Function UserExists(userName)
		
		userName = Trim(userName)
		
		Dim arUsers, i, user
		arUsers = conquerChatUsers.Keys
		For i = 0 To conquerChatUsers.Count-1
			
			Set user = getUser(arUsers(i))
			If (StrComp(userName, user.name, 1) = 0) Then
				UserExists = True
				Exit Function
			End If
			
		Next
		
		UserExists = False
		
	End Function ' // > Function UserExists(userName)
	
	
	'
	' Returns Room object specified by parameter "roomId". If the room 
	' does not exist, Nothing is returned
	'
	Function getRoom(roomId)
		
		' make sure id is treated as a String variant
		roomId = CStr(roomId)
		
		If (conquerChatRooms.Exists(roomId)) Then
			Set getRoom = New Room
			getRoom.data = conquerChatRooms.Item(roomId)
			Exit Function
		End If
		
		Set getRoom = Nothing
		
	End Function ' // > Function getRoom(roomId)
	
	
	Function getRoomByName(roomName)
		
		Dim roomId
		For Each roomId In conquerChatRooms
			Set getRoomByName = getRoom(roomId)
			If (NOT (getRoomByName Is Nothing)) Then
				If (StrComp(roomName, getRoomByName.name, 1) = 0) Then
					Exit Function
				End If
			End If
		Next
		
		Set getRoomByName = Nothing
		
	End Function ' // > Function getRoomByName(roomName)
	
	
	'
	' The isLoggedIn(userId) function ensures a valid user login. If the user
	' has been kicked out or his/hers session has expired, the user has been
	' removed from the array of active users and thus needs to login again
	' if he/she wants to continue chatting.
	'
	' Function returns True if user is logged in, False otherwise.
	'
	Function isLoggedIn(userId)
		
		Dim user
		Set user = getUser(userId)
		If (NOT (user Is Nothing)) Then
			Dim room
			Set room = getRoom(user.roomId)
			If (NOT (room Is Nothing)) Then
				isLoggedIn = True
				Exit Function
			End If
		End If
		
		isLoggedIn = False
		
	End Function ' // > Function isLoggedIn(userId)
	
	
	' 
	' The "adduser(user)" function adds a new user to the chat. When a 
	' user enters, a unique key is generated in order to track user properly
	' without using an ASP Session object.
	' 
	' Function returns unique id of new user.
	' 
	Function addUser(user)
		
		Application.Lock
		
		' generate an unique id (timestamp) for this user session
		user.id = CStr(Timer)
		
		' as default, the user is placed in the main entrance room
		user.roomId = 0
		
		' add user to our internal structure of active users
		conquerChatUsers.Add user.id, user.data
		
		' return user with updated information
		Set addUser = user
		
		Application.UnLock
		
	End Function ' // > Function addUser(user)
	
	'
	' Since classes in VBScript doesn't maintains its instance between pages
	' we have to make sure all data we change on an instance will be stored
	' in our global structure of users. This method simply reset the values
	' for the specified user.
	'
	Private Function updateUser(user)
	
		Application.Lock
		
		' add user to our internal structure of active users
		conquerChatUsers.Item(user.id) = user.data
		
		Set updateUser = user
		
		Application.UnLock
	
	End Function ' // > Private Function updateUser(user)
	
	
	'
	' The 'removeUser(userId)' sub procedure removes a logged in user either
	' because his/hers session has expired, was kicked or clicked on logout.
	' 
	Sub removeUser(userId)
		
		Application.Lock
		userId = CStr(userId)
		If (conquerChatUsers.Exists(userId)) Then
			conquerChatUsers.Remove(userId)
			
			' we need to remove all rooms for this user as well
			removeUserRooms(userId)
		End If
		Application.UnLock
		
	End Sub ' // > Sub removeUser(userId)
	
	Function removeUserRooms(userId)
	
		Application.Lock
		Dim roomId, room
		For Each roomId In conquerChatRooms
			Set room = getRoom(roomId)
			If (NOT room Is Nothing) Then
				If (room.createdBy = userId) Then
					removeRoom(room.id)
				End If
			End If
		Next
		
'		Dim roomIds, roomOwners, i
'		roomIds = conquerChatRooms.Keys
'		roomOwners = conquerChatRooms.Items
'		If (IsArray(roomOwners)) Then
'			For i = 0 To conquerChatRooms.Count-1
'				If (roomOwners(i) = userId) Then
'					conquerChatRooms.Remove(roomIds(i))
'				End If
'			Next
'		End If
		Application.UnLock
		
	End Function ' // > Function removeUserRooms(userId)
	
	' 
	' The countUsers function returns the number of currently logged in chat
	' users in all rooms.
	' 
	Function countUsers()
		
		countUsers = conquerChatUsers.Count
		
	End Function ' // > Function countUsers()
	
	
	'
	' Adds a new message to the room the user is currently located in. The
	' message will be added to the queue of posted messages and printed for
	' all users the next time the "window.asp" page is refreshed.
	'
	Function addUserMessage(userId, message)
		
		' lock (synchronize) access to global variables
		Application.Lock
		
		Dim user
		Set user = getUser(userId)
		
		' move all messages one item down in queue
		Dim i
		For i = MESSAGES To 2 Step -1
			Application("$CONQUERCHAT:MESSAGES_" & user.roomId & "_" & i) = _
			 Application("$CONQUERCHAT:MESSAGES_" & user.roomId & "_" & i-1)
		Next
		
		' add message in top of queue (first message)
		Application("$CONQUERCHAT:MESSAGES_" & user.roomId & "_1") = message
		
		' update users timestamp (thus we know he/she is active)
		user.action()
		
		' update internal class structure
		updateUser(user)
		
		' unlock access to global variables
		Application.UnLock
		
	End Function ' // > Function addUserMessage(userId, message)
	
	
	' 
	' The getUser(userId) function returns the object of specified user. 
	' All users of this chat has a unique id in order to identify him/her
	' without using sessions.
	' 
	' Function returns object of user if found, 'Nothing' object otherwise.
	' 
	Function getUser(userId)
		
		userId = CStr(userId)
		If (conquerChatUsers.Exists(userId)) Then
			Set getUser = New Person
			getUser.data = conquerChatUsers.Item(userId)
			Exit Function
		End If
		
		Set getUser = Nothing
		
	End Function ' // > Function getUser(userId)
	
	
	Function addRoom(roomName, userId)
	
		' check for valid room name
		Dim check
		Set check = New RegExp
		check.Pattern = "[a-zA-z0-9 ]"
		check.IgnoreCase = False
		check.Global = True
		If (NOT check.Test(roomName)) Then
			addRoom = False
			Exit Function
		End If
		
		Application.Lock
		If (getRoomByName(roomName) Is Nothing) Then
			Dim room
			Set room = New Room
'			room.id = CStr(Timer)
			room.id = CStr(conquerChatRooms.Count)
			room.name = roomName
			room.createdBy = userId
			
			conquerChatRooms.Add room.id, room.data
			addRoom = True
		Else
			addRoom = False
		End If
		Application.UnLock
		
	End Function ' // > Function addRoom(roomName, userId)
	
	
	Function removeRoom(roomId)
	
		Application.Lock
		
		' treat as string
		roomId = CStr(roomId)
		
		' make sure we actually have the room we are about to remove
		If (conquerChatRooms.Exists(roomId)) Then
			
			' remove from global internal structure
			conquerChatRooms.Remove(roomId)
			
			' transfer all users from this (removed) room to main entrance
			Dim userId, user
			For Each userId In conquerChatUsers
				Set user = getuser(userId)
				If (NOT user Is Nothing) Then
					If (user.roomId = roomId) Then
						user.roomId = 0
						updateUser(user)
					End If
				End If
			Next
			
		End If
		
		Application.UnLock
		
	End Function ' // > Function removeRoom(roomId)
	
	
	' this user wants to switch to another room thus we have to remove
	' the id from the old one and place it in the new
	Function enterRoom(userId, roomId)
	
		Application.Lock
		
		Dim user
		Set user = getUser(userId)
		
		' notify users in old room
		Call addUserMessage(userId, "<span class='LeavingRoom'>&nbsp;" & user.name & " left the room</span><br>")
		
		' change room
		user.roomId = roomId
		
		updateUser(user)
		
		' notify users in new room
		Call addUserMessage(userId, "<span class='EnteringRoom'>&nbsp;" & user.name & " has entered the room</span><br>")
		
		Application.UnLock
		
	End Function ' // > Function enterRoom(userId, roomId)
	
	
	'
	' We do not want to have inactive users in our chat. In order to avoid
	' this, we enumerate all users last chat line and check the timestamp
	' on it. If it is older than the allowed inactivity limit, the user
	' is kicked from the chatroom
	'
	Function kickInactiveUsers()
		
		Dim now_
		now_ = Now()
		
		Application.Lock
		
		Dim userId, user
		For Each userId In conquerChatUsers
			Set user = getUser(userId)
			If (NOT user Is Nothing) Then
'				If (user.lastAction = "") Then
'					' somehow the lastAction is able to get zero or empty. I
'					' do not know why, but we take care of it by pinging the
'					' user (setting the lastAction) and .. well -- we're ex-
'					' tending his life a bit.
'					user.action()
'					Call updateUser(user)
'				End If
				
				If (DateDiff("s", CDate(user.lastAction), now_) > TIMEOUT) Then
					' this user needs to be logged out - he fell asleep in class..hmm
					Call removeUser(userId)
					For i = MESSAGES To 2 Step - 1
						Application("chatline_" & i) = Application("chatline_" & i-1)
					Next
					Application("chatline_1") = "<span class='LoggedOut'><img src='images/bp.gif' height='9' width='9'>&nbsp;" & user.name & " fell asleep and was put to bed at " & now_ & "</span><br>"
				End If
			End If
		Next
		
		Application.UnLock
		
	End Function ' // > Function kickInactiveUsers()
	
%>